/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util;

import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String[] forbiddenCharacters = new String[]{"!", ":", "\\?", "/", "\\\\", "\\*", "<", ">", "\"", "\\|"};

    public static String removeForbiddenCharacters(String string) {
        String result = string;
        for (String fc : forbiddenCharacters) {
            String[] split = string.split(fc);
            result = "";
            for (String splitPart : split) {
                result = result + splitPart;
            }
        }
        return result;
    }

    public static boolean containsForbiddenCharacter(String string) {
        for (String forbiddenCharacter : forbiddenCharacters) {
            if (!string.contains(forbiddenCharacter)) continue;
            return true;
        }
        return false;
    }

    public static double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                boolean success = Util.deleteDir(child);
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static double getPpmError(double theoreticalMzValue, double massError) {
        double ppmValue = massError / theoreticalMzValue * 1000000.0;
        return ppmValue;
    }

    public static String color2Hex(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF);
    }

    public static String getFileName(String filePath) {
        int slash2;
        String tempFileName = filePath;
        int slash1 = tempFileName.lastIndexOf("/");
        int lastSlashIndex = Math.max(slash1, slash2 = tempFileName.lastIndexOf("\\"));
        if (lastSlashIndex != -1) {
            tempFileName = tempFileName.substring(lastSlashIndex + 1);
        }
        return tempFileName;
    }

    public static String getFileName(File file) {
        return Util.getFileName(file.getAbsolutePath());
    }

    public static String getExtension(File file) {
        String fileName = Util.getFileName(file.getAbsolutePath());
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static String removeExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static File getUserSelectedFile(Component parent, String aFileEnding, String aFileFormatDescription, String aDialogTitle, String lastSelectedFolder, boolean openDialog) {
        final String fileEnding = aFileEnding;
        final String fileFormatDescription = aFileFormatDescription;
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter filter = new FileFilter(){

            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(fileEnding) || myFile.isDirectory();
            }

            public String getDescription() {
                return fileFormatDescription;
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = openDialog ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        if (returnVal == 0) {
            String selectedFile = fileChooser.getSelectedFile().getPath();
            if (!selectedFile.endsWith(fileEnding)) {
                selectedFile = selectedFile + fileEnding;
            }
            File newFile = new File(selectedFile);
            int outcome = 0;
            if (!openDialog && newFile.exists()) {
                outcome = JOptionPane.showConfirmDialog(parent, "Should " + selectedFile + " be overwritten?", "Selected File Already Exists", 0, 2);
            } else if (openDialog && !newFile.exists()) {
                JOptionPane.showMessageDialog(parent, "The file'" + newFile.getAbsolutePath() + "' " + "does not exist!", "File Not Found.", 0);
                return null;
            }
            if (outcome != 0) {
                return null;
            }
            return newFile;
        }
        return null;
    }

    public static String tableToText(JTable table, String separator, ProgressDialogX progressDialog, boolean removeHtml) {
        int i;
        String tableAsString = "";
        for (i = 0; i < table.getColumnCount() && !progressDialog.isRunCanceled(); ++i) {
            tableAsString = tableAsString + table.getColumnName(i) + separator;
        }
        progressDialog.setIndeterminate(false);
        progressDialog.setMaxProgressValue(table.getRowCount());
        tableAsString = tableAsString + System.getProperty("line.separator");
        for (i = 0; i < table.getRowCount() && !progressDialog.isRunCanceled(); ++i) {
            progressDialog.increaseProgressValue();
            for (int j = 0; j < table.getColumnCount() && !progressDialog.isRunCanceled(); ++j) {
                if (table.getValueAt(i, j) != null) {
                    String tempValue = table.getValueAt(i, j).toString();
                    if (tempValue.indexOf("<html>") != -1 && removeHtml) {
                        tempValue = tempValue.replaceAll("\\<[^>]*>", "");
                    }
                    tableAsString = tableAsString + tempValue + separator;
                    continue;
                }
                tableAsString = tableAsString + separator;
            }
            tableAsString = tableAsString + System.getProperty("line.separator");
        }
        return tableAsString;
    }

    public static void tableToFile(JTable table, String separator, ProgressDialogX progressDialog, boolean removeHtml, BufferedWriter writer) throws IOException {
        int i;
        for (i = 0; i < table.getColumnCount() && !progressDialog.isRunCanceled(); ++i) {
            writer.write(table.getColumnName(i) + separator);
        }
        if (progressDialog != null) {
            progressDialog.setIndeterminate(false);
            progressDialog.setMaxProgressValue(table.getRowCount());
        }
        writer.write(System.getProperty("line.separator"));
        for (i = 0; i < table.getRowCount() && !progressDialog.isRunCanceled(); ++i) {
            if (progressDialog != null) {
                progressDialog.increaseProgressValue();
            }
            for (int j = 0; j < table.getColumnCount() && !progressDialog.isRunCanceled(); ++j) {
                if (table.getValueAt(i, j) != null) {
                    String tempValue = table.getValueAt(i, j).toString();
                    if (tempValue.indexOf("<html>") != -1 && removeHtml) {
                        tempValue = tempValue.replaceAll("\\<[^>]*>", "");
                    }
                    writer.write(tempValue + separator);
                    continue;
                }
                writer.write(separator);
            }
            writer.write(System.getProperty("line.separator"));
        }
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfLines(File file) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            int readChars;
            byte[] c = new byte[1024];
            int lineCount = 0;
            while ((readChars = ((InputStream)inputStream).read(c)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++lineCount;
                }
            }
            int n = lineCount;
            return n;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static boolean sameLists(ArrayList<Integer> list1, ArrayList<Integer> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        ArrayList<Integer> list1copy = new ArrayList<Integer>(list1);
        Collections.sort(list1copy);
        ArrayList<Integer> list2copy = new ArrayList<Integer>(list2);
        Collections.sort(list2copy);
        for (int i = 0; i < list1copy.size(); ++i) {
            if (list1copy.get(i).equals(list2copy.get(i))) continue;
            return false;
        }
        return true;
    }
}

