/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class DBResultSet
extends AbstractTableModel {
    Logger logger = Logger.getLogger(DBResultSet.class);
    private int iColCount = 0;
    private int iRowCount = 0;
    private String[] iColNames = null;
    private Object[][] iData = null;

    public DBResultSet() {
        this.iColNames = new String[0];
        this.iData = new Object[][]{new Object[0]};
    }

    public DBResultSet(ResultSet aRS) throws SQLException {
        this(aRS, false);
    }

    public DBResultSet(ResultSet aRS, boolean aNullReplace) throws SQLException {
        ResultSetMetaData rsmd = aRS.getMetaData();
        this.iColCount = rsmd.getColumnCount();
        this.iColNames = new String[this.iColCount];
        for (int i = 0; i < this.iColCount; ++i) {
            this.iColNames[i] = rsmd.getColumnLabel(i + 1);
        }
        Vector<Object[]> rows = new Vector<Object[]>();
        while (aRS.next()) {
            Object[] temp = new Object[this.iColCount];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = aRS.getObject(i + 1);
                if (!aNullReplace || temp[i] != null) continue;
                temp[i] = "(null)";
            }
            rows.add(temp);
        }
        this.iRowCount = rows.size();
        this.iData = new Object[this.iRowCount][this.iColCount];
        for (int i = 0; i < this.iData.length; ++i) {
            this.iData[i] = (Object[])rows.get(i);
        }
    }

    public String[] getColumnNames() {
        return this.iColNames;
    }

    public Object[][] getData() {
        return this.iData;
    }

    public int getColumnCount() {
        return this.iColCount;
    }

    public int getRowCount() {
        return this.iRowCount;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.iData[rowIndex][columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        Class result = String.class;
        for (int i = 0; i < this.iData.length; ++i) {
            if (this.iData[i][columnIndex] == null) continue;
            result = this.iData[i][columnIndex].getClass();
            break;
        }
        return result;
    }

    public String getColumnName(int column) {
        return this.iColNames[column];
    }

    public void writeToCSVFile(Writer out, String aSeparator) throws IOException {
        int i;
        for (i = 0; i < this.iColCount; ++i) {
            out.write(aSeparator + this.getColumnName(i));
        }
        out.write("\n");
        for (i = 0; i < this.iRowCount; ++i) {
            for (int j = 0; j < this.iColCount; ++j) {
                String text = "" + this.getValueAt(i, j);
                if (text.indexOf("<html>") >= 0) {
                    int start = -1;
                    while ((start = text.indexOf("<html>")) >= 0) {
                        text = text.substring(0, start) + text.substring(start + 6);
                    }
                    while ((start = text.indexOf("</html>")) >= 0) {
                        text = text.substring(0, start) + text.substring(start + 7);
                    }
                }
                out.write(aSeparator + text);
            }
            out.write("\n");
        }
    }

    public void writeToHTMLTable(Writer out, int aBorderstyle) throws IOException {
        int i;
        out.write("<table border=\"" + aBorderstyle + "\">\n");
        out.write(" <caption align=\"bottom\">This table was generated by the DBResultSet Java Object.</caption>\n");
        out.write(" <tr>\n");
        for (i = 0; i < this.iColCount; ++i) {
            out.write("  <th>" + this.getColumnName(i) + "</th>\n");
        }
        out.write(" </tr>\n");
        for (i = 0; i < this.iRowCount; ++i) {
            out.write(" <tr>\n");
            for (int j = 0; j < this.iColCount; ++j) {
                Object o = this.getValueAt(i, j);
                String text = null;
                if (o == null) {
                    text = "&nbsp";
                } else {
                    text = o.toString();
                    if (text.trim().equals("")) {
                        text = "&nbsp";
                    } else if (text.indexOf("<html>") >= 0) {
                        int start = -1;
                        while ((start = text.indexOf("<html>")) >= 0) {
                            text = text.substring(0, start) + text.substring(start + 6);
                        }
                        while ((start = text.indexOf("</html>")) >= 0) {
                            text = text.substring(0, start) + text.substring(start + 7);
                        }
                    }
                }
                out.write("  <td>" + text + "</td>\n");
            }
            out.write(" </tr>\n");
        }
        out.write("</table>\n");
    }
}

