/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.db.ObjectsDB;
import com.compomics.util.gui.waiting.WaitingHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectsCache {
    private HashMap<String, ObjectsDB> databases = new HashMap();
    private int cacheSize = 0;
    private boolean automatedMemoryManagement = true;
    private double memoryShare = 0.99;
    private HashMap<String, HashMap<String, HashMap<String, CacheEntry>>> loadedObjectsMap = new HashMap();
    private ArrayList<String> loadedObjectsKeys = new ArrayList();
    private static final String cacheSeparator = "_ccs_";
    private int batchSize = 10000;

    public boolean isAutomatedMemoryManagement() {
        return this.automatedMemoryManagement;
    }

    public void setAutomatedMemoryManagement(boolean automatedMemoryManagement) {
        this.automatedMemoryManagement = automatedMemoryManagement;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public double getMemoryShare() {
        return this.memoryShare;
    }

    public void setMemoryShare(double memoryShare) {
        this.memoryShare = memoryShare;
    }

    public void addDb(ObjectsDB objectsDB) {
        String dbName = objectsDB.getName();
        if (dbName.contains(cacheSeparator)) {
            throw new IllegalArgumentException("Database name (" + dbName + ") should not contain " + cacheSeparator);
        }
        this.databases.put(dbName, objectsDB);
    }

    public void removeObject(String dbName, String tableName, String objectKey) {
        String cacheKey = this.getCacheKey(dbName, tableName, objectKey);
        this.loadedObjectsKeys.remove(cacheKey);
        if (this.loadedObjectsMap.containsKey(dbName) && this.loadedObjectsMap.get(dbName).containsKey(tableName)) {
            this.loadedObjectsMap.get(dbName).get(tableName).remove(objectKey);
        }
    }

    private CacheEntry getEntry(String dbName, String tableName, String objectKey) {
        if (this.loadedObjectsMap.containsKey(dbName) && this.loadedObjectsMap.get(dbName).containsKey(tableName)) {
            return this.loadedObjectsMap.get(dbName).get(tableName).get(objectKey);
        }
        return null;
    }

    public Object getObject(String dbName, String tableName, String objectKey) {
        CacheEntry entry = this.getEntry(dbName, tableName, objectKey);
        if (entry != null) {
            if (!this.memoryCheck()) {
                String entryKey = this.getCacheKey(dbName, tableName, objectKey);
                for (int i = 0; i <= Math.min(100000, this.loadedObjectsKeys.size() / 2); ++i) {
                    if (!entryKey.equals(this.loadedObjectsKeys.get(i))) continue;
                    this.loadedObjectsKeys.remove(i);
                    this.loadedObjectsKeys.add(entryKey);
                    break;
                }
            }
            return entry.getObject();
        }
        return null;
    }

    public boolean updateObject(String dbName, String tableName, String objectKey, Object object) {
        CacheEntry entry = this.getEntry(dbName, tableName, objectKey);
        if (entry != null) {
            entry.setModified(true);
            entry.setObject(object);
            return true;
        }
        return false;
    }

    public void addObject(String dbName, String tableName, String objectKey, Object object, boolean modifiedOrNew) throws IOException, SQLException {
        if (dbName.contains(cacheSeparator)) {
            throw new IllegalArgumentException("Database name (" + dbName + ") should not contain " + cacheSeparator);
        }
        if (tableName.contains(cacheSeparator)) {
            throw new IllegalArgumentException("Table name (" + tableName + ") should not contain " + cacheSeparator);
        }
        if (objectKey.contains(cacheSeparator)) {
            throw new IllegalArgumentException("Object key (" + objectKey + ") should not contain " + cacheSeparator);
        }
        this.loadedObjectsKeys.add(this.getCacheKey(dbName, tableName, objectKey));
        if (!this.loadedObjectsMap.containsKey(dbName)) {
            this.loadedObjectsMap.put(dbName, new HashMap());
        }
        if (!this.loadedObjectsMap.get(dbName).containsKey(tableName)) {
            this.loadedObjectsMap.get(dbName).put(tableName, new HashMap());
        }
        this.loadedObjectsMap.get(dbName).get(tableName).put(objectKey, new CacheEntry(object, modifiedOrNew));
        this.updateCache();
    }

    public boolean memoryCheck() {
        return Runtime.getRuntime().totalMemory() < (long)(this.memoryShare * (double)Runtime.getRuntime().maxMemory());
    }

    public void saveObjects(ArrayList<String> entryKeys) throws IOException, SQLException {
        this.saveObjects(entryKeys, null, true);
    }

    public void saveObjects(ArrayList<String> entryKeys, WaitingHandler waitingHandler) throws IOException, SQLException {
        this.saveObjects(entryKeys, waitingHandler, true);
    }

    public void saveObjects(ArrayList<String> entryKeys, WaitingHandler waitingHandler, boolean clearEntries) throws IOException, SQLException {
        String objectKey;
        String tableName2;
        String dbName;
        String[] splittedKey;
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressValue(2 * entryKeys.size());
            waitingHandler.setSecondaryProgressDialogIndeterminate(false);
        }
        HashMap toSave = new HashMap();
        for (String entryKey : entryKeys) {
            splittedKey = this.getKeyComponents(entryKey);
            dbName = splittedKey[0];
            tableName2 = splittedKey[1];
            objectKey = splittedKey[2];
            CacheEntry entry = this.loadedObjectsMap.get(dbName).get(tableName2).get(objectKey);
            if (entry.isModified()) {
                if (!toSave.containsKey(dbName)) {
                    toSave.put(dbName, new HashMap());
                }
                if (!((HashMap)toSave.get(dbName)).containsKey(tableName2)) {
                    ((HashMap)toSave.get(dbName)).put(tableName2, new HashMap());
                }
                ((HashMap)((HashMap)toSave.get(dbName)).get(tableName2)).put(objectKey, entry.getObject());
                continue;
            }
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressValue();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        for (String dbName2 : toSave.keySet()) {
            ObjectsDB objectsDB = this.databases.get(dbName2);
            for (String tableName2 : ((HashMap)toSave.get(dbName2)).keySet()) {
                objectsDB.insertObjects(tableName2, (HashMap)((HashMap)toSave.get(dbName2)).get(tableName2), waitingHandler);
            }
        }
        if ((waitingHandler == null || !waitingHandler.isRunCanceled()) && clearEntries) {
            for (String entryKey : entryKeys) {
                splittedKey = this.getKeyComponents(entryKey);
                dbName = splittedKey[0];
                tableName2 = splittedKey[1];
                objectKey = splittedKey[2];
                this.loadedObjectsKeys.remove(entryKey);
                this.loadedObjectsMap.get(dbName).get(tableName2).remove(objectKey);
                if (this.loadedObjectsMap.get(dbName).get(tableName2).isEmpty()) {
                    this.loadedObjectsMap.get(dbName).remove(tableName2);
                }
                if (!this.loadedObjectsMap.get(dbName).isEmpty()) continue;
                this.loadedObjectsMap.remove(dbName);
            }
        }
    }

    public void saveObject(String entryKey) throws IOException, SQLException {
        this.saveObject(entryKey, true);
    }

    public void saveObject(String entryKey, boolean clearEntry) throws IOException, SQLException {
        String[] splittedKey = this.getKeyComponents(entryKey);
        String dbName = splittedKey[0];
        String tableName = splittedKey[1];
        String objectKey = splittedKey[2];
        CacheEntry entry = this.loadedObjectsMap.get(dbName).get(tableName).get(objectKey);
        if (entry.isModified()) {
            try {
                ObjectsDB objectsDB = this.databases.get(dbName);
                if (objectsDB == null) {
                    throw new IllegalStateException("Database " + dbName + " not loaded in cache");
                }
                if (objectsDB.inDB(tableName, objectKey, false)) {
                    objectsDB.updateObject(tableName, objectKey, entry.getObject(), false);
                } else {
                    objectsDB.insertObject(tableName, objectKey, entry.getObject(), false);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException("Error while writing match " + objectKey + " in table " + tableName + " in database" + dbName + ".");
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException("Error while writing match " + objectKey + " in table " + tableName + " in database" + dbName + ".");
            }
        }
        if (clearEntry) {
            this.loadedObjectsKeys.remove(entryKey);
            this.loadedObjectsMap.get(dbName).get(tableName).remove(objectKey);
            if (this.loadedObjectsMap.get(dbName).get(tableName).isEmpty()) {
                this.loadedObjectsMap.get(dbName).remove(tableName);
            }
            if (this.loadedObjectsMap.get(dbName).isEmpty()) {
                this.loadedObjectsMap.remove(dbName);
            }
        }
    }

    public void updateCache() throws IOException, SQLException {
        while (!this.automatedMemoryManagement && this.loadedObjectsKeys.size() > this.cacheSize || this.automatedMemoryManagement && !this.memoryCheck()) {
            int toRemove = Math.min(this.batchSize, this.loadedObjectsKeys.size() / 2);
            if (toRemove <= 1) {
                this.saveObject(this.loadedObjectsKeys.get(0));
            } else {
                ArrayList<String> keysToRemove = new ArrayList<String>(this.loadedObjectsKeys.subList(0, toRemove));
                this.saveObjects(keysToRemove);
            }
            if (!this.loadedObjectsKeys.isEmpty()) continue;
            break;
        }
    }

    public void reduceMemoryConsumption(double share, WaitingHandler waitingHandler) throws IOException, SQLException {
        int toRemove = (int)(share * (double)this.loadedObjectsKeys.size());
        ArrayList<String> keysToRemove = new ArrayList<String>(this.loadedObjectsKeys.subList(0, toRemove));
        this.saveObjects(keysToRemove, waitingHandler);
    }

    public boolean inCache(String dbName, String tableName, String objectKey) {
        return this.loadedObjectsMap.containsKey(dbName) && this.loadedObjectsMap.get(dbName).containsKey(tableName) && this.loadedObjectsMap.get(dbName).get(tableName).containsKey(objectKey);
    }

    public void saveCache(WaitingHandler waitingHandler, boolean emptyCache) throws IOException, SQLException {
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressValue(this.loadedObjectsKeys.size() + 1);
            waitingHandler.setSecondaryProgressDialogIndeterminate(false);
            waitingHandler.setSecondaryProgressValue(0);
        }
        for (String dbName : this.loadedObjectsMap.keySet()) {
            ObjectsDB objectsDB = this.databases.get(dbName);
            if (objectsDB == null) {
                throw new IllegalStateException("Database " + dbName + " not loaded in cache");
            }
            for (String tableName : this.loadedObjectsMap.get(dbName).keySet()) {
                HashMap<String, Object> objectsToStore = new HashMap<String, Object>();
                HashMap<String, CacheEntry> data = this.loadedObjectsMap.get(dbName).get(tableName);
                for (String objectKey : data.keySet()) {
                    CacheEntry entry = this.loadedObjectsMap.get(dbName).get(tableName).get(objectKey);
                    if (entry.isModified()) {
                        objectsToStore.put(objectKey, entry.getObject());
                        continue;
                    }
                    if (waitingHandler == null) continue;
                    waitingHandler.increaseSecondaryProgressValue();
                    if (!waitingHandler.isRunCanceled()) continue;
                    return;
                }
                objectsDB.insertObjects(tableName, objectsToStore, waitingHandler);
            }
        }
        if (emptyCache) {
            this.loadedObjectsMap.clear();
            this.loadedObjectsKeys.clear();
        }
    }

    private String getCacheKey(String dbName, String tableName, String objectKey) {
        return dbName + cacheSeparator + tableName + cacheSeparator + objectKey;
    }

    private String[] getKeyComponents(String cacheKey) {
        return cacheKey.split(cacheSeparator);
    }

    private class CacheEntry {
        private Object object;
        private boolean modified;

        public CacheEntry(Object object, boolean modified) {
            this.object = object;
            this.modified = modified;
        }

        public boolean isModified() {
            return this.modified;
        }

        public void setModified(boolean modified) {
            this.modified = modified;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }
}

