/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enzyme
extends ExperimentObject {
    static final long serialVersionUID = -1852087173903613377L;
    private int id;
    private String name;
    private ArrayList<Character> aminoAcidBefore = new ArrayList();
    private ArrayList<Character> aminoAcidAfter = new ArrayList();
    private ArrayList<Character> restrictionBefore = new ArrayList();
    private ArrayList<Character> restrictionAfter = new ArrayList();

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Enzyme(int id, String name, String aminoAcidBefore, String restrictionBefore, String aminoAcidAfter, String restrictionAfter) {
        this.id = id;
        this.name = name;
        for (char aa : aminoAcidBefore.toCharArray()) {
            this.aminoAcidBefore.add(Character.valueOf(aa));
        }
        for (char aa : restrictionBefore.toCharArray()) {
            this.restrictionBefore.add(Character.valueOf(aa));
        }
        for (char aa : aminoAcidAfter.toCharArray()) {
            this.aminoAcidAfter.add(Character.valueOf(aa));
        }
        for (char aa : restrictionAfter.toCharArray()) {
            this.restrictionAfter.add(Character.valueOf(aa));
        }
    }

    public String getXTandemFormat() {
        String result = "";
        if (this.aminoAcidBefore.size() > 0) {
            result = result + "[";
            for (Character aa : this.aminoAcidBefore) {
                result = result + aa;
            }
            result = result + "]";
        }
        if (this.restrictionBefore.size() > 0) {
            result = result + "{";
            for (Character aa : this.restrictionBefore) {
                result = result + aa;
            }
            result = result + "}";
        }
        result = result + "|";
        if (this.aminoAcidAfter.size() > 0) {
            result = result + "[";
            for (Character aa : this.aminoAcidAfter) {
                result = result + aa;
            }
            result = result + "]";
        }
        if (this.restrictionAfter.size() > 0) {
            result = result + "{";
            for (Character aa : this.restrictionAfter) {
                result = result + aa;
            }
            result = result + "}";
        }
        return result;
    }

    public ArrayList<Character> getAminoAcidAfter() {
        return this.aminoAcidAfter;
    }

    public ArrayList<Character> getAminoAcidBefore() {
        return this.aminoAcidBefore;
    }

    public ArrayList<Character> getRestrictionAfter() {
        return this.restrictionAfter;
    }

    public ArrayList<Character> getRestrictionBefore() {
        return this.restrictionBefore;
    }

    public boolean enzymeCleaves() {
        return !this.getAminoAcidBefore().isEmpty() || !this.getAminoAcidAfter().isEmpty();
    }

    public boolean isCleavageSite(String aaBefore, String aaAfter) {
        boolean restriction;
        for (Character aa1 : this.aminoAcidBefore) {
            if (!aaBefore.equals(aa1 + "")) continue;
            restriction = false;
            for (Character aa2 : this.restrictionAfter) {
                if (!aaAfter.equals(aa2 + "")) continue;
                restriction = true;
                break;
            }
            if (restriction) continue;
            return true;
        }
        for (Character aa1 : this.aminoAcidAfter) {
            if (!aaBefore.equals(aa1 + "")) continue;
            restriction = false;
            for (Character aa2 : this.restrictionBefore) {
                if (!aaAfter.equals(aa2 + "")) continue;
                restriction = true;
                break;
            }
            if (restriction) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> digest(String sequence, int nMissedCleavages, int nMin, int nMax) {
        int i;
        String aaBefore = "";
        String aaAfter = "";
        String currentPeptide = "";
        ArrayList<String> results = new ArrayList<String>();
        HashMap mc = new HashMap();
        for (i = 1; i <= nMissedCleavages; ++i) {
            mc.put(i, new ArrayList());
        }
        for (i = 0; i < sequence.length(); ++i) {
            aaBefore = aaAfter;
            String aa = sequence.charAt(i) + "";
            if (this.isCleavageSite(aaBefore, aaAfter = aa) && !currentPeptide.equals("")) {
                if (currentPeptide.length() >= nMin && currentPeptide.length() <= nMax && !results.contains(currentPeptide)) {
                    results.add(currentPeptide);
                }
                Iterator i$ = mc.keySet().iterator();
                while (i$.hasNext()) {
                    int nMc = (Integer)i$.next();
                    ((ArrayList)mc.get(nMc)).add(currentPeptide);
                    while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                        ((ArrayList)mc.get(nMc)).remove(0);
                    }
                    String mcSequence = "";
                    for (String subPeptide : (ArrayList)mc.get(nMc)) {
                        mcSequence = mcSequence + subPeptide;
                    }
                    if (mcSequence.length() < nMin || mcSequence.length() > nMax || results.contains(mcSequence)) continue;
                    results.add(mcSequence);
                }
                currentPeptide = "";
            }
            currentPeptide = currentPeptide + aa;
        }
        if (currentPeptide.length() >= nMin && currentPeptide.length() <= nMax && !results.contains(currentPeptide)) {
            results.add(currentPeptide);
        }
        Iterator i$ = mc.keySet().iterator();
        while (i$.hasNext()) {
            int nMc = (Integer)i$.next();
            ((ArrayList)mc.get(nMc)).add(currentPeptide);
            while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                ((ArrayList)mc.get(nMc)).remove(0);
            }
            String mcSequence = "";
            for (String subPeptide : (ArrayList)mc.get(nMc)) {
                mcSequence = mcSequence + subPeptide;
            }
            if (mcSequence.length() < nMin || mcSequence.length() > nMax || results.contains(mcSequence)) continue;
            results.add(mcSequence);
        }
        return results;
    }
}

