/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.Enzyme;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnzymeFactory {
    private HashMap<String, Enzyme> enzymes = null;
    private static EnzymeFactory instance = null;

    private EnzymeFactory() {
    }

    public static EnzymeFactory getInstance() {
        if (instance == null) {
            instance = new EnzymeFactory();
        }
        return instance;
    }

    public ArrayList<Enzyme> getEnzymes() {
        return new ArrayList<Enzyme>(this.enzymes.values());
    }

    public Enzyme getEnzyme(String enzymeName) {
        return this.enzymes.get(enzymeName);
    }

    public void addEnzyme(Enzyme enzyme) {
        this.enzymes.put(enzyme.getName(), enzyme);
    }

    public boolean enzymeLoaded(String enzyme) {
        return this.enzymes.containsKey(enzyme);
    }

    public void importEnzymes(File enzymeFile) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(enzymeFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        this.enzymes = new HashMap();
        while (type != 1) {
            if (type == 2 && parser.getName().equals("enzyme")) {
                this.parseEnzyme(parser);
            }
            type = parser.next();
        }
        br.close();
    }

    private void parseEnzyme(XmlPullParser aParser) throws XmlPullParserException, IOException {
        int id;
        aParser.nextTag();
        if (!aParser.getName().equals("id")) {
            throw new XmlPullParserException("Found tag '" + aParser.getName() + "' where 'id' was expected on line " + aParser.getLineNumber() + ".");
        }
        aParser.next();
        String idString = aParser.getText();
        try {
            id = Integer.parseInt(idString.trim());
        }
        catch (NumberFormatException nfe) {
            throw new XmlPullParserException("Found non-parseable text '" + idString + "' for the value of the 'id' tag on line " + aParser.getLineNumber() + ".");
        }
        int type = aParser.next();
        while (type != 2 || !aParser.getName().equals("name")) {
            type = aParser.next();
        }
        aParser.next();
        String name = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("aminoAcidBefore")) {
            type = aParser.next();
        }
        aParser.next();
        String aaBefore = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("restrictionBefore")) {
            type = aParser.next();
        }
        aParser.next();
        String restrictionBefore = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("aminoAcidAfter")) {
            type = aParser.next();
        }
        aParser.next();
        String aaAfter = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("restrictionAfter")) {
            type = aParser.next();
        }
        aParser.next();
        String restrictionAfter = aParser.getText().trim();
        this.enzymes.put(name, new Enzyme(id, name, aaBefore, restrictionBefore, aaAfter, restrictionAfter));
    }
}

