/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.ions.Glycon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyconFactory {
    private static GlyconFactory instance = null;
    private static ArrayList<Glycon> glycons = new ArrayList();

    private GlyconFactory() {
    }

    public static GlyconFactory getInstance() {
        if (instance == null) {
            instance = new GlyconFactory();
        }
        return instance;
    }

    public ArrayList<Glycon> getGlycons() {
        return glycons;
    }

    public void importGlycons(File aFile) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(aFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        while (type != 1) {
            if (type == 2 && parser.getName().equals("glycon")) {
                this.parseGlycon(parser);
            }
            type = parser.next();
        }
        br.close();
    }

    private void parseGlycon(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("name")) {
            type = parser.next();
        }
        type = parser.next();
        String name = parser.getText().trim();
        while (type != 2 || !parser.getName().equals("shortName")) {
            type = parser.next();
        }
        type = parser.next();
        String shortName = parser.getText().trim();
        Glycon currentGlycon = new Glycon(shortName, name);
        while (type != 2 || !parser.getName().equals("underivatisedMass")) {
            type = parser.next();
        }
        type = parser.next();
        Double mass = new Double(parser.getText().trim());
        currentGlycon.addMass(0, mass);
        while (type != 2 || !parser.getName().equals("permethylatedMass")) {
            type = parser.next();
        }
        type = parser.next();
        mass = new Double(parser.getText().trim());
        currentGlycon.addMass(1, mass);
        while (type != 2 || !parser.getName().equals("deuteromethylatedMass")) {
            type = parser.next();
        }
        type = parser.next();
        mass = new Double(parser.getText().trim());
        currentGlycon.addMass(2, mass);
        while (type != 2 || !parser.getName().equals("peracetylatedMass")) {
            type = parser.next();
        }
        type = parser.next();
        mass = new Double(parser.getText().trim());
        currentGlycon.addMass(3, mass);
        while (type != 2 || !parser.getName().equals("deuteroacetylatedMass")) {
            type = parser.next();
        }
        type = parser.next();
        mass = new Double(parser.getText().trim());
        currentGlycon.addMass(4, mass);
        glycons.add(currentGlycon);
    }
}

