/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.ModificationProfile;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTMFactory
implements Serializable {
    static final long serialVersionUID = 7935264190312934466L;
    private static PTMFactory instance = null;
    private static final String SERIALIZATION_FILE = System.getProperty("user.home") + "/.compomics/ptmFactory-3.10.32.cus";
    private HashMap<String, PTM> ptmMap = new HashMap();
    private ArrayList<String> defaultMods = new ArrayList();
    private ArrayList<String> userMods = new ArrayList();
    private HashMap<String, Color> userColors = new HashMap();
    private HashMap<String, String> shortNames = new HashMap();
    private HashMap<String, Integer> defaultOmssaIndexes = new HashMap();
    public static final PTM unknownPTM = new PTM(0, "unknown", 0.0, new AminoAcidPattern());
    public static final String SEARCH_SUFFIX = "|search-only";

    private PTMFactory() {
        this.ptmMap.put(unknownPTM.getName(), unknownPTM);
        this.defaultMods = new ArrayList();
        this.defaultMods.add("unknown");
    }

    public static PTMFactory getInstance() {
        if (instance == null) {
            try {
                File savedFile = new File(SERIALIZATION_FILE);
                instance = (PTMFactory)SerializationUtils.readObject(savedFile);
            }
            catch (Exception e) {
                instance = new PTMFactory();
                try {
                    instance.saveFactory();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            instance.setDefaultReporterIons();
        }
        return instance;
    }

    public void clearFactory() {
        instance = new PTMFactory();
    }

    public void reloadFactory() {
        instance = null;
    }

    public void saveFactory() throws IOException {
        File factoryFile = new File(SERIALIZATION_FILE);
        if (!factoryFile.getParentFile().exists()) {
            factoryFile.getParentFile().mkdir();
        }
        SerializationUtils.writeObject(instance, factoryFile);
    }

    public PTM getPTM(ModificationProfile modificationProfile, int index) {
        String name = modificationProfile.getModification(index);
        if (name != null && this.ptmMap.get(name) != null) {
            return this.ptmMap.get(name);
        }
        return unknownPTM;
    }

    public PTM getSearchedPTM(PTM modification) {
        if (!modification.isStandardSearch()) {
            return new PTM(modification.getType(), modification.getName() + SEARCH_SUFFIX, modification.getMass(), modification.getPattern().getStandardSearchPattern());
        }
        return modification;
    }

    public PTM getSearchedPTM(String modificationName) {
        PTM modification = this.getPTM(modificationName);
        return this.getSearchedPTM(modification);
    }

    public void addUserPTM(PTM ptm) {
        String modName = ptm.getName();
        this.ptmMap.put(modName, ptm);
        if (!this.userMods.contains(modName)) {
            this.userMods.add(modName);
        } else {
            this.userMods.set(this.userMods.indexOf(modName), modName);
        }
    }

    public void removeUserPtm(String ptmName) {
        if (this.defaultMods.contains(ptmName)) {
            throw new IllegalArgumentException("Impossible to remove default modification " + ptmName);
        }
        this.ptmMap.remove(ptmName);
        this.userMods.remove(ptmName);
    }

    public PTM getPTM(String name) {
        if (this.ptmMap.containsKey(name)) {
            return this.ptmMap.get(name);
        }
        if (name.indexOf("@") > 1) {
            try {
                double mass = 0.0;
                try {
                    mass = new Double(name.substring(0, name.indexOf("@")));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Trying to parse modification " + name + " like an X!Tandem modification!");
                }
                return new PTM(-1, name, mass, new AminoAcidPattern());
            }
            catch (Exception e) {
                return unknownPTM;
            }
        }
        return unknownPTM;
    }

    public boolean containsPTM(String name) {
        return this.ptmMap.containsKey(name);
    }

    public PTM getPTM(double mass, String location, String sequence) {
        for (PTM currentPTM : this.ptmMap.values()) {
            if (currentPTM.getType() == 0 || currentPTM.getType() == 4 || currentPTM.getType() == 8 || currentPTM.getType() == 2 || currentPTM.getType() == 6) {
                if (!(Math.abs(currentPTM.getMass() - mass) < 0.01)) continue;
                try {
                    for (int index : Peptide.getPotentialModificationSites(sequence, currentPTM)) {
                        if (!location.equals(sequence.charAt(index) + "")) continue;
                        return currentPTM;
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (!(currentPTM.getType() == 3 || currentPTM.getType() == 7 ? Math.abs(currentPTM.getMass() - mass) < 0.01 && sequence.endsWith(location) : (currentPTM.getType() == 1 || currentPTM.getType() == 5) && Math.abs(currentPTM.getMass() - mass) < 0.01 && sequence.startsWith(location))) continue;
            return currentPTM;
        }
        return unknownPTM;
    }

    public void importModifications(File modificationsFile, boolean userMod) throws XmlPullParserException, IOException {
        this.importModifications(modificationsFile, userMod, false);
    }

    public void importModifications(File modificationsFile, boolean userMod, boolean overwrite) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(modificationsFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        while (type != 1) {
            if (type == 2 && parser.getName().equals("MSModSpec")) {
                this.parseMSModSpec(parser, userMod, overwrite);
            }
            type = parser.next();
        }
        br.close();
        this.setDefaultNeutralLosses();
        this.setDefaultReporterIons();
    }

    public Integer getDefaultOMSSAIndex(String modificationName) {
        return this.defaultOmssaIndexes.get(modificationName);
    }

    public static HashMap<String, Integer> getOMSSAIndexes(File modificationsFile) throws XmlPullParserException, FileNotFoundException, IOException {
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(modificationsFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        Integer number = null;
        while (type != 1) {
            if (type == 2 && parser.getName().equals("MSMod")) {
                parser.next();
                String numberString = parser.getText();
                try {
                    number = new Integer(numberString);
                }
                catch (NumberFormatException nfe) {
                    throw new XmlPullParserException("Found non-parseable text '" + numberString + "' for the value of the 'MSMod' tag on line " + parser.getLineNumber() + ".");
                }
            }
            if (type == 2 && parser.getName().equals("MSModSpec_name")) {
                parser.next();
                String name = parser.getText();
                if (number != null) {
                    indexes.put(name, number);
                }
            }
            type = parser.next();
        }
        br.close();
        return indexes;
    }

    private void parseMSModSpec(XmlPullParser parser, boolean userMod, boolean overwrite) throws XmlPullParserException, IOException {
        if (!parser.getName().equals("MSModSpec") || parser.getEventType() != 2) {
            throw new IllegalArgumentException("XmlPullParser should have been on the start tag for 'MSModSpec', but was on '" + parser.getName() + "' instead.");
        }
        parser.nextTag();
        if (!parser.getName().equals("MSModSpec_mod")) {
            throw new XmlPullParserException("Found tag '" + parser.getName() + "' where 'MSModSpec_mod' was expected on line " + parser.getLineNumber() + ".");
        }
        parser.nextTag();
        if (!parser.getName().equals("MSMod")) {
            throw new XmlPullParserException("Found tag '" + parser.getName() + "' where 'MSMod' was expected on line " + parser.getLineNumber() + ".");
        }
        parser.next();
        String numberString = parser.getText();
        int number = -1;
        try {
            number = Integer.parseInt(numberString);
        }
        catch (NumberFormatException nfe) {
            throw new XmlPullParserException("Found non-parseable text '" + numberString + "' for the value of the 'MSMod' tag on line " + parser.getLineNumber() + ".");
        }
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModType")) {
            type = parser.next();
        }
        String modType = parser.getAttributeValue(0);
        type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModSpec_name")) {
            type = parser.next();
        }
        parser.next();
        String name = parser.getText().trim().toLowerCase();
        type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModSpec_monomass")) {
            type = parser.next();
        }
        parser.next();
        String mass = parser.getText().trim();
        type = parser.next();
        ArrayList<String> residues = new ArrayList<String>();
        if (modType.compareTo("modcaa") == 0 || modType.compareTo("modcpaa") == 0 || modType.compareTo("modnaa") == 0 || modType.compareTo("modnpaa") == 0 || modType.compareTo("modaa") == 0) {
            while (type != 2 || !parser.getName().equals("MSModSpec_residues_E")) {
                type = parser.next();
            }
            ArrayList<String> aminoAcids = new ArrayList<String>();
            while (type == 2 && parser.getName().equals("MSModSpec_residues_E")) {
                parser.next();
                aminoAcids.add(parser.getText().trim());
                parser.next();
                parser.next();
                type = parser.next();
            }
            for (String aa : aminoAcids) {
                if (residues.contains(aa)) continue;
                residues.add(aa);
            }
        }
        AminoAcidPattern pattern = new AminoAcidPattern(residues);
        PTM currentPTM = new PTM(this.getIndex(modType), name, (double)new Double(mass), pattern);
        while (!(type == 2 && parser.getName().equals("MSModSpec_neutralloss") || type == 3 && parser.getName().equals("MSModSpec"))) {
            type = parser.next();
        }
        if (parser.getName().equals("MSModSpec_neutralloss")) {
            ArrayList<NeutralLoss> neutralLosses = new ArrayList<NeutralLoss>();
            int cpt = 1;
            while (type != 3 || !parser.getName().equals("MSModSpec_neutralloss")) {
                type = parser.next();
                if (type != 2 || !parser.getName().equals("MSMassSet_monomass")) continue;
                parser.next();
                String doubleString = "";
                try {
                    doubleString = parser.getText().trim();
                    double neutralLossMass = new Double(doubleString);
                    neutralLosses.add(new NeutralLoss(name + " " + cpt, neutralLossMass, true));
                }
                catch (Exception e) {
                    throw new XmlPullParserException("Found non-parseable text '" + doubleString + "' for the value of the 'MSMassSet_monomass' neutral loss tag on line " + parser.getLineNumber() + ".");
                }
                ++cpt;
            }
            currentPTM.setNeutralLosses(neutralLosses);
        }
        while (type != 3 || !parser.getName().equals("MSModSpec")) {
            type = parser.next();
        }
        if (!name.startsWith("user modification ")) {
            if (!name.endsWith(SEARCH_SUFFIX)) {
                this.ptmMap.put(name, currentPTM);
            } else {
                name = name.substring(0, name.lastIndexOf(SEARCH_SUFFIX));
            }
            if (userMod) {
                if (this.defaultMods.contains(name)) {
                    throw new IllegalArgumentException("Impossible to load " + name + " as user modification. Already defined as default modification.");
                }
                if (!this.userMods.contains(name) || overwrite) {
                    this.userMods.add(name);
                }
            } else if (!this.defaultMods.contains(name) || overwrite) {
                this.defaultMods.add(name);
                this.defaultOmssaIndexes.put(name, number);
            }
        }
    }

    private int getIndex(String modType) {
        if (modType.compareTo("modaa") == 0) {
            return 0;
        }
        if (modType.compareTo("modn") == 0) {
            return 1;
        }
        if (modType.compareTo("modnaa") == 0) {
            return 2;
        }
        if (modType.compareTo("modnp") == 0) {
            return 5;
        }
        if (modType.compareTo("modnpaa") == 0) {
            return 6;
        }
        if (modType.compareTo("modc") == 0) {
            return 3;
        }
        if (modType.compareTo("modcaa") == 0) {
            return 4;
        }
        if (modType.compareTo("modcp") == 0) {
            return 7;
        }
        if (modType.compareTo("modcpaa") == 0) {
            return 8;
        }
        return -1;
    }

    public void writeOmssaModificationsFiles(File aFolder, File utilitiesModFile, File utilitiesUserModFile) throws IOException {
        int c;
        BufferedReader br = new BufferedReader(new FileReader(utilitiesModFile));
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(aFolder, "mods.xml")));
        while ((c = br.read()) != -1) {
            bw.write(c);
        }
        bw.flush();
        bw.close();
        br.close();
        br = new BufferedReader(new FileReader(utilitiesUserModFile));
        bw = new BufferedWriter(new FileWriter(new File(aFolder, "usermods.xml")));
        while ((c = br.read()) != -1) {
            bw.write(c);
        }
        bw.flush();
        bw.close();
        br.close();
    }

    public void writeOmssaUserModificationFile(File file) throws IOException {
        int cpt;
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        String toWrite = "<?xml version=\"1.0\"?>\n<MSModSpecSet\nxmlns=\"http://www.ncbi.nlm.nih.gov\"\nxmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\nxs:schemaLocation=\"http://www.ncbi.nlm.nih.gov OMSSA.xsd\"\n>\n\n";
        bw.write(toWrite);
        for (cpt = 1; cpt <= this.userMods.size(); ++cpt) {
            String ptmName = this.userMods.get(cpt - 1);
            toWrite = this.getOmssaUserModBloc(ptmName, cpt);
            bw.write(toWrite);
        }
        for (cpt = this.userMods.size() + 1; cpt <= 30; ++cpt) {
            int omssaIndex = cpt + 118;
            if (omssaIndex > 128) {
                omssaIndex += 13;
            }
            toWrite = "\t<MSModSpec>\n\t\t<MSModSpec_mod>\n\t\t\t<MSMod value=\"usermod" + cpt + "\">" + omssaIndex + "</MSMod>\n" + "\t\t</MSModSpec_mod>\n" + "\t\t<MSModSpec_type>\n" + "\t\t\t<MSModType value=\"modaa\">0</MSModType>\n" + "\t\t</MSModSpec_type>\n" + "\t\t<MSModSpec_name>User modification " + cpt + "</MSModSpec_name>\n" + "\t\t<MSModSpec_monomass>0</MSModSpec_monomass>\n" + "\t\t<MSModSpec_averagemass>0</MSModSpec_averagemass>\n" + "\t\t<MSModSpec_n15mass>0</MSModSpec_n15mass>\n" + "\t\t<MSModSpec_residues>\n" + "\t\t\t<MSModSpec_residues_E>X</MSModSpec_residues_E>\n" + "\t\t</MSModSpec_residues>\n" + "\t</MSModSpec>\n";
            bw.write(toWrite);
        }
        toWrite = "</MSModSpecSet>";
        bw.write(toWrite);
        bw.flush();
        bw.close();
    }

    public String getOmssaUserModBloc(String ptmName, int cpt) {
        int omssaIndex = cpt + 118;
        if (omssaIndex > 128) {
            omssaIndex += 13;
        }
        PTM ptm = this.getSearchedPTM(ptmName);
        String result = "\t<MSModSpec>\n";
        result = result + "\t\t<MSModSpec_mod>\n";
        result = result + "\t\t\t<MSMod value=\"usermod" + cpt + "\">" + omssaIndex + "</MSMod>\n";
        result = result + "\t\t</MSModSpec_mod>\n\t\t<MSModSpec_type>\n";
        if (ptm.getType() == 0) {
            result = result + "\t\t\t<MSModType value=\"modaa\">0</MSModType>\n";
        } else if (ptm.getType() == 1) {
            result = result + "\t\t\t<MSModType value=\"modn\">1</MSModType>\n";
        } else if (ptm.getType() == 2) {
            result = result + "\t\t\t<MSModType value=\"modnaa\">2</MSModType>\n";
        } else if (ptm.getType() == 5) {
            result = result + "\t\t\t<MSModType value=\"modnp\">5</MSModType>\n";
        } else if (ptm.getType() == 6) {
            result = result + "\t\t\t<MSModType value=\"modnpaa\">6</MSModType>\n";
        } else if (ptm.getType() == 3) {
            result = result + "\t\t\t<MSModType value=\"modc\">3</MSModType>\n";
        } else if (ptm.getType() == 4) {
            result = result + "\t\t\t<MSModType value=\"modcaa\">4</MSModType>\n";
        } else if (ptm.getType() == 7) {
            result = result + "\t\t\t<MSModType value=\"modcp\">7</MSModType>\n";
        } else if (ptm.getType() == 8) {
            result = result + "\t\t\t<MSModType value=\"modcpaa\">8</MSModType>\n";
        }
        result = result + "\t\t</MSModSpec_type>\n";
        result = result + "\t\t<MSModSpec_name>" + ptm.getName() + "</MSModSpec_name>\n";
        result = result + "\t\t<MSModSpec_monomass>" + ptm.getMass() + "</MSModSpec_monomass>\n" + "\t\t<MSModSpec_averagemass>0</MSModSpec_averagemass>\n" + "\t\t<MSModSpec_n15mass>0</MSModSpec_n15mass>\n";
        if (ptm.getType() == 0 || ptm.getType() == 2 || ptm.getType() == 6 || ptm.getType() == 4 || ptm.getType() == 8) {
            result = result + "\t\t<MSModSpec_residues>\n";
            for (AminoAcid aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                result = result + "\t\t\t<MSModSpec_residues_E>" + aa.singleLetterCode + "</MSModSpec_residues_E>\n";
            }
            result = result + "\t\t</MSModSpec_residues>\n";
        }
        boolean first = true;
        for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
            if (!neutralLoss.isFixed()) continue;
            if (first) {
                result = result + "\t\t<MSModSpec_neutralloss>\n";
                first = false;
            }
            result = result + "\t\t\t<MSMassSet>\n";
            result = result + "\t\t\t\t<MSMassSet_monomass>" + neutralLoss.mass + "</MSMassSet_monomass>\n";
            result = result + "\t\t\t\t<MSMassSet_averagemass>0</MSMassSet_averagemass>";
            result = result + "\t\t\t\t<MSMassSet_n15mass>0</MSMassSet_n15mass>";
            result = result + "\t\t\t</MSMassSet>\n";
        }
        if (!first) {
            result = result + "\t\t</MSModSpec_neutralloss>\n";
        }
        result = result + "\t</MSModSpec>\n";
        return result;
    }

    public ArrayList<String> getDefaultModifications() {
        return this.defaultMods;
    }

    public ArrayList<String> getUserModifications() {
        return this.userMods;
    }

    public ArrayList<String> getPTMs() {
        return new ArrayList<String>(this.ptmMap.keySet());
    }

    public boolean isUserDefined(String ptmName) {
        return !this.defaultMods.contains(ptmName);
    }

    public ArrayList<String> loadBackedUpModifications(SearchParameters searchParameters, boolean overwrite) {
        ModificationProfile modificationProfile = searchParameters.getModificationProfile();
        ArrayList<String> toCheck = new ArrayList<String>();
        for (String modification : modificationProfile.getBackedUpPtms()) {
            PTM ptm;
            if (this.containsPTM(modification)) {
                PTM oldPTM = this.getPTM(modification);
                if (!oldPTM.isSameAs(modificationProfile.getPtm(modification))) {
                    toCheck.add(modification);
                    if (overwrite) {
                        this.ptmMap.put(modification, modificationProfile.getPtm(modification));
                    }
                }
            } else {
                this.addUserPTM(modificationProfile.getPtm(modification));
            }
            if (this.shortNames.containsKey(modification) || (ptm = modificationProfile.getPtm(modification)).getShortName() == null) continue;
            this.shortNames.put(modification, ptm.getShortName());
        }
        return toCheck;
    }

    public HashMap<Integer, ArrayList<String>> getExpectedPTMs(ModificationProfile modificationProfile, Peptide peptide, double modificationMass, double massTolerance) throws IOException, IllegalArgumentException, InterruptedException {
        HashMap<Integer, ArrayList<String>> mapping = new HashMap<Integer, ArrayList<String>>();
        for (String ptmName : modificationProfile.getAllNotFixedModifications()) {
            PTM ptm = this.getPTM(ptmName);
            if (!(Math.abs(ptm.getMass() - modificationMass) <= massTolerance)) continue;
            for (int site : peptide.getPotentialModificationSites(ptm)) {
                if (!mapping.containsKey(site)) {
                    mapping.put(site, new ArrayList());
                }
                mapping.get(site).add(ptmName);
            }
        }
        return mapping;
    }

    public HashMap<Integer, ArrayList<String>> getExpectedPTMs(ModificationProfile modificationProfile, Peptide peptide, String ptmName) throws IOException, IllegalArgumentException, InterruptedException {
        HashMap<Integer, ArrayList<String>> mapping = new HashMap<Integer, ArrayList<String>>();
        PTM referencePTM = this.getPTM(ptmName);
        for (String variableModification : modificationProfile.getAllNotFixedModifications()) {
            PTM secondaryPTM = this.getPTM(variableModification);
            if (secondaryPTM.getMass() != referencePTM.getMass()) continue;
            PTM ptm = this.getPTM(variableModification);
            for (int site : peptide.getPotentialModificationSites(ptm)) {
                if (!mapping.containsKey(site)) {
                    mapping.put(site, new ArrayList());
                }
                mapping.get(site).add(ptmName);
            }
        }
        return mapping;
    }

    public void checkFixedModifications(ModificationProfile modificationProfile, Peptide peptide) throws IOException, IllegalArgumentException, InterruptedException {
        ArrayList<ModificationMatch> toRemove = new ArrayList<ModificationMatch>();
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            if (modMatch.isVariable()) continue;
            toRemove.add(modMatch);
        }
        for (ModificationMatch modMatch : toRemove) {
            peptide.getModificationMatches().remove(modMatch);
        }
        HashMap<Integer, Double> taken = new HashMap<Integer, Double>();
        for (String fixedModification : modificationProfile.getFixedModifications()) {
            String sequence;
            PTM ptm = this.getPTM(fixedModification);
            if (ptm.getType() == 0) {
                for (int pos : peptide.getPotentialModificationSites(ptm)) {
                    if (!taken.containsKey(pos)) {
                        taken.put(pos, ptm.getMass());
                        peptide.addModificationMatch(new ModificationMatch(fixedModification, false, pos));
                        continue;
                    }
                    if (((Double)taken.get(pos)).doubleValue() == ptm.getMass()) continue;
                    throw new IllegalArgumentException("Attempting to put two fixed modifications of different masses (" + taken.get(pos) + ", " + ptm.getMass() + ") at position " + pos + " in peptide " + peptide.getSequence() + ".");
                }
                continue;
            }
            if (ptm.getType() == 3) {
                if (peptide.isCterm().isEmpty()) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                continue;
            }
            if (ptm.getType() == 1) {
                if (peptide.isNterm().isEmpty()) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                continue;
            }
            if (ptm.getType() == 4) {
                sequence = peptide.getSequence();
                if (!peptide.getPotentialModificationSites(ptm).contains(sequence.length()) || peptide.isCterm().isEmpty()) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                continue;
            }
            if (ptm.getType() == 2) {
                if (!peptide.getPotentialModificationSites(ptm).contains(1) || peptide.isNterm().isEmpty()) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                continue;
            }
            if (ptm.getType() == 7) {
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                continue;
            }
            if (ptm.getType() == 5) {
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                continue;
            }
            if (ptm.getType() == 8) {
                sequence = peptide.getSequence();
                if (!peptide.getPotentialModificationSites(ptm).contains(sequence.length())) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, sequence.length()));
                continue;
            }
            if (ptm.getType() != 6 || !peptide.getPotentialModificationSites(ptm).contains(1)) continue;
            peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
        }
    }

    public void setSearchedOMSSAIndexes(ModificationProfile modificationProfile) {
        for (int rank = 1; rank <= this.userMods.size(); ++rank) {
            String ptm;
            int omssaIndex = rank + 118;
            if (omssaIndex > 128) {
                omssaIndex += 13;
            }
            if (!modificationProfile.contains(ptm = this.userMods.get(rank - 1))) continue;
            modificationProfile.setOmssaIndex(ptm, omssaIndex);
        }
        for (String ptm : this.defaultOmssaIndexes.keySet()) {
            if (!modificationProfile.contains(ptm)) continue;
            modificationProfile.setOmssaIndex(ptm, this.defaultOmssaIndexes.get(ptm));
        }
    }

    public void setDefaultNeutralLosses() {
        boolean changed = false;
        for (String ptmName : this.defaultMods) {
            boolean found;
            PTM ptm;
            if (ptmName.contains("phospho")) {
                ptm = this.ptmMap.get(ptmName);
                if (ptmName.contains(" s") || ptmName.contains(" t")) {
                    found = false;
                    for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                        if (!implemented.isSameAs(NeutralLoss.H3PO4)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ptm.addNeutralLoss(NeutralLoss.H3PO4);
                    }
                }
                if (ptmName.contains(" y")) {
                    found = false;
                    for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                        if (!implemented.isSameAs(NeutralLoss.HPO3)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ptm.addNeutralLoss(NeutralLoss.HPO3);
                    }
                }
            } else if (ptmName.contains("oxidation") && ptmName.contains("M")) {
                ptm = this.ptmMap.get(ptmName);
                found = false;
                for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                    if (!implemented.isSameAs(NeutralLoss.CH4OS)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ptm.addNeutralLoss(NeutralLoss.CH4OS);
                }
            }
            if (!changed) continue;
            try {
                this.saveFactory();
            }
            catch (IOException e) {}
        }
    }

    public void setDefaultReporterIons() {
        boolean changed = false;
        for (String ptmName : this.defaultMods) {
            PTM ptm;
            if (ptmName.contains("itraq")) {
                ptm = this.ptmMap.get(ptmName);
                if (!ptm.getReporterIons().isEmpty()) continue;
                changed = true;
                if (ptmName.contains("8")) {
                    ptm.addReporterIon(ReporterIon.iTRAQ113);
                }
                ptm.addReporterIon(ReporterIon.iTRAQ114);
                ptm.addReporterIon(ReporterIon.iTRAQ115);
                ptm.addReporterIon(ReporterIon.iTRAQ116);
                ptm.addReporterIon(ReporterIon.iTRAQ117);
                if (!ptmName.contains("8")) continue;
                ptm.addReporterIon(ReporterIon.iTRAQ118);
                ptm.addReporterIon(ReporterIon.iTRAQ119);
                ptm.addReporterIon(ReporterIon.iTRAQ121);
                continue;
            }
            if (!ptmName.contains("tmt")) continue;
            changed = true;
            ptm = this.ptmMap.get(ptmName);
            if (!ptm.getReporterIons().isEmpty()) continue;
            ptm.addReporterIon(ReporterIon.TMT0);
            ptm.addReporterIon(ReporterIon.TMT1);
            if (!ptmName.contains("6")) continue;
            ptm.addReporterIon(ReporterIon.TMT2);
            ptm.addReporterIon(ReporterIon.TMT3);
            ptm.addReporterIon(ReporterIon.TMT4);
            ptm.addReporterIon(ReporterIon.TMT5);
        }
        if (changed) {
            try {
                this.saveFactory();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setShortName(String modification, String shortName) {
        this.shortNames.put(modification, shortName);
    }

    public String getShortName(String modification) {
        if (this.shortNames.containsKey(modification)) {
            return this.shortNames.get(modification);
        }
        PTM ptm = this.getPTM(modification);
        if (ptm.getShortName() != null) {
            return ptm.getShortName();
        }
        return PTMFactory.getDefaultShortName(modification);
    }

    public static String getDefaultShortName(String modificationName) {
        if (modificationName.contains("oxidation")) {
            return "ox";
        }
        if (modificationName.contains("phospho")) {
            return "p";
        }
        if (modificationName.contains("sulfation")) {
            return "sulf";
        }
        if (modificationName.contains("acetylation")) {
            return "ace";
        }
        if (modificationName.contains("deamidation")) {
            return "deam";
        }
        if (modificationName.contains("itraq")) {
            return "itraq";
        }
        if (modificationName.contains("icat")) {
            return "icat";
        }
        if (modificationName.contains("heavy arginine")) {
            return "heavyR";
        }
        if (modificationName.contains("heavy lysine")) {
            return "heavyK";
        }
        if (modificationName.contains("o18")) {
            return "o18";
        }
        if (modificationName.contains("tmt")) {
            return "tmt";
        }
        if (modificationName.contains("carbamidomethyl")) {
            return "cmm";
        }
        if (modificationName.contains("di-methylation") || modificationName.contains("dimethylation")) {
            return "dimeth";
        }
        if (modificationName.contains("tri-methylation") || modificationName.contains("trimethylation")) {
            return "trimeth\u00b2";
        }
        if (modificationName.contains("methylation")) {
            return "meth";
        }
        if (modificationName.contains("pyro")) {
            return "pyro";
        }
        String result = modificationName;
        if (result.contains(" ")) {
            result = result.substring(0, result.indexOf(" "));
        }
        return result;
    }

    public Color getColor(String modification) {
        if (!this.userColors.containsKey(modification)) {
            this.setColor(modification, PTMFactory.getDefaultColor(modification));
        }
        return this.userColors.get(modification);
    }

    public void setColor(String expectedModification, Color color) {
        this.userColors.put(expectedModification, color);
    }

    public static Color getDefaultColor(String modification) {
        if (modification.contains("no modification")) {
            return Color.LIGHT_GRAY;
        }
        if (modification.contains("phospho")) {
            return Color.RED;
        }
        if (modification.contains("ox")) {
            return Color.BLUE;
        }
        if (modification.contains("itraq")) {
            return Color.magenta;
        }
        if (modification.contains("carbamido")) {
            return Color.LIGHT_GRAY;
        }
        if (modification.contains("ace")) {
            return new Color(153, 153, 0);
        }
        if (modification.contains("glyco")) {
            return Color.ORANGE;
        }
        float r = (float)Math.random();
        float g = (float)Math.random();
        float b = (float)Math.random();
        return new Color(r, g, b);
    }
}

