/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filters.massspectrometry.spectrumfilters;

import com.compomics.util.experiment.filters.massspectrometry.SpectrumFilter;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class PeakFilter
extends SpectrumFilter {
    static final long serialVersionUID = 1751883115257153259L;
    private double mz;
    private double mzTolerance;
    private boolean isPpm;
    private double intensity;
    private double intensityTolerance;

    public PeakFilter(double mz, double mzTolerance, boolean isPpm, double intensity, double intensityTolerance) {
        this.mz = mz;
        this.mzTolerance = mzTolerance;
        this.isPpm = isPpm;
        this.intensity = intensity;
        this.intensityTolerance = intensityTolerance;
    }

    public boolean validateSpectrum(MSnSpectrum spectrum) {
        ArrayList<Double> intensitiesShortList = new ArrayList<Double>();
        ArrayList<Double> mzArray = new ArrayList<Double>(spectrum.getPeakMap().keySet());
        Collections.sort(mzArray);
        double deltaMz = this.isPpm ? this.mzTolerance / 1000000.0 * this.mz : this.mzTolerance;
        if (!mzArray.isEmpty() && this.mz >= mzArray.get(0) - deltaMz && this.mz <= mzArray.get(mzArray.size() - 1) + deltaMz) {
            int indexMin = 0;
            int indexMax = mzArray.size() - 1;
            if (Math.abs(this.getError(mzArray.get(indexMax))) <= this.mzTolerance) {
                intensitiesShortList.add(spectrum.getPeakMap().get((Object)mzArray.get((int)indexMax)).intensity);
            } else if (Math.abs(mzArray.get(indexMin)) <= this.mzTolerance) {
                intensitiesShortList.add(spectrum.getPeakMap().get((Object)mzArray.get((int)indexMin)).intensity);
            }
            while (indexMax - indexMin > 1) {
                int index = (indexMax - indexMin) / 2 + indexMin;
                double currentMz = mzArray.get(index);
                if (Math.abs(this.getError(currentMz)) <= this.mzTolerance) {
                    intensitiesShortList.add(spectrum.getPeakMap().get((Object)Double.valueOf((double)currentMz)).intensity);
                }
                if (currentMz < this.mz) {
                    indexMin = index;
                    continue;
                }
                indexMax = index;
            }
        }
        Iterator i$ = intensitiesShortList.iterator();
        while (i$.hasNext()) {
            double tempIntensity = (Double)i$.next();
            if (!(Math.abs(tempIntensity - this.intensity) / this.intensity <= this.intensityTolerance)) continue;
            return true;
        }
        return false;
    }

    public double getError(double otherMz) {
        if (this.isPpm) {
            return (otherMz - this.mz) / this.mz * 1000000.0;
        }
        return otherMz - this.mz;
    }

    public String getDescription() {
        return "containing a peak at m/z " + this.mz + " and intensity " + this.intensity;
    }
}

