/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation;

import com.compomics.util.experiment.filters.massspectrometry.SpectrumFilter;
import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.CombFilter;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class CombDialog
extends JDialog {
    private SpectrumFilter spectrumFilter = null;
    private ArrayList<Double> mzArray = new ArrayList();
    private JButton addButton;
    private JButton cancelButton;
    private JTextField intTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable mzTable;
    private JTextField mzTolTxt;
    private JButton okButtonButton;
    private JComboBox ppmCmb;
    private JButton removeButton;

    public CombDialog(JFrame parent, Double mzTolerance, Double intensityQuantile, Boolean isPpm) {
        super((Frame)parent, true);
        this.initComponents();
        if (mzTolerance != null) {
            this.mzTolTxt.setText(mzTolerance + "");
        }
        if (intensityQuantile != null) {
            this.intTxt.setText(intensityQuantile + "");
        }
        if (isPpm != null) {
            if (!isPpm.booleanValue()) {
                this.ppmCmb.setSelectedIndex(0);
            } else {
                this.ppmCmb.setSelectedIndex(1);
            }
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public boolean validateInput() {
        if (this.mzArray.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Please select at least one m/z.", "Wrong m/z", 2);
            return false;
        }
        try {
            new Double(this.mzTolTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the m/z tolerance.", "Wrong m/z tolerance", 2);
            return false;
        }
        try {
            new Double(this.intTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the intensity quantile.", "Wrong intensity quantile", 2);
            return false;
        }
        return true;
    }

    public SpectrumFilter getFilter() {
        return this.spectrumFilter;
    }

    private void repaintTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CombDialog.this.mzTable.revalidate();
                CombDialog.this.mzTable.repaint();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ppmCmb = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.okButtonButton = new JButton();
        this.intTxt = new JTextField();
        this.mzTolTxt = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.mzTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("m/z:");
        this.jLabel2.setText("m/z Accuracy:");
        this.ppmCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Da", "ppm"}));
        this.jLabel3.setText("Intensity Quantile:");
        this.jLabel4.setText("%");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CombDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButtonButton.setText("OK");
        this.okButtonButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CombDialog.this.okButtonButtonActionPerformed(evt);
            }
        });
        this.intTxt.setHorizontalAlignment(4);
        this.intTxt.setText("0");
        this.mzTolTxt.setHorizontalAlignment(4);
        this.mzTolTxt.setText("0.01");
        this.mzTable.setModel(new MzTable());
        this.jScrollPane1.setViewportView(this.mzTable);
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CombDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("-");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CombDialog.this.removeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intTxt).addComponent(this.mzTolTxt, -1, 217, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ppmCmb, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel4)))).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButtonButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton, -2, 65, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addButton, -1, 45, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 101, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ppmCmb, -2, -1, -2).addComponent(this.mzTolTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.intTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButtonButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            Double mzTol = new Double(this.mzTolTxt.getText());
            Double intQuantile = new Double(this.intTxt.getText());
            Collections.sort(this.mzArray);
            this.spectrumFilter = new CombFilter(this.mzArray, mzTol, this.ppmCmb.getSelectedIndex() == 1, intQuantile);
            String name = "Comb (";
            boolean first = true;
            for (double mz : this.mzArray) {
                if (first) {
                    first = false;
                } else {
                    name = name + ", ";
                }
                name = name + mz;
            }
            name = name + ")";
            this.spectrumFilter.setName(name);
            this.dispose();
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String outcome = JOptionPane.showInputDialog(this, (Object)"Please select an m/z to add to the filter");
        try {
            Double mz = new Double(outcome + "");
            this.mzArray.add(mz);
            this.repaintTable();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "m/z: " + outcome + " could not be added.", "Wrong m/z", 2);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.mzTable.convertRowIndexToModel(this.mzTable.getSelectedRow());
        if (row >= 0) {
            this.mzArray.remove(row);
            this.repaintTable();
        }
    }

    private class MzTable
    extends DefaultTableModel {
        private MzTable() {
        }

        public int getRowCount() {
            return CombDialog.this.mzArray.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "m/z";
                }
            }
            return "";
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return CombDialog.this.mzArray.get(row);
                }
            }
            return "";
        }

        public void setValueAt(Object aValue, int row, int column) {
            String value;
            if (column == 1 && !(value = aValue.toString().trim()).equals("")) {
                try {
                    Double newValue = new Double(value);
                    CombDialog.this.mzArray.set(row, newValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return new Double(0.0).getClass();
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }
    }
}

