/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation;

import com.compomics.util.experiment.filters.massspectrometry.SpectrumFilter;
import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.MzFilter;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MzDialog
extends JDialog {
    private SpectrumFilter spectrumFilter = null;
    private JButton cancelButton;
    private JTextField intTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JTextField mzTolTxt;
    private JTextField mzTxt;
    private JButton okButton;
    private JComboBox ppmCmb;

    public MzDialog(JFrame parent, Double mzTolerance, Double intensityQuantile, Boolean isPpm) {
        super((Frame)parent, true);
        this.initComponents();
        if (mzTolerance != null) {
            this.mzTolTxt.setText(mzTolerance + "");
        }
        if (intensityQuantile != null) {
            this.intTxt.setText(intensityQuantile + "");
        }
        if (isPpm != null) {
            if (!isPpm.booleanValue()) {
                this.ppmCmb.setSelectedIndex(0);
            } else {
                this.ppmCmb.setSelectedIndex(1);
            }
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public boolean validateInput() {
        try {
            new Double(this.mzTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the m/z.", "Wrong m/z", 2);
            return false;
        }
        try {
            new Double(this.mzTolTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the m/z tolerance.", "Wrong m/z tolerance", 2);
            return false;
        }
        try {
            new Double(this.intTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the intensity quantile.", "Wrong intensity quantile", 2);
            return false;
        }
        return true;
    }

    public SpectrumFilter getFilter() {
        return this.spectrumFilter;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ppmCmb = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.intTxt = new JTextField();
        this.mzTolTxt = new JTextField();
        this.mzTxt = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("m/z:");
        this.jLabel2.setText("m/z Accuracy:");
        this.ppmCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Da", "ppm"}));
        this.jLabel3.setText("Intensity Quantile:");
        this.jLabel4.setText("%");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MzDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MzDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.intTxt.setHorizontalAlignment(4);
        this.intTxt.setText("0");
        this.mzTolTxt.setHorizontalAlignment(4);
        this.mzTolTxt.setText("0.01");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton, -2, 65, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.intTxt).addComponent(this.mzTolTxt, -1, 217, Short.MAX_VALUE).addComponent(this.mzTxt)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ppmCmb, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel4))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.mzTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ppmCmb, -2, -1, -2).addComponent(this.mzTolTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.intTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            Double mz = new Double(this.mzTxt.getText());
            Double mzTol = new Double(this.mzTolTxt.getText());
            Double intQuantile = new Double(this.intTxt.getText());
            this.spectrumFilter = new MzFilter(mz, mzTol, this.ppmCmb.getSelectedIndex() == 1, intQuantile);
            String name = "m/z (" + mz + ")";
            this.spectrumFilter.setName(name);
            this.dispose();
        }
    }
}

