/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.advocates.PostProcessor;
import com.compomics.util.experiment.identification.advocates.SearchEngine;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvocateFactory {
    private static AdvocateFactory instance = null;

    private AdvocateFactory() {
    }

    public static AdvocateFactory getInstance() {
        if (instance == null) {
            instance = new AdvocateFactory();
        }
        return instance;
    }

    public Advocate getAdvocate(int index) {
        switch (index) {
            case 0: {
                return new SearchEngine(0);
            }
            case 1: {
                return new SearchEngine(1);
            }
            case 2: {
                return new SearchEngine(2);
            }
            case 4: {
                return new SearchEngine(4);
            }
            case 3: {
                return new PostProcessor(3);
            }
            case 5: {
                return new PostProcessor(5);
            }
        }
        return null;
    }

    public ArrayList<Advocate> getPossibilities() {
        ArrayList<Advocate> possibilities = new ArrayList<Advocate>();
        possibilities.add(new SearchEngine(0));
        possibilities.add(new SearchEngine(1));
        possibilities.add(new SearchEngine(2));
        possibilities.add(new SearchEngine(4));
        possibilities.add(new PostProcessor(3));
        possibilities.add(new PostProcessor(5));
        return possibilities;
    }

    public int getAdvocate(String aName) {
        ArrayList<Advocate> possibilities = this.getPossibilities();
        for (Advocate advocate : possibilities) {
            if (advocate.getName().compareTo(aName) != 0) continue;
            return advocate.getId();
        }
        return -1;
    }
}

