/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.personalization.ExperimentObject;

public class PeptideAssumption
extends ExperimentObject {
    static final long serialVersionUID = 3606509518581203063L;
    private int rank;
    private Peptide peptide;
    private int advocate;
    private Charge identificationCharge;
    private double eValue;
    private String file;
    private Boolean isDecoy = null;

    public PeptideAssumption(Peptide aPeptide, int rank, int advocate, Charge identificationCharge, double eValue, String identificationFile) {
        this.peptide = aPeptide;
        this.rank = rank;
        this.advocate = advocate;
        this.identificationCharge = identificationCharge;
        this.eValue = eValue;
        this.file = identificationFile;
    }

    public int getRank() {
        return this.rank;
    }

    public Peptide getPeptide() {
        return this.peptide;
    }

    public int getAdvocate() {
        return this.advocate;
    }

    public int getC13(double measuredMZ) {
        return (int)Math.round(measuredMZ * (double)this.identificationCharge.value - (double)this.identificationCharge.value * ElementaryIon.proton.getTheoreticMass() - this.peptide.getMass());
    }

    public double getDeltaMass(double measuredMZ, boolean ppm) {
        return this.getPrecursorMatch(new Peak(measuredMZ, 0.0, 0.0)).getError(ppm);
    }

    public double getEValue() {
        return this.eValue;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isDecoy() {
        if (this.isDecoy == null) {
            for (String protein : this.peptide.getParentProteins()) {
                if (!SequenceFactory.isDecoy(protein)) continue;
                this.isDecoy = true;
                return this.isDecoy;
            }
            this.isDecoy = false;
        }
        return this.isDecoy;
    }

    public Charge getIdentificationCharge() {
        return this.identificationCharge;
    }

    public void setRank(int aRank) {
        this.rank = aRank;
    }

    public IonMatch getPrecursorMatch(Peak precursorPeak) {
        return new IonMatch(precursorPeak, new PrecursorIon(this.peptide), this.identificationCharge);
    }
}

