/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.ModificationProfile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import no.uib.jsparklines.data.XYDataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchParameters
implements Serializable {
    static final long serialVersionUID = -2773993307168773763L;
    private PrecursorAccuracyType currentPrecursorAccuracyType = PrecursorAccuracyType.PPM;
    private Double precursorTolerance = 10.0;
    private Double fragmentIonMZTolerance = 0.5;
    private ModificationProfile utilitiesModificationProfile = new ModificationProfile();
    private Enzyme enzyme;
    private Integer nMissedCleavages = 2;
    private File fastaFile;
    private File parametersFile;
    private HashMap<String, Double> fractionMolecularWeights = new HashMap();
    private HashMap<String, XYDataPoint> fractionMolecularWeightRanges = new HashMap();
    private Integer forwardIon = 1;
    private Integer rewindIon = 4;
    private Charge minChargeSearched = new Charge(1, 2);
    private Charge maxChargeSearched = new Charge(1, 4);
    private static String[] forwardIons = new String[]{"a", "b", "c"};
    private static String[] rewindIons = new String[]{"x", "y", "z"};
    private Double maxEValue = 100.0;
    private Integer hitListLength = 25;
    private Charge minimalChargeForMultipleChargedFragments = new Charge(1, 3);
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Boolean removePrecursor = true;
    private Boolean scalePrecursor = false;
    private Boolean estimateCharge = true;

    public ModificationProfile getModificationProfile() {
        return this.utilitiesModificationProfile;
    }

    public void setModificationProfile(ModificationProfile modificationProfile) {
        this.utilitiesModificationProfile = modificationProfile;
    }

    public Double getFragmentIonAccuracy() {
        return this.fragmentIonMZTolerance;
    }

    public void setFragmentIonAccuracy(Double fragmentIonMZTolerance) {
        this.fragmentIonMZTolerance = fragmentIonMZTolerance;
    }

    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    public void setEnzyme(Enzyme enzyme) {
        this.enzyme = enzyme;
    }

    public File getParametersFile() {
        return this.parametersFile;
    }

    public void setParametersFile(File parametersFile) {
        this.parametersFile = parametersFile;
    }

    public File getFastaFile() {
        return this.fastaFile;
    }

    public void setFastaFile(File fastaFile) {
        this.fastaFile = fastaFile;
    }

    public Integer getnMissedCleavages() {
        return this.nMissedCleavages;
    }

    public void setnMissedCleavages(Integer nMissedCleavages) {
        this.nMissedCleavages = nMissedCleavages;
    }

    public Integer getIonSearched1() {
        return this.forwardIon;
    }

    public void setIonSearched1(String ionSearched1) {
        if (ionSearched1.equals("a")) {
            this.forwardIon = 0;
        } else if (ionSearched1.equals("b")) {
            this.forwardIon = 1;
        } else if (ionSearched1.equals("c")) {
            this.forwardIon = 2;
        } else if (ionSearched1.equals("x")) {
            this.forwardIon = 3;
        } else if (ionSearched1.equals("y")) {
            this.forwardIon = 4;
        } else if (ionSearched1.equals("z")) {
            this.forwardIon = 5;
        }
    }

    public Integer getIonSearched2() {
        return this.rewindIon;
    }

    public void setIonSearched2(String ionSearched2) {
        if (ionSearched2.equals("a")) {
            this.rewindIon = 0;
        } else if (ionSearched2.equals("b")) {
            this.rewindIon = 1;
        } else if (ionSearched2.equals("c")) {
            this.rewindIon = 2;
        } else if (ionSearched2.equals("x")) {
            this.rewindIon = 3;
        } else if (ionSearched2.equals("y")) {
            this.rewindIon = 4;
        } else if (ionSearched2.equals("z")) {
            this.rewindIon = 5;
        }
    }

    public static String[] getIons() {
        int i;
        String[] ions = new String[forwardIons.length + rewindIons.length];
        for (i = 0; i < forwardIons.length; ++i) {
            ions[ions.length] = forwardIons[i];
        }
        for (i = 0; i < rewindIons.length; ++i) {
            ions[ions.length] = rewindIons[i];
        }
        return ions;
    }

    public static String[] getForwardIons() {
        return forwardIons;
    }

    public static String[] getRewindIons() {
        return rewindIons;
    }

    public Double getPrecursorAccuracy() {
        return this.precursorTolerance;
    }

    public void setPrecursorAccuracy(Double precursorTolerance) {
        this.precursorTolerance = precursorTolerance;
    }

    public PrecursorAccuracyType getPrecursorAccuracyType() {
        return this.currentPrecursorAccuracyType;
    }

    public void setPrecursorAccuracyType(PrecursorAccuracyType currentPrecursorAccuracyType) {
        this.currentPrecursorAccuracyType = currentPrecursorAccuracyType;
    }

    public Boolean isPrecursorAccuracyTypePpm() {
        return this.currentPrecursorAccuracyType == PrecursorAccuracyType.PPM;
    }

    public HashMap<String, Double> getFractionMolecularWeights() {
        return this.fractionMolecularWeights;
    }

    public void setFractionMolecularWeights(HashMap<String, Double> fractionMolecularWeights) {
        this.fractionMolecularWeights = fractionMolecularWeights;
    }

    public HashMap<String, XYDataPoint> getFractionMolecularWeightRanges() {
        return this.fractionMolecularWeightRanges;
    }

    public void setFractionMolecularWeightRanges(HashMap<String, XYDataPoint> fractionMolecularWeightRanges) {
        this.fractionMolecularWeightRanges = fractionMolecularWeightRanges;
    }

    public Charge getMaxChargeSearched() {
        return this.maxChargeSearched;
    }

    public void setMaxChargeSearched(Charge maxChargeSearched) {
        this.maxChargeSearched = maxChargeSearched;
    }

    public Charge getMinChargeSearched() {
        return this.minChargeSearched;
    }

    public void setMinChargeSearched(Charge minChargeSearched) {
        this.minChargeSearched = minChargeSearched;
    }

    public Double getMaxEValue() {
        return this.maxEValue;
    }

    public void setMaxEValue(Double maxEValue) {
        this.maxEValue = maxEValue;
    }

    public Integer getHitListLength() {
        return this.hitListLength;
    }

    public void setHitListLength(Integer hitListLength) {
        this.hitListLength = hitListLength;
    }

    public Charge getMinimalChargeForMultipleChargedFragments() {
        return this.minimalChargeForMultipleChargedFragments;
    }

    public void setMinimalChargeForMultipleChargedFragments(Charge minimalChargeForMultipleChargedFragments) {
        this.minimalChargeForMultipleChargedFragments = minimalChargeForMultipleChargedFragments;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Boolean isEstimateCharge() {
        return this.estimateCharge;
    }

    public void setEstimateCharge(Boolean estimateCharge) {
        this.estimateCharge = estimateCharge;
    }

    public Boolean isRemovePrecursor() {
        return this.removePrecursor;
    }

    public void setRemovePrecursor(Boolean removePrecursor) {
        this.removePrecursor = removePrecursor;
    }

    public Boolean isScalePrecursor() {
        return this.scalePrecursor;
    }

    public void setScalePrecursor(Boolean scalePrecursor) {
        this.scalePrecursor = scalePrecursor;
    }

    public static SearchParameters getIdentificationParameters(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        return (SearchParameters)SerializationUtils.readObject(file);
    }

    public static void saveIdentificationParameters(SearchParameters identificationParameters, File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        SerializationUtils.writeObject(identificationParameters, file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrecursorAccuracyType {
        PPM,
        DA;

    }
}

