/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.FastaIndex;
import com.compomics.util.gui.waiting.WaitingHandler;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.protein.Header;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JProgressBar;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceFactory {
    private static SequenceFactory instance = null;
    private HashMap<String, Header> currentHeaderMap = new HashMap();
    private HashMap<String, Protein> currentProteinMap = new HashMap();
    private FastaIndex fastaIndex = null;
    private BufferedRandomAccessFile currentFastaFile = null;
    private int nCache = 1;
    private ArrayList<String> loadedProteins = new ArrayList();
    public static final String[] decoyFlags = new String[]{"REVERSED", "RND", "SHUFFLED"};
    private HashMap<String, Double> molecularWeights = new HashMap();

    private SequenceFactory() {
    }

    public static SequenceFactory getInstance() {
        if (instance == null) {
            instance = new SequenceFactory();
        }
        return instance;
    }

    public static SequenceFactory getInstance(int nCache) {
        if (instance == null) {
            instance = new SequenceFactory();
        }
        instance.setnCache(nCache);
        return instance;
    }

    public void clearFactory() {
        this.currentHeaderMap.clear();
        this.currentProteinMap.clear();
        this.fastaIndex = null;
        this.currentFastaFile = null;
        this.loadedProteins.clear();
        this.molecularWeights.clear();
    }

    public Protein getProtein(String accession) throws IOException, IllegalArgumentException, InterruptedException {
        Protein currentProtein = this.currentProteinMap.get(accession);
        if (currentProtein == null) {
            Long index = this.fastaIndex.getIndex(accession);
            if (index == null) {
                throw new IllegalArgumentException("Protein not found: " + accession + ".");
            }
            currentProtein = this.getProtein(accession, index, 0);
            if (this.loadedProteins.size() == this.nCache) {
                this.currentProteinMap.remove(this.loadedProteins.get(0));
                this.currentHeaderMap.remove(this.loadedProteins.get(0));
                this.loadedProteins.remove(0);
            }
            this.loadedProteins.add(accession);
            this.currentProteinMap.put(accession, currentProtein);
        }
        if (currentProtein == null) {
            throw new IllegalArgumentException("Protein not found: " + accession + ".");
        }
        return currentProtein;
    }

    private synchronized Protein getProtein(String accession, long index, int nTries) throws InterruptedException, IOException {
        try {
            String line;
            this.currentFastaFile.seek(index);
            String sequence = "";
            Header currentHeader = this.currentHeaderMap.get(accession);
            while ((line = this.currentFastaFile.readLine()) != null) {
                if ((line = line.trim()).startsWith(">")) {
                    if (!sequence.equals("")) break;
                    if (currentHeader != null) continue;
                    currentHeader = Header.parseFromFASTA(line);
                    this.currentHeaderMap.put(accession, currentHeader);
                    continue;
                }
                sequence = sequence + line;
            }
            return new Protein(accession, currentHeader.getDatabaseType(), sequence, SequenceFactory.isDecoy(accession));
        }
        catch (IOException e) {
            if (nTries <= 100) {
                this.wait(10L);
                return this.getProtein(accession, index, nTries + 1);
            }
            throw e;
        }
    }

    public Header getHeader(String accession) throws IOException, IllegalArgumentException, InterruptedException {
        Header result = this.currentHeaderMap.get(accession);
        if (result == null) {
            Long index = this.fastaIndex.getIndex(accession);
            if (index == null) {
                throw new IllegalArgumentException("Protein not found: " + accession + ".");
            }
            return this.getHeader(index, 0);
        }
        return result;
    }

    private synchronized Header getHeader(long index, int nTries) throws InterruptedException, IOException {
        try {
            this.currentFastaFile.seek(index);
            return Header.parseFromFASTA(this.currentFastaFile.readLine());
        }
        catch (IOException e) {
            if (nTries <= 100) {
                this.wait(10L);
                return this.getHeader(index, nTries + 1);
            }
            throw e;
        }
    }

    public void loadFastaFile(File fastaFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.currentFastaFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        this.fastaIndex = this.getFastaIndex(fastaFile);
    }

    public void loadFastaFile(File fastaFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException, StringIndexOutOfBoundsException {
        this.currentFastaFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        this.fastaIndex = this.getFastaIndex(fastaFile, waitingHandler);
    }

    private FastaIndex getFastaIndex(File fastaFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        return this.getFastaIndex(fastaFile, null);
    }

    private FastaIndex getFastaIndex(File fastaFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException, StringIndexOutOfBoundsException {
        File indexFile = new File(fastaFile.getParent(), fastaFile.getName() + ".cui");
        if (indexFile.exists()) {
            try {
                FastaIndex tempFastaIndex = (FastaIndex)SerializationUtils.readObject(indexFile);
                return tempFastaIndex;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FastaIndex tempFastaIndex = SequenceFactory.createFastaIndex(fastaFile, waitingHandler);
        if (!waitingHandler.isRunCanceled()) {
            this.writeIndex(tempFastaIndex, fastaFile.getParentFile());
        }
        return tempFastaIndex;
    }

    private void writeIndex(FastaIndex fastaIndex, File directory) throws IOException {
        File destinationFile = new File(directory, fastaIndex.getFileName() + ".cui");
        SerializationUtils.writeObject(fastaIndex, destinationFile);
    }

    public void closeFile() throws IOException {
        if (this.currentFastaFile != null) {
            this.currentFastaFile.close();
        }
    }

    private static FastaIndex createFastaIndex(File fastaFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, StringIndexOutOfBoundsException {
        String line;
        HashMap<String, Long> indexes = new HashMap<String, Long>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressDialogIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressValue(100);
            waitingHandler.setSecondaryProgressValue(0);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        boolean decoy = false;
        int nTarget = 0;
        long index = bufferedRandomAccessFile.getFilePointer();
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            if (line.startsWith(">")) {
                Header fastaHeader = Header.parseFromFASTA(line);
                String accession = fastaHeader.getAccession();
                if (accession == null) {
                    accession = fastaHeader.getRest();
                }
                indexes.put(accession, index);
                if (!SequenceFactory.isDecoy(accession)) {
                    ++nTarget;
                } else if (!decoy) {
                    decoy = true;
                }
                if (waitingHandler == null) continue;
                waitingHandler.setSecondaryProgressValue((int)(index / progressUnit));
                if (!waitingHandler.isRunCanceled()) continue;
                break;
            }
            index = bufferedRandomAccessFile.getFilePointer();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressDialogIndeterminate(true);
        }
        bufferedRandomAccessFile.close();
        return new FastaIndex(indexes, fastaFile.getName(), decoy, nTarget);
    }

    public static boolean isDecoy(String proteinAccession) {
        for (String flag : decoyFlags) {
            String start = flag + ".*";
            String end = ".*" + flag;
            if (!proteinAccession.matches(start) && !proteinAccession.matches(end)) continue;
            return true;
        }
        return false;
    }

    public boolean concatenatedTargetDecoy() {
        return this.fastaIndex.isDecoy();
    }

    public int getNTargetSequences() {
        return this.fastaIndex.getNTarget();
    }

    public void appendDecoySequences(File destinationFile) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        this.appendDecoySequences(destinationFile, null);
    }

    public void appendDecoySequences(File destinationFile, WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressDialogIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressValue(this.fastaIndex.getNTarget());
            waitingHandler.setSecondaryProgressValue(0);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(destinationFile));
        for (String accession : this.fastaIndex.getIndexes().keySet()) {
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.increaseSecondaryProgressValue();
            Protein currentProtein = this.getProtein(accession);
            Header currentHeader = this.getHeader(accession);
            String decoyAccession = currentProtein.getAccession() + "_" + decoyFlags[0];
            Header decoyHeader = Header.parseFromFASTA(currentHeader.toString());
            decoyHeader.setAccession(decoyAccession);
            decoyHeader.setDescription(decoyHeader.getDescription() + "-" + decoyFlags[0]);
            String decoySequence = this.reverseSequence(currentProtein.getSequence());
            bufferedWriter.write(currentHeader.toString() + System.getProperty("line.separator"));
            bufferedWriter.write(currentProtein.getSequence() + System.getProperty("line.separator"));
            if (decoyHeader.toString().equalsIgnoreCase(currentHeader.toString())) {
                decoyHeader.setRest(decoyAccession);
            }
            bufferedWriter.write(decoyHeader.toString() + System.getProperty("line.separator"));
            bufferedWriter.write(decoySequence + System.getProperty("line.separator"));
        }
        bufferedWriter.close();
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressDialogIndeterminate(true);
        }
        if (waitingHandler.isRunCanceled()) {
            destinationFile.delete();
        } else {
            this.loadFastaFile(destinationFile);
        }
    }

    private String reverseSequence(String sequence) {
        return new StringBuilder(sequence).reverse().toString();
    }

    public ArrayList<String> getAccessions() {
        return new ArrayList<String>(this.fastaIndex.getIndexes().keySet());
    }

    public int getnCache() {
        return this.nCache;
    }

    public void setnCache(int nCache) {
        this.nCache = nCache;
    }

    public HashMap<String, Integer> getAAOccurrences(JProgressBar progressBar) throws IOException, IllegalArgumentException, InterruptedException {
        HashMap<String, Integer> aaMap = new HashMap<String, Integer>();
        ArrayList<String> accessions = this.getAccessions();
        if (progressBar != null) {
            progressBar.setIndeterminate(false);
            progressBar.setMaximum(accessions.size());
            progressBar.setValue(0);
        }
        for (String accession : accessions) {
            if (!SequenceFactory.isDecoy(accession)) {
                Protein protein = this.getProtein(accession);
                for (String aa : protein.getSequence().split("")) {
                    Integer n = aaMap.get(aa);
                    if (n == null) {
                        n = 0;
                    }
                    aaMap.put(aa, n + 1);
                }
            }
            if (progressBar == null) continue;
            progressBar.setValue(progressBar.getValue() + 1);
        }
        if (progressBar != null) {
            progressBar.setIndeterminate(true);
        }
        return aaMap;
    }

    public double computeMolecularWeight(String accession) throws IOException, IllegalArgumentException, InterruptedException {
        if (this.molecularWeights.containsKey(accession)) {
            return this.molecularWeights.get(accession);
        }
        Protein protein = this.getProtein(accession);
        double weight = protein.computeMolecularWeight() / 1000.0;
        this.molecularWeights.put(accession, weight);
        return weight;
    }
}

