/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.SequenceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProteinMatch
extends IdentificationMatch {
    static final long serialVersionUID = -6061842447053092696L;
    private ArrayList<String> theoreticProtein = new ArrayList();
    private String mainMatch;
    private ArrayList<String> peptideMatches = new ArrayList();
    public static final String PROTEIN_KEY_SPLITTER = "_cus_";

    public ProteinMatch() {
    }

    public ProteinMatch(String proteinAccession) throws IllegalArgumentException {
        if (proteinAccession.contains(PROTEIN_KEY_SPLITTER)) {
            throw new IllegalArgumentException("Protein accession containing '_cus_' are not supported. Conflicting accession: " + this.mainMatch);
        }
        this.theoreticProtein.add(proteinAccession);
        this.mainMatch = proteinAccession;
    }

    public ProteinMatch(Peptide peptide) {
        ArrayList<String> parentProteins = peptide.getParentProteins();
        if (parentProteins == null || parentProteins.isEmpty()) {
            throw new IllegalArgumentException("Peptide " + peptide.getSequence() + " presents no parent protein.");
        }
        Collections.sort(parentProteins);
        for (String protein : parentProteins) {
            if (this.theoreticProtein.contains(protein)) continue;
            this.theoreticProtein.add(protein);
        }
        this.mainMatch = parentProteins.get(0);
        this.peptideMatches.add(peptide.getKey());
    }

    public ArrayList<String> getTheoreticProteinsAccessions() {
        return this.theoreticProtein;
    }

    public void addTheoreticProtein(String proteinAccession) {
        this.theoreticProtein.add(proteinAccession);
    }

    public String getMainMatch() {
        return this.mainMatch;
    }

    public void setMainMatch(String mainMatch) {
        this.mainMatch = mainMatch;
    }

    public ArrayList<String> getPeptideMatches() {
        return this.peptideMatches;
    }

    public void addPeptideMatch(String peptideMatchKey) {
        if (!this.peptideMatches.contains(peptideMatchKey)) {
            this.peptideMatches.add(peptideMatchKey);
        }
    }

    public int getPeptideCount() {
        return this.peptideMatches.size();
    }

    public boolean isDecoy() {
        for (String protein : this.theoreticProtein) {
            if (!SequenceFactory.isDecoy(protein)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecoy(String key) {
        for (String accession : ProteinMatch.getAccessions(key)) {
            if (!SequenceFactory.isDecoy(accession)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getKey() {
        Collections.sort(this.theoreticProtein);
        String result = "";
        for (String accession : this.theoreticProtein) {
            if (!result.equals("")) {
                result = result + PROTEIN_KEY_SPLITTER;
            }
            result = result + accession;
        }
        return result;
    }

    public static String getProteinMatchKey(Peptide peptide) {
        ArrayList<String> accessions = new ArrayList<String>();
        for (String protein : peptide.getParentProteins()) {
            if (accessions.contains(protein)) continue;
            accessions.add(protein);
        }
        Collections.sort(accessions);
        String result = "";
        for (String accession : accessions) {
            if (!result.equals("")) {
                result = result + PROTEIN_KEY_SPLITTER;
            }
            result = result + accession;
        }
        return result.trim();
    }

    public static int getNProteins(String matchKey) {
        return ProteinMatch.getAccessions(matchKey).length;
    }

    public int getNProteins() {
        return this.theoreticProtein.size();
    }

    public static boolean contains(String sharedKey, String uniqueKey) {
        if (sharedKey.equals(uniqueKey)) {
            return false;
        }
        List<String> sharedAccessions = Arrays.asList(ProteinMatch.getAccessions(sharedKey));
        for (String uniqueAccession : ProteinMatch.getAccessions(uniqueKey)) {
            if (sharedAccessions.contains(uniqueAccession)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(ProteinMatch proteinMatch) {
        if (this.getKey().equals(proteinMatch.getKey())) {
            return false;
        }
        for (String accession : proteinMatch.getTheoreticProteinsAccessions()) {
            if (this.theoreticProtein.contains(accession)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String aProtein) {
        return this.theoreticProtein.contains(aProtein);
    }

    public static String[] getAccessions(String key) {
        return key.split(PROTEIN_KEY_SPLITTER);
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Protein;
    }
}

