/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.SpectrumAnnotator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.ptm.PtmtableContent;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.math.BasicMathFunctions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTMLocationScores {
    public static HashMap<ArrayList<Integer>, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<Integer> charges, int precursorCharge, double mzTolerance) throws IOException, IllegalArgumentException, InterruptedException {
        return PTMLocationScores.getAScore(peptide, ptms, spectrum, iontypes, null, charges, precursorCharge, mzTolerance, false);
    }

    public static HashMap<ArrayList<Integer>, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance) throws IOException, IllegalArgumentException, InterruptedException {
        return PTMLocationScores.getAScore(peptide, ptms, spectrum, iontypes, neutralLosses, charges, precursorCharge, mzTolerance, true);
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap<ArrayList<Integer>, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, boolean accountNeutralLosses) throws IOException, IllegalArgumentException, InterruptedException {
        if (ptms.isEmpty()) {
            throw new IllegalArgumentException("No PTM given for A-score calculation.");
        }
        int nPTM = 0;
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            if (!modMatch.isVariable()) continue;
            for (PTM ptm : ptms) {
                if (!ptm.getName().equals(modMatch.getTheoreticPtm())) continue;
                ++nPTM;
            }
        }
        if (nPTM == 0) {
            throw new IllegalArgumentException("Given PTMs not found in the peptide for A-score calculation.");
        }
        PTM refPTM = ptms.get(0);
        double ptmMass = refPTM.getMass();
        NeutralLossesMap scoringLossesMap = new NeutralLossesMap();
        if (accountNeutralLosses) {
            for (NeutralLoss neutralLoss : neutralLosses.getAccountedNeutralLosses()) {
                if (!(Math.abs(neutralLoss.mass - ptmMass) > mzTolerance)) continue;
                scoringLossesMap.addNeutralLoss(neutralLoss, 1, 1);
            }
        }
        HashMap<ArrayList<Integer>, Double> result = new HashMap<ArrayList<Integer>, Double>();
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        for (PTM ptm : ptms) {
            for (int potentialSite : peptide.getPotentialModificationSites(ptm)) {
                if (possibleSites.contains(potentialSite)) continue;
                possibleSites.add(potentialSite);
            }
        }
        if (possibleSites.size() > nPTM) {
            ArrayList<IonMatch> matches;
            Collections.sort(possibleSites);
            HashMap positionToScoreMap = new HashMap();
            HashMap<Integer, MSnSpectrum> spectrumMap = PTMLocationScores.getReducedSpectra(spectrum, mzTolerance, 10);
            SpectrumAnnotator spectrumAnnotator = new SpectrumAnnotator();
            int N = 0;
            Peptide noModPeptide = new Peptide(peptide.getSequence(), peptide.getParentProteins(), new ArrayList<ModificationMatch>());
            for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
                boolean found = false;
                for (PTM ptm : ptms) {
                    if (modificationMatch.getTheoreticPtm().equals(ptm.getName())) continue;
                    found = true;
                }
                if (found) continue;
                noModPeptide.addModificationMatch(modificationMatch);
            }
            for (ArrayList arrayList : spectrumAnnotator.getExpectedIons(iontypes, scoringLossesMap, charges, precursorCharge, peptide).values()) {
                N += arrayList.size();
            }
            for (int i = 0; i < spectrumMap.keySet().size(); ++i) {
                double d = ((double)i + 1.0) / 100.0;
                Iterator<PTM> i$ = possibleSites.iterator();
                while (i$.hasNext()) {
                    int pos = (Integer)((Object)i$.next());
                    Peptide tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getParentProteins(), noModPeptide.getModificationMatches());
                    tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, pos));
                    matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumMap.get(i), tempPeptide, 0.0, mzTolerance, false);
                    int n = matches.size();
                    double P = 0.0;
                    for (int k = n; k <= N; ++k) {
                        P += BasicMathFunctions.getCombination(k, N) * Math.pow(d, k) * Math.pow(1.0 - d, N - k);
                    }
                    if (P <= Double.MIN_NORMAL) {
                        P = Double.MIN_NORMAL;
                    }
                    double score = -10.0 * Math.log10(P);
                    if (!positionToScoreMap.containsKey(pos)) {
                        positionToScoreMap.put(pos, new HashMap());
                    }
                    ((HashMap)positionToScoreMap.get(pos)).put(i + 1, score);
                }
            }
            Double bestScore = null;
            Object var24_32 = null;
            Integer bestPosition = null;
            Integer secondPosition = null;
            ArrayList<Integer> bestPositions = new ArrayList<Integer>();
            Iterator i$ = positionToScoreMap.keySet().iterator();
            while (i$.hasNext()) {
                void var24_33;
                int pos = (Integer)i$.next();
                Double peptideScore = 0.0;
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(1)) {
                    peptideScore = peptideScore + 0.5 * (Double)((HashMap)positionToScoreMap.get(pos)).get(1);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(2)) {
                    peptideScore = peptideScore + 0.75 * (Double)((HashMap)positionToScoreMap.get(pos)).get(2);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(3)) {
                    peptideScore = peptideScore + 1.0 * (Double)((HashMap)positionToScoreMap.get(pos)).get(3);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(4)) {
                    peptideScore = peptideScore + 1.0 * (Double)((HashMap)positionToScoreMap.get(pos)).get(4);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(5)) {
                    peptideScore = peptideScore + 1.0 * (Double)((HashMap)positionToScoreMap.get(pos)).get(5);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(6)) {
                    peptideScore = peptideScore + 1.0 * (Double)((HashMap)positionToScoreMap.get(pos)).get(6);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(7)) {
                    peptideScore = peptideScore + 0.75 * (Double)((HashMap)positionToScoreMap.get(pos)).get(7);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(8)) {
                    peptideScore = peptideScore + 0.5 * (Double)((HashMap)positionToScoreMap.get(pos)).get(8);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(9)) {
                    peptideScore = peptideScore + 0.25 * (Double)((HashMap)positionToScoreMap.get(pos)).get(9);
                }
                if (((HashMap)positionToScoreMap.get(pos)).containsKey(10)) {
                    peptideScore = peptideScore + 0.25 * (Double)((HashMap)positionToScoreMap.get(pos)).get(10);
                }
                if (bestScore == null) {
                    bestScore = peptideScore;
                    bestPosition = pos;
                    bestPositions.add(pos);
                    continue;
                }
                if (peptideScore >= bestScore) {
                    if (var24_33 == null || bestScore >= var24_33.doubleValue()) {
                        Double d = bestScore;
                        secondPosition = bestPosition;
                    }
                    if (peptideScore > bestScore) {
                        bestPositions.clear();
                    }
                    bestScore = peptideScore;
                    bestPosition = pos;
                    bestPositions.add(pos);
                    continue;
                }
                if (var24_33 != null && !(peptideScore >= var24_33.doubleValue())) continue;
                Double d = peptideScore;
                secondPosition = pos;
            }
            double maxDiff = 0.0;
            int bestI = 0;
            for (int i = 1; i <= 10; ++i) {
                double diff;
                try {
                    diff = (Double)((HashMap)positionToScoreMap.get(bestPosition)).get(i) - (Double)((HashMap)positionToScoreMap.get(secondPosition)).get(i);
                }
                catch (NullPointerException e) {
                    double debugDiff = (Double)((HashMap)positionToScoreMap.get(bestPosition)).get(i) - (Double)((HashMap)positionToScoreMap.get(secondPosition)).get(i);
                    throw e;
                }
                if (!(diff >= maxDiff)) continue;
                bestI = i - 1;
                maxDiff = diff;
            }
            N = 0;
            int posMin = Math.min(bestPosition, secondPosition);
            int posMax = Math.max(bestPosition, secondPosition);
            for (ArrayList<Ion> ions : spectrumAnnotator.getExpectedIons(iontypes, scoringLossesMap, charges, precursorCharge, peptide).values()) {
                for (Ion ion : ions) {
                    int aa;
                    if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                    PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                    if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                        aa = fragmentIon.getNumber();
                        if (aa <= posMin || aa > posMax) continue;
                        ++N;
                        continue;
                    }
                    if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
                    ++N;
                }
            }
            double p = ((double)bestI + 1.0) / 100.0;
            Peptide tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getParentProteins(), noModPeptide.getModificationMatches());
            tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, posMin));
            matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumMap.get(bestI), tempPeptide, 0.0, mzTolerance, false);
            int n = 0;
            for (IonMatch match : matches) {
                int aa;
                Ion ion = match.ion;
                if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                    aa = fragmentIon.getNumber();
                    if (aa <= posMin || aa > posMax) continue;
                    ++n;
                    continue;
                }
                if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
                ++n;
            }
            double p1 = 0.0;
            for (int k = n; k <= N; ++k) {
                p1 += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
            }
            tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getParentProteins(), noModPeptide.getModificationMatches());
            tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, posMax));
            matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumMap.get(bestI), tempPeptide, 0.0, mzTolerance, false);
            n = 0;
            for (IonMatch match : matches) {
                int aa;
                Ion ion = match.ion;
                if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                    aa = fragmentIon.getNumber();
                    if (aa <= posMin || aa > posMax) continue;
                    ++n;
                    continue;
                }
                if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
                ++n;
            }
            double p2 = 0.0;
            for (int k = n; k <= N; ++k) {
                p2 += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
            }
            if (p1 == p2) {
                result.put(bestPositions, 0.0);
            } else if (p1 < p2) {
                ArrayList<Integer> modificationProfile = new ArrayList<Integer>();
                modificationProfile.add(posMin);
                double score1 = -10.0 * Math.log10(p1);
                double score2 = -10.0 * Math.log10(p2);
                double score = score1 - score2;
                result.put(modificationProfile, score);
            } else {
                ArrayList<Integer> modificationProfile = new ArrayList<Integer>();
                modificationProfile.add(posMax);
                double score1 = -10.0 * Math.log10(p1);
                double score2 = -10.0 * Math.log10(p2);
                double score = score2 - score1;
                result.put(modificationProfile, score);
            }
        } else if (possibleSites.size() == nPTM) {
            ArrayList<Integer> modificationProfile = new ArrayList<Integer>();
            Iterator i$ = possibleSites.iterator();
            while (i$.hasNext()) {
                int pos = (Integer)i$.next();
                modificationProfile.add(pos);
            }
            if (possibleSites.size() > 0) {
                result.put(modificationProfile, 100.0);
            }
        } else {
            throw new IllegalArgumentException("Found less potential modification sites than PTMs during A-score calculation. Peptide key: " + peptide.getKey());
        }
        return result;
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance) {
        return PTMLocationScores.getReducedSpectra(baseSpectrum, mzTolerance, -1);
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance, int depthMax) {
        int i;
        double currentmzMin;
        HashMap<Integer, MSnSpectrum> result = new HashMap<Integer, MSnSpectrum>();
        HashMap<Double, Peak> peakMap = baseSpectrum.getPeakMap();
        ArrayList<Double> mz = new ArrayList<Double>(peakMap.keySet());
        Collections.sort(mz);
        double mzMax = mz.get(mz.size() - 1);
        int cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            int cptTemp = 0;
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                ++cptTemp;
                ++cpt;
            }
            if (depthMax != -1 || cptTemp <= depthMax) continue;
            depthMax = cptTemp;
        }
        for (i = 0; i < depthMax; ++i) {
            result.put(i, new MSnSpectrum(2, baseSpectrum.getPrecursor(), baseSpectrum.getSpectrumTitle() + "_" + i, new HashMap<Double, Peak>(), "a score"));
        }
        cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            ArrayList<Double> intensities = new ArrayList<Double>();
            HashMap<Double, Peak> tempMap = new HashMap<Double, Peak>();
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                Peak tempPeak = peakMap.get(mz.get(cpt));
                intensities.add(-tempPeak.intensity);
                tempMap.put(-tempPeak.intensity, tempPeak);
                ++cpt;
            }
            Collections.sort(intensities);
            for (i = 0; i < intensities.size(); ++i) {
                for (int j = i; j < depthMax; ++j) {
                    result.get(j).addPeak((Peak)tempMap.get(intensities.get(i)));
                }
            }
        }
        return result;
    }

    public static HashMap<PeptideFragmentIon, ArrayList<IonMatch>> getPTMPlotData(Peptide peptide, PTM ptm, int nPTM, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, double intensityLimit) {
        Peptide noModPeptide = new Peptide(peptide.getSequence(), peptide.getParentProteins(), new ArrayList<ModificationMatch>());
        for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
            if (modificationMatch.getTheoreticPtm().equals(ptm.getName())) continue;
            noModPeptide.addModificationMatch(modificationMatch);
        }
        SpectrumAnnotator spectrumAnnotator = new SpectrumAnnotator();
        HashMap<Integer, ArrayList<Ion>> fragmentIons = spectrumAnnotator.getExpectedIons(iontypes, neutralLosses, charges, precursorCharge, noModPeptide);
        HashMap<PeptideFragmentIon, ArrayList<IonMatch>> map = new HashMap<PeptideFragmentIon, ArrayList<IonMatch>>();
        for (int i = 0; i <= nPTM; ++i) {
            spectrumAnnotator.setMassShift((double)i * ptm.getMass());
            ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, neutralLosses, charges, precursorCharge, spectrum, noModPeptide, intensityLimit, mzTolerance, false);
            block2: for (IonMatch ionMatch : matches) {
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ionMatch.ion;
                for (Ion noModIon : fragmentIons.get(ionMatch.charge.value)) {
                    if (noModIon.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || !peptideFragmentIon.isSameAs(noModIon)) continue;
                    PeptideFragmentIon noModFragmentIon = (PeptideFragmentIon)noModIon;
                    if (!map.containsKey(noModFragmentIon)) {
                        map.put(noModFragmentIon, new ArrayList());
                    }
                    map.get(noModFragmentIon).add(ionMatch);
                    continue block2;
                }
            }
        }
        return map;
    }

    public static PtmtableContent getPTMTableContent(Peptide peptide, PTM ptm, int nPTM, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, double intensityLimit) {
        PtmtableContent ptmTableContent = new PtmtableContent();
        Peptide noModPeptide = new Peptide(peptide.getSequence(), peptide.getParentProteins(), new ArrayList<ModificationMatch>());
        for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
            if (modificationMatch.getTheoreticPtm().equals(ptm.getName())) continue;
            noModPeptide.addModificationMatch(modificationMatch);
        }
        NeutralLossesMap lossesMap = new NeutralLossesMap();
        for (NeutralLoss neutralLoss : neutralLosses.getAccountedNeutralLosses()) {
            if (!(Math.abs(neutralLoss.mass - ptm.getMass()) > mzTolerance)) continue;
            lossesMap.addNeutralLoss(neutralLoss, 1, 1);
        }
        SpectrumAnnotator spectrumAnnotator = new SpectrumAnnotator();
        spectrumAnnotator.setPeptide(noModPeptide, precursorCharge);
        for (int i = 0; i <= nPTM; ++i) {
            spectrumAnnotator.setMassShift((double)i * ptm.getMass());
            ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, lossesMap, charges, precursorCharge, spectrum, noModPeptide, intensityLimit, mzTolerance, false);
            for (IonMatch ionMatch : matches) {
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ionMatch.ion;
                if (peptideFragmentIon.getSubType() == 0 || peptideFragmentIon.getSubType() == 1 || peptideFragmentIon.getSubType() == 2) {
                    ptmTableContent.addIntensity(i, peptideFragmentIon.getSubType(), peptideFragmentIon.getNumber(), ionMatch.peak.intensity);
                    continue;
                }
                if (peptideFragmentIon.getSubType() != 3 && peptideFragmentIon.getSubType() != 4 && peptideFragmentIon.getSubType() != 5) continue;
                ptmTableContent.addIntensity(i, peptideFragmentIon.getSubType(), peptide.getSequence().length() - peptideFragmentIon.getNumber() + 1, ionMatch.peak.intensity);
            }
        }
        return ptmTableContent;
    }
}

