/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndromedaIdfileReader
extends ExperimentObject
implements IdfileReader {
    private HashMap<String, Long> index;
    private BufferedRandomAccessFile bufferedRandomAccessFile;
    private String fileName;

    public AndromedaIdfileReader() {
    }

    public AndromedaIdfileReader(File resFile) throws FileNotFoundException, IOException {
        this(resFile, null);
    }

    public AndromedaIdfileReader(File resFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String line;
        this.bufferedRandomAccessFile = new BufferedRandomAccessFile(resFile, "r", 102400);
        this.fileName = resFile.getName();
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressValue(100);
        }
        long currentIndex = 0L;
        long progressUnit = this.bufferedRandomAccessFile.length() / 100L;
        this.index = new HashMap();
        String title = null;
        boolean newTitle = false;
        while ((line = this.bufferedRandomAccessFile.readLine()) != null) {
            if (line.startsWith(">")) {
                title = line.substring(1);
                newTitle = true;
            } else if (newTitle) {
                currentIndex = this.bufferedRandomAccessFile.getFilePointer();
                this.index.put(title, currentIndex);
                newTitle = false;
            }
            if (waitingHandler == null) continue;
            waitingHandler.setSecondaryProgressValue((int)(currentIndex / progressUnit));
        }
    }

    @Override
    public String getExtension() {
        return ".res";
    }

    @Override
    public HashSet<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, Exception {
        HashSet<SpectrumMatch> result = new HashSet<SpectrumMatch>();
        for (String title : this.index.keySet()) {
            String line;
            SpectrumMatch currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(this.fileName, title));
            int cpt = 1;
            while ((line = this.bufferedRandomAccessFile.getNextLine()) != null && !line.startsWith(">")) {
                currentMatch.addHit(4, this.getAssumptionFromLine(line, cpt));
                ++cpt;
            }
            result.add(currentMatch);
        }
        return result;
    }

    private PeptideAssumption getAssumptionFromLine(String line, int rank) {
        String[] temp = line.trim().split("\t");
        String[] temp1 = temp[5].split(";");
        ArrayList<String> proteins = new ArrayList<String>();
        for (String accession : temp1) {
            proteins.add(accession.substring(1, accession.length()));
        }
        temp1 = temp[4].split(",");
        ArrayList<ModificationMatch> modMatches = new ArrayList<ModificationMatch>();
        for (int aa = 0; aa < temp1.length; ++aa) {
            String mod = temp1[aa];
            if (mod.equals("A")) continue;
            modMatches.add(new ModificationMatch(mod, true, aa));
        }
        Peptide peptide = new Peptide(temp[0], proteins, modMatches);
        Charge charge = new Charge(1, new Integer(temp[6]));
        double score = new Double(temp[1]);
        return new PeptideAssumption(peptide, rank, 4, charge, -score, this.fileName);
    }

    @Override
    public void close() throws IOException {
        this.bufferedRandomAccessFile.close();
    }
}

