/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.massspectrometry;

import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgfIndex
extends ExperimentObject {
    private HashMap<String, Long> indexMap;
    private ArrayList<String> spectrumTitles = null;
    private String fileName;
    private Double maxRT;
    private Double minRT;
    private Double maxMz;
    private Double maxIntensity;

    public MgfIndex(ArrayList<String> spectrumTitles, HashMap<String, Long> indexMap, String fileName, double minRT, double maxRT, double maxMz, double maxIntensity) {
        this.spectrumTitles = spectrumTitles;
        this.indexMap = indexMap;
        this.fileName = fileName;
        this.maxRT = maxRT;
        this.minRT = minRT;
        this.maxMz = maxMz;
        this.maxIntensity = maxIntensity;
    }

    public Long getIndex(String spectrumTitle) {
        return this.indexMap.get(spectrumTitle);
    }

    public boolean containsSpectrum(String spectrumTitle) {
        return this.indexMap.containsKey(spectrumTitle);
    }

    public ArrayList<String> getSpectrumTitles() {
        if (this.spectrumTitles != null) {
            return this.spectrumTitles;
        }
        return new ArrayList<String>(this.indexMap.keySet());
    }

    public String getFileName() {
        return this.fileName;
    }

    public Double getMaxRT() {
        return this.maxRT;
    }

    public void setMaxRT(Double maxRT) {
        this.maxRT = maxRT;
    }

    public Double getMaxMz() {
        return this.maxMz;
    }

    public void setMaxMz(Double maxMz) {
        this.maxMz = maxMz;
    }

    public Double getMaxIntensity() {
        return this.maxIntensity;
    }

    public void setMaxIntensity(Double maxIntensity) {
        this.maxIntensity = maxIntensity;
    }

    public Double getMinRT() {
        return this.minRT;
    }

    public void setMinRT(Double minRT) {
        this.minRT = minRT;
    }

    public int getNSpectra() {
        return this.indexMap.size();
    }
}

