/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.io.massspectrometry.MgfIndex;
import com.compomics.util.experiment.io.massspectrometry.MgfReader;
import com.compomics.util.experiment.massspectrometry.MS1Spectrum;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.gui.waiting.WaitingHandler;
import com.compomics.util.io.SerializationUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import uk.ac.ebi.jmzml.model.mzml.BinaryDataArray;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.ParamGroup;
import uk.ac.ebi.jmzml.model.mzml.PrecursorList;
import uk.ac.ebi.jmzml.model.mzml.Scan;
import uk.ac.ebi.jmzml.model.mzml.ScanList;
import uk.ac.ebi.jmzml.model.mzml.SelectedIonList;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshaller;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpectrumFactory {
    private static SpectrumFactory instance = null;
    private HashMap<String, Spectrum> currentSpectrumMap = new HashMap();
    private HashMap<String, Precursor> loadedPrecursorsMap = new HashMap();
    private static int nSpectraCache = 1;
    private static int nPrecursorsCache = 10000;
    private ArrayList<String> loadedSpectra = new ArrayList();
    private ArrayList<String> loadedPrecursors = new ArrayList();
    private HashMap<String, BufferedRandomAccessFile> mgfFilesMap = new HashMap();
    private HashMap<String, MgfIndex> mgfIndexesMap = new HashMap();
    private HashMap<String, MzMLUnmarshaller> mzMLUnmarshallers = new HashMap();
    private HashMap<String, File> idToSpectrumName = new HashMap();

    private SpectrumFactory() {
    }

    public static SpectrumFactory getInstance() {
        if (instance == null) {
            instance = new SpectrumFactory();
        }
        return instance;
    }

    public static SpectrumFactory getInstance(int nCache) {
        if (instance == null) {
            instance = new SpectrumFactory();
        }
        instance.setCacheSize(nCache);
        return instance;
    }

    public void clearFactory() {
        this.currentSpectrumMap.clear();
        this.loadedPrecursorsMap.clear();
        this.loadedSpectra.clear();
        this.loadedPrecursors.clear();
        this.mgfFilesMap.clear();
        this.mgfIndexesMap.clear();
        this.mzMLUnmarshallers.clear();
        this.idToSpectrumName.clear();
    }

    public void setCacheSize(int nCache) {
        nSpectraCache = nCache;
    }

    public int getCacheSize() {
        return nSpectraCache;
    }

    public void addSpectra(File spectrumFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.addSpectra(spectrumFile, null);
    }

    public void addSpectra(File spectrumFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, IllegalArgumentException {
        String fileName = spectrumFile.getName();
        if (fileName.endsWith(".mgf")) {
            MgfIndex mgfIndex;
            File indexFile = new File(spectrumFile.getParent(), fileName + ".cui");
            if (!indexFile.exists()) {
                mgfIndex = MgfReader.getIndexMap(spectrumFile, waitingHandler);
                this.writeIndex(mgfIndex, spectrumFile.getParentFile());
            } else {
                try {
                    mgfIndex = this.getIndex(indexFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    mgfIndex = MgfReader.getIndexMap(spectrumFile, waitingHandler);
                    this.writeIndex(mgfIndex, spectrumFile.getParentFile());
                }
            }
            this.mgfFilesMap.put(fileName, new BufferedRandomAccessFile(spectrumFile, "r", 102400));
            this.mgfIndexesMap.put(fileName, mgfIndex);
        } else if (fileName.endsWith(".mzml")) {
            MzMLUnmarshaller mzMLUnmarshaller = new MzMLUnmarshaller(spectrumFile);
            this.mzMLUnmarshallers.put(fileName, mzMLUnmarshaller);
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
    }

    public Precursor getPrecursor(String fileName, String spectrumTitle) throws IOException, MzMLUnmarshallerException {
        return this.getPrecursor(Spectrum.getSpectrumKey(fileName, spectrumTitle));
    }

    public Precursor getPrecursor(String spectrumKey) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        return this.getPrecursor(spectrumKey, false);
    }

    public Double getMaxMz(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMaxMz();
    }

    public Double getMaxMz() {
        double maxMz = 0.0;
        Iterator<String> keys = this.mgfIndexesMap.keySet().iterator();
        while (keys.hasNext()) {
            String tempFileName = this.mgfIndexesMap.get(keys.next()).getFileName();
            if (!(this.getMaxMz(tempFileName) > maxMz)) continue;
            maxMz = this.getMaxMz(tempFileName);
        }
        return maxMz;
    }

    public Double getMaxIntensity(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMaxIntensity();
    }

    public Double getMaxIntensity() {
        double maxIntensity = 0.0;
        Iterator<String> keys = this.mgfIndexesMap.keySet().iterator();
        while (keys.hasNext()) {
            String tempFileName = this.mgfIndexesMap.get(keys.next()).getFileName();
            if (!(this.getMaxIntensity(tempFileName) > maxIntensity)) continue;
            maxIntensity = this.getMaxIntensity(tempFileName);
        }
        return maxIntensity;
    }

    public Double getMaxRT(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMaxRT();
    }

    public Double getMinRT(String fileName) {
        return this.mgfIndexesMap.get(fileName).getMinRT();
    }

    public Double getMaxRT() {
        double maxRT = 0.0;
        Iterator<String> keys = this.mgfIndexesMap.keySet().iterator();
        while (keys.hasNext()) {
            String tempFileName = this.mgfIndexesMap.get(keys.next()).getFileName();
            if (!(this.getMaxRT(tempFileName) > maxRT)) continue;
            maxRT = this.getMaxRT(tempFileName);
        }
        return maxRT;
    }

    public Double getMinRT() {
        double minRT = Double.MAX_VALUE;
        Iterator<String> keys = this.mgfIndexesMap.keySet().iterator();
        while (keys.hasNext()) {
            String tempFileName = this.mgfIndexesMap.get(keys.next()).getFileName();
            if (!(this.getMinRT(tempFileName) < minRT)) continue;
            minRT = this.getMinRT(tempFileName);
        }
        if (minRT == Double.MAX_VALUE) {
            minRT = 0.0;
        }
        return minRT;
    }

    public int getNSpectra(String fileName) {
        return this.mgfIndexesMap.get(fileName).getNSpectra();
    }

    public int getNSpectra() {
        int totalSpectrumCount = 0;
        for (String fileName : this.mgfIndexesMap.keySet()) {
            totalSpectrumCount += this.getNSpectra(fileName);
        }
        return totalSpectrumCount;
    }

    public Precursor getPrecursor(String spectrumKey, boolean save) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        if (this.currentSpectrumMap.containsKey(spectrumKey)) {
            return ((MSnSpectrum)this.currentSpectrumMap.get(spectrumKey)).getPrecursor();
        }
        Precursor currentPrecursor = this.loadedPrecursorsMap.get(spectrumKey);
        if (currentPrecursor != null) {
            return currentPrecursor;
        }
        return this.getPrecursor(spectrumKey, save, 0);
    }

    public boolean fileLoaded(String fileName) {
        return this.mgfIndexesMap.containsKey(fileName);
    }

    public boolean spectrumLoaded(String fileName, String spectrumTitle) {
        spectrumTitle = this.fixMgfTitle(spectrumTitle, fileName);
        return this.mgfIndexesMap.containsKey(fileName) && this.mgfIndexesMap.get(fileName).containsSpectrum(spectrumTitle);
    }

    public boolean spectrumLoaded(String spectrumKey) {
        String fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        return this.spectrumLoaded(fileName, spectrumTitle);
    }

    private synchronized Precursor getPrecursor(String spectrumKey, boolean save, int errorCounter) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        String fileName;
        Precursor currentPrecursor = null;
        String name = fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        if (name.endsWith(".mgf")) {
            spectrumTitle = this.fixMgfTitle(spectrumTitle, name);
            if (this.mgfIndexesMap.get(name) == null) {
                throw new IOException("Mgf file not found: '" + name + "'.");
            }
            if (this.mgfIndexesMap.get(name).getIndex(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mgf file '" + name + "' not found.");
            }
            try {
                currentPrecursor = MgfReader.getPrecursor(this.mgfFilesMap.get(name), this.mgfIndexesMap.get(name).getIndex(spectrumTitle), fileName);
            }
            catch (Exception e) {
                if (errorCounter <= 100) {
                    try {
                        this.wait(50L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    return this.getPrecursor(spectrumKey, save, errorCounter + 1);
                }
                e.printStackTrace();
                throw new IllegalArgumentException("Error while loading precursor of spectrum " + spectrumKey);
            }
        }
        if (name.endsWith(".mzml")) {
            SelectedIonList sIonList;
            PrecursorList precursorList;
            ScanList scanList;
            uk.ac.ebi.jmzml.model.mzml.Spectrum mzMLSpectrum = this.mzMLUnmarshallers.get(name).getSpectrumById(spectrumTitle);
            int level = 2;
            double mzPrec = 0.0;
            double scanTime = -1.0;
            int chargePrec = 0;
            for (CVParam cvParam : mzMLSpectrum.getCvParam()) {
                if (!cvParam.getAccession().equals("MS:1000511")) continue;
                level = new Integer(cvParam.getValue());
                break;
            }
            if ((scanList = mzMLSpectrum.getScanList()) != null) {
                for (CVParam cvParam : ((Scan)scanList.getScan().get(scanList.getScan().size() - 1)).getCvParam()) {
                    if (!cvParam.getAccession().equals("MS:1000016")) continue;
                    scanTime = new Double(cvParam.getValue());
                    break;
                }
            }
            if ((precursorList = mzMLSpectrum.getPrecursorList()) != null && precursorList.getCount() == 1 && (sIonList = ((uk.ac.ebi.jmzml.model.mzml.Precursor)precursorList.getPrecursor().get(0)).getSelectedIonList()) != null) {
                for (CVParam cvParam : ((ParamGroup)sIonList.getSelectedIon().get(0)).getCvParam()) {
                    if (cvParam.getAccession().equals("MS:1000744")) {
                        mzPrec = new Double(cvParam.getValue());
                        continue;
                    }
                    if (!cvParam.getAccession().equals("MS:1000041")) continue;
                    chargePrec = new Integer(cvParam.getValue());
                }
            }
            if (level == 1) {
                throw new IllegalArgumentException("MS1 spectrum");
            }
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
        if (save) {
            this.loadedPrecursorsMap.put(spectrumKey, currentPrecursor);
            this.loadedPrecursors.add(spectrumKey);
            while (this.loadedPrecursors.size() > nPrecursorsCache) {
                this.loadedPrecursorsMap.remove(this.loadedPrecursors.get(0));
                this.loadedPrecursors.remove(0);
            }
        }
        return currentPrecursor;
    }

    public Spectrum getSpectrum(String spectrumFile, String spectrumTitle) throws IOException, MzMLUnmarshallerException {
        return this.getSpectrum(Spectrum.getSpectrumKey(spectrumFile, spectrumTitle));
    }

    public Spectrum getSpectrum(String spectrumKey) throws IOException, IllegalArgumentException, MzMLUnmarshallerException {
        Spectrum currentSpectrum = this.currentSpectrumMap.get(spectrumKey);
        if (currentSpectrum != null) {
            return currentSpectrum;
        }
        return this.getSpectrum(spectrumKey, 0);
    }

    private synchronized Spectrum getSpectrum(String spectrumKey, int errorCounter) throws IOException, IllegalArgumentException, MzMLUnmarshallerException {
        String fileName;
        Spectrum currentSpectrum = null;
        String name = fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        if (name.endsWith(".mgf")) {
            spectrumTitle = this.fixMgfTitle(spectrumTitle, name);
            if (this.mgfIndexesMap.get(name) == null) {
                throw new FileNotFoundException("Mgf file not found: '" + name + "'!");
            }
            if (this.mgfIndexesMap.get(name).getIndex(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mgf file '" + name + "' not found!");
            }
            try {
                currentSpectrum = MgfReader.getSpectrum(this.mgfFilesMap.get(name), this.mgfIndexesMap.get(name).getIndex(spectrumTitle), fileName);
            }
            catch (Exception e) {
                if (errorCounter <= 100) {
                    try {
                        this.wait(50L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    return this.getSpectrum(spectrumKey, errorCounter + 1);
                }
                e.printStackTrace();
                throw new IllegalArgumentException("Error while loading spectrum " + spectrumKey);
            }
        }
        if (name.endsWith(".mzml")) {
            SelectedIonList sIonList;
            PrecursorList precursorList;
            ScanList scanList;
            if (this.mzMLUnmarshallers.get(name) == null) {
                throw new IOException("mzML file not found: '" + name + "'!");
            }
            if (this.mzMLUnmarshallers.get(name).getSpectrumById(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mzML file '" + name + "' not found!");
            }
            uk.ac.ebi.jmzml.model.mzml.Spectrum mzMLSpectrum = this.mzMLUnmarshallers.get(name).getSpectrumById(spectrumTitle);
            int level = 2;
            double mzPrec = 0.0;
            double scanTime = -1.0;
            int chargePrec = 0;
            for (CVParam cvParam : mzMLSpectrum.getCvParam()) {
                if (!cvParam.getAccession().equals("MS:1000511")) continue;
                level = new Integer(cvParam.getValue());
                break;
            }
            if ((scanList = mzMLSpectrum.getScanList()) != null) {
                for (CVParam cvParam : ((Scan)scanList.getScan().get(scanList.getScan().size() - 1)).getCvParam()) {
                    if (!cvParam.getAccession().equals("MS:1000016")) continue;
                    scanTime = new Double(cvParam.getValue());
                    break;
                }
            }
            if ((precursorList = mzMLSpectrum.getPrecursorList()) != null && precursorList.getCount() == 1 && (sIonList = ((uk.ac.ebi.jmzml.model.mzml.Precursor)precursorList.getPrecursor().get(0)).getSelectedIonList()) != null) {
                for (CVParam cvParam : ((ParamGroup)sIonList.getSelectedIon().get(0)).getCvParam()) {
                    if (cvParam.getAccession().equals("MS:1000744")) {
                        mzPrec = new Double(cvParam.getValue());
                        continue;
                    }
                    if (!cvParam.getAccession().equals("MS:1000041")) continue;
                    chargePrec = new Integer(cvParam.getValue());
                }
            }
            List bdal = mzMLSpectrum.getBinaryDataArrayList().getBinaryDataArray();
            BinaryDataArray mzBinaryDataArray = (BinaryDataArray)bdal.get(0);
            Number[] mzNumbers = mzBinaryDataArray.getBinaryDataAsNumberArray();
            BinaryDataArray intBinaryDataArray = (BinaryDataArray)bdal.get(1);
            Number[] intNumbers = intBinaryDataArray.getBinaryDataAsNumberArray();
            HashMap<Double, Peak> peakList = new HashMap<Double, Peak>();
            for (int i = 0; i < mzNumbers.length; ++i) {
                peakList.put(mzNumbers[i].doubleValue(), new Peak(mzNumbers[i].doubleValue(), intNumbers[i].doubleValue(), scanTime));
            }
            if (level == 1) {
                currentSpectrum = new MS1Spectrum(fileName, spectrumTitle, scanTime, peakList);
            }
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
        if (this.loadedSpectra.size() == nSpectraCache) {
            this.currentSpectrumMap.remove(this.loadedSpectra.get(0));
            this.loadedSpectra.remove(0);
        }
        this.currentSpectrumMap.put(spectrumKey, currentSpectrum);
        this.loadedSpectra.add(spectrumKey);
        return currentSpectrum;
    }

    public void writeIndex(MgfIndex mgfIndex, File directory) throws IOException {
        File indexFile = new File(directory, mgfIndex.getFileName() + ".cui");
        SerializationUtils.writeObject(mgfIndex, indexFile);
    }

    public MgfIndex getIndex(File mgfIndex) throws FileNotFoundException, IOException, ClassNotFoundException {
        return (MgfIndex)SerializationUtils.readObject(mgfIndex);
    }

    public void closeFiles() throws IOException {
        for (BufferedRandomAccessFile randomAccessFile : this.mgfFilesMap.values()) {
            randomAccessFile.close();
        }
    }

    public ArrayList<String> getMgfFileNames() {
        return new ArrayList<String>(this.mgfFilesMap.keySet());
    }

    public ArrayList<String> getMzMLFileNames() {
        return new ArrayList<String>(this.mzMLUnmarshallers.keySet());
    }

    public ArrayList<String> getSpectrumTitles(String mgfFile) {
        return this.mgfIndexesMap.get(mgfFile).getSpectrumTitles();
    }

    private String fixMgfTitle(String spectrumTitle, String fileName) {
        if (this.mgfIndexesMap.get(fileName).getIndex(spectrumTitle) == null) {
            try {
                spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("An exception was thrown when trying to decode an mgf title: " + spectrumTitle);
                e.printStackTrace();
            }
        }
        if (this.mgfIndexesMap.get(fileName).getIndex(spectrumTitle) == null) {
            spectrumTitle = spectrumTitle.replaceAll("\\\\\\\\", "\\\\");
        }
        return spectrumTitle;
    }

    public void addIdNameMapping(String idName, File spectrumFile) {
        this.idToSpectrumName.put(idName, spectrumFile);
    }

    public File getSpectrumFileFromIdName(String idName) {
        return this.idToSpectrumName.get(idName);
    }
}

