/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification;

import com.compomics.util.db.ObjectsCache;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.quantification.QuantificationDB;
import com.compomics.util.experiment.quantification.QuantificationMatch;
import com.compomics.util.experiment.quantification.matches.PeptideQuantification;
import com.compomics.util.experiment.quantification.matches.ProteinQuantification;
import com.compomics.util.experiment.quantification.matches.PsmQuantification;
import com.compomics.util.gui.waiting.WaitingHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Quantification
extends ExperimentObject {
    protected QuantificationMethod methodUsed;
    protected ArrayList<String> proteinQuantification = new ArrayList();
    protected ArrayList<String> peptideQuantification = new ArrayList();
    protected HashMap<String, ArrayList<String>> modifiedPeptidesQuantification = new HashMap();
    protected HashMap<String, ArrayList<String>> psmIDentificationToQuantification = new HashMap();
    private QuantificationDB quantificationDB;

    public ArrayList<String> getProteinQuantification() {
        return this.proteinQuantification;
    }

    public ArrayList<String> getPeptideQuantification() {
        return this.peptideQuantification;
    }

    public ArrayList<String> getModifiedPeptideQuantification(String modificationName) {
        return this.modifiedPeptidesQuantification.get(modificationName);
    }

    public HashMap<String, ArrayList<String>> getPsmIDentificationToQuantification() {
        return this.psmIDentificationToQuantification;
    }

    public QuantificationMethod getMethodUsed() {
        return this.methodUsed;
    }

    public void setMethodUsed(QuantificationMethod methodUsed) {
        this.methodUsed = methodUsed;
    }

    public ArrayList<PsmQuantification> getSpectrumMatches(String identificationMatchKey) throws Exception {
        ArrayList<PsmQuantification> result = new ArrayList<PsmQuantification>();
        for (String spectrumKey : this.psmIDentificationToQuantification.get(identificationMatchKey)) {
            result.add(this.getSpectrumMatch(spectrumKey));
        }
        return result;
    }

    public PsmQuantification getSpectrumMatch(String spectrumKey) throws Exception {
        return this.quantificationDB.getSpectrumMatch(spectrumKey);
    }

    public PeptideQuantification getPeptideMatch(String peptideKey) throws Exception {
        return this.quantificationDB.getPeptideMatch(peptideKey);
    }

    public ProteinQuantification getProteinMatch(String proteinKey) throws Exception {
        return this.quantificationDB.getProteinMatch(proteinKey);
    }

    public void addPsmQuantification(PsmQuantification match) throws Exception {
        String spectrumKey = match.getKey();
        String psmKey = match.getSpectrumMatchKey();
        if (!this.psmIDentificationToQuantification.containsKey(psmKey)) {
            this.psmIDentificationToQuantification.put(spectrumKey, new ArrayList());
        }
        if (!this.psmIDentificationToQuantification.get(psmKey).contains(spectrumKey)) {
            this.psmIDentificationToQuantification.get(psmKey).add(spectrumKey);
        }
        this.quantificationDB.addSpectrumMatch(match);
    }

    public void addPeptideQuantification(PeptideQuantification match) throws Exception {
        this.peptideQuantification.add(match.getKey());
        this.quantificationDB.addPeptideMatch(match);
    }

    public void addProteinQuantification(ProteinQuantification match) throws Exception {
        this.proteinQuantification.add(match.getKey());
        this.quantificationDB.addProteinMatch(match);
    }

    public void buildPeptidesAndProteinQuantifications(Identification identification, WaitingHandler waitingHandler) throws Exception {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressDialogIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressValue(identification.getProteinIdentification().size() + identification.getPeptideIdentification().size() + identification.getSpectrumIdentificationSize());
        }
        identification.loadProteinMatches(null);
        for (String proteinKey : identification.getProteinIdentification()) {
            ProteinMatch proteinMatch = identification.getProteinMatch(proteinKey);
            if (proteinMatch == null) {
                throw new IllegalArgumentException("Protein match " + proteinKey + " not found.");
            }
            ProteinQuantification tempProteinQuantification = new ProteinQuantification(proteinKey, proteinMatch.getPeptideMatches());
            this.addProteinQuantification(tempProteinQuantification);
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressValue();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        identification.loadPeptideMatches(null);
        for (String peptideKey : identification.getPeptideIdentification()) {
            PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
            PeptideQuantification tempPeptideQuantification = new PeptideQuantification(peptideKey, peptideMatch.getSpectrumMatches());
            this.addPeptideQuantification(tempPeptideQuantification);
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressValue();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        for (String fileName : identification.getSpectrumFiles()) {
            for (String psmKey : identification.getSpectrumIdentification(fileName)) {
                if (!this.psmIDentificationToQuantification.containsKey(psmKey)) {
                    this.psmIDentificationToQuantification.put(psmKey, new ArrayList());
                }
                if (waitingHandler == null) continue;
                waitingHandler.increaseSecondaryProgressValue();
                if (!waitingHandler.isRunCanceled()) continue;
                return;
            }
        }
    }

    public void setMatchChanged(QuantificationMatch match) throws IllegalArgumentException, IOException, SQLException {
        try {
            this.quantificationDB.updateMatch(match);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Error while writing match " + match.getKey() + " in the database.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Error while writing match " + match.getKey() + " in the database.");
        }
    }

    public void establishConnection(String dbFolder, String name, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        this.quantificationDB = new QuantificationDB(dbFolder, name, deleteOldDatabase, objectsCache);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QuantificationMethod {
        MS1_LABEL_FREE,
        MS1_LABEL,
        SPECTRUM_COUNTING,
        REPORTER_IONS;

    }
}

