/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification;

import com.compomics.util.db.ObjectsCache;
import com.compomics.util.db.ObjectsDB;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.experiment.quantification.QuantificationMatch;
import com.compomics.util.experiment.quantification.matches.PeptideQuantification;
import com.compomics.util.experiment.quantification.matches.ProteinQuantification;
import com.compomics.util.experiment.quantification.matches.PsmQuantification;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;

public class QuantificationDB
implements Serializable {
    static final long serialVersionUID = 4600091320219653637L;
    public String dbName;
    private String proteinTableName = "proteins";
    private String proteinParametersTableSuffix = "_protein_parameters";
    private String peptideTableName = "peptides";
    private String peptideParametersTableSuffix = "_peptide_parameters";
    private String psmTableSuffix = "_psms";
    private String psmParametersTableSuffix = "_psm_parameters";
    private ArrayList<String> psmTables = new ArrayList();
    private ArrayList<String> psmParametersTables = new ArrayList();
    private ArrayList<String> peptideParametersTables = new ArrayList();
    private ArrayList<String> proteinParametersTables = new ArrayList();
    private ObjectsDB objectsDB;

    public QuantificationDB(String folder, String name, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        this.dbName = name;
        this.objectsDB = new ObjectsDB(folder, this.dbName, deleteOldDatabase, objectsCache);
        if (deleteOldDatabase) {
            this.objectsDB.addTable(this.proteinTableName);
            this.objectsDB.addTable(this.peptideTableName);
        }
    }

    public boolean spectrumMatchLoaded(String spectrumKey) throws SQLException {
        String tableName = this.getSpectrumMatchTable(spectrumKey);
        return this.objectsDB.inDB(tableName, spectrumKey, true);
    }

    public boolean peptideMatchLoaded(String peptideKey) throws SQLException {
        return this.objectsDB.inDB(this.peptideTableName, peptideKey, true);
    }

    public boolean proteinMatchLoaded(String proteinKey) throws SQLException {
        return this.objectsDB.inDB(this.proteinTableName, proteinKey, true);
    }

    public void updateProteinMatch(ProteinQuantification proteinMatch) throws SQLException, IOException {
        this.objectsDB.updateObject(this.proteinTableName, proteinMatch.getKey(), proteinMatch);
    }

    public void updatePeptideMatch(PeptideQuantification peptideMatch) throws SQLException, IOException {
        this.objectsDB.updateObject(this.peptideTableName, peptideMatch.getKey(), peptideMatch);
    }

    public void updateSpectrumMatch(PsmQuantification spectrumMatch) throws SQLException, IOException {
        String key = spectrumMatch.getKey();
        String tableName = this.getSpectrumMatchTable(key);
        this.objectsDB.updateObject(tableName, key, spectrumMatch);
    }

    public void updateMatch(QuantificationMatch match) throws SQLException, IOException {
        switch (match.getType()) {
            case Spectrum: {
                this.updateSpectrumMatch((PsmQuantification)match);
                return;
            }
            case Peptide: {
                this.updatePeptideMatch((PeptideQuantification)match);
                return;
            }
            case Protein: {
                this.updateProteinMatch((ProteinQuantification)match);
            }
        }
    }

    public void updateProteinParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getProteinParameterTable(urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void updatePeptideParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getPeptideParameterTable(urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void updateSpectrumParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void removeProteinMatch(String key) throws SQLException, IOException {
        this.objectsDB.deleteObject(this.proteinTableName, key);
        for (String proteinParameterTable : this.proteinParametersTables) {
            this.objectsDB.deleteObject(proteinParameterTable, key);
        }
    }

    public void removePeptideMatch(String key) throws SQLException, IOException {
        this.objectsDB.deleteObject(this.peptideTableName, key);
        for (String peptideParameterTable : this.peptideParametersTables) {
            this.objectsDB.deleteObject(peptideParameterTable, key);
        }
    }

    public void removeSpectrumMatch(String key) throws SQLException, IOException {
        for (String psmTable : this.psmTables) {
            this.objectsDB.deleteObject(psmTable, key);
        }
        for (String psmParameterTable : this.psmParametersTables) {
            this.objectsDB.deleteObject(psmParameterTable, key);
        }
    }

    public PsmQuantification getSpectrumMatch(String key) throws SQLException, IOException, ClassNotFoundException {
        String tableName = this.getSpectrumMatchTable(key);
        return (PsmQuantification)this.objectsDB.retrieveObject(tableName, key);
    }

    public void addSpectrumMatch(PsmQuantification spectrumMatch) throws SQLException, IOException {
        String key = spectrumMatch.getKey();
        String tableName = this.getSpectrumMatchTable(key);
        if (!this.psmTables.contains(tableName)) {
            this.objectsDB.addTable(tableName);
            this.psmTables.add(tableName);
        }
        if (this.spectrumMatchLoaded(key)) {
            this.updateMatch(spectrumMatch);
        } else {
            this.objectsDB.insertObject(tableName, key, spectrumMatch, true);
        }
    }

    public PeptideQuantification getPeptideMatch(String key) throws SQLException, IOException, ClassNotFoundException {
        return (PeptideQuantification)this.objectsDB.retrieveObject(this.peptideTableName, key);
    }

    public void addPeptideMatch(PeptideQuantification peptideMatch) throws SQLException, IOException {
        if (this.peptideMatchLoaded(peptideMatch.getKey())) {
            this.updatePeptideMatch(peptideMatch);
        } else {
            this.objectsDB.insertObject(this.peptideTableName, peptideMatch.getKey(), peptideMatch, true);
        }
    }

    public ProteinQuantification getProteinMatch(String key) throws SQLException, IOException, ClassNotFoundException {
        return (ProteinQuantification)this.objectsDB.retrieveObject(this.proteinTableName, key);
    }

    public void addProteinMatch(ProteinQuantification proteinMatch) throws SQLException, IOException {
        if (this.proteinMatchLoaded(proteinMatch.getKey())) {
            this.updateProteinMatch(proteinMatch);
        } else {
            this.objectsDB.insertObject(this.proteinTableName, proteinMatch.getKey(), proteinMatch, true);
        }
    }

    public UrParameter getSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key);
    }

    public void addSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        if (!this.psmParametersTables.contains(tableName)) {
            this.objectsDB.addTable(tableName);
            this.psmParametersTables.add(tableName);
        }
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public UrParameter getPeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException {
        String tableName = this.getPeptideParameterTable(urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key);
    }

    public void addPeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getPeptideParameterTable(urParameter);
        if (!this.peptideParametersTables.contains(tableName)) {
            this.objectsDB.addTable(tableName);
            this.peptideParametersTables.add(tableName);
        }
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public UrParameter getProteinMatchPArameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException {
        String tableName = this.getProteinParameterTable(urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key);
    }

    public void addProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getProteinParameterTable(urParameter);
        if (!this.proteinParametersTables.contains(tableName)) {
            this.objectsDB.addTable(tableName);
            this.proteinParametersTables.add(tableName);
        }
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public String getSpectrumMatchTable(String spectrumKey) {
        String tableName = Spectrum.getSpectrumFile(spectrumKey) + this.psmTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getSpectrumParameterTable(String spectrumKey, UrParameter urParameter) {
        String fileName = Spectrum.getSpectrumFile(spectrumKey);
        String tableName = ExperimentObject.getParameterKey(urParameter) + "_" + fileName + this.psmParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getPeptideParameterTable(UrParameter urParameter) {
        String tableName = ExperimentObject.getParameterKey(urParameter) + this.peptideParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getProteinParameterTable(UrParameter urParameter) {
        String tableName = ExperimentObject.getParameterKey(urParameter) + this.proteinParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public void close() throws SQLException {
        this.objectsDB.close();
    }

    public void establishConnection(String dbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        this.objectsDB.establishConnection(dbFolder, deleteOldDatabase, objectsCache);
    }

    public void addMatch(QuantificationMatch match) throws SQLException, IOException {
        switch (match.getType()) {
            case Spectrum: {
                this.addSpectrumMatch((PsmQuantification)match);
                return;
            }
            case Peptide: {
                this.addPeptideMatch((PeptideQuantification)match);
                return;
            }
            case Protein: {
                this.addProteinMatch((ProteinQuantification)match);
            }
        }
    }
}

