/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AminoAcidPatternDialog
extends JDialog {
    private AminoAcidPattern pattern;
    private boolean editable;
    private boolean cancel = false;
    private ArrayList<String> patternDesignTableToolTips;
    private String exampleSequence = "MKFILLWALLNLTVALAFNPDYTVSSTPPYLVYLKSDYLPCAGVLIHPLWVITAAHCNLPKLRVILGVTIPADSNEKHLQVIGYEKMIHHPHFSVTSIDHDIMLIKLKTEAELNDYVKLANLPYQTISENTMCSVSTWSYNVCDIYKEPDSLQTVNISVISKPQCRDAYKTYNITENMLCVGIVPGRRQPCKEVSAAPAICNGMLQGILSFADGCVLRADVGIYAKIFYYIPWIENVIQNN";
    private JMenuItem addJMenuItem;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JMenuItem deleteSelectedRowJMenuItem;
    private JLabel exampleLabel;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JMenuItem moveDownJMenuItem;
    private JMenuItem moveUpJMenuItem;
    private JButton okButton;
    private JPanel patternDesignPanel;
    private JScrollPane patternDesignScrollPane;
    private JTable patternDesignTable;
    private JEditorPane patternTestEditorPane;
    private JScrollPane patternTestJScrollPane;
    private JPopupMenu popupJMenu;
    private JLabel rightClickHelpLabel;
    private JPanel testPanel;

    public AminoAcidPatternDialog(Frame parent, AminoAcidPattern pattern, boolean editable) {
        super(parent, true);
        this.pattern = new AminoAcidPattern(pattern);
        this.editable = editable;
        this.initComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/compomics-utilities.png")));
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.patternDesignScrollPane.getViewport().setOpaque(false);
        this.patternDesignTable.getTableHeader().setReorderingAllowed(false);
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.patternDesignTable.getTableHeader().getBackground());
        this.patternDesignScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        if (!this.editable) {
            this.cancelButton.setEnabled(false);
        }
        this.patternDesignTableToolTips = new ArrayList();
        this.patternDesignTableToolTips.add(null);
        this.patternDesignTableToolTips.add("Reference Index");
        this.patternDesignTableToolTips.add("The targeted amino acids");
        this.patternDesignTableToolTips.add("The excluded amino acids");
        this.patternDesignTable.getColumn(" ").setMaxWidth(50);
        this.patternDesignTable.getColumn(" ").setMinWidth(50);
        this.patternDesignTable.getColumn("Ref").setMaxWidth(30);
        this.patternDesignTable.getColumn("Ref").setMinWidth(30);
        this.patternDesignTable.getColumn("Ref").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.patternTestEditorPane.setText(this.exampleSequence);
        this.testPattern();
        this.repaintTable();
    }

    private void initComponents() {
        this.popupJMenu = new JPopupMenu();
        this.addJMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.moveUpJMenuItem = new JMenuItem();
        this.moveDownJMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.deleteSelectedRowJMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.patternDesignPanel = new JPanel();
        this.patternDesignScrollPane = new JScrollPane();
        this.patternDesignTable = new JTable(){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)AminoAcidPatternDialog.this.patternDesignTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.rightClickHelpLabel = new JLabel();
        this.testPanel = new JPanel();
        this.patternTestJScrollPane = new JScrollPane();
        this.patternTestEditorPane = new JEditorPane();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.exampleLabel = new JLabel();
        this.addJMenuItem.setMnemonic('A');
        this.addJMenuItem.setText("Add");
        this.addJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AminoAcidPatternDialog.this.addJMenuItemActionPerformed(evt);
            }
        });
        this.popupJMenu.add(this.addJMenuItem);
        this.popupJMenu.add(this.jSeparator3);
        this.moveUpJMenuItem.setMnemonic('U');
        this.moveUpJMenuItem.setText("Move Up");
        this.moveUpJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AminoAcidPatternDialog.this.moveUpJMenuItemActionPerformed(evt);
            }
        });
        this.popupJMenu.add(this.moveUpJMenuItem);
        this.moveDownJMenuItem.setMnemonic('D');
        this.moveDownJMenuItem.setText("Move Down");
        this.moveDownJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AminoAcidPatternDialog.this.moveDownJMenuItemActionPerformed(evt);
            }
        });
        this.popupJMenu.add(this.moveDownJMenuItem);
        this.popupJMenu.add(this.jSeparator4);
        this.deleteSelectedRowJMenuItem.setText("Delete");
        this.deleteSelectedRowJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AminoAcidPatternDialog.this.deleteSelectedRowJMenuItemActionPerformed(evt);
            }
        });
        this.popupJMenu.add(this.deleteSelectedRowJMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Modification Pattern");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.patternDesignPanel.setBorder(BorderFactory.createTitledBorder("Pattern Design"));
        this.patternDesignPanel.setOpaque(false);
        this.patternDesignScrollPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AminoAcidPatternDialog.this.patternDesignScrollPaneMouseClicked(evt);
            }
        });
        this.patternDesignTable.setModel(new PatternTable());
        this.patternDesignTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AminoAcidPatternDialog.this.patternDesignTableMouseClicked(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                AminoAcidPatternDialog.this.patternDesignTableMouseReleased(evt);
            }
        });
        this.patternDesignTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                AminoAcidPatternDialog.this.patternDesignTableKeyReleased(evt);
            }
        });
        this.patternDesignScrollPane.setViewportView(this.patternDesignTable);
        this.rightClickHelpLabel.setFont(this.rightClickHelpLabel.getFont().deriveFont(this.rightClickHelpLabel.getFont().getStyle() | 2));
        this.rightClickHelpLabel.setText("Right click in the table for options.");
        GroupLayout patternDesignPanelLayout = new GroupLayout(this.patternDesignPanel);
        this.patternDesignPanel.setLayout(patternDesignPanelLayout);
        patternDesignPanelLayout.setHorizontalGroup(patternDesignPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(patternDesignPanelLayout.createSequentialGroup().addContainerGap().addGroup(patternDesignPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.patternDesignScrollPane, -1, 402, Short.MAX_VALUE).addGroup(patternDesignPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.rightClickHelpLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        patternDesignPanelLayout.setVerticalGroup(patternDesignPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(patternDesignPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.patternDesignScrollPane, -1, 108, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightClickHelpLabel)));
        this.testPanel.setBorder(BorderFactory.createTitledBorder("Pattern Test"));
        this.testPanel.setOpaque(false);
        this.patternTestEditorPane.setContentType("text/html");
        this.patternTestEditorPane.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                AminoAcidPatternDialog.this.patternTestEditorPaneKeyReleased(evt);
            }
        });
        this.patternTestJScrollPane.setViewportView(this.patternTestEditorPane);
        GroupLayout testPanelLayout = new GroupLayout(this.testPanel);
        this.testPanel.setLayout(testPanelLayout);
        testPanelLayout.setHorizontalGroup(testPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, testPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.patternTestJScrollPane, -2, 0, Short.MAX_VALUE).addContainerGap()));
        testPanelLayout.setVerticalGroup(testPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.patternTestJScrollPane, -1, 117, Short.MAX_VALUE).addContainerGap()));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AminoAcidPatternDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(65, 23));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AminoAcidPatternDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.exampleLabel.setText("<html><i>\n<a href>Show Example</a></i>\n</html>");
        this.exampleLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AminoAcidPatternDialog.this.exampleLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                AminoAcidPatternDialog.this.exampleLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                AminoAcidPatternDialog.this.exampleLabelMouseExited(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.patternDesignPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.exampleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.patternDesignPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cancelButton, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton, -2, -1, -2).addComponent(this.exampleLabel, -2, -1, -2))).addContainerGap()));
        backgroundPanelLayout.linkSize(1, this.cancelButton, this.okButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean valid = this.validateInput();
        if (valid) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.dispose();
    }

    private void exampleLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exampleLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exampleLabelMouseClicked(MouseEvent evt) {
        this.pattern = AminoAcidPattern.getTrypsinExample();
        this.patternTestEditorPane.setText(this.exampleSequence);
        this.testPattern();
        this.repaintTable();
    }

    private void moveUpJMenuItemActionPerformed(ActionEvent evt) {
        int selectedRow = this.patternDesignTable.getSelectedRow();
        int selectedColumn = this.patternDesignTable.getSelectedColumn();
        this.pattern.swapRows(selectedRow, selectedRow - 1);
        this.patternDesignTable.changeSelection(selectedRow - 1, selectedColumn, false, false);
    }

    private void moveDownJMenuItemActionPerformed(ActionEvent evt) {
        int selectedRow = this.patternDesignTable.getSelectedRow();
        int selectedColumn = this.patternDesignTable.getSelectedColumn();
        this.pattern.swapRows(selectedRow, selectedRow + 1);
        this.patternDesignTable.changeSelection(selectedRow + 1, selectedColumn, false, false);
    }

    private void deleteSelectedRowJMenuItemActionPerformed(ActionEvent evt) {
        int selectedRow = this.patternDesignTable.getSelectedRow();
        if (selectedRow != -1) {
            this.pattern.removeAA(selectedRow);
            this.repaintTable();
            this.testPattern();
            this.validateInput();
        }
    }

    private void addJMenuItemActionPerformed(ActionEvent evt) {
        this.pattern.setTargeted(this.patternDesignTable.getRowCount(), new ArrayList<AminoAcid>());
        this.repaintTable();
    }

    private void patternDesignTableKeyReleased(KeyEvent evt) {
        this.testPattern();
    }

    private void patternDesignTableMouseReleased(MouseEvent evt) {
        this.testPattern();
    }

    private void patternDesignTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            int selectedRow = this.patternDesignTable.rowAtPoint(evt.getPoint());
            int column = this.patternDesignTable.columnAtPoint(evt.getPoint());
            this.patternDesignTable.changeSelection(selectedRow, column, false, false);
            this.moveUpJMenuItem.setEnabled(false);
            this.moveDownJMenuItem.setEnabled(false);
            this.deleteSelectedRowJMenuItem.setEnabled(true);
            if (selectedRow > 0) {
                this.moveUpJMenuItem.setEnabled(true);
            }
            if (selectedRow < this.patternDesignTable.getRowCount() - 1) {
                this.moveDownJMenuItem.setEnabled(true);
            }
            this.popupJMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void patternDesignScrollPaneMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            if (this.patternDesignTable.getSelectedRow() == -1) {
                this.moveUpJMenuItem.setEnabled(false);
                this.moveDownJMenuItem.setEnabled(false);
                this.deleteSelectedRowJMenuItem.setEnabled(false);
            }
            this.popupJMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void patternTestEditorPaneKeyReleased(KeyEvent evt) {
        this.testPattern();
    }

    public AminoAcidPattern getPattern() {
        return this.pattern;
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    private String getAAasString(ArrayList<AminoAcid> aminoAcids) {
        String result = "";
        if (aminoAcids != null) {
            for (AminoAcid aa : aminoAcids) {
                if (result.contains(aa.singleLetterCode)) continue;
                if (!result.equals("")) {
                    result = result + ", ";
                }
                result = result + aa.singleLetterCode;
            }
        }
        return result;
    }

    private ArrayList<AminoAcid> getAAfromString(String aminoAcids) {
        ArrayList<AminoAcid> result = new ArrayList<AminoAcid>();
        for (String aa : aminoAcids.split(", ")) {
            String input = aa.trim();
            if ((input = input.toUpperCase()).equals("")) continue;
            for (int i = 0; i < input.length(); ++i) {
                AminoAcid aminoAcid = AminoAcid.getAminoAcid(input.charAt(i));
                if (aminoAcid == null) {
                    throw new IllegalArgumentException("Cannot parse " + input.charAt(i) + " into an amino-acid");
                }
                result.add(aminoAcid);
            }
        }
        return result;
    }

    private void testPattern() {
        String tempSequence = this.patternTestEditorPane.getText();
        int caretPosition = this.patternTestEditorPane.getCaretPosition();
        if (tempSequence.indexOf("<html>") != -1) {
            tempSequence = tempSequence.replaceAll("\\<[^>]*>", "");
        }
        ArrayList<Integer> indexes = this.pattern.getIndexes(tempSequence);
        String result = "";
        for (int i = 0; i < tempSequence.length(); ++i) {
            result = indexes.contains(i + 1) ? result + "<span style=\"color:#" + Util.color2Hex(Color.WHITE) + ";background:#" + Util.color2Hex(Color.BLUE) + "\">" : result + "<span style=\"color:#" + Util.color2Hex(Color.BLACK) + ";background:#" + Util.color2Hex(Color.WHITE) + "\">";
            result = result + tempSequence.charAt(i);
            result = result + "</span>";
        }
        this.patternTestEditorPane.setText(result);
        this.patternTestEditorPane.setCaretPosition(caretPosition);
    }

    private void repaintTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AminoAcidPatternDialog.this.patternDesignTable.revalidate();
                AminoAcidPatternDialog.this.patternDesignTable.repaint();
            }
        });
    }

    private boolean validateInput() {
        return true;
    }

    private class PatternTable
    extends DefaultTableModel {
        private PatternTable() {
        }

        public int getRowCount() {
            return AminoAcidPatternDialog.this.pattern.length();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Ref";
                }
                case 2: {
                    return "Targeted AA";
                }
                case 3: {
                    return "Excluded AA";
                }
            }
            return "";
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return row == AminoAcidPatternDialog.this.pattern.getTarget();
                }
                case 2: {
                    return AminoAcidPatternDialog.this.getAAasString(AminoAcidPatternDialog.this.pattern.getTargetedAA(row));
                }
                case 3: {
                    return AminoAcidPatternDialog.this.getAAasString(AminoAcidPatternDialog.this.pattern.getExcludedAA(row));
                }
            }
            return "";
        }

        public void setValueAt(Object aValue, int row, int column) {
            try {
                if (column == 1) {
                    AminoAcidPatternDialog.this.pattern.setTarget(row);
                } else if (column == 2) {
                    ArrayList aa = AminoAcidPatternDialog.this.getAAfromString(aValue.toString());
                    AminoAcidPatternDialog.this.pattern.setTargeted(row, aa);
                } else if (column == 3) {
                    ArrayList aa = AminoAcidPatternDialog.this.getAAfromString(aValue.toString());
                    AminoAcidPatternDialog.this.pattern.setExcluded(row, aa);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Input Error", 0);
            }
            AminoAcidPatternDialog.this.repaintTable();
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return new Double(0.0).getClass();
        }

        public boolean isCellEditable(int row, int column) {
            return AminoAcidPatternDialog.this.editable && column != 0;
        }
    }
}

