/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.gui.VisibleTableColumnsDialogParent;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;

public class VisibleTableColumnsDialog
extends JDialog {
    private VisibleTableColumnsDialogParent visibleTableColumnsDialogParent;
    private JPanel backgroundPanel;
    private JMenuItem deselectAllMenuItem;
    private JButton okButton;
    private JMenuItem selectAllMenuItem;
    private JPopupMenu selectJPopupMenu;
    private JTable selectedColumnsTable;
    private JScrollPane selectedValuesTableScrollPane;

    public VisibleTableColumnsDialog(JDialog dialog, VisibleTableColumnsDialogParent visibleTableColumnsDialogParent, boolean modal) {
        super((Dialog)dialog, modal);
        this.initComponents();
        this.visibleTableColumnsDialogParent = visibleTableColumnsDialogParent;
        this.setUpGui();
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    public VisibleTableColumnsDialog(JFrame frame, VisibleTableColumnsDialogParent visibleTableColumnsDialogParent, boolean modal) {
        super((Frame)frame, modal);
        this.initComponents();
        this.visibleTableColumnsDialogParent = visibleTableColumnsDialogParent;
        this.setUpGui();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private void setUpGui() {
        TableModel tableModel = this.visibleTableColumnsDialogParent.getTable().getModel();
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            ((DefaultTableModel)this.selectedColumnsTable.getModel()).addRow(new Object[]{i + 1, tableModel.getColumnName(i), this.visibleTableColumnsDialogParent.getVisibleColumns().get(i)});
        }
        this.selectedValuesTableScrollPane.getViewport().setOpaque(false);
        this.selectedColumnsTable.getTableHeader().setReorderingAllowed(false);
        this.selectedColumnsTable.getColumn(" ").setMaxWidth(50);
        this.selectedColumnsTable.getColumn(" ").setMinWidth(50);
        this.selectedColumnsTable.getColumn("  ").setMaxWidth(30);
        this.selectedColumnsTable.getColumn("  ").setMinWidth(30);
        this.selectedColumnsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
    }

    private void initComponents() {
        this.selectJPopupMenu = new JPopupMenu();
        this.selectAllMenuItem = new JMenuItem();
        this.deselectAllMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.selectedValuesTableScrollPane = new JScrollPane();
        this.selectedColumnsTable = new JTable();
        this.okButton = new JButton();
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisibleTableColumnsDialog.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.selectJPopupMenu.add(this.selectAllMenuItem);
        this.deselectAllMenuItem.setText("Deselect All");
        this.deselectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisibleTableColumnsDialog.this.deselectAllMenuItemActionPerformed(evt);
            }
        });
        this.selectJPopupMenu.add(this.deselectAllMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Visible Columns");
        this.setMinimumSize(new Dimension(297, 386));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.selectedColumnsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.selectedColumnsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                VisibleTableColumnsDialog.this.selectedColumnsTableMouseClicked(evt);
            }
        });
        this.selectedValuesTableScrollPane.setViewportView(this.selectedColumnsTable);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisibleTableColumnsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.selectedValuesTableScrollPane, -2, 0, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 230, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.selectedValuesTableScrollPane, -1, 342, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addGap(4, 4, 4)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int i;
        HashMap<Integer, Boolean> showColumns = new HashMap<Integer, Boolean>();
        for (int i2 = 0; i2 < this.selectedColumnsTable.getRowCount(); ++i2) {
            if (((Boolean)this.selectedColumnsTable.getValueAt(i2, this.selectedColumnsTable.getColumn("  ").getModelIndex())).booleanValue()) {
                showColumns.put(i2, true);
                continue;
            }
            showColumns.put(i2, false);
        }
        ArrayList<TableColumn> allTableColumns = this.visibleTableColumnsDialogParent.getAllTableColumns();
        for (i = 0; i < allTableColumns.size(); ++i) {
            this.visibleTableColumnsDialogParent.getTable().removeColumn(allTableColumns.get(i));
        }
        for (i = 0; i < allTableColumns.size(); ++i) {
            if (!((Boolean)showColumns.get(i)).booleanValue()) continue;
            this.visibleTableColumnsDialogParent.getTable().addColumn(allTableColumns.get(i));
        }
        this.visibleTableColumnsDialogParent.setVisibleColumns(showColumns);
        this.dispose();
    }

    private void selectedColumnsTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.selectJPopupMenu.show(this.selectedColumnsTable, evt.getX(), evt.getY());
        }
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.selectedColumnsTable.getRowCount(); ++i) {
            ((DefaultTableModel)this.selectedColumnsTable.getModel()).setValueAt(true, i, this.selectedColumnsTable.getColumn("  ").getModelIndex());
        }
    }

    private void deselectAllMenuItemActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.selectedColumnsTable.getRowCount(); ++i) {
            ((DefaultTableModel)this.selectedColumnsTable.getModel()).setValueAt(false, i, this.selectedColumnsTable.getColumn("  ").getModelIndex());
        }
    }
}

