/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.error_handlers;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpDialog
extends JDialog {
    private Frame frameParent = null;
    private JDialog dialogParent = null;
    private JPanel backgroundPanel;
    private JButton closeJButton;
    private JScrollPane jScrollPane1;
    private JEditorPane textJEditorPane;

    public HelpDialog(Frame parent, URL fileName, Image helpIcon, Image aboutIcon, String title) {
        this(parent, fileName, null, helpIcon, aboutIcon, title, 500, 300);
    }

    public HelpDialog(Frame parent, URL fileName, Image helpIcon, Image aboutIcon, String title, int windowWidth, int windowHeightReduction) {
        this(parent, fileName, null, helpIcon, aboutIcon, title, windowWidth, windowHeightReduction);
    }

    public HelpDialog(Frame parent, URL fileName, String reference, Image helpIcon, Image aboutIcon, String title) {
        this(parent, fileName, reference, helpIcon, aboutIcon, title, 500, 300);
    }

    public HelpDialog(Frame parent, URL fileName, String reference, Image helpIcon, Image aboutIcon, String title, int windowWidth, int windowHeightReduction) {
        super(parent, true);
        this.frameParent = parent;
        this.initComponents();
        try {
            InputStream stream = fileName.openStream();
            InputStreamReader streamReader = new InputStreamReader(stream);
            BufferedReader b = new BufferedReader(streamReader);
            String s = b.readLine();
            String helpText = "";
            while (s != null) {
                helpText = helpText + s;
                s = b.readLine();
            }
            String imageTag = "<img src=\"";
            int index = 0;
            while (helpText.indexOf(imageTag, index) != -1) {
                int startIndex = helpText.indexOf(imageTag, index) + imageTag.length();
                String figureName = helpText.substring(startIndex, helpText.indexOf(".", startIndex));
                String figureType = helpText.substring(helpText.indexOf(".", startIndex) + 1, helpText.indexOf("\"", startIndex));
                helpText = helpText.replaceAll(imageTag + figureName + "." + figureType, imageTag + this.getClass().getResource("/helpFiles/" + figureName + "." + figureType));
                index = helpText.indexOf(imageTag, index) + 1;
            }
            this.textJEditorPane.setText(helpText);
            if (fileName.getPath().substring(fileName.getPath().lastIndexOf(File.separator) + File.separator.length()).startsWith("About")) {
                this.setTitle("About");
                this.setIconImage(aboutIcon);
            } else {
                this.setTitle(title);
                this.setIconImage(helpIcon);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.textJEditorPane.setPage(this.getClass().getResource("/helpfiles/DefaultHelpFile.html"));
            }
            catch (Exception ex) {
                this.textJEditorPane.setText("The selected help file is not yet available.");
            }
        }
        this.textJEditorPane.setCaretPosition(0);
        if (reference != null) {
            final String marker = reference;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HelpDialog.this.textJEditorPane.scrollToReference(marker);
                }
            });
        }
        this.setSize(windowWidth, parent.getHeight() - windowHeightReduction);
        parent.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public HelpDialog(JDialog parent, URL fileName, Image helpIcon, Image aboutIcon, String title) {
        this(parent, fileName, null, helpIcon, aboutIcon, title, 500, 300);
    }

    public HelpDialog(JDialog parent, URL fileName, Image helpIcon, Image aboutIcon, String title, int windowWidth, int windowHeightReduction) {
        this(parent, fileName, null, helpIcon, aboutIcon, title, windowWidth, windowHeightReduction);
    }

    public HelpDialog(JDialog parent, URL fileName, String reference, Image helpIcon, Image aboutIcon, String title) {
        this(parent, fileName, reference, helpIcon, aboutIcon, title, 500, 300);
    }

    public HelpDialog(JDialog parent, URL fileName, String reference, Image helpIcon, Image aboutIcon, String title, int windowWidth, int windowHeightReduction) {
        super((Dialog)parent, true);
        this.dialogParent = parent;
        this.initComponents();
        try {
            InputStream stream = fileName.openStream();
            InputStreamReader streamReader = new InputStreamReader(stream);
            BufferedReader b = new BufferedReader(streamReader);
            String s = b.readLine();
            String helpText = "";
            while (s != null) {
                helpText = helpText + s;
                s = b.readLine();
            }
            String imageTag = "<img src=\"";
            int index = 0;
            while (helpText.indexOf(imageTag, index) != -1) {
                int startIndex = helpText.indexOf(imageTag, index) + imageTag.length();
                String figureName = helpText.substring(startIndex, helpText.indexOf(".", startIndex));
                String figureType = helpText.substring(helpText.indexOf(".", startIndex) + 1, helpText.indexOf("\"", startIndex));
                helpText = helpText.replaceAll(imageTag + figureName + "." + figureType, imageTag + this.getClass().getResource("/helpFiles/" + figureName + "." + figureType));
                index = helpText.indexOf(imageTag, index) + 1;
            }
            this.textJEditorPane.setText(helpText);
            if (fileName.getPath().substring(fileName.getPath().lastIndexOf(File.separator) + File.separator.length()).startsWith("About")) {
                this.setTitle("About");
                this.setIconImage(aboutIcon);
            } else {
                this.setTitle(title);
                this.setIconImage(helpIcon);
            }
        }
        catch (Exception e) {
            try {
                this.textJEditorPane.setPage(this.getClass().getResource("/helpfiles/DefaultHelpFile.html"));
            }
            catch (Exception ex) {
                this.textJEditorPane.setText("The selected help file is not yet available.");
            }
        }
        this.textJEditorPane.setCaretPosition(0);
        if (reference != null) {
            final String marker = reference;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HelpDialog.this.textJEditorPane.scrollToReference(marker);
                }
            });
        }
        this.setSize(windowWidth, parent.getParent().getHeight() - windowHeightReduction);
        parent.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.closeJButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textJEditorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("PeptideShaker - Help");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.closeJButton.setText("Close");
        this.closeJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HelpDialog.this.closeJButtonActionPerformed(evt);
            }
        });
        this.textJEditorPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.textJEditorPane.setContentType("text/html");
        this.textJEditorPane.setEditable(false);
        this.textJEditorPane.setMinimumSize(new Dimension(10, 10));
        this.textJEditorPane.setPreferredSize(new Dimension(10, 10));
        this.textJEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                HelpDialog.this.textJEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.textJEditorPane);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeJButton, GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 382, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.closeJButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeJButtonActionPerformed(ActionEvent evt) {
        if (this.frameParent != null) {
            this.frameParent.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        } else {
            this.dialogParent.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void textJEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ENTERED.toString())) {
            this.setCursor(new Cursor(12));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.EXITED.toString())) {
            this.setCursor(new Cursor(0));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            if (evt.getDescription().startsWith("#")) {
                this.textJEditorPane.scrollToReference(evt.getDescription());
            } else {
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(evt.getDescription());
                this.setCursor(new Cursor(0));
            }
        }
    }
}

