/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.filehandling;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelectionDialog
extends JDialog {
    private HashMap<String, File> fileMap = new HashMap();
    private boolean canceled = false;
    private JButton cancelButton;
    private JList fileList;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JLabel txtLabel;

    public FileSelectionDialog(JFrame parent, ArrayList<File> files, String text) {
        super((Frame)parent, true);
        this.initComponents();
        String[] fileNames = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            fileNames[i] = files.get(i).getName();
            this.fileMap.put(files.get(i).getName(), files.get(i));
        }
        this.fileList.setListData(fileNames);
        this.setLocationRelativeTo(parent);
        this.txtLabel.setText(text);
        this.setVisible(true);
    }

    private void initComponents() {
        this.txtLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fileList = new JList();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("SearchGUI Parameters");
        this.txtLabel.setFont(this.txtLabel.getFont().deriveFont(this.txtLabel.getFont().getStyle() | 2));
        this.txtLabel.setText("Please select the desired file.");
        this.fileList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fileList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.fileList);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.txtLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.jScrollPane1, -1, 612, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.txtLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    public File getSelectedFile() {
        String selectedName = (String)this.fileList.getSelectedValue();
        return this.fileMap.get(selectedName);
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

