/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.ptm;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.gui.AminoAcidPatternDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.ptm.PtmDialogParent;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.renderers.ToolTipComboBoxRenderer;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.pride.PrideObjectsFactory;
import com.compomics.util.pride.PtmToPrideMap;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import no.uib.olsdialog.OLSDialog;
import no.uib.olsdialog.OLSInputable;
import uk.ac.ebi.ols.soap.Query;
import uk.ac.ebi.ols.soap.QueryServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtmDialog
extends JDialog
implements OLSInputable {
    private PtmDialogParent ptmDialogParent;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private PTM currentPtm = null;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList();
    private ArrayList<ReporterIon> reporterIons = new ArrayList();
    private PtmToPrideMap ptmToPrideMap;
    private CvTerm cvTerm = null;
    private boolean editable;
    private AminoAcidPattern pattern;
    private JButton addNeutralLoss;
    private JButton addReporterIon;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JPanel detailsPanel;
    private JButton helpJButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel massLabel;
    private JTextField massTxt;
    private JLabel nameLabel;
    private JTextField nameTxt;
    private JPanel neutralLossesAndReporterIonsPanel;
    private JScrollPane neutralLossesJScrollPane;
    private JTable neutralLossesTable;
    private JButton okButton;
    private JButton olsJButton;
    private JLabel patternLabel;
    private JTextField psiModMappingJTextField;
    private JPanel psiModMappingPanel;
    private JButton removeNeutralLoss;
    private JButton removerReporterIon;
    private JScrollPane reporterIonsJScrollPane;
    private JTable reporterIonsTable;
    private JTextField residuesTxt;
    private JComboBox typeCmb;

    public PtmDialog(JDialog parent, PtmDialogParent ptmDialogParent, PtmToPrideMap ptmToPrideMap, PTM currentPTM, boolean editable) {
        super((Dialog)parent, true);
        this.ptmDialogParent = ptmDialogParent;
        this.ptmToPrideMap = ptmToPrideMap;
        this.currentPtm = currentPTM;
        this.pattern = currentPTM != null ? this.currentPtm.getPattern() : new AminoAcidPattern();
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public PtmDialog(JFrame parent, PtmDialogParent ptmDialogParent, PtmToPrideMap ptmToPrideMap, PTM currentPTM, boolean editable) {
        super((Frame)parent, true);
        this.ptmDialogParent = ptmDialogParent;
        this.ptmToPrideMap = ptmToPrideMap;
        this.currentPtm = currentPTM;
        this.editable = editable;
        this.pattern = currentPTM != null ? this.currentPtm.getPattern() : new AminoAcidPattern();
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.typeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.neutralLossesTable.getTableHeader().setReorderingAllowed(false);
        this.reporterIonsTable.getTableHeader().setReorderingAllowed(false);
        this.neutralLossesJScrollPane.getViewport().setOpaque(false);
        this.reporterIonsJScrollPane.getViewport().setOpaque(false);
        this.neutralLossesTable.getColumn(" ").setMaxWidth(50);
        this.neutralLossesTable.getColumn(" ").setMinWidth(50);
        this.reporterIonsTable.getColumn(" ").setMaxWidth(50);
        this.reporterIonsTable.getColumn(" ").setMinWidth(50);
        this.neutralLossesTable.getColumn("Fixed").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green.png")), null, "Fixed", null));
        Vector<String> comboboxTooltips = new Vector<String>();
        comboboxTooltips.add("Modification at particular amino acids");
        comboboxTooltips.add("Modification at the N terminus of a protein");
        comboboxTooltips.add("Modification at the N terminus of a protein at particular amino acids");
        comboboxTooltips.add("Modification at the C terminus of a protein");
        comboboxTooltips.add("Modification at the C terminus of a protein at particular amino acids");
        comboboxTooltips.add("Modification at the N terminus of a peptide");
        comboboxTooltips.add("Modification at the N terminus of a peptide at particular amino acids");
        comboboxTooltips.add("Modification at the C terminus of a peptide");
        comboboxTooltips.add("Modification at the C terminus of a peptide at particular amino acids");
        this.typeCmb.setRenderer(new ToolTipComboBoxRenderer(comboboxTooltips, 0));
        this.typeCmb.setEnabled(this.editable);
        this.nameTxt.setEditable(this.editable);
        this.massTxt.setEditable(this.editable);
        this.addNeutralLoss.setEnabled(this.editable);
        this.removeNeutralLoss.setEnabled(this.editable);
        this.addReporterIon.setEnabled(this.editable);
        this.removerReporterIon.setEnabled(this.editable);
        if (this.currentPtm != null) {
            this.typeCmb.setSelectedIndex(this.currentPtm.getType());
            this.nameTxt.setText(this.currentPtm.getName());
            this.massTxt.setText(this.currentPtm.getMass() + "");
            this.residuesTxt.setText(this.pattern.toString());
            this.neutralLosses.addAll(this.currentPtm.getNeutralLosses());
            this.reporterIons.addAll(this.currentPtm.getReporterIons());
            this.updateTables();
            this.cvTerm = this.ptmToPrideMap.getCVTerm(this.currentPtm.getName());
            if (this.cvTerm == null) {
                this.cvTerm = PtmToPrideMap.getDefaultCVTerm(this.currentPtm.getName());
            }
            if (this.cvTerm != null) {
                this.updateModMappingText();
            }
            this.setTitle("Edit Modification");
        }
        this.validateInput(false);
    }

    private boolean validateInput(boolean showMessage) {
        int outcome;
        String newName;
        boolean error = false;
        this.nameLabel.setForeground(Color.BLACK);
        this.massLabel.setForeground(Color.BLACK);
        this.patternLabel.setForeground(Color.BLACK);
        this.nameLabel.setToolTipText(null);
        this.nameTxt.setToolTipText(null);
        this.massLabel.setToolTipText(null);
        this.massTxt.setToolTipText(null);
        this.patternLabel.setToolTipText(null);
        this.residuesTxt.setToolTipText(null);
        if (this.massTxt.getText().trim().length() == 0) {
            error = true;
            this.massLabel.setForeground(Color.RED);
            this.massLabel.setToolTipText("Please provide a modification mass.");
            this.massTxt.setToolTipText("Please provide a modification mass.");
        } else {
            try {
                new Double(this.massTxt.getText().trim());
            }
            catch (Exception e) {
                if (showMessage) {
                    JOptionPane.showMessageDialog(this, "Please verify the input for the modification mass.", "Wrong Mass", 2);
                }
                error = true;
                this.massLabel.setForeground(Color.RED);
                this.massLabel.setToolTipText("Please verify the input for the modification mass.");
                this.massTxt.setToolTipText("Please verify the input for the modification mass.");
            }
        }
        String name = this.nameTxt.getText().trim();
        if (name.length() == 0) {
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Please provide a modification name.");
            this.nameTxt.setToolTipText("Please provide a modification name.");
        }
        if (name.contains(Peptide.MODIFICATION_SEPARATOR)) {
            newName = name.replace(Peptide.MODIFICATION_SEPARATOR, " ");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'" + Peptide.MODIFICATION_SEPARATOR + "' should be avoided in modification names." + "\nShall " + name + " be replaced by " + newName + "?", "'" + Peptide.MODIFICATION_SEPARATOR + "' in Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'" + Peptide.MODIFICATION_SEPARATOR + "' should be avoided in modification names.");
                    this.nameTxt.setToolTipText("'" + Peptide.MODIFICATION_SEPARATOR + "' should be avoided in modification names.");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'" + Peptide.MODIFICATION_SEPARATOR + "' should be avoided in modification names.");
                this.nameTxt.setToolTipText("'" + Peptide.MODIFICATION_SEPARATOR + "' should be avoided in modification names.");
            }
        }
        if (name.contains(Peptide.MODIFICATION_LOCALIZATION_SEPARATOR)) {
            newName = name.replace(Peptide.MODIFICATION_LOCALIZATION_SEPARATOR, "AT-AA");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'" + Peptide.MODIFICATION_LOCALIZATION_SEPARATOR + "' should be avoided in modification names.\n" + "Shall " + name + " be replaced by " + newName + "?", "'" + Peptide.MODIFICATION_LOCALIZATION_SEPARATOR + "' in Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'" + Peptide.MODIFICATION_LOCALIZATION_SEPARATOR + "' should be avoided in modification names.");
                    this.nameTxt.setToolTipText("'" + Peptide.MODIFICATION_LOCALIZATION_SEPARATOR + "' should be avoided in modification names.");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'" + Peptide.MODIFICATION_LOCALIZATION_SEPARATOR + "' should be avoided in modification names.");
                this.nameTxt.setToolTipText("'" + Peptide.MODIFICATION_LOCALIZATION_SEPARATOR + "' should be avoided in modification names.");
            }
        }
        if (name.contains("|search-only")) {
            newName = name.replace("|search-only", "SEARCH-ONLY");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'|search-only' should be avoided in the end of modification names.\nShall " + name + " be replaced by " + newName + "?", "'|search-only' Ending Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'|search-only' should be avoided in modification names.");
                    this.nameTxt.setToolTipText("'|search-only' should be avoided in modification names.");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'|search-only' should be avoided in modification names.");
                this.nameTxt.setToolTipText("'|search-only' should be avoided in modification names.");
            }
        }
        name = this.nameTxt.getText().trim();
        if (this.ptmFactory.getDefaultModifications().contains(name) && (this.currentPtm == null || !name.equals(this.currentPtm.getName()))) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "A modification named '" + name + "' already exists in the " + "default modification lists.\n" + "Please select the default modification or use another name.", "Modification Already Exists", 2);
            } else {
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("<html>A modification named '" + name + "' already exists in the " + "default modification lists.<br>" + "Please select the default modification or use another name.</html>");
                this.nameTxt.setToolTipText("<html>A modification named '" + name + "' already exists in the " + "default modification lists.<br>" + "Please select the default modification or use another name.</html>");
            }
            error = true;
        }
        if (this.ptmFactory.getUserModifications().contains(name) && (this.currentPtm == null || !name.equals(this.currentPtm.getName()))) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "There is already a modification named '" + name + "'!", "Modification Already Exists", 2);
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("There is already a modification named '" + name + "'!");
            this.nameTxt.setToolTipText("There is already a modification named '" + name + "'!");
        }
        if (this.residuesTxt.getText().length() == 0) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the modification pattern.", "Missing Pattern", 2);
            }
            error = true;
            this.patternLabel.setForeground(Color.RED);
            this.patternLabel.setToolTipText("Please provide a modification pattern.");
            this.residuesTxt.setToolTipText("Please provide a modification pattern.");
        }
        this.okButton.setEnabled(!error);
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.detailsPanel = new JPanel();
        this.typeCmb = new JComboBox();
        this.jLabel1 = new JLabel();
        this.nameLabel = new JLabel();
        this.nameTxt = new JTextField();
        this.massLabel = new JLabel();
        this.massTxt = new JTextField();
        this.patternLabel = new JLabel();
        this.residuesTxt = new JTextField();
        this.neutralLossesAndReporterIonsPanel = new JPanel();
        this.neutralLossesJScrollPane = new JScrollPane();
        this.neutralLossesTable = new JTable();
        this.addNeutralLoss = new JButton();
        this.removeNeutralLoss = new JButton();
        this.helpJButton = new JButton();
        this.cancelButton = new JButton();
        this.psiModMappingPanel = new JPanel();
        this.psiModMappingJTextField = new JTextField();
        this.olsJButton = new JButton();
        this.jPanel1 = new JPanel();
        this.reporterIonsJScrollPane = new JScrollPane();
        this.reporterIonsTable = new JTable();
        this.removerReporterIon = new JButton();
        this.addReporterIon = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Modification");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.detailsPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.detailsPanel.setOpaque(false);
        this.typeCmb.setMaximumRowCount(15);
        this.typeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Particular Amino Acid", "Protein N-term", "Protein N-term - Particular Amino Acid(s)", "Protein C-term", "Protein C-term - Particular Amino Acid(s)", "Peptide N-term", "Peptide N-term - Particular Amino Acid(s)", "Peptide C-term", "Peptide C-term - Particular Amino Acid(s)"}));
        this.typeCmb.setToolTipText("The modification type. See help for details.");
        this.typeCmb.setEnabled(false);
        this.typeCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.typeCmbActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Type");
        this.jLabel1.setToolTipText("The modification type. See help for details.");
        this.nameLabel.setText("Name");
        this.nameLabel.setToolTipText("The modification name");
        this.nameTxt.setEditable(false);
        this.nameTxt.setHorizontalAlignment(0);
        this.nameTxt.setToolTipText("The modification name");
        this.nameTxt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PtmDialog.this.nameTxtKeyReleased(evt);
            }
        });
        this.massLabel.setText("Mass (Da)");
        this.massLabel.setToolTipText("Monoisotopic mass in Dalton");
        this.massTxt.setEditable(false);
        this.massTxt.setHorizontalAlignment(0);
        this.massTxt.setToolTipText("Monoisotopic mass in Dalton");
        this.massTxt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PtmDialog.this.massTxtKeyReleased(evt);
            }
        });
        this.patternLabel.setText("Pattern");
        this.patternLabel.setToolTipText("Residues modified");
        this.residuesTxt.setEditable(false);
        this.residuesTxt.setHorizontalAlignment(0);
        this.residuesTxt.setToolTipText("Residues modified");
        this.residuesTxt.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PtmDialog.this.residuesTxtMouseReleased(evt);
            }
        });
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(detailsPanelLayout.createSequentialGroup().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nameLabel, -1, 65, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTxt).addComponent(this.typeCmb, 0, 345, Short.MAX_VALUE))).addGroup(detailsPanelLayout.createSequentialGroup().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.patternLabel, -2, 65, -2).addComponent(this.massLabel, -2, 65, -2)).addGap(18, 18, 18).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.residuesTxt, -1, 345, Short.MAX_VALUE).addComponent(this.massTxt)))).addContainerGap(58, Short.MAX_VALUE)));
        detailsPanelLayout.linkSize(0, this.jLabel1, this.massLabel, this.nameLabel, this.patternLabel);
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeCmb).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTxt).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.massTxt).addComponent(this.massLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.residuesTxt, -2, -1, -2).addComponent(this.patternLabel)).addContainerGap()));
        this.neutralLossesAndReporterIonsPanel.setBorder(BorderFactory.createTitledBorder("Neutral Losses"));
        this.neutralLossesAndReporterIonsPanel.setOpaque(false);
        this.neutralLossesTable.setModel(new NeutralLossesTable());
        this.neutralLossesTable.setSelectionMode(0);
        this.neutralLossesTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PtmDialog.this.neutralLossesTableMouseReleased(evt);
            }
        });
        this.neutralLossesJScrollPane.setViewportView(this.neutralLossesTable);
        this.addNeutralLoss.setText("+");
        this.addNeutralLoss.setToolTipText("Add a neutral loss");
        this.addNeutralLoss.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.addNeutralLossActionPerformed(evt);
            }
        });
        this.removeNeutralLoss.setText("-");
        this.removeNeutralLoss.setToolTipText("Remove the selected neutral loss");
        this.removeNeutralLoss.setEnabled(false);
        this.removeNeutralLoss.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.removeNeutralLossActionPerformed(evt);
            }
        });
        GroupLayout neutralLossesAndReporterIonsPanelLayout = new GroupLayout(this.neutralLossesAndReporterIonsPanel);
        this.neutralLossesAndReporterIonsPanel.setLayout(neutralLossesAndReporterIonsPanelLayout);
        neutralLossesAndReporterIonsPanelLayout.setHorizontalGroup(neutralLossesAndReporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(neutralLossesAndReporterIonsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.neutralLossesJScrollPane, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(neutralLossesAndReporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addNeutralLoss, -2, 0, Short.MAX_VALUE).addComponent(this.removeNeutralLoss, -1, 40, Short.MAX_VALUE)).addContainerGap()));
        neutralLossesAndReporterIonsPanelLayout.setVerticalGroup(neutralLossesAndReporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(neutralLossesAndReporterIonsPanelLayout.createSequentialGroup().addContainerGap().addGroup(neutralLossesAndReporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.neutralLossesJScrollPane, -2, 0, Short.MAX_VALUE).addGroup(neutralLossesAndReporterIonsPanelLayout.createSequentialGroup().addComponent(this.addNeutralLoss).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeNeutralLoss).addGap(0, 33, Short.MAX_VALUE))).addContainerGap()));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                PtmDialog.this.helpJButtonMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                PtmDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.psiModMappingPanel.setBorder(BorderFactory.createTitledBorder("PSI-MOD Mapping"));
        this.psiModMappingPanel.setOpaque(false);
        this.psiModMappingJTextField.setEditable(false);
        this.psiModMappingJTextField.setHorizontalAlignment(0);
        this.olsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ols_transparent.GIF")));
        this.olsJButton.setToolTipText("Ontology Lookup Service");
        this.olsJButton.setPreferredSize(new Dimension(61, 23));
        this.olsJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.olsJButtonActionPerformed(evt);
            }
        });
        GroupLayout psiModMappingPanelLayout = new GroupLayout(this.psiModMappingPanel);
        this.psiModMappingPanel.setLayout(psiModMappingPanelLayout);
        psiModMappingPanelLayout.setHorizontalGroup(psiModMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, psiModMappingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psiModMappingJTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.olsJButton, -2, 40, -2).addContainerGap()));
        psiModMappingPanelLayout.setVerticalGroup(psiModMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psiModMappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(psiModMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psiModMappingJTextField, -2, -1, -2).addComponent(this.olsJButton, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Reporter Ions"));
        this.jPanel1.setOpaque(false);
        this.reporterIonsTable.setModel(new ReporterIonsTable());
        this.reporterIonsTable.setSelectionMode(0);
        this.reporterIonsTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PtmDialog.this.reporterIonsTableMouseReleased(evt);
            }
        });
        this.reporterIonsJScrollPane.setViewportView(this.reporterIonsTable);
        this.removerReporterIon.setText("-");
        this.removerReporterIon.setToolTipText("Remove the selected reporter ion");
        this.removerReporterIon.setEnabled(false);
        this.removerReporterIon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.removerReporterIonActionPerformed(evt);
            }
        });
        this.addReporterIon.setText("+");
        this.addReporterIon.setToolTipText("Add a reporter ion");
        this.addReporterIon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.addReporterIonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.reporterIonsJScrollPane, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addReporterIon, -2, 0, Short.MAX_VALUE).addComponent(this.removerReporterIon, -2, 40, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.addReporterIon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removerReporterIon).addGap(0, 33, Short.MAX_VALUE)).addComponent(this.reporterIonsJScrollPane, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.detailsPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.neutralLossesAndReporterIonsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.psiModMappingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.detailsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.neutralLossesAndReporterIonsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psiModMappingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        backgroundPanelLayout.linkSize(1, this.jPanel1, this.neutralLossesAndReporterIonsPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            PTM newPTM = new PTM(this.typeCmb.getSelectedIndex(), this.nameTxt.getText().trim().toLowerCase(), (double)new Double(this.massTxt.getText().trim()), this.pattern);
            ArrayList<NeutralLoss> tempNeutralLosses = new ArrayList<NeutralLoss>();
            for (int row = 0; row < this.neutralLossesTable.getRowCount(); ++row) {
                tempNeutralLosses.add(new NeutralLoss((String)this.neutralLossesTable.getValueAt(row, 1), (Double)this.neutralLossesTable.getValueAt(row, 2), (Boolean)this.neutralLossesTable.getValueAt(row, 3)));
            }
            newPTM.setNeutralLosses(tempNeutralLosses);
            ArrayList<ReporterIon> tempReporterIons = new ArrayList<ReporterIon>();
            for (int row = 0; row < this.reporterIonsTable.getRowCount(); ++row) {
                tempReporterIons.add(new ReporterIon((String)this.reporterIonsTable.getValueAt(row, 1), (Double)this.reporterIonsTable.getValueAt(row, 2)));
            }
            newPTM.setReporterIons(tempReporterIons);
            for (String ptm : this.ptmFactory.getPTMs()) {
                int outcome;
                PTM otherPTM;
                if (this.currentPtm != null && ptm.equals(this.currentPtm.getName()) || !newPTM.isSameAs(otherPTM = this.ptmFactory.getPTM(ptm)) || (outcome = JOptionPane.showConfirmDialog(this, "The modification '" + ptm + "' presents characteristics similar to your input.\n" + "Are you sure you want to create this new modification?", "Modification Already Exists", 0)) != 1) continue;
                return;
            }
            if (this.editable) {
                this.ptmFactory.addUserPTM(newPTM);
            }
            if (this.cvTerm != null) {
                this.cvTerm.setValue(this.massTxt.getText());
            }
            this.ptmToPrideMap.putCVTerm(newPTM.getName(), this.cvTerm);
            this.ptmDialogParent.updateModifications();
            this.saveChanges();
            this.dispose();
        }
    }

    private void typeCmbActionPerformed(ActionEvent evt) {
        if (this.typeCmb.getSelectedIndex() == 0 || this.typeCmb.getSelectedIndex() == 2 || this.typeCmb.getSelectedIndex() == 4 || this.typeCmb.getSelectedIndex() == 6 || this.typeCmb.getSelectedIndex() == 8) {
            this.residuesTxt.setEnabled(true);
        } else {
            this.residuesTxt.setEnabled(false);
        }
    }

    private void olsJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        String searchTerm = null;
        String ontology = "MOD";
        if (this.psiModMappingJTextField.getText().length() > 0) {
            searchTerm = this.psiModMappingJTextField.getText();
            ontology = searchTerm.substring(searchTerm.lastIndexOf("[") + 1, searchTerm.lastIndexOf("]") - 1);
            searchTerm = this.psiModMappingJTextField.getText().substring(0, this.psiModMappingJTextField.getText().lastIndexOf("[") - 1);
            searchTerm = searchTerm.replaceAll("-", " ");
            searchTerm = searchTerm.replaceAll(":", " ");
            searchTerm = searchTerm.replaceAll("\\(", " ");
            searchTerm = searchTerm.replaceAll("\\)", " ");
            searchTerm = searchTerm.replaceAll("&", " ");
            searchTerm = searchTerm.replaceAll("\\+", " ");
            searchTerm = searchTerm.replaceAll("\\[", " ");
            searchTerm = searchTerm.replaceAll("\\]", " ");
        }
        new OLSDialog((JDialog)this, (OLSInputable)this, true, "mod", ontology, searchTerm);
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/PtmDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), null, "Modification Help");
        this.setCursor(new Cursor(0));
    }

    private void addNeutralLossActionPerformed(ActionEvent evt) {
        this.neutralLosses.add(new NeutralLoss("new neutral loss", 0.0, false));
        this.updateTables();
    }

    private void addReporterIonActionPerformed(ActionEvent evt) {
        this.reporterIons.add(new ReporterIon("New reporter ion", 0.0));
        this.updateTables();
    }

    private void removeNeutralLossActionPerformed(ActionEvent evt) {
        int row = this.neutralLossesTable.getSelectedRow();
        if (row != -1) {
            int index = this.neutralLossesTable.convertRowIndexToModel(row);
            this.neutralLosses.remove(index);
            this.updateTables();
        }
        this.removeNeutralLoss.setEnabled((row = this.neutralLossesTable.getSelectedRow()) != -1);
    }

    private void removerReporterIonActionPerformed(ActionEvent evt) {
        int row = this.reporterIonsTable.getSelectedRow();
        if (row != -1) {
            int index = this.reporterIonsTable.convertRowIndexToModel(row);
            this.reporterIons.remove(index);
            this.updateTables();
        }
        this.removerReporterIon.setEnabled((row = this.reporterIonsTable.getSelectedRow()) != -1);
    }

    private void neutralLossesTableMouseReleased(MouseEvent evt) {
        int row = this.neutralLossesTable.getSelectedRow();
        this.removeNeutralLoss.setEnabled(row != -1);
    }

    private void reporterIonsTableMouseReleased(MouseEvent evt) {
        int row = this.reporterIonsTable.getSelectedRow();
        this.removerReporterIon.setEnabled(row != -1);
    }

    private void residuesTxtMouseReleased(MouseEvent evt) {
        AminoAcidPatternDialog dialog;
        if (evt.getButton() == 1 && !(dialog = new AminoAcidPatternDialog(null, this.pattern, this.editable)).isCanceled()) {
            this.pattern = dialog.getPattern();
            this.residuesTxt.setText(this.pattern.toString());
            this.validateInput(false);
        }
    }

    private void nameTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void massTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public void insertOLSResult(String field, String selectedValue, String accession, String ontologyShort, String ontologyLong, int modifiedRow, String mappedTerm, Map<String, String> metadata) {
        Double monoMass;
        block6: {
            monoMass = null;
            try {
                QueryServiceLocator locator = new QueryServiceLocator();
                Query olsConnection = locator.getOntologyQuery();
                HashMap metaData = olsConnection.getTermMetadata(accession, ontologyShort);
                String monoMassAsString = (String)metaData.get("DiffMono");
                if (monoMassAsString != null) {
                    monoMass = (double)new Double(monoMassAsString);
                    try {
                        double userMass = new Double(this.massTxt.getText());
                        if (monoMass != userMass) {
                            JOptionPane.showMessageDialog(this, "The modification mass has been updated.", "Modification Mass", 1);
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    this.massTxt.setText(monoMassAsString);
                    break block6;
                }
                JOptionPane.showMessageDialog(this, "The modification selected has no mass. Using user defined mass.", "Modification Mass", 2);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Error connecting to the OLS.", "OLS Connection Error", 0);
                ex.printStackTrace();
            }
        }
        this.cvTerm = monoMass != null ? new CvTerm(ontologyShort, accession, selectedValue, monoMass.toString()) : new CvTerm(ontologyShort, accession, selectedValue, monoMass.toString());
        this.updateModMappingText();
    }

    public Window getWindow() {
        return this;
    }

    private void updateModMappingText() {
        this.psiModMappingJTextField.setText(this.cvTerm.getName() + " [" + this.cvTerm.getAccession() + "]");
        this.psiModMappingJTextField.setCaretPosition(0);
    }

    private void updateTables() {
        ((DefaultTableModel)this.neutralLossesTable.getModel()).fireTableDataChanged();
        ((DefaultTableModel)this.reporterIonsTable.getModel()).fireTableDataChanged();
    }

    private void saveChanges() {
        try {
            this.ptmFactory.saveFactory();
            PrideObjectsFactory prideObjectsFactory = PrideObjectsFactory.getInstance();
            prideObjectsFactory.setPtmToPrideMap(this.ptmToPrideMap);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the modification.", "Saving Error", 2);
        }
        catch (ClassNotFoundException ce) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the modification.", "Saving Error", 2);
        }
    }

    private class ReporterIonsTable
    extends DefaultTableModel {
        private ReporterIonsTable() {
        }

        public int getRowCount() {
            return PtmDialog.this.reporterIons.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Mass";
                }
            }
            return "";
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ((ReporterIon)PtmDialog.this.reporterIons.get(row)).getName();
                }
                case 2: {
                    return ((ReporterIon)PtmDialog.this.reporterIons.get(row)).getTheoreticMass();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public void setValueAt(Object aValue, int row, int column) {
            int index = PtmDialog.this.reporterIonsTable.convertColumnIndexToModel(row);
            ReporterIon reporterIon = (ReporterIon)PtmDialog.this.reporterIons.get(index);
            if (column == 1) {
                reporterIon.setName((String)aValue);
            } else if (column == 2) {
                reporterIon.setMass((Double)aValue);
            }
        }
    }

    private class NeutralLossesTable
    extends DefaultTableModel {
        private NeutralLossesTable() {
        }

        public int getRowCount() {
            return PtmDialog.this.neutralLosses.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Mass";
                }
                case 3: {
                    return "Fixed";
                }
            }
            return "";
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ((NeutralLoss)((PtmDialog)PtmDialog.this).neutralLosses.get((int)row)).name;
                }
                case 2: {
                    return ((NeutralLoss)((PtmDialog)PtmDialog.this).neutralLosses.get((int)row)).mass;
                }
                case 3: {
                    return ((NeutralLoss)PtmDialog.this.neutralLosses.get(row)).isFixed();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public void setValueAt(Object aValue, int row, int column) {
            int index = PtmDialog.this.neutralLossesTable.convertColumnIndexToModel(row);
            NeutralLoss neutralLoss = (NeutralLoss)PtmDialog.this.neutralLosses.get(index);
            if (column == 1) {
                neutralLoss.name = (String)aValue;
            } else if (column == 2) {
                neutralLoss.mass = (Double)aValue;
            } else if (column == 3) {
                neutralLoss.setFixed((Boolean)aValue);
            }
        }
    }
}

