/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.renderers;

import com.compomics.util.gui.spectrum.GraphicsPanel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class GraphicsPanelTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private double minXAxisValue;
    private double maxXAxisValue;
    private TableCellRenderer delegate = new DefaultTableCellRenderer();

    public GraphicsPanelTableCellRenderer(double minXAxisValue, double maxXAxisValue) {
        this.minXAxisValue = minXAxisValue;
        this.maxXAxisValue = maxXAxisValue;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        GraphicsPanel graphicsPanel = (GraphicsPanel)value;
        graphicsPanel.setMaxPadding(2);
        graphicsPanel.setMiniature(true);
        graphicsPanel.rescale(this.minXAxisValue, this.maxXAxisValue, true);
        if (isSelected) {
            graphicsPanel.setBackground(c.getBackground());
        } else {
            graphicsPanel.setBackground(Color.WHITE);
        }
        if (hasFocus) {
            graphicsPanel.setBorder(c.getBorder());
        } else {
            graphicsPanel.setBorder(null);
        }
        return graphicsPanel;
    }
}

