/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.gui.renderers.AlignedTableCellRenderer;
import com.compomics.util.gui.renderers.FragmentIonTableCellRenderer;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesErrorBarChartTableCellRenderer;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentIonTable
extends JTable {
    private ArrayList<Integer> currentFragmentIonTypes;
    private NeutralLossesMap neutralLosses;
    private boolean singleCharge;
    private boolean twoCharges;
    private ArrayList<String> tooltips = new ArrayList();
    private Peptide currentPeptide;
    private String peptideSequence;
    private ArrayList<ArrayList<IonMatch>> allAnnotations;
    private ArrayList<MSnSpectrum> allSpectra;

    public FragmentIonTable(Peptide currentPeptide, ArrayList<ArrayList<IonMatch>> allAnnotations, ArrayList<Integer> currentFragmentIonTypes, NeutralLossesMap neutralLosses, boolean singleCharge, boolean twoCharges) {
        this.currentPeptide = currentPeptide;
        this.currentFragmentIonTypes = currentFragmentIonTypes;
        this.neutralLosses = neutralLosses;
        this.singleCharge = singleCharge;
        this.twoCharges = twoCharges;
        this.allAnnotations = allAnnotations;
        this.peptideSequence = currentPeptide.getSequence();
        this.setUpTable(Double.class);
        this.addPeptideSequenceAndIndexes();
        this.insertMzValues();
    }

    public FragmentIonTable(Peptide currentPeptide, ArrayList<ArrayList<IonMatch>> allAnnotations, ArrayList<MSnSpectrum> allSpectra, ArrayList<Integer> currentFragmentIonTypes, NeutralLossesMap neutralLosses, boolean singleCharge, boolean twoCharges) {
        this.currentPeptide = currentPeptide;
        this.currentFragmentIonTypes = currentFragmentIonTypes;
        this.neutralLosses = neutralLosses;
        this.singleCharge = singleCharge;
        this.twoCharges = twoCharges;
        this.allAnnotations = allAnnotations;
        this.allSpectra = allSpectra;
        this.peptideSequence = currentPeptide.getSequence();
        if (allAnnotations.size() == 1) {
            this.setUpTable(Double.class);
        } else {
            this.setUpTable(DefaultStatisticalCategoryDataset.class);
        }
        this.addPeptideSequenceAndIndexes();
        this.insertBarCharts();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return (String)FragmentIonTable.this.tooltips.get(realIndex);
            }
        };
    }

    private void setUpTable(Class valueClass) {
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(2);
        TableCellRenderer renderer = this.getTableHeader().getDefaultRenderer();
        JLabel label = (JLabel)((Object)renderer);
        label.setHorizontalAlignment(0);
        Vector<String> columnHeaders = new Vector<String>();
        ArrayList<Class<Integer>> tempColumnTypes = new ArrayList<Class<Integer>>();
        this.tooltips = new ArrayList();
        columnHeaders.add(" ");
        tempColumnTypes.add(Integer.class);
        this.tooltips.add("a, b and c ion index");
        if (this.currentFragmentIonTypes.contains(0)) {
            columnHeaders.add("a");
            tempColumnTypes.add(valueClass);
            this.tooltips.add("a-ion");
        }
        if (this.currentFragmentIonTypes.contains(1)) {
            if (this.singleCharge) {
                columnHeaders.add("b");
                tempColumnTypes.add(valueClass);
                this.tooltips.add("b-ion");
            }
            if (this.twoCharges) {
                columnHeaders.add("b++");
                tempColumnTypes.add(valueClass);
                this.tooltips.add("b-ion doubly charged");
            }
            if (this.neutralLosses.containsLoss(NeutralLoss.H2O)) {
                if (this.singleCharge) {
                    columnHeaders.add("b-H2O");
                    tempColumnTypes.add(valueClass);
                    this.tooltips.add("b-ion with water loss");
                }
                if (this.twoCharges) {
                    columnHeaders.add("b++-H2O");
                    tempColumnTypes.add(valueClass);
                    this.tooltips.add("b-ion with water loss, doubly charged");
                }
            }
            if (this.neutralLosses.containsLoss(NeutralLoss.NH3)) {
                if (this.singleCharge) {
                    columnHeaders.add("b-NH3");
                    tempColumnTypes.add(valueClass);
                    this.tooltips.add("b-ion with ammonia loss");
                }
                if (this.twoCharges) {
                    columnHeaders.add("b++-NH3");
                    tempColumnTypes.add(valueClass);
                    this.tooltips.add("b-ion with ammonia loss, doubly charged");
                }
            }
        }
        if (this.currentFragmentIonTypes.contains(2)) {
            columnHeaders.add("c");
            tempColumnTypes.add(valueClass);
            this.tooltips.add("c-ion");
        }
        columnHeaders.add("AA");
        tempColumnTypes.add(String.class);
        this.tooltips.add("amino acid sequence");
        if (this.currentFragmentIonTypes.contains(5)) {
            columnHeaders.add("z");
            tempColumnTypes.add(valueClass);
            this.tooltips.add("z-ion");
        }
        if (this.currentFragmentIonTypes.contains(4)) {
            if (this.singleCharge) {
                columnHeaders.add("y");
                tempColumnTypes.add(valueClass);
                this.tooltips.add("y-ion");
            }
            if (this.twoCharges) {
                columnHeaders.add("y++");
                tempColumnTypes.add(valueClass);
                this.tooltips.add("y-ion, doubly charged");
            }
            if (this.neutralLosses.containsLoss(NeutralLoss.H2O)) {
                if (this.singleCharge) {
                    columnHeaders.add("y-H2O");
                    tempColumnTypes.add(valueClass);
                    this.tooltips.add("y-ion with water loss");
                }
                if (this.twoCharges) {
                    columnHeaders.add("y++-H2O");
                    tempColumnTypes.add(valueClass);
                    this.tooltips.add("y-ion with water loss, doubly charged");
                }
            }
            if (this.neutralLosses.containsLoss(NeutralLoss.NH3)) {
                if (this.singleCharge) {
                    columnHeaders.add("y-NH3");
                    tempColumnTypes.add(valueClass);
                    this.tooltips.add("y-ion with ammonia loss");
                }
                if (this.twoCharges) {
                    columnHeaders.add("y++-NH3");
                    tempColumnTypes.add(valueClass);
                    this.tooltips.add("y-ion with ammonia loss, doubly charged");
                }
            }
        }
        if (this.currentFragmentIonTypes.contains(3)) {
            columnHeaders.add("x");
            tempColumnTypes.add(valueClass);
            this.tooltips.add("x-ion");
        }
        columnHeaders.add("  ");
        tempColumnTypes.add(Integer.class);
        this.tooltips.add("x, y and z ion index");
        final ArrayList<Class<Integer>> columnTypes = tempColumnTypes;
        this.setModel(new DefaultTableModel(new Vector(), columnHeaders){

            public Class getColumnClass(int columnIndex) {
                return (Class)columnTypes.get(columnIndex);
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        int tempWidth = 30;
        this.getColumn(" ").setMaxWidth(tempWidth);
        this.getColumn(" ").setMinWidth(tempWidth);
        this.getColumn("  ").setMaxWidth(tempWidth);
        this.getColumn("  ").setMinWidth(tempWidth);
        this.getColumn("AA").setMaxWidth(tempWidth);
        this.getColumn("AA").setMinWidth(tempWidth);
        this.getColumn(" ").setCellRenderer(new AlignedTableCellRenderer(0, Color.LIGHT_GRAY));
        this.getColumn("  ").setCellRenderer(new AlignedTableCellRenderer(0, Color.LIGHT_GRAY));
        this.getColumn("AA").setCellRenderer(new AlignedTableCellRenderer(0, Color.LIGHT_GRAY));
    }

    private void addPeptideSequenceAndIndexes() {
        int i;
        for (i = 0; i < this.peptideSequence.length(); ++i) {
            ((DefaultTableModel)this.getModel()).addRow(new Object[]{i + 1});
        }
        for (i = 0; i < this.peptideSequence.length(); ++i) {
            this.setValueAt(Character.valueOf(this.peptideSequence.charAt(i)), i, this.getColumn("AA").getModelIndex());
            this.setValueAt(this.peptideSequence.length() - i, i, this.getColumn("  ").getModelIndex());
        }
    }

    private void insertMzValues() {
        IonFactory fragmentFactory = IonFactory.getInstance();
        ArrayList<Ion> fragmentIons = fragmentFactory.getFragmentIons(this.currentPeptide);
        for (Ion ion : fragmentIons) {
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || !ion.getNeutralLosses().isEmpty()) continue;
            PeptideFragmentIon fragmention = (PeptideFragmentIon)ion;
            double fragmentMzChargeOne = (ion.getTheoreticMass() + 1.0 * ElementaryIon.proton.getTheoreticMass()) / 1.0;
            double fragmentMzChargeTwo = (ion.getTheoreticMass() + 2.0 * ElementaryIon.proton.getTheoreticMass()) / 2.0;
            int fragmentNumber = fragmention.getNumber();
            if (!this.currentFragmentIonTypes.contains(fragmention.getSubType())) continue;
            if (fragmention.getSubType() == 0) {
                if (!this.singleCharge) continue;
                this.setValueAt(fragmentMzChargeOne, fragmentNumber - 1, this.getColumn("a").getModelIndex());
                continue;
            }
            if (fragmention.getSubType() == 1) {
                if (this.singleCharge) {
                    this.setValueAt(fragmentMzChargeOne, fragmentNumber - 1, this.getColumn("b").getModelIndex());
                }
                if (this.twoCharges) {
                    this.setValueAt(fragmentMzChargeTwo, fragmentNumber - 1, this.getColumn("b++").getModelIndex());
                }
                if (this.neutralLosses.containsLoss(NeutralLoss.H2O)) {
                    if (this.singleCharge) {
                        this.setValueAt(fragmentMzChargeOne, fragmentNumber - 1, this.getColumn("b-H2O").getModelIndex());
                    }
                    if (this.twoCharges) {
                        this.setValueAt(fragmentMzChargeTwo, fragmentNumber - 1, this.getColumn("b++-H2O").getModelIndex());
                    }
                }
                if (!this.neutralLosses.containsLoss(NeutralLoss.NH3)) continue;
                if (this.singleCharge) {
                    this.setValueAt(fragmentMzChargeOne, fragmentNumber - 1, this.getColumn("b-NH3").getModelIndex());
                }
                if (!this.twoCharges) continue;
                this.setValueAt(fragmentMzChargeTwo, fragmentNumber - 1, this.getColumn("b++-NH3").getModelIndex());
                continue;
            }
            if (fragmention.getSubType() == 2) {
                if (!this.singleCharge) continue;
                this.setValueAt(fragmentMzChargeOne, fragmentNumber - 1, this.getColumn("c").getModelIndex());
                continue;
            }
            if (fragmention.getSubType() == 4) {
                if (this.singleCharge) {
                    this.setValueAt(fragmentMzChargeOne, this.peptideSequence.length() - fragmentNumber, this.getColumn("y").getModelIndex());
                }
                if (this.twoCharges) {
                    this.setValueAt(fragmentMzChargeTwo, this.peptideSequence.length() - fragmentNumber, this.getColumn("y++").getModelIndex());
                }
                if (this.neutralLosses.containsLoss(NeutralLoss.H2O)) {
                    if (this.singleCharge) {
                        this.setValueAt(fragmentMzChargeOne, this.peptideSequence.length() - fragmentNumber, this.getColumn("y-H2O").getModelIndex());
                    }
                    if (this.twoCharges) {
                        this.setValueAt(fragmentMzChargeTwo, this.peptideSequence.length() - fragmentNumber, this.getColumn("y++-H2O").getModelIndex());
                    }
                }
                if (!this.neutralLosses.containsLoss(NeutralLoss.NH3)) continue;
                if (this.singleCharge) {
                    this.setValueAt(fragmentMzChargeOne, this.peptideSequence.length() - fragmentNumber, this.getColumn("y-NH3").getModelIndex());
                }
                if (!this.twoCharges) continue;
                this.setValueAt(fragmentMzChargeTwo, this.peptideSequence.length() - fragmentNumber, this.getColumn("y++-NH3").getModelIndex());
                continue;
            }
            if (fragmention.getSubType() == 3) {
                if (!this.singleCharge) continue;
                this.setValueAt(fragmentMzChargeOne, this.peptideSequence.length() - fragmentNumber, this.getColumn("x").getModelIndex());
                continue;
            }
            if (fragmention.getSubType() != 5 || !this.singleCharge) continue;
            this.setValueAt(fragmentMzChargeOne, this.peptideSequence.length() - fragmentNumber, this.getColumn("z").getModelIndex());
        }
        ArrayList<Integer> aIonsSinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> bIonsSinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> bIonsDoublyCharged = new ArrayList<Integer>();
        ArrayList<Integer> bIonsH2OSinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> bIonsH2ODoublyCharged = new ArrayList<Integer>();
        ArrayList<Integer> bIonsNH3SinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> bIonsNH3DoublyCharged = new ArrayList<Integer>();
        ArrayList<Integer> cIonsSinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> yIonsSinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> yIonsDoublyCharged = new ArrayList<Integer>();
        ArrayList<Integer> yIonsH2OSinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> yIonsH2ODoublyCharged = new ArrayList<Integer>();
        ArrayList<Integer> yIonsNH3SinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> yIonsNH3DoublyCharged = new ArrayList<Integer>();
        ArrayList<Integer> xIonsSinglyCharged = new ArrayList<Integer>();
        ArrayList<Integer> zIonsSinglyCharged = new ArrayList<Integer>();
        for (int i = 0; i < this.allAnnotations.size(); ++i) {
            ArrayList<IonMatch> currentAnnotations = this.allAnnotations.get(i);
            for (IonMatch ionMatch : currentAnnotations) {
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                int currentCharge = ionMatch.charge.value;
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ionMatch.ion;
                int fragmentNumber = fragmentIon.getNumber();
                if (!this.currentFragmentIonTypes.contains(fragmentIon.getSubType())) continue;
                if (fragmentIon.getSubType() == 0) {
                    if (currentCharge != 1 || !this.singleCharge) continue;
                    aIonsSinglyCharged.add(fragmentNumber - 1);
                    continue;
                }
                if (fragmentIon.getSubType() == 1) {
                    if (fragmentIon.getNeutralLosses().isEmpty()) {
                        if (currentCharge == 1 && this.singleCharge) {
                            bIonsSinglyCharged.add(fragmentNumber - 1);
                            continue;
                        }
                        if (!this.twoCharges) continue;
                        bIonsDoublyCharged.add(fragmentNumber - 1);
                        continue;
                    }
                    if (fragmentIon.getNeutralLossesAsString().equalsIgnoreCase("-H20") && this.neutralLosses.containsLoss(NeutralLoss.H2O)) {
                        if (currentCharge == 1 && this.singleCharge) {
                            bIonsH2OSinglyCharged.add(fragmentNumber - 1);
                            continue;
                        }
                        if (!this.twoCharges) continue;
                        bIonsH2ODoublyCharged.add(fragmentNumber - 1);
                        continue;
                    }
                    if (!fragmentIon.getNeutralLossesAsString().equalsIgnoreCase("-NH3") || !this.neutralLosses.containsLoss(NeutralLoss.NH3)) continue;
                    if (currentCharge == 1 && this.singleCharge) {
                        bIonsNH3SinglyCharged.add(fragmentNumber - 1);
                        continue;
                    }
                    if (!this.twoCharges) continue;
                    bIonsNH3DoublyCharged.add(fragmentNumber - 1);
                    continue;
                }
                if (fragmentIon.getSubType() == 2) {
                    if (currentCharge != 1 || !this.singleCharge) continue;
                    cIonsSinglyCharged.add(fragmentNumber - 1);
                    continue;
                }
                if (fragmentIon.getSubType() == 4) {
                    if (fragmentIon.getNeutralLosses().isEmpty()) {
                        if (currentCharge == 1 && this.singleCharge) {
                            yIonsSinglyCharged.add(this.peptideSequence.length() - fragmentNumber);
                            continue;
                        }
                        if (!this.twoCharges) continue;
                        yIonsDoublyCharged.add(this.peptideSequence.length() - fragmentNumber);
                        continue;
                    }
                    if (fragmentIon.getNeutralLossesAsString().equalsIgnoreCase("-H20") && this.neutralLosses.containsLoss(NeutralLoss.H2O)) {
                        if (currentCharge == 1 && this.singleCharge) {
                            yIonsH2OSinglyCharged.add(this.peptideSequence.length() - fragmentNumber);
                            continue;
                        }
                        if (!this.twoCharges) continue;
                        yIonsH2ODoublyCharged.add(this.peptideSequence.length() - fragmentNumber);
                        continue;
                    }
                    if (!fragmentIon.getNeutralLossesAsString().equalsIgnoreCase("-NH3") || !this.neutralLosses.containsLoss(NeutralLoss.NH3)) continue;
                    if (currentCharge == 1 && this.singleCharge) {
                        yIonsNH3SinglyCharged.add(this.peptideSequence.length() - fragmentNumber);
                        continue;
                    }
                    if (!this.twoCharges) continue;
                    yIonsNH3DoublyCharged.add(this.peptideSequence.length() - fragmentNumber);
                    continue;
                }
                if (fragmentIon.getSubType() == 3) {
                    if (currentCharge != 1 || !this.singleCharge) continue;
                    xIonsSinglyCharged.add(this.peptideSequence.length() - fragmentNumber);
                    continue;
                }
                if (fragmentIon.getSubType() != 5 || currentCharge != 1 || !this.singleCharge) continue;
                zIonsSinglyCharged.add(this.peptideSequence.length() - fragmentNumber);
            }
        }
        try {
            this.getColumn("a").setCellRenderer(new FragmentIonTableCellRenderer(aIonsSinglyCharged, Color.BLUE, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("b").setCellRenderer(new FragmentIonTableCellRenderer(bIonsSinglyCharged, Color.BLUE, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("b++").setCellRenderer(new FragmentIonTableCellRenderer(bIonsDoublyCharged, Color.BLUE, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("b-H2O").setCellRenderer(new FragmentIonTableCellRenderer(bIonsH2OSinglyCharged, Color.BLUE, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("b++-H2O").setCellRenderer(new FragmentIonTableCellRenderer(bIonsH2ODoublyCharged, Color.BLUE, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("b-NH3").setCellRenderer(new FragmentIonTableCellRenderer(bIonsNH3SinglyCharged, Color.BLUE, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("b++-NH3").setCellRenderer(new FragmentIonTableCellRenderer(bIonsNH3DoublyCharged, Color.BLUE, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("c").setCellRenderer(new FragmentIonTableCellRenderer(cIonsSinglyCharged, Color.BLUE, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("y").setCellRenderer(new FragmentIonTableCellRenderer(yIonsSinglyCharged, Color.RED, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("y++").setCellRenderer(new FragmentIonTableCellRenderer(yIonsDoublyCharged, Color.RED, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("y-H2O").setCellRenderer(new FragmentIonTableCellRenderer(yIonsH2OSinglyCharged, Color.RED, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("y++-H2O").setCellRenderer(new FragmentIonTableCellRenderer(yIonsH2ODoublyCharged, Color.RED, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("y-NH3").setCellRenderer(new FragmentIonTableCellRenderer(yIonsNH3SinglyCharged, Color.RED, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("y++-NH3").setCellRenderer(new FragmentIonTableCellRenderer(yIonsNH3DoublyCharged, Color.RED, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("x").setCellRenderer(new FragmentIonTableCellRenderer(xIonsSinglyCharged, Color.RED, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getColumn("y").setCellRenderer(new FragmentIonTableCellRenderer(yIonsSinglyCharged, Color.RED, Color.WHITE));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void insertBarCharts() {
        HashMap<String, ArrayList<Double>> values = new HashMap<String, ArrayList<Double>>();
        double maxIntensity = 0.0;
        for (int i = 0; i < this.allAnnotations.size(); ++i) {
            ArrayList<IonMatch> currentAnnotations = this.allAnnotations.get(i);
            double totalIntensity = this.allSpectra.get(i).getTotalIntensity();
            for (IonMatch ionMatch : currentAnnotations) {
                String key;
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                int currentCharge = ionMatch.charge.value;
                double peakIntensity = ionMatch.peak.intensity;
                if (this.allAnnotations.size() > 1) {
                    peakIntensity /= totalIntensity;
                }
                if (maxIntensity < peakIntensity) {
                    maxIntensity = peakIntensity;
                }
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ionMatch.ion;
                int fragmentNumber = fragmentIon.getNumber();
                if (!this.currentFragmentIonTypes.contains(fragmentIon.getSubType())) continue;
                if (fragmentIon.getSubType() == 0) {
                    if (currentCharge != 1 || !this.singleCharge) continue;
                    key = "a_" + (fragmentNumber - 1);
                    this.addValue(values, key, peakIntensity);
                    continue;
                }
                if (fragmentIon.getSubType() == 1) {
                    if (fragmentIon.getNeutralLosses().isEmpty()) {
                        if (currentCharge == 1 && this.singleCharge) {
                            key = "b_" + (fragmentNumber - 1);
                            this.addValue(values, key, peakIntensity);
                            continue;
                        }
                        if (!this.twoCharges) continue;
                        key = "b++_" + (fragmentNumber - 1);
                        this.addValue(values, key, peakIntensity);
                        continue;
                    }
                    if (fragmentIon.getNeutralLossesAsString().equalsIgnoreCase("-H20") && this.neutralLosses.containsLoss(NeutralLoss.H2O)) {
                        if (currentCharge == 1 && this.singleCharge) {
                            key = "b-H2O_" + (fragmentNumber - 1);
                            this.addValue(values, key, peakIntensity);
                            continue;
                        }
                        if (!this.twoCharges) continue;
                        key = "b++-H2O_" + (fragmentNumber - 1);
                        this.addValue(values, key, peakIntensity);
                        continue;
                    }
                    if (!fragmentIon.getNeutralLossesAsString().equalsIgnoreCase("-NH3") || !this.neutralLosses.containsLoss(NeutralLoss.NH3)) continue;
                    if (currentCharge == 1 && this.singleCharge) {
                        key = "b-NH3_" + (fragmentNumber - 1);
                        this.addValue(values, key, peakIntensity);
                        continue;
                    }
                    if (!this.twoCharges) continue;
                    key = "b++-NH3_" + (fragmentNumber - 1);
                    this.addValue(values, key, peakIntensity);
                    continue;
                }
                if (fragmentIon.getSubType() == 2) {
                    if (currentCharge != 1 || !this.singleCharge) continue;
                    key = "c_" + (fragmentNumber - 1);
                    this.addValue(values, key, peakIntensity);
                    continue;
                }
                if (fragmentIon.getSubType() == 4) {
                    if (fragmentIon.getNeutralLosses().isEmpty()) {
                        if (currentCharge == 1 && this.singleCharge) {
                            key = "y_" + (this.peptideSequence.length() - fragmentNumber);
                            this.addValue(values, key, peakIntensity);
                            continue;
                        }
                        if (!this.twoCharges) continue;
                        key = "y++_" + (this.peptideSequence.length() - fragmentNumber);
                        this.addValue(values, key, peakIntensity);
                        continue;
                    }
                    if (fragmentIon.getNeutralLossesAsString().equalsIgnoreCase("-H20") && this.neutralLosses.containsLoss(NeutralLoss.H2O)) {
                        if (currentCharge == 1 && this.singleCharge) {
                            key = "y-H2O_" + (this.peptideSequence.length() - fragmentNumber);
                            this.addValue(values, key, peakIntensity);
                            continue;
                        }
                        if (!this.twoCharges) continue;
                        key = "y++-H2O_" + (this.peptideSequence.length() - fragmentNumber);
                        this.addValue(values, key, peakIntensity);
                        continue;
                    }
                    if (!fragmentIon.getNeutralLossesAsString().equalsIgnoreCase("-NH3") || !this.neutralLosses.containsLoss(NeutralLoss.NH3)) continue;
                    if (currentCharge == 1 && this.singleCharge) {
                        key = "y-NH3_" + (this.peptideSequence.length() - fragmentNumber);
                        this.addValue(values, key, peakIntensity);
                        continue;
                    }
                    if (!this.twoCharges) continue;
                    key = "y++-NH3_" + (this.peptideSequence.length() - fragmentNumber);
                    this.addValue(values, key, peakIntensity);
                    continue;
                }
                if (fragmentIon.getSubType() == 3) {
                    if (currentCharge != 1 || !this.singleCharge) continue;
                    key = "x_" + (this.peptideSequence.length() - fragmentNumber);
                    this.addValue(values, key, peakIntensity);
                    continue;
                }
                if (fragmentIon.getSubType() != 5 || currentCharge != 1 || !this.singleCharge) continue;
                key = "z_" + (this.peptideSequence.length() - fragmentNumber);
                this.addValue(values, key, peakIntensity);
            }
        }
        for (String ionType : values.keySet()) {
            String[] ionTypeSplit = ionType.split("_");
            String ion = ionTypeSplit[0];
            Integer ionNumber = new Integer(ionTypeSplit[1]);
            ArrayList allCurrentIonValues = (ArrayList)values.get(ionType);
            SummaryStatistics stats = new SummaryStatistics();
            for (int i = 0; i < allCurrentIonValues.size(); ++i) {
                stats.addValue(((Double)allCurrentIonValues.get(i)).doubleValue());
            }
            while (stats.getN() < (long)this.allAnnotations.size()) {
                stats.addValue(0.0);
            }
            double meanValue = stats.getMean();
            double standardDeviation = stats.getStandardDeviation();
            if (this.allAnnotations.size() > 1 && meanValue + standardDeviation > maxIntensity) {
                maxIntensity = meanValue + standardDeviation;
            }
            DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
            dataset.add(meanValue, standardDeviation, (Comparable)((Object)ion), (Comparable)ionNumber);
            if (this.allAnnotations.size() > 1) {
                this.setValueAt(dataset, ionNumber, this.getColumn(ion).getModelIndex());
                continue;
            }
            this.setValueAt(meanValue, ionNumber, this.getColumn(ion).getModelIndex());
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("a").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("a")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("a").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("a").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("a")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("a").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("b").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("b").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("b").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("b").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("b++").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b++")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("b++").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("b++").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b++")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("b++").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("b-H2O").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b-H2O")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("b-H2O").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("b-H2O").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b-H2O")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("b-H2O").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("b++-H2O").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b++-H2O")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("b++-H2O").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("b++-H2O").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b++-H2O")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("b++-H2O").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("b-NH3").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b-NH3")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("b-NH3").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("b-NH3").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b-NH3")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("b-NH3").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("b++-NH3").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b++-NH3")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("b++-NH3").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("b++-NH3").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("b++-NH3")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("b++-NH3").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("c").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("c")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("c").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("c").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("c")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("c").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("y").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("y").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("y").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("y").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("y++").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y++")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("y++").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("y++").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y++")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("y++").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("y-H2O").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y-H2O")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("y-H2O").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("y-H2O").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y-H2O")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("y-H2O").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("y++-H2O").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y++-H2O")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("y++-H2O").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("y++-H2O").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y++-H2O")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("y++-H2O").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("y-NH3").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y-NH3")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("y-NH3").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("y-NH3").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y-NH3")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("y-NH3").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("y++-NH3").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y++-NH3")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("y++-NH3").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("y++-NH3").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("y++-NH3")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("y++-NH3").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("x").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("x")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("x").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("x").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("x")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("x").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            if (this.allAnnotations.size() > 1) {
                this.getColumn("z").setCellRenderer((TableCellRenderer)new JSparklinesErrorBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("z")));
                ((JSparklinesErrorBarChartTableCellRenderer)this.getColumn("z").getCellRenderer()).setMinimumChartValue(0.0);
            } else {
                this.getColumn("z").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxIntensity), SpectrumPanel.determineFragmentIonColor("z")));
                ((JSparklinesBarChartTableCellRenderer)this.getColumn("z").getCellRenderer()).setMinimumChartValue(0.0);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void addValue(HashMap<String, ArrayList<Double>> values, String key, Double peakIntensity) {
        if (values.containsKey(key)) {
            values.get(key).add(peakIntensity);
        } else {
            ArrayList<Double> tempArray = new ArrayList<Double>();
            tempArray.add(peakIntensity);
            values.put(key, tempArray);
        }
    }
}

