/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.GraphicsPanel;
import com.compomics.util.gui.spectrum.ReferenceArea;
import com.compomics.util.interfaces.SpectrumFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpectrumPanel
extends GraphicsPanel {
    static Logger logger = Logger.getLogger(SpectrumPanel.class);
    private Color aSpectrumPeakColor = Color.RED;
    private Color aSpectrumProfileModeLineColor = Color.PINK;
    private static HashMap<Ion.IonType, HashMap<Integer, HashMap<String, Color>>> colorMap = new HashMap();

    public SpectrumPanel(SpectrumFile aSpecFile) {
        this(aSpecFile, 0, true);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, boolean aEnableInteraction) {
        this(aSpecFile, 0, aEnableInteraction);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, int aDrawStyle, boolean aEnableInteraction) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, null);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, int aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, aSpectrumFilenameColor, 50, false, true, true);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, int aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor, int aMaxPadding, boolean aShowFileName) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, aSpectrumFilenameColor, aMaxPadding, aShowFileName, true, true);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, int aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, aSpectrumFilenameColor, aMaxPadding, aShowFileName, aShowPrecursorDetails, aShowResolution, 0);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, int aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution, int aMSLevel) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, aSpectrumFilenameColor, aMaxPadding, aShowFileName, aShowPrecursorDetails, aShowResolution, aMSLevel, false);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, int aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution, int aMSLevel, boolean aProfileMode) {
        this.iDrawStyle = aDrawStyle;
        this.iSpecPanelListeners = new ArrayList();
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBackground(Color.WHITE);
        if (aSpecFile != null) {
            dataSetCounter = 0;
            this.processSpectrumFile(aSpecFile, this.aSpectrumPeakColor, this.aSpectrumProfileModeLineColor);
        }
        if (aEnableInteraction) {
            this.addListeners();
        }
        this.iFilenameColor = aSpectrumFilenameColor;
        this.maxPadding = aMaxPadding;
        this.showFileName = aShowFileName;
        this.showPrecursorDetails = aShowPrecursorDetails;
        this.showResolution = aShowResolution;
        this.iMSLevel = aMSLevel;
        this.currentGraphicsPanelType = aProfileMode ? GraphicsPanel.GraphicsPanelType.profileSpectrum : GraphicsPanel.GraphicsPanelType.centroidSpectrum;
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, 50, false, true, true);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, boolean aShowFileName) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, 50, aShowFileName, true, true);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, int aMaxPadding, boolean aShowFileName) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, aMaxPadding, aShowFileName, true, true);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, aMaxPadding, aShowFileName, aShowPrecursorDetails, aShowResolution, 0);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution, int aMSLevel) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, aMaxPadding, aShowFileName, aShowPrecursorDetails, aShowResolution, aMSLevel, false);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution, int aMSLevel, boolean aProfileMode) {
        this.iDrawStyle = 0;
        this.iSpecPanelListeners = new ArrayList();
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBackground(Color.WHITE);
        dataSetCounter = 0;
        this.processXAndYData(aXAxisData, aYAxisData, this.aSpectrumPeakColor, this.aSpectrumProfileModeLineColor);
        this.iPrecursorMZ = aPrecursorMZ;
        this.iPrecursorCharge = aPrecursorCharge;
        this.iFilename = aFileName;
        this.maxPadding = aMaxPadding;
        this.showFileName = aShowFileName;
        this.showPrecursorDetails = aShowPrecursorDetails;
        this.showResolution = aShowResolution;
        this.iMSLevel = aMSLevel;
        this.currentGraphicsPanelType = aProfileMode ? GraphicsPanel.GraphicsPanelType.profileSpectrum : GraphicsPanel.GraphicsPanelType.centroidSpectrum;
        this.addListeners();
    }

    public void addAdditionalDataset(double[] aXAxisData, double[] aYAxisData, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        this.processXAndYData(aXAxisData, aYAxisData, dataPointAndLineColor, areaUnderCurveColor);
        this.showFileName = false;
        this.showPrecursorDetails = false;
        this.showResolution = false;
    }

    public void setProfileMode(boolean aProfileMode) {
        this.currentGraphicsPanelType = aProfileMode ? GraphicsPanel.GraphicsPanelType.profileSpectrum : GraphicsPanel.GraphicsPanelType.centroidSpectrum;
    }

    public void showAnnotatedPeaksOnly(boolean aAnnotatedPeaks) {
        this.showAllPeaks = !aAnnotatedPeaks;
    }

    public void setSpectrumFile(SpectrumFile aSpecFile) {
        this.processSpectrumFile(aSpecFile, this.aSpectrumPeakColor, this.aSpectrumProfileModeLineColor);
    }

    private void processSpectrumFile(SpectrumFile aSpecFile, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        if (dataSetCounter == 0) {
            this.iXAxisData = new ArrayList();
            this.iYAxisData = new ArrayList();
        }
        this.iDataPointAndLineColor.add(dataPointAndLineColor);
        this.iAreaUnderCurveColor.add(areaUnderCurveColor);
        HashMap peaks = aSpecFile.getPeaks();
        this.iXAxisData.add(new double[peaks.size()]);
        this.iYAxisData.add(new double[peaks.size()]);
        this.iFilename = aSpecFile.getFilename();
        double maxInt = 0.0;
        TreeSet masses = new TreeSet(peaks.keySet());
        Iterator iter = masses.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Double key = (Double)iter.next();
            double mass = key;
            double intensity = (Double)peaks.get(key);
            if (intensity > maxInt) {
                maxInt = intensity;
            }
            ((double[])this.iXAxisData.get((int)SpectrumPanel.dataSetCounter))[count] = mass;
            ((double[])this.iYAxisData.get((int)SpectrumPanel.dataSetCounter))[count] = intensity;
            ++count;
        }
        if (this.iXAxisStartAtZero) {
            this.rescale(0.0, this.getMaxXAxisValue());
        } else {
            this.rescale(this.getMinXAxisValue(), this.getMaxXAxisValue());
        }
        this.iPrecursorMZ = aSpecFile.getPrecursorMZ();
        int liTemp = aSpecFile.getCharge();
        if (liTemp == 0) {
            this.iPrecursorCharge = "?";
        } else {
            this.iPrecursorCharge = Integer.toString(liTemp);
            this.iPrecursorCharge = this.iPrecursorCharge + (liTemp > 0 ? "+" : "-");
        }
        ++dataSetCounter;
    }

    public static Color determineColorOfPeak(String peakLabel) {
        Color currentColor = Color.GRAY;
        if (peakLabel.startsWith("a")) {
            currentColor = new Color(153, 0, 0);
            if (peakLabel.lastIndexOf("H2O") != -1 || peakLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(171, 161, 255);
            } else if (peakLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(248, 151, 202);
            }
        } else if (peakLabel.startsWith("b")) {
            currentColor = new Color(0, 0, 255);
            if (peakLabel.lastIndexOf("H2O") != -1 || peakLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(0, 125, 200);
            } else if (peakLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(153, 0, 255);
            }
        } else if (peakLabel.startsWith("c")) {
            currentColor = new Color(188, 0, 255);
        } else if (peakLabel.startsWith("x")) {
            currentColor = new Color(78, 200, 0);
        } else if (peakLabel.startsWith("y")) {
            currentColor = new Color(0, 0, 0);
            if (peakLabel.lastIndexOf("H2O") != -1 || peakLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(0, 70, 135);
            } else if (peakLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(155, 0, 155);
            }
        } else if (peakLabel.startsWith("z")) {
            currentColor = new Color(64, 179, 0);
        } else if (peakLabel.startsWith("Prec") || peakLabel.startsWith("MH")) {
            currentColor = Color.gray;
        } else if (peakLabel.startsWith("i")) {
            currentColor = Color.gray;
        }
        return currentColor;
    }

    public static Vector<DefaultSpectrumAnnotation> filterAnnotations(Vector<DefaultSpectrumAnnotation> annotations, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<NeutralLoss> neutralLosses, boolean singleChargeSelected, boolean doubleChargeSelected, boolean moreThanTwoChargesSelected) {
        Vector<DefaultSpectrumAnnotation> filteredAnnotations = new Vector<DefaultSpectrumAnnotation>();
        for (int i = 0; i < annotations.size(); ++i) {
            String currentLabel = annotations.get(i).getLabel();
            boolean useAnnotation = false;
            if (currentLabel.startsWith("a")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(0)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("b")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(1)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("c")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(2)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("x")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(3)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("y")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(4)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("z")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(5)) {
                    useAnnotation = true;
                }
            } else if (iontypes.containsKey((Object)Ion.IonType.IMMONIUM_ION) || iontypes.containsKey((Object)Ion.IonType.PRECURSOR_ION) || iontypes.containsKey((Object)Ion.IonType.IMMONIUM_ION)) {
                useAnnotation = true;
            }
            if (useAnnotation) {
                boolean h2oLossSelected = false;
                boolean nh3LossSelected = false;
                boolean phosphoLossSelected = false;
                boolean moxLossSelected = false;
                for (NeutralLoss neutralLoss : neutralLosses) {
                    if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                        h2oLossSelected = true;
                        continue;
                    }
                    if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                        nh3LossSelected = true;
                        continue;
                    }
                    if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                        phosphoLossSelected = true;
                        continue;
                    }
                    if (!neutralLoss.isSameAs(NeutralLoss.CH4OS)) continue;
                    moxLossSelected = true;
                }
                if (!(currentLabel.lastIndexOf("-H2O") == -1 && currentLabel.lastIndexOf("-H20") == -1 || h2oLossSelected)) {
                    useAnnotation = false;
                }
                if (currentLabel.lastIndexOf("-NH3") != -1 && !nh3LossSelected) {
                    useAnnotation = false;
                }
                if (!(currentLabel.lastIndexOf("-H3PO4") == -1 && currentLabel.lastIndexOf("-HPO3") == -1 || phosphoLossSelected)) {
                    useAnnotation = false;
                }
                if (currentLabel.lastIndexOf("-CH4OS") != -1 && !moxLossSelected) {
                    useAnnotation = false;
                }
            }
            if (useAnnotation) {
                if (currentLabel.lastIndexOf("+") == -1) {
                    if ((currentLabel.startsWith("a") || currentLabel.startsWith("b") || currentLabel.startsWith("c") || currentLabel.startsWith("x") || currentLabel.startsWith("y") || currentLabel.startsWith("z")) && !singleChargeSelected) {
                        useAnnotation = false;
                    }
                } else if (currentLabel.lastIndexOf("+++") != -1) {
                    if (!moreThanTwoChargesSelected) {
                        useAnnotation = false;
                    }
                } else if (currentLabel.lastIndexOf("++") != -1 && !doubleChargeSelected) {
                    useAnnotation = false;
                }
            }
            if (!useAnnotation) continue;
            filteredAnnotations.add(annotations.get(i));
        }
        return filteredAnnotations;
    }

    public static void setIonColor(Ion ion, Color color) {
        if (!colorMap.containsKey((Object)ion.getType())) {
            colorMap.put(ion.getType(), new HashMap());
        }
        if (!colorMap.get((Object)ion.getType()).containsKey(ion.getSubType())) {
            colorMap.get((Object)ion.getType()).put(ion.getSubType(), new HashMap());
        }
        colorMap.get((Object)ion.getType()).get(ion.getSubType()).put(ion.getNeutralLossesAsString(), color);
    }

    public static Color determineFragmentIonColor(Ion ion, boolean isSpectrum) {
        if (colorMap.containsKey((Object)ion.getType()) && colorMap.get((Object)ion.getType()).containsKey(ion.getSubType()) && colorMap.get((Object)ion.getType()).get(ion.getSubType()).containsKey(ion.getNeutralLossesAsString())) {
            return colorMap.get((Object)ion.getType()).get(ion.getSubType()).get(ion.getNeutralLossesAsString());
        }
        return SpectrumPanel.determineDefaultFragmentIonColor(ion, isSpectrum);
    }

    public static Color determineDefaultFragmentIonColor(Ion ion, boolean isSpectrum) {
        switch (ion.getType()) {
            case PEPTIDE_FRAGMENT_ION: {
                switch (ion.getSubType()) {
                    case 0: {
                        if (ion.getNeutralLosses().size() == 1) {
                            NeutralLoss neutralLoss = ion.getNeutralLosses().get(0);
                            if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                return new Color(171, 161, 255);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                return new Color(248, 151, 202);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                return Color.BLACK;
                            }
                        } else if (ion.getNeutralLosses().size() > 1) {
                            return Color.GRAY;
                        }
                        return new Color(153, 0, 0);
                    }
                    case 1: {
                        if (ion.getNeutralLosses().size() == 1) {
                            NeutralLoss neutralLoss = ion.getNeutralLosses().get(0);
                            if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                return new Color(0, 125, 200);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                return new Color(153, 0, 255);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                return Color.BLACK;
                            }
                        } else if (ion.getNeutralLosses().size() > 1) {
                            return Color.GRAY;
                        }
                        return new Color(0, 0, 255);
                    }
                    case 2: {
                        if (ion.getNeutralLosses().size() == 1) {
                            NeutralLoss neutralLoss = ion.getNeutralLosses().get(0);
                            if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                return new Color(188, 150, 255);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                return new Color(255, 0, 255);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                return Color.BLACK;
                            }
                        } else if (ion.getNeutralLosses().size() > 1) {
                            return Color.GRAY;
                        }
                        return new Color(188, 0, 255);
                    }
                    case 3: {
                        if (ion.getNeutralLosses().size() == 1) {
                            NeutralLoss neutralLoss = ion.getNeutralLosses().get(0);
                            if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                return new Color(78, 200, 150);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                return new Color(255, 200, 255);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                return Color.BLACK;
                            }
                        } else if (ion.getNeutralLosses().size() > 1) {
                            return Color.GRAY;
                        }
                        return new Color(78, 200, 0);
                    }
                    case 4: {
                        if (ion.getNeutralLosses().size() == 1) {
                            NeutralLoss neutralLoss = ion.getNeutralLosses().get(0);
                            if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                if (isSpectrum) {
                                    return new Color(0, 70, 135);
                                }
                                return new Color(255, 150, 0);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                if (isSpectrum) {
                                    return new Color(155, 0, 155);
                                }
                                return new Color(255, 0, 150);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                return Color.BLACK;
                            }
                        } else if (ion.getNeutralLosses().size() > 1) {
                            return Color.GRAY;
                        }
                        if (isSpectrum) {
                            return Color.BLACK;
                        }
                        return new Color(255, 0, 0);
                    }
                    case 5: {
                        if (ion.getNeutralLosses().size() == 1) {
                            NeutralLoss neutralLoss = ion.getNeutralLosses().get(0);
                            if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                return new Color(64, 179, 150);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                return new Color(255, 179, 150);
                            }
                            if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                return Color.BLACK;
                            }
                        } else if (ion.getNeutralLosses().size() > 1) {
                            return Color.GRAY;
                        }
                        return new Color(64, 179, 0);
                    }
                }
                return Color.GRAY;
            }
            case PRECURSOR_ION: {
                return Color.GRAY;
            }
            case IMMONIUM_ION: {
                return Color.GRAY;
            }
            case REPORTER_ION: {
                return Color.ORANGE;
            }
        }
        return Color.GRAY;
    }

    public static Color determineFragmentIonColor(String seriesLabel) {
        Color currentColor = Color.GRAY;
        if (seriesLabel.startsWith("a")) {
            currentColor = new Color(153, 0, 0);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(171, 161, 255);
            } else if (seriesLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(248, 151, 202);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed() - 100, currentColor.getGreen(), currentColor.getBlue());
            }
        } else if (seriesLabel.startsWith("b")) {
            currentColor = new Color(0, 0, 255);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(0, 150, 255);
            } else if (seriesLabel.lastIndexOf("NH3") != -1 || seriesLabel.equalsIgnoreCase("b ions - mod.")) {
                currentColor = new Color(150, 0, 255);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue() - 100);
            }
        } else if (seriesLabel.startsWith("c")) {
            currentColor = new Color(188, 0, 255);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(188, 150, 255);
            } else if (seriesLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(255, 0, 255);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue() - 100);
            }
        } else if (seriesLabel.startsWith("x")) {
            currentColor = new Color(78, 200, 0);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(78, 200, 150);
            } else if (seriesLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(255, 200, 255);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed(), currentColor.getGreen() - 100, currentColor.getBlue());
            }
        } else if (seriesLabel.startsWith("y")) {
            currentColor = new Color(255, 0, 0);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(255, 150, 0);
            } else if (seriesLabel.lastIndexOf("NH3") != -1 || seriesLabel.equalsIgnoreCase("y ions - mod.")) {
                currentColor = new Color(255, 0, 150);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed() - 100, currentColor.getGreen(), currentColor.getBlue());
            }
        } else if (seriesLabel.startsWith("z")) {
            currentColor = new Color(64, 179, 0);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(64, 179, 150);
            } else if (seriesLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(255, 179, 150);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed(), currentColor.getGreen() - 100, currentColor.getBlue());
            }
        }
        return currentColor;
    }

    public void addAutomaticDeNovoSequencing(Peptide currentPeptide, ArrayList<IonMatch> annotations, int aForwardIon, int aReverseIon, int aDeNovoCharge, boolean showForwardTags, boolean showReverseTags) {
        String mod;
        Color annotationColor;
        int forwardIon = aForwardIon;
        int reverseIon = aReverseIon;
        int deNovoCharge = aDeNovoCharge;
        IonMatch[] forwardIons = new IonMatch[currentPeptide.getSequence().length()];
        IonMatch[] reverseIons = new IonMatch[currentPeptide.getSequence().length()];
        for (int i = 0; i < annotations.size(); ++i) {
            IonMatch tempMatch = annotations.get(i);
            if (tempMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || !tempMatch.ion.getNeutralLosses().isEmpty() || tempMatch.charge.value != deNovoCharge) continue;
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)tempMatch.ion;
            if (fragmentIon.getSubType() == forwardIon) {
                forwardIons[fragmentIon.getNumber() - 1] = tempMatch;
                continue;
            }
            if (fragmentIon.getSubType() != reverseIon) continue;
            reverseIons[fragmentIon.getNumber() - 1] = tempMatch;
        }
        ArrayList<Integer> modifiedIndexes = currentPeptide.getModifiedIndexes();
        if (showReverseTags) {
            annotationColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, reverseIon), false);
            for (int i = 1; i < reverseIons.length; ++i) {
                if (reverseIons[i] == null || reverseIons[i - 1] == null) continue;
                mod = "";
                if (modifiedIndexes.contains(currentPeptide.getSequence().length() - i)) {
                    mod = "*";
                }
                this.addReferenceAreaXAxis(new ReferenceArea("r" + i, currentPeptide.getSequence().substring(currentPeptide.getSequence().length() - i - 1, currentPeptide.getSequence().length() - i) + mod, reverseIons[i - 1].peak.mz, reverseIons[i].peak.mz, annotationColor, 0.2f, false, true, annotationColor, true, Color.lightGray, 0.2f, 1.0));
            }
        }
        if (showForwardTags) {
            annotationColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, forwardIon), false);
            for (int i = 1; i < forwardIons.length; ++i) {
                if (forwardIons[i] == null || forwardIons[i - 1] == null) continue;
                mod = "";
                if (modifiedIndexes.contains(i + 1)) {
                    mod = "*";
                }
                this.addReferenceAreaXAxis(new ReferenceArea("f" + i, currentPeptide.getSequence().substring(i, i + 1) + mod, forwardIons[i - 1].peak.mz, forwardIons[i].peak.mz, annotationColor, 0.2f, false, true, annotationColor, true, Color.lightGray, 0.2f, 0.9));
            }
        }
    }
}

