/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DateChooser
extends JDialog {
    static Logger logger = Logger.getLogger(DateChooser.class);
    private Calendar iSelectedCalendar = null;
    private Calendar iShownCalendar = null;
    private int iSelectedDayIndex = -1;
    private static final String iCoreTitle = "Date chooser";
    private JLabel[] lblDayNames = new JLabel[]{new JLabel("Sun"), new JLabel("Mon"), new JLabel("Tue"), new JLabel("Wed"), new JLabel("Thur"), new JLabel("Fri"), new JLabel("Sat")};
    private JLabel[] lblDays = new JLabel[42];
    private Integer[] iDays = new Integer[42];
    private JLabel lblCurrentMonthYear = new JLabel("");
    private static final SimpleDateFormat iSDFCurrentMonthyear = new SimpleDateFormat("MMMM yyyy");

    public DateChooser(JFrame aParent) {
        this(aParent, null);
    }

    public DateChooser(JFrame aParent, Calendar aSelectedCalendar) {
        super((Frame)aParent, iCoreTitle);
        this.iSelectedCalendar = aSelectedCalendar;
        this.iShownCalendar = this.iSelectedCalendar == null ? Calendar.getInstance() : (Calendar)this.iSelectedCalendar.clone();
        this.setModal(true);
        this.createScreen();
        this.initDates();
    }

    public Calendar getSelectedDate() {
        Calendar result = null;
        if (this.iSelectedCalendar != null) {
            result = this.iSelectedCalendar;
        }
        return result;
    }

    private void createScreen() {
        JPanel jpanDate = new JPanel(new GridLayout(7, 7));
        for (int i = 0; i < this.lblDayNames.length; ++i) {
            this.lblDayNames[i].setHorizontalAlignment(4);
            this.lblDayNames[i].setFont(this.lblDayNames[i].getFont().deriveFont(1));
            this.setColour(i, this.lblDayNames[i]);
            jpanDate.add(this.lblDayNames[i]);
        }
        jpanDate.setMinimumSize(new Dimension(jpanDate.getPreferredSize().width, jpanDate.getPreferredSize().height));
        int dayCounter = 0;
        for (int i = 0; i < this.lblDays.length; ++i) {
            final int counter = i;
            this.lblDays[i] = new JLabel("", 4);
            this.lblDays[i].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    DateChooser.this.dateClicked(counter);
                }

                public void mouseEntered(MouseEvent me) {
                    DateChooser.this.mouseFocus(counter, true);
                }

                public void mouseExited(MouseEvent me) {
                    DateChooser.this.mouseFocus(counter, false);
                }
            });
            this.setColour(dayCounter, this.lblDays[i]);
            jpanDate.add(this.lblDays[i]);
            if (++dayCounter <= 6) continue;
            dayCounter = 0;
        }
        JPanel jpanDateHolder = new JPanel();
        jpanDateHolder.setLayout(new BoxLayout(jpanDateHolder, 0));
        jpanDateHolder.add(jpanDate);
        jpanDateHolder.add(Box.createHorizontalStrut(20));
        JPanel jpanScrollDate = new JPanel();
        jpanScrollDate.setLayout(new BoxLayout(jpanScrollDate, 0));
        JLabel lblPrevious = new JLabel("<< Previous");
        lblPrevious.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                DateChooser.this.iShownCalendar.add(2, -1);
                DateChooser.this.initDates();
            }
        });
        JLabel lblNext = new JLabel("Next >>");
        lblNext.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                DateChooser.this.iShownCalendar.add(2, 1);
                DateChooser.this.initDates();
            }
        });
        jpanScrollDate.add(lblPrevious);
        jpanScrollDate.add(Box.createHorizontalGlue());
        jpanScrollDate.add(this.lblCurrentMonthYear);
        jpanScrollDate.add(Box.createHorizontalGlue());
        jpanScrollDate.add(lblNext);
        JPanel jpanChooser = new JPanel(new BorderLayout());
        jpanChooser.add((Component)jpanDateHolder, "Center");
        jpanChooser.add((Component)jpanScrollDate, "South");
        JPanel jpanButtons = this.getButtonPanel();
        this.getContentPane().add((Component)jpanChooser, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DateChooser.this.close();
            }
        });
        this.pack();
        this.setSize(new Dimension(this.getSize().width + 100, this.getSize().height + 100));
    }

    private void setColour(int aZeroBaseDayIndex, JLabel aLabel) {
        switch (aZeroBaseDayIndex) {
            case 0: {
                aLabel.setForeground(Color.RED);
                break;
            }
            case 6: {
                aLabel.setForeground(Color.BLUE);
            }
        }
    }

    private void mouseFocus(int aLblIndex, boolean aHasFocus) {
        String nbr;
        String string = nbr = this.iDays[aLblIndex] == null ? "" : "" + this.iDays[aLblIndex];
        if (aHasFocus) {
            this.lblDays[aLblIndex].setText("<html><u>" + nbr + "</u></html>");
        } else {
            this.lblDays[aLblIndex].setText(nbr);
        }
    }

    private void initDates() {
        this.iShownCalendar.set(5, 1);
        int dayOfWeek = this.iShownCalendar.get(7);
        int daysInMonth = this.iShownCalendar.getActualMaximum(5);
        int displayDay = 1;
        for (int i = 0; i < this.lblDays.length; ++i) {
            this.lblDays[i].setBorder(BorderFactory.createEmptyBorder());
            int dayNbr = i + 1;
            if (dayNbr < dayOfWeek || displayDay > daysInMonth) {
                this.lblDays[i].setText("");
                this.iDays[i] = null;
                continue;
            }
            if (this.iSelectedCalendar != null && this.iShownCalendar.get(1) == this.iSelectedCalendar.get(1) && this.iShownCalendar.get(2) == this.iSelectedCalendar.get(2) && displayDay == this.iSelectedCalendar.get(5)) {
                this.lblDays[i].setBorder(BorderFactory.createBevelBorder(1));
            }
            this.lblDays[i].setText("" + displayDay);
            this.iDays[i] = new Integer(displayDay);
            ++displayDay;
        }
        String currentMonthYear = iSDFCurrentMonthyear.format(this.iShownCalendar.getTime());
        this.lblCurrentMonthYear.setText(currentMonthYear);
        this.setTitle("Date chooser (" + currentMonthYear + ")");
    }

    private JPanel getButtonPanel() {
        JButton btnOK = new JButton("OK");
        btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooser.this.btnOKPressed();
            }
        });
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooser.this.btnCancelPressed();
            }
        });
        JPanel jpanButtons = new JPanel();
        jpanButtons.setLayout(new BoxLayout(jpanButtons, 0));
        jpanButtons.add(Box.createHorizontalGlue());
        jpanButtons.add(btnCancel);
        jpanButtons.add(Box.createHorizontalStrut(5));
        jpanButtons.add(btnOK);
        jpanButtons.add(Box.createHorizontalStrut(15));
        return jpanButtons;
    }

    private void btnOKPressed() {
        if (this.iSelectedCalendar != null) {
            this.close();
        } else {
            JOptionPane.showMessageDialog(this, "You have not yet selected a date!", "No date selected!", 2);
        }
    }

    private void btnCancelPressed() {
        this.iSelectedCalendar = null;
        this.close();
    }

    private void dateClicked(int aCounter) {
        this.iSelectedDayIndex = aCounter;
        int currentDay = this.iDays[this.iSelectedDayIndex];
        if (this.iSelectedCalendar == null) {
            this.iSelectedCalendar = Calendar.getInstance();
        }
        this.iSelectedCalendar.set(this.iShownCalendar.get(1), this.iShownCalendar.get(2), currentDay);
        for (int i = 0; i < this.lblDays.length; ++i) {
            if (i == this.iSelectedDayIndex) {
                this.lblDays[i].setBorder(BorderFactory.createBevelBorder(1));
                continue;
            }
            this.lblDays[i].setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        JFrame temp = new JFrame();
        DateChooser dc = new DateChooser(temp);
        dc.setVisible(true);
        Calendar c = dc.getSelectedDate();
        if (c != null) {
            logger.info((Object)("\n\nSelected date was: " + new SimpleDateFormat("dd-MM-yyyy").format(c.getTime()) + "\n\n"));
        } else {
            logger.info((Object)"\n\nNo date selected!\n\n");
        }
        System.exit(0);
    }
}

