/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.waiting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;

public class ProgressDialog
extends JDialog {
    Logger logger = Logger.getLogger(ProgressDialog.class);
    private JProgressBar iProgress = new JProgressBar(0);

    public ProgressDialog(JFrame aParent, String aTitle, String aMessage) {
        super(aParent, aTitle, true);
        this.constructGUI(aMessage);
        this.positionDialog();
    }

    public void setIndeterminate() {
        this.iProgress.setIndeterminate(true);
    }

    public void setDeterminate(int aMin, int aMax) {
        this.iProgress.setMinimum(aMin);
        this.iProgress.setMaximum(aMax);
        this.iProgress.setIndeterminate(false);
        this.iProgress.setValue(aMin);
    }

    public int getMaximumValue() {
        return this.iProgress.getMaximum();
    }

    public int getMinimumValue() {
        return this.iProgress.getMinimum();
    }

    public boolean isIndeterminate() {
        return this.iProgress.isIndeterminate();
    }

    public void setProgress(int aValue, String aMessage) {
        if (aValue < this.iProgress.getMinimum() || aValue > this.iProgress.getMaximum()) {
            throw new IllegalArgumentException("Your value (" + aValue + ") was out of bounds (" + this.iProgress.getMinimum() + "-" + this.iProgress.getMaximum() + ")!");
        }
        this.iProgress.setValue(aValue);
        if (aMessage != null) {
            this.iProgress.setStringPainted(true);
            this.iProgress.setString(aMessage);
        } else {
            this.iProgress.setStringPainted(false);
        }
    }

    public void setMessage(String aMessage) {
        if (aMessage != null) {
            this.iProgress.setString(aMessage);
            this.iProgress.setStringPainted(true);
        } else {
            this.iProgress.setStringPainted(false);
        }
    }

    public boolean isProgressBarValid() {
        return this.iProgress.isValid();
    }

    public void setProgress(int aValue) {
        this.setProgress(aValue, null);
    }

    public int getProgress() {
        return this.iProgress.getValue();
    }

    private void constructGUI(String aMessage) {
        JPanel jpanHorizontalStrutLeft = new JPanel();
        jpanHorizontalStrutLeft.setLayout(new BoxLayout(jpanHorizontalStrutLeft, 0));
        jpanHorizontalStrutLeft.add(Box.createHorizontalStrut(10));
        JPanel jpanHorizontalStrutRight = new JPanel();
        jpanHorizontalStrutRight.setLayout(new BoxLayout(jpanHorizontalStrutRight, 0));
        jpanHorizontalStrutRight.add(Box.createHorizontalStrut(10));
        JPanel jpanVerticalStrutTop = new JPanel();
        jpanVerticalStrutTop.setLayout(new BoxLayout(jpanVerticalStrutTop, 1));
        jpanVerticalStrutTop.add(Box.createVerticalStrut(5));
        JPanel jpanVerticalStrutBottom = new JPanel();
        jpanVerticalStrutBottom.setLayout(new BoxLayout(jpanVerticalStrutBottom, 1));
        jpanVerticalStrutBottom.add(Box.createVerticalStrut(5));
        this.iProgress.setIndeterminate(true);
        this.setMessage(aMessage);
        JPanel jpanProgress = new JPanel(new BorderLayout());
        jpanProgress.add((Component)jpanVerticalStrutTop, "North");
        jpanProgress.add((Component)jpanVerticalStrutBottom, "South");
        jpanProgress.add((Component)jpanHorizontalStrutRight, "East");
        jpanProgress.add((Component)jpanHorizontalStrutLeft, "West");
        jpanProgress.add((Component)this.iProgress, "Center");
        this.getContentPane().add((Component)jpanProgress, "Center");
    }

    private void positionDialog() {
        this.pack();
        this.setSize(this.getSize().width + 50, this.getSize().height);
        if (super.getParent().isVisible()) {
            Point parentLoc = super.getParent().getLocationOnScreen();
            int x = (int)parentLoc.getX();
            int y = (int)parentLoc.getY();
            Dimension parentSize = super.getParent().getSize();
            Point location = new Point(x + parentSize.width / 2 - this.getSize().width / 2, y + parentSize.height / 2);
            this.setLocation(location);
        } else {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screen.width / 2 - this.getSize().width / 2, screen.height / 2);
        }
    }
}

