/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.waiting.waitinghandlers;

import com.compomics.util.gui.waiting.WaitingHandler;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;

public class ProgressDialogX
extends JDialog
implements WaitingHandler {
    private boolean doNothingOnClose = false;
    private boolean unstoppable = false;
    private boolean canceled = false;
    private boolean finished = false;
    private Image waitingIcon;
    private Image normalIcon;
    private Frame waitingHandlerParentFrame;
    private JDialog waitingHandlerParentDialog;
    private JProgressBar progressBar;

    public ProgressDialogX(Frame waitingHandlerParent, Image normalIcon, Image waitingIcon, boolean modal) {
        super(waitingHandlerParent, modal);
        this.initComponents();
        this.setLocationRelativeTo(waitingHandlerParent);
        this.waitingHandlerParentFrame = waitingHandlerParent;
        this.waitingIcon = waitingIcon;
        this.normalIcon = normalIcon;
        if (waitingIcon != null) {
            this.waitingHandlerParentFrame.setIconImage(waitingIcon);
        }
    }

    public ProgressDialogX(JDialog waitingHandlerParent, Frame waitingHandlerParentFrame, Image normalIcon, Image waitingIcon, boolean modal) {
        super((Dialog)waitingHandlerParent, modal);
        this.initComponents();
        this.setLocationRelativeTo(waitingHandlerParent);
        this.waitingIcon = waitingIcon;
        this.normalIcon = normalIcon;
        this.waitingHandlerParentDialog = waitingHandlerParent;
        this.waitingHandlerParentFrame = waitingHandlerParentFrame;
        if (waitingIcon != null) {
            waitingHandlerParentFrame.setIconImage(waitingIcon);
        }
    }

    public ProgressDialogX(boolean modal) {
        this.setModal(true);
        this.initComponents();
        this.setLocationRelativeTo(null);
    }

    public void setValue(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setValue(value);
            }
        });
    }

    public void incrementValue() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setValue(ProgressDialogX.this.progressBar.getValue() + 1);
            }
        });
    }

    public void incrementValue(final int increment) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setValue(ProgressDialogX.this.progressBar.getValue() + increment);
            }
        });
    }

    public void setMax(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setMaximum(value);
            }
        });
    }

    public void setIntermidiate(final boolean intermidiate) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setStringPainted(!intermidiate);
                ProgressDialogX.this.progressBar.setIndeterminate(intermidiate);
            }
        });
    }

    public void setIndeterminate(final boolean indeterminate) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setStringPainted(!indeterminate);
                ProgressDialogX.this.progressBar.setIndeterminate(indeterminate);
            }
        });
    }

    public void setString(final String currentFileName) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setStringPainted(currentFileName != null);
                ProgressDialogX.this.progressBar.setString(currentFileName);
            }
        });
    }

    public void doNothingOnClose() {
        this.doNothingOnClose = true;
    }

    public void setUnstoppable(boolean unstoppable) {
        this.unstoppable = unstoppable;
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Please Wait");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ProgressDialogX.this.formWindowClosing(evt);
            }
        });
        this.progressBar.setFont(this.progressBar.getFont().deriveFont((float)this.progressBar.getFont().getSize() - 1.0f));
        this.progressBar.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.progressBar, -1, 453, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.progressBar, -2, 19, -2).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setRunCanceled();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setMaxProgressValue(final int maxProgressValue) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setMaximum(maxProgressValue);
            }
        });
    }

    public void increaseProgressValue() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setValue(ProgressDialogX.this.progressBar.getValue() + 1);
            }
        });
    }

    public void increaseProgressValue(final int increment) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setValue(ProgressDialogX.this.progressBar.getValue() + increment);
            }
        });
    }

    public void setMaxSecondaryProgressValue(int maxProgressValue) {
        this.setMaxProgressValue(maxProgressValue);
    }

    public void resetSecondaryProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialogX.this.progressBar.setIndeterminate(false);
                ProgressDialogX.this.progressBar.setStringPainted(true);
                ProgressDialogX.this.progressBar.setValue(0);
            }
        });
    }

    public void increaseSecondaryProgressValue() {
        this.increaseProgressValue();
    }

    public void setSecondaryProgressValue(int value) {
        this.setValue(value);
    }

    public void increaseSecondaryProgressValue(int number) {
        this.increaseProgressValue(number);
    }

    public void setSecondaryProgressDialogIndeterminate(boolean indeterminate) {
        this.setIndeterminate(indeterminate);
    }

    public void setRunFinished() {
        if (this.normalIcon != null) {
            this.waitingHandlerParentFrame.setIconImage(this.normalIcon);
        }
        this.finished = true;
        this.dispose();
    }

    public void setRunCanceled() {
        if (!this.finished) {
            int selection;
            if (!this.doNothingOnClose && !this.unstoppable) {
                this.canceled = true;
            }
            if (!this.canceled && this.unstoppable && (selection = JOptionPane.showConfirmDialog(this, "Cancelling this process is not directly supported.\nDoing so may result in instability or errors.\n\nDo you still want to cancel the process?", "Cancel Process?", 1, 2)) == 0) {
                this.canceled = true;
            }
        }
    }

    public void appendReport(String report, boolean includeDate, boolean addNewLine) {
        throw new UnsupportedOperationException("This waiting handler has no report.");
    }

    public void appendReportNewLineNoDate() {
        throw new UnsupportedOperationException("This waiting handler has no report.");
    }

    public void appendReportEndLine() {
        throw new UnsupportedOperationException("This waiting handler has no report.");
    }

    public boolean isRunCanceled() {
        return this.canceled;
    }

    public boolean isRunFinished() {
        return this.finished;
    }

    public JProgressBar getSecondaryProgressBar() {
        throw new UnsupportedOperationException("This waiting handler has no secondary progress bar.");
    }

    public void displayMessage(String message, String title, int messageType) {
        JOptionPane.showMessageDialog(this, message, title, messageType);
    }

    public void displayHtmlMessage(JEditorPane messagePane, String title, int messageType) {
        JOptionPane.showMessageDialog(this, messagePane, title, messageType);
    }

    public void setWaitingText(String text) {
    }

    public JProgressBar getPrimaryProgressBar() {
        return this.progressBar;
    }
}

