/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializationUtils {
    public static void writeObject(Object object, File destinationFile) throws IOException {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(destinationFile);
            bos = new BufferedOutputStream(fos);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.close();
            bos.close();
            fos.close();
        }
        catch (IOException e) {
            if (oos != null) {
                oos.close();
            }
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
            throw e;
        }
    }

    public static Object readObject(File serializedFile) throws IOException, ClassNotFoundException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(serializedFile);
            bis = new BufferedInputStream(fis);
            in = new ObjectInputStream(bis);
            Object object = in.readObject();
            in.close();
            fis.close();
            bis.close();
            return object;
        }
        catch (IOException e) {
            if (in != null) {
                in.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (bis != null) {
                bis.close();
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (in != null) {
                in.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (bis != null) {
                bis.close();
            }
            throw e;
        }
    }
}

