/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.gui.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarUtils {
    public static void tarFolder(File folder, File destinationFile, WaitingHandler waitingHandler) throws FileNotFoundException, ArchiveException, IOException {
        FileOutputStream fos = new FileOutputStream(destinationFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        TarArchiveOutputStream tarOutput = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)bos);
        tarOutput.setLongFileMode(2);
        File matchFolder = folder;
        TarUtils.addFolderContent((ArchiveOutputStream)tarOutput, matchFolder, waitingHandler);
        tarOutput.close();
        bos.close();
        fos.close();
    }

    public static void addFolderContent(ArchiveOutputStream tarOutput, File folder, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        for (File file : folder.listFiles()) {
            int count;
            if (file.isDirectory()) {
                TarUtils.addFolderContent(tarOutput, file, waitingHandler);
                continue;
            }
            int BUFFER = 2048;
            FileInputStream fi = new FileInputStream(file);
            BufferedInputStream origin = new BufferedInputStream(fi, 2048);
            byte[] data = new byte[2048];
            TarArchiveEntry entry = new TarArchiveEntry(file);
            tarOutput.putArchiveEntry((ArchiveEntry)entry);
            while (!((count = origin.read(data, 0, 2048)) == -1 || waitingHandler != null && waitingHandler.isRunCanceled())) {
                tarOutput.write(data, 0, count);
            }
            tarOutput.closeArchiveEntry();
            origin.close();
            fi.close();
        }
    }
}

