/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationProfile
implements Serializable {
    static final long serialVersionUID = 342611308111304721L;
    private HashMap<String, String> modificationNames = new HashMap();
    private ArrayList<String> fixedModifications = new ArrayList();
    private ArrayList<String> variableModifications = new ArrayList();
    private ArrayList<String> refinementModifications = new ArrayList();
    private HashMap<Integer, String> omssaIndexes = new HashMap();
    private HashMap<String, Color> colors = new HashMap();
    private HashMap<String, PTM> backUp = new HashMap();

    public ArrayList<String> getVariableModifications() {
        return this.variableModifications;
    }

    public ArrayList<String> getFixedModifications() {
        return this.fixedModifications;
    }

    public ArrayList<String> getRefinementModifications() {
        return this.refinementModifications;
    }

    public ArrayList<String> getAllModifications() {
        this.compatibilityCheck();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.fixedModifications);
        result.addAll(this.variableModifications);
        result.addAll(this.refinementModifications);
        return result;
    }

    public ArrayList<String> getAllNotFixedModifications() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.variableModifications);
        result.addAll(this.refinementModifications);
        return result;
    }

    public void addVariableModification(PTM modification) {
        String modName = modification.getName();
        if (!this.variableModifications.contains(modName)) {
            this.variableModifications.add(modName);
        }
        modification.setShortName(PTMFactory.getInstance().getShortName(modName));
        this.backUp.put(modName, modification);
    }

    public void addRefinementModification(PTM modification) {
        String modName = modification.getName();
        if (!this.refinementModifications.contains(modName)) {
            this.refinementModifications.add(modName);
        }
        modification.setShortName(PTMFactory.getInstance().getShortName(modName));
        this.backUp.put(modName, modification);
    }

    public void addFixedModification(PTM modification) {
        String modName = modification.getName();
        if (!this.fixedModifications.contains(modName)) {
            this.fixedModifications.add(modName);
        }
        modification.setShortName(PTMFactory.getInstance().getShortName(modName));
        this.backUp.put(modName, modification);
    }

    public void setColor(String expectedModification, Color color) {
        this.colors.put(expectedModification, color);
    }

    public Color getColor(String modification) {
        if (!this.colors.containsKey(modification)) {
            PTMFactory ptmFactory = PTMFactory.getInstance();
            this.setColor(modification, ptmFactory.getColor(modification));
        }
        return this.colors.get(modification);
    }

    public void compatibilityCheck() {
        if (this.fixedModifications == null) {
            this.fixedModifications = new ArrayList();
        }
        if (this.variableModifications == null) {
            this.variableModifications = new ArrayList();
            for (String modName : this.modificationNames.values()) {
                this.variableModifications.add(modName);
            }
        }
        if (this.refinementModifications == null) {
            this.refinementModifications = new ArrayList();
        }
        if (this.backUp == null) {
            this.backUp = new HashMap();
        }
    }

    public Set<String> getBackedUpPtms() {
        return this.backUp.keySet();
    }

    public PTM getPtm(String modName) {
        return this.backUp.get(modName);
    }

    public void removeVariableModification(String modificationName) {
        while (this.variableModifications.contains(modificationName)) {
            this.variableModifications.remove(modificationName);
        }
    }

    public void removeFixedModification(String modificationName) {
        while (this.fixedModifications.contains(modificationName)) {
            this.fixedModifications.remove(modificationName);
        }
    }

    public void removeRefinementModification(String modificationName) {
        while (this.refinementModifications.contains(modificationName)) {
            this.refinementModifications.remove(modificationName);
        }
    }

    public void setOmssaIndex(String modificationName, int omssaIndex) {
        this.omssaIndexes.put(omssaIndex, modificationName);
    }

    public String getModification(int omssaIndex) {
        return this.omssaIndexes.get(omssaIndex);
    }

    public Integer getOmssaIndex(String modificationName) {
        for (int index : this.omssaIndexes.keySet()) {
            if (!modificationName.equalsIgnoreCase(this.omssaIndexes.get(index))) continue;
            return index;
        }
        return null;
    }

    public boolean contains(String modificationName) {
        return this.variableModifications.contains(modificationName) || this.fixedModifications.contains(modificationName) || this.refinementModifications.contains(modificationName);
    }

    public ArrayList<String> getSimilarNotFixedModifications(Double ptmMass) {
        PTMFactory ptmFactory = PTMFactory.getInstance();
        ArrayList<String> ptms = new ArrayList<String>();
        for (String ptmName : this.getAllNotFixedModifications()) {
            PTM ptm = ptmFactory.getPTM(ptmName);
            if (ptms.contains(ptmName) || ptm.getMass() != ptmMass.doubleValue()) continue;
            ptms.add(ptmName);
        }
        return ptms;
    }
}

