package com.compomics.util.examples;

import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.io.PklFile;
import java.awt.Color;
import java.io.File;

/**
 * Mirrored spectra test class.
 *
 * @author Harald Barsnes
 */
public class MirroredSpectraTestDialog extends javax.swing.JDialog {

    /**
     * Creates a new MirroredSpectraTestDialog
     *
     * @param parent
     * @param modal
     */
    public MirroredSpectraTestDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        
        try {
            File spectrumFileA = new File(getJarFilePath() + "/exampleFiles/exampleSpectrumA.pkl");
            PklFile pklFileA = new PklFile(spectrumFileA);
            
            File spectrumFileB = new File(getJarFilePath() + "/exampleFiles/exampleSpectrumA.pkl");
            PklFile pklFileB = new PklFile(spectrumFileB);
            
            SpectrumPanel spectrumPanel = new SpectrumPanel(
                    pklFileA.getMzValues(), pklFileA.getIntensityValues(),
                    pklFileA.getPrecursorMz(), "" + pklFileA.getPrecurorCharge(),
                    "" + pklFileA.getFileName(),
                    50, false, false, false, 2, false);
            
            // add a second normal spectrum
            //spectrumPanel.addAdditionalDataset(pklFileB.getMzValues(), pklFileB.getIntensityValues(), Color.BLUE, Color.BLUE);
            
            // add a second mirrored spectrum
            spectrumPanel.addMirroredSpectrum(pklFileB.getMzValues(), pklFileB.getIntensityValues(),
                    pklFileB.getPrecursorMz(), "" + pklFileB.getPrecurorCharge(),
                    "" + pklFileB.getFileName(), false, Color.BLUE, Color.BLUE);

            // add a third mirrored spectrum
//            spectrumPanel.addMirroredSpectrum(pklFileA.getMzValues(), pklFileA.getIntensityValues(),
//                    pklFileA.getPrecursorMz(), "" + pklFileA.getPrecurorCharge(),
//                    "" + pklFileA.getFileName(), false, Color.GREEN, Color.BLUE);

            backgroundPanel.add(spectrumPanel);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Mirrored Spectra Demo");

        backgroundPanel.setLayout(new javax.swing.BoxLayout(backgroundPanel, javax.swing.BoxLayout.LINE_AXIS));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 1085, Short.MAX_VALUE)
                .addGap(0, 0, 0))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 650, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(MirroredSpectraTestDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(MirroredSpectraTestDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(MirroredSpectraTestDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(MirroredSpectraTestDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                MirroredSpectraTestDialog dialog = new MirroredSpectraTestDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    // End of variables declaration//GEN-END:variables

    /**
     * Returns the path to the jar file.
     *
     * @return the path to the jar file
     */
    private String getJarFilePath() {
        String path = this.getClass().getResource("MirroredSpectraTestDialog.class").getPath();
        
        if (path.lastIndexOf("/utilities-") != -1) {
            // remove starting 'file:' tag if there
            if (path.startsWith("file:")) {
                path = path.substring("file:".length(), path.lastIndexOf("/utilities-"));
            } else {
                path = path.substring(0, path.lastIndexOf("/utilities-"));
            }
            path = path.replace("%20", " ");
            path = path.replace("%5b", "[");
            path = path.replace("%5d", "]");
        } else {
            path = ".";
        }
        
        return path;
    }
}
