/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software;

import com.compomics.software.CommandLineUtils;
import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.io.StreamGobbler;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class CompomicsWrapper {
    private boolean useStartUpLog = true;
    private BufferedWriter bw = null;
    private boolean firstTry = true;
    private boolean proxySettingsFound = false;
    private UtilitiesUserPreferences userPreferences;

    public void launchTool(String toolName, File jarFile, String splashName, String mainClass) {
        this.launchTool(toolName, jarFile, splashName, mainClass, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void launchTool(String toolName, File jarFile, String splashName, String mainClass, String[] args) {
        File folder = new File(jarFile.getParentFile(), "startup.log");
        try {
            try {
                this.userPreferences = UtilitiesUserPreferences.loadUserPreferences();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.useStartUpLog) {
                folder = new File(jarFile.getParentFile(), "resources/conf");
                if (!folder.exists()) {
                    String path = URLDecoder.decode(jarFile.getParentFile().getAbsolutePath(), "UTF-8");
                    folder = new File(path, "resources/conf");
                }
                if (!folder.exists()) {
                    if (!folder.mkdirs()) throw new FileNotFoundException(folder.getAbsolutePath() + " not found!");
                    this.copyDefaultJavaOptionsFile(folder);
                } else if (!new File(folder.getAbsolutePath(), "JavaOptions.txt").exists()) {
                    this.copyDefaultJavaOptionsFile(folder);
                }
                File debugOutput = new File(folder, "startup.log");
                this.bw = new BufferedWriter(new FileWriter(debugOutput));
                this.bw.write("Memory settings read from the user preferences: " + this.userPreferences.getMemoryPreference() + System.getProperty("line.separator"));
                String arguments = "args: ";
                if (args != null) {
                    for (String arg : args) {
                        arguments = arguments + arg + " ";
                    }
                }
                this.bw.write(arguments);
                this.bw.newLine();
            }
            try {
                UtilitiesGUIDefaults.setLookAndFeel();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Seems like you are trying to start " + toolName + " from within a zip file!", toolName + " - Startup Failed", 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.launch(jarFile, splashName, mainClass, args);
            if (!this.useStartUpLog) return;
            this.bw.flush();
            this.bw.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.bw = new BufferedWriter(new FileWriter(folder));
                this.bw.write(e.getMessage());
                JOptionPane.showMessageDialog(null, "Failed to start " + toolName + ":" + System.getProperty("line.separator") + e.getMessage(), toolName + " - Startup Failed", 0);
                return;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, "Failed to start " + toolName + ":" + System.getProperty("line.separator") + e.getMessage() + "\nCould not write to statup.log file", toolName + " - Startup Failed", 0);
            }
        }
    }

    private void launch(File jarFile, String splashName, String mainClass) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        this.launch(jarFile, splashName, mainClass, null);
    }

    private void launch(File jarFile, String splashName, String mainClass, String[] args) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String jarFilePath;
        File confFolder = new File(jarFile.getParentFile(), "resources/conf");
        String javaHome = this.getJavaHome(confFolder, this.bw);
        String splashPath = null;
        if (splashName != null) {
            splashPath = "resources/conf" + File.separator + splashName;
            if (System.getProperty("os.name").lastIndexOf("Windows") != -1 && (splashPath = splashPath.replace("/", "\\")).startsWith("\\") && !splashPath.startsWith("\\\\")) {
                splashPath = splashPath.substring(1);
            }
        }
        String uniprotProxyClassPath = "";
        String quote = CommandLineUtils.getQuoteType();
        if (this.proxySettingsFound) {
            uniprotProxyClassPath = confFolder.getAbsolutePath() + File.separator + "proxy";
            if (System.getProperty("os.name").lastIndexOf("Windows") != -1 && (uniprotProxyClassPath = uniprotProxyClassPath.replace("/", "\\")).startsWith("\\") && !uniprotProxyClassPath.startsWith("\\\\")) {
                uniprotProxyClassPath = uniprotProxyClassPath.substring(1);
            }
            uniprotProxyClassPath = ";" + quote + uniprotProxyClassPath + quote;
        }
        if (!new File(jarFilePath = jarFile.getAbsolutePath()).exists()) {
            jarFilePath = URLDecoder.decode(jarFile.getAbsolutePath(), "UTF-8");
        }
        ArrayList<String> process_name_array = new ArrayList<String>();
        process_name_array.add(javaHome);
        if (splashName != null) {
            process_name_array.add("-splash:" + splashPath);
        }
        ArrayList<String> optionsAsList = this.getJavaOptions(confFolder, jarFile, this.bw);
        for (String currentOption : optionsAsList) {
            process_name_array.add(currentOption);
        }
        process_name_array.add("-cp");
        String classPath = quote + jarFilePath;
        if (uniprotProxyClassPath.trim().length() > 0) {
            classPath = classPath + uniprotProxyClassPath;
        }
        classPath = classPath + quote;
        process_name_array.add(classPath);
        process_name_array.add(mainClass);
        if (args != null) {
            process_name_array.addAll(Arrays.asList(args));
        }
        process_name_array.trimToSize();
        if (this.useStartUpLog) {
            System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Command line: ");
            this.bw.write(System.getProperty("line.separator") + "Command line: " + System.getProperty("line.separator"));
            for (int i = 0; i < process_name_array.size(); ++i) {
                System.out.print(process_name_array.get(i) + " ");
                this.bw.write(process_name_array.get(i) + " ");
            }
            this.bw.write(System.getProperty("line.separator"));
            System.out.println(System.getProperty("line.separator"));
        }
        ProcessBuilder pb = new ProcessBuilder(process_name_array);
        pb.directory(jarFile.getParentFile());
        try {
            Process p = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream());
            Thread errorThread = new Thread(errorGobbler);
            Thread inputThread = new Thread(new StreamGobbler(p.getInputStream()));
            errorThread.start();
            inputThread.start();
            errorThread.join();
            inputThread.join();
            int exitValue = p.waitFor();
            if (this.useStartUpLog) {
                System.out.println("Process exitValue: " + exitValue + System.getProperty("line.separator"));
                this.bw.write("Process exitValue: " + exitValue + System.getProperty("line.separator"));
            }
            if (exitValue != 0) {
                this.firstTry = false;
                String temp = errorGobbler.getMessages().toLowerCase();
                if (temp.contains("could not create the java virtual machine")) {
                    if (this.userPreferences.getMemoryPreference() > 3072) {
                        this.userPreferences.setMemoryPreference(this.userPreferences.getMemoryPreference() - 1024);
                        UtilitiesUserPreferences.saveUserPreferences(this.userPreferences);
                        this.launch(jarFile, splashName, mainClass, args);
                    } else if (this.userPreferences.getMemoryPreference() > 1024) {
                        this.userPreferences.setMemoryPreference(this.userPreferences.getMemoryPreference() - 512);
                        UtilitiesUserPreferences.saveUserPreferences(this.userPreferences);
                        this.launch(jarFile, splashName, mainClass, args);
                    } else {
                        if (this.useStartUpLog) {
                            this.bw.write("Memory Limit:" + this.userPreferences.getMemoryPreference() + System.getProperty("line.separator"));
                            this.bw.flush();
                            this.bw.close();
                        }
                        JOptionPane.showMessageDialog(null, "Failed to create the Java virtual machine.\n\nInspect the log file for details: resources/conf/startup.log.\n\nThen go to Troubleshooting at http://peptide-shaker.googlecode.com", "Startup Failed", 0);
                        System.exit(0);
                    }
                } else if (temp.toLowerCase().contains("cgcontextgetctm: invalid context") || temp.toLowerCase().contains("cgcontextsetbasectm: invalid context")) {
                    System.out.println("Mac OS/Java error (can be ignored): " + temp);
                } else {
                    if (this.useStartUpLog) {
                        this.bw.flush();
                        this.bw.close();
                    }
                    if (temp.lastIndexOf("noclassdeffound") != -1) {
                        JOptionPane.showMessageDialog(null, "Seems like you are trying to start the tool from within a zip file!", "Startup Failed", 0);
                    } else {
                        JOptionPane.showMessageDialog(null, "An error occurred when starting the tool.\n\nInspect the log file for details: resources/conf/startup.log.\n\nThen go to Troubleshooting at http://peptide-shaker.googlecode.com", "Startup Error", 0);
                    }
                    System.exit(0);
                }
            } else {
                System.exit(0);
            }
        }
        catch (Throwable t) {
            if (this.useStartUpLog) {
                this.bw.write(t.getMessage());
                this.bw.flush();
                this.bw.close();
            }
            t.printStackTrace();
            System.exit(0);
        }
    }

    private void saveJavaOptions(File jarFile) throws FileNotFoundException, UnsupportedEncodingException {
        String lines = "";
        File confFolder = new File(jarFile.getParentFile(), "resources/conf");
        if (!confFolder.exists()) {
            String path = URLDecoder.decode(jarFile.getParentFile().getAbsolutePath(), "UTF-8");
            confFolder = new File(path, "resources/conf");
        }
        if (!confFolder.exists()) {
            throw new FileNotFoundException(confFolder.getAbsolutePath() + " not found!");
        }
        File javaOptions = new File(confFolder, "JavaOptions.txt");
        if (javaOptions.exists()) {
            try {
                String currentLine;
                FileReader f = new FileReader(javaOptions);
                BufferedReader b = new BufferedReader(f);
                while ((currentLine = b.readLine()) != null) {
                    if (currentLine.startsWith("-Xmx")) continue;
                    lines = lines + currentLine + System.getProperty("line.separator");
                }
                b.close();
                f.close();
                FileWriter fw = new FileWriter(javaOptions);
                BufferedWriter bow = new BufferedWriter(fw);
                bow.write(lines);
                bow.write("-Xmx" + this.userPreferences.getMemoryPreference() + "M" + System.getProperty("line.separator"));
                bow.close();
                fw.close();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getJarFilePath(String classPath, String toolName) {
        String path = classPath;
        toolName = toolName + "-";
        if (path.lastIndexOf("/" + toolName) != -1) {
            path = path.startsWith("file:") ? path.substring("file:".length(), path.lastIndexOf("/" + toolName)) : path.substring(0, path.lastIndexOf("/" + toolName));
            path = path.replace("%20", " ");
            path = path.replace("%5b", "[");
            path = path.replace("%5d", "]");
            if (System.getProperty("os.name").lastIndexOf("Windows") != -1) {
                path = path.replace("/", "\\");
            }
        } else {
            path = ".";
        }
        try {
            if (!new File(path).exists()) {
                path = URLDecoder.decode(path, "UTF-8");
            }
            if (!new File(path).exists()) {
                JOptionPane.showMessageDialog(null, path + " not found!", "File Error", 0);
            }
        }
        catch (UnsupportedEncodingException ex) {
            JOptionPane.showMessageDialog(null, "Error reading file " + path + ".", "File Error", 0);
            ex.printStackTrace();
        }
        return path;
    }

    public static void checkJavaVersion(String toolName) {
        String arch = System.getProperty("os.arch");
        if (arch.endsWith("x86")) {
            JLabel label = new JLabel();
            JEditorPane ep = new JEditorPane("text/html", "<html><body bgcolor=\"#" + Util.color2Hex(label.getBackground()) + "\">" + toolName + " works best with Java 64 bit.<br><br>" + "See <a href=\"http://code.google.com/p/compomics-utilities/wiki/JavaTroubleShooting\">Java Troubleshooting</a> for more details." + "</body></html>");
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        BareBonesBrowserLaunch.openURL(e.getURL().toString());
                    }
                }
            });
            ep.setBorder(null);
            ep.setEditable(false);
            JOptionPane.showMessageDialog(null, ep, "Java 64 Bit?", 1);
        }
    }

    public static void checkForNewVersion(String currentVersion, String toolName, String googleCodeToolName) {
        CompomicsWrapper.checkForNewVersion(currentVersion, toolName, googleCodeToolName, true, "", ".zip");
    }

    public static void checkForNewVersion(String currentVersion, String toolName, String googleCodeToolName, boolean closeToolWhenUpgrading, String zipFileTag, String zipFileType) {
        try {
            boolean deprecatedOrDeleted = false;
            URL downloadPage = new URL("http://code.google.com/p/" + googleCodeToolName + "/downloads/detail?name=" + toolName + "-" + currentVersion + zipFileTag + zipFileType);
            if ((HttpURLConnection)downloadPage.openConnection() != null) {
                int respons = ((HttpURLConnection)downloadPage.openConnection()).getResponseCode();
                if (respons == 404) {
                    deprecatedOrDeleted = true;
                } else {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(downloadPage.openStream()));
                    while ((inputLine = in.readLine()) != null && !deprecatedOrDeleted) {
                        if (inputLine.lastIndexOf("Deprecated") == -1 || inputLine.lastIndexOf("Deprecated Downloads") != -1 || inputLine.lastIndexOf("Deprecated downloads") != -1) continue;
                        deprecatedOrDeleted = true;
                    }
                    in.close();
                }
                if (deprecatedOrDeleted && currentVersion.lastIndexOf("beta") == -1 && currentVersion.lastIndexOf("${version}") == -1) {
                    int option = JOptionPane.showConfirmDialog(null, "A newer version of " + toolName + " is available.\n" + "Do you want to upgrade?", "Upgrade Available", 1);
                    if (option == 0) {
                        BareBonesBrowserLaunch.openURL("http://" + googleCodeToolName + ".googlecode.com/");
                        if (closeToolWhenUpgrading) {
                            System.exit(0);
                        }
                    } else if (option == 2 && closeToolWhenUpgrading) {
                        System.exit(0);
                    }
                }
            }
        }
        catch (UnknownHostException e) {
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getJavaOptions(File confFolder, File jarFile, BufferedWriter bw) throws IOException {
        ArrayList<String> options;
        block28: {
            try {
                this.userPreferences = UtilitiesUserPreferences.loadUserPreferences();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            options = new ArrayList<String>();
            File javaOptions = new File(confFolder, "JavaOptions.txt");
            File uniprotApiPropertiesFile = new File(confFolder, "proxy/uniprotjapi.properties");
            String uniprotApiProperties = "";
            if (javaOptions.exists()) {
                try {
                    FileReader f = new FileReader(javaOptions);
                    BufferedReader b = new BufferedReader(f);
                    String currentOption = b.readLine();
                    while (currentOption != null) {
                        if (currentOption.startsWith("-Xmx")) {
                            if (this.firstTry) {
                                currentOption = currentOption.substring(4, currentOption.length() - 1);
                                boolean input = false;
                                for (char c : currentOption.toCharArray()) {
                                    if (c == '*') continue;
                                    input = true;
                                    break;
                                }
                                if (input) {
                                    try {
                                        this.userPreferences.setMemoryPreference(new Integer(currentOption));
                                        UtilitiesUserPreferences.saveUserPreferences(this.userPreferences);
                                        if (bw != null) {
                                            bw.write("New memory setting saved: " + this.userPreferences.getMemoryPreference() + System.getProperty("line.separator"));
                                        }
                                    }
                                    catch (Exception e) {
                                        JOptionPane.showMessageDialog(null, "Could not parse the memory setting: " + currentOption + ". The value was reset to" + this.userPreferences.getMemoryPreference() + ".", "Wrong memory settings", 2);
                                    }
                                }
                            }
                        } else if (!currentOption.startsWith("#")) {
                            if (currentOption.startsWith("-Dhttp")) {
                                this.proxySettingsFound = true;
                                String[] tempProxySetting = currentOption.split("=");
                                if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyHost")) {
                                    uniprotApiProperties = uniprotApiProperties + "proxy.host=" + tempProxySetting[1] + System.getProperty("line.separator");
                                } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyPort")) {
                                    uniprotApiProperties = uniprotApiProperties + "proxy.port=" + tempProxySetting[1] + System.getProperty("line.separator");
                                } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyUser")) {
                                    uniprotApiProperties = uniprotApiProperties + "username=" + tempProxySetting[1] + System.getProperty("line.separator");
                                } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyPassword")) {
                                    uniprotApiProperties = uniprotApiProperties + "password=" + tempProxySetting[1] + System.getProperty("line.separator");
                                }
                            }
                            options.add(currentOption.trim());
                        }
                        currentOption = b.readLine();
                    }
                    if (this.proxySettingsFound) {
                        FileWriter uniprotProxyWriter = new FileWriter(uniprotApiPropertiesFile);
                        BufferedWriter uniprotProxyBufferedWriter = new BufferedWriter(uniprotProxyWriter);
                        uniprotProxyBufferedWriter.write(uniprotApiProperties);
                        uniprotProxyBufferedWriter.close();
                        uniprotProxyWriter.close();
                    }
                    b.close();
                    f.close();
                    options.add("-Xmx" + this.userPreferences.getMemoryPreference() + "M");
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                    if (bw != null) {
                        bw.write(ex.getMessage());
                    }
                    break block28;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (bw != null) {
                        bw.write(ex.getMessage());
                    }
                    break block28;
                }
            }
            options.add("-Xms128M");
            options.add("-Xmx1024M");
        }
        return options;
    }

    private String getJavaHome(File confFolder, BufferedWriter bw) throws IOException {
        String javaHome;
        boolean usingStandardJavaHome;
        block14: {
            usingStandardJavaHome = true;
            javaHome = System.getProperty("java.home") + File.separator + "bin" + File.separator;
            File nonStandardJavaHome = new File(confFolder, "JavaHome.txt");
            if (nonStandardJavaHome.exists()) {
                try {
                    FileReader f = new FileReader(nonStandardJavaHome);
                    BufferedReader b = new BufferedReader(f);
                    String tempLocation = b.readLine();
                    if (!tempLocation.endsWith(File.separator)) {
                        tempLocation = tempLocation + File.separator;
                    }
                    if (new File(tempLocation).exists() && (new File(tempLocation, "java.exe").exists() || new File(tempLocation, "java").exists())) {
                        javaHome = tempLocation;
                        usingStandardJavaHome = false;
                    } else if (this.firstTry) {
                        JOptionPane.showMessageDialog(null, "Non-standard Java home location not found.\nUsing default Java home.", "Java Home Not Found!", 2);
                    }
                    b.close();
                    f.close();
                }
                catch (FileNotFoundException ex) {
                    if (this.firstTry) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Non-standard Java home location not found.\nUsing default Java home", "Java Home Not Found!", 2);
                    }
                }
                catch (IOException ex) {
                    if (!this.firstTry) break block14;
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error when reading non-standard Java home location.\nUsing default Java home.", "Java Home Error", 2);
                }
            }
        }
        if (bw != null) {
            bw.write("original java.home: " + javaHome + System.getProperty("line.separator"));
        }
        if (usingStandardJavaHome && javaHome.lastIndexOf(" (x86)") != -1 && System.getProperty("os.name").lastIndexOf("Windows") != -1) {
            String tempJavaHome = javaHome.replaceAll(" \\(x86\\)", "");
            if (bw != null) {
                bw.write("temp java.home: " + tempJavaHome + System.getProperty("line.separator"));
            }
            if (new File(tempJavaHome).exists()) {
                javaHome = tempJavaHome;
            }
        }
        if (bw != null) {
            bw.write("new java.home: " + javaHome + System.getProperty("line.separator"));
        }
        String quote = CommandLineUtils.getQuoteType();
        javaHome = quote + javaHome + "java" + quote;
        return javaHome;
    }

    public ArrayList<String> getJavaHomeAndOptions(String toolPath) throws FileNotFoundException, IOException, ClassNotFoundException {
        ArrayList<String> javaHomeAndOptions = new ArrayList<String>();
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        CompomicsWrapper wrapper = new CompomicsWrapper();
        File confFolder = new File(new File(toolPath).getParentFile(), "resources/conf");
        if (!confFolder.exists()) {
            String path = URLDecoder.decode(new File(toolPath).getParentFile().getAbsolutePath(), "UTF-8");
            confFolder = new File(path, "resources/conf");
        }
        if (!confFolder.exists()) {
            throw new FileNotFoundException(confFolder.getAbsolutePath() + " not found!");
        }
        File debugOutput = new File(confFolder, "startup.log");
        BufferedWriter bwr = new BufferedWriter(new FileWriter(debugOutput));
        String javaHome = wrapper.getJavaHome(confFolder, bwr);
        javaHomeAndOptions.add(javaHome);
        ArrayList<String> optionsAsList = wrapper.getJavaOptions(confFolder, new File(utilitiesUserPreferences.getPeptideShakerPath()), bwr);
        for (String tempOption : optionsAsList) {
            javaHomeAndOptions.add(tempOption);
        }
        bwr.close();
        return javaHomeAndOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDefaultJavaOptionsFile(File folder) throws IOException {
        File destination = new File(folder.getAbsolutePath() + "/JavaOptions.txt");
        InputStream resStreamIn = this.getClass().getClassLoader().getResourceAsStream("DefaultJavaOptions.txt");
        FileOutputStream resStreamOut = new FileOutputStream(destination);
        try {
            int readBytes;
            byte[] buffer = new byte[1024];
            while ((readBytes = resStreamIn.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
        }
        finally {
            resStreamIn.close();
            ((OutputStream)resStreamOut).close();
        }
    }
}

