/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.autoupdater;

import com.compomics.software.autoupdater.FileDAO;
import com.compomics.software.autoupdater.GUIFileDAO;
import com.compomics.software.autoupdater.HeadlessFileDAO;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.autoupdater.WebDAO;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;

public class DownloadLatestZipFromRepo {
    public static void downloadLatestZipFromRepo(URL jarPath) throws IOException, XMLStreamException, URISyntaxException {
        DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, true, true);
    }

    public static void downloadLatestZipFromRepo(URL jarPath, boolean deleteOldFiles, boolean startDownloadedVersion) throws IOException, XMLStreamException, URISyntaxException {
        DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, deleteOldFiles, new String[0], startDownloadedVersion);
    }

    public static void downloadLatestZipFromRepo(URL jarPath, boolean deleteOldFiles, String[] args, boolean startDownloadedVersion) throws IOException, XMLStreamException, URISyntaxException {
        DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, deleteOldFiles, null, args, new URL("http", "genesis.ugent.be", "/maven2/"), startDownloadedVersion);
    }

    public static void downloadLatestZipFromRepo(URL jarPath, boolean deleteOldFiles, String[] args, URL jarRepository) throws IOException, XMLStreamException, URISyntaxException {
        DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, deleteOldFiles, null, args, jarRepository, true);
    }

    public static void downloadLatestZipFromRepo(URL jarPath, boolean deleteOldFiles, String iconName, String[] args, URL jarRepository, boolean startDownloadedVersion) throws IOException, XMLStreamException, URISyntaxException {
        if (GraphicsEnvironment.isHeadless()) {
            DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, deleteOldFiles, iconName, args, jarRepository, startDownloadedVersion, new HeadlessFileDAO());
        } else {
            DownloadLatestZipFromRepo.downloadLatestZipFromRepo(jarPath, deleteOldFiles, iconName, args, jarRepository, startDownloadedVersion, new GUIFileDAO());
        }
    }

    public static void downloadLatestZipFromRepo(final URL jarPath, boolean deleteOldFiles, String iconName, String[] args, URL jarRepository, boolean startDownloadedVersion, FileDAO fileDAO) throws IOException, XMLStreamException, URISyntaxException {
        MavenJarFile oldMavenJarFile = new MavenJarFile(jarPath.toURI());
        if (WebDAO.newVersionReleased(oldMavenJarFile, jarRepository)) {
            MavenJarFile downloadedJarFile;
            String artifactInRepoLocation = jarRepository.toExternalForm() + oldMavenJarFile.getGroupId().replaceAll("\\.", "/") + "/" + oldMavenJarFile.getArtifactId();
            String latestRemoteRelease = WebDAO.getLatestVersionNumberFromRemoteRepo(new URL(artifactInRepoLocation + "/maven-metadata.xml"));
            String latestArtifactLocation = artifactInRepoLocation + "/" + latestRemoteRelease;
            if (System.getProperty("os.name").toLowerCase(new Locale("en")).contains("win")) {
                downloadedJarFile = DownloadLatestZipFromRepo.downloadAndUnzipJarForWindows(oldMavenJarFile, new URL(latestArtifactLocation), fileDAO, true);
                fileDAO.createDesktopShortcut(downloadedJarFile, iconName, deleteOldFiles);
            } else {
                downloadedJarFile = DownloadLatestZipFromRepo.downloadAndUnzipJarForUnix(oldMavenJarFile, new URL(latestArtifactLocation), fileDAO);
            }
            try {
                Process launchedJar = null;
                if (startDownloadedVersion) {
                    launchedJar = DownloadLatestZipFromRepo.launchJar(downloadedJarFile, args);
                }
                if (deleteOldFiles && launchedJar != null) {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                File jarParent = new File(jarPath.toURI()).getParentFile();
                                if (jarParent.exists()) {
                                    FileUtils.deleteDirectory((File)jarParent);
                                }
                            }
                            catch (URISyntaxException ex) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    launchedJar.waitFor();
                }
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("jvm ended unexpectedly, old files have not been deleted");
            }
        }
    }

    private static Process launchJar(MavenJarFile downloadedFile, String[] args) throws NullPointerException, IOException {
        Process jar;
        ArrayList<String> processToRun = new ArrayList<String>();
        try {
            processToRun.add("java");
            processToRun.add("-jar");
            processToRun.add(downloadedFile.getAbsoluteFilePath());
            processToRun.addAll(Arrays.asList(args));
            ProcessBuilder p = new ProcessBuilder(processToRun);
            jar = p.start();
        }
        catch (NullPointerException npe) {
            throw new IOException("could not start the jar");
        }
        return jar;
    }

    private static MavenJarFile downloadAndUnzipJarForWindows(MavenJarFile mavenJarFile, URL jarRepository, FileDAO fileDAO, boolean cleanupZipFile) throws MalformedURLException, IOException, XMLStreamException {
        URL archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".zip", false);
        String folderName = archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/"), archiveURL.getFile().lastIndexOf(".zip"));
        File downloadFolder = new File(fileDAO.getLocationToDownloadOnDisk(new File(mavenJarFile.getAbsoluteFilePath()).getParent()), folderName);
        if (!downloadFolder.exists() && !downloadFolder.mkdirs()) {
            throw new IOException("could not make the directories needed to download the file in");
        }
        File downloadedFile = fileDAO.writeStreamToDisk(archiveURL.openStream(), archiveURL.getFile().substring(archiveURL.getFile().lastIndexOf("/")), downloadFolder);
        fileDAO.unzipFile(new ZipFile(downloadedFile), downloadFolder);
        MavenJarFile newMavenJar = fileDAO.getMavenJarFileFromFolderWithArtifactId(downloadFolder, mavenJarFile.getArtifactId());
        if (cleanupZipFile && !downloadedFile.delete()) {
            throw new IOException("could not delete the zip file");
        }
        return newMavenJar;
    }

    private static MavenJarFile downloadAndUnzipJarForUnix(MavenJarFile oldMavenJarFile, URL jarRepository, FileDAO fileDAO) throws MalformedURLException, IOException, XMLStreamException {
        URL archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".tar.gz", true);
        if (archiveURL == null) {
            archiveURL = WebDAO.getUrlOfZippedVersion(jarRepository, ".zip", true);
        }
        File downloadFolder = new File(fileDAO.getLocationToDownloadOnDisk(oldMavenJarFile.getAbsoluteFilePath()), archiveURL.getFile());
        fileDAO.unGzipAndUntarFile(new GZIPInputStream(archiveURL.openStream()), downloadFolder);
        MavenJarFile downloadedJarFile = fileDAO.getMavenJarFileFromFolderWithArtifactId(downloadFolder, oldMavenJarFile.getArtifactId());
        return downloadedJarFile;
    }
}

