/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.autoupdater;

import com.compomics.software.autoupdater.MavenJarFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.jimmc.jshortcut.JShellLink;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;

public abstract class FileDAO {
    public abstract boolean createDesktopShortcut(MavenJarFile var1, String var2, boolean var3) throws IOException;

    public boolean addShortcutAtDeskTop(MavenJarFile mavenJarFile) {
        return this.addShortcutAtDeskTop(mavenJarFile, null);
    }

    public boolean addShortcutAtDeskTop(MavenJarFile mavenJarFile, String iconName) throws NullPointerException, RuntimeException {
        JShellLink link = new JShellLink();
        link.setFolder(JShellLink.getDirectory((String)"desktop"));
        link.setName(mavenJarFile.getArtifactId() + "-" + mavenJarFile.getVersionNumber());
        if (iconName != null) {
            link.setIconLocation(mavenJarFile.getAbsoluteFilePath() + "/resources/" + iconName);
        }
        link.setPath(mavenJarFile.getAbsoluteFilePath());
        link.save();
        return true;
    }

    public abstract File getLocationToDownloadOnDisk(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unzipFile(ZipFile zip, File fileLocationOnDiskToDownloadTo) throws IOException {
        FileOutputStream dest = null;
        InputStream inStream = null;
        Enumeration<? extends ZipEntry> zipFileEnum = zip.entries();
        while (zipFileEnum.hasMoreElements()) {
            ZipEntry entry = zipFileEnum.nextElement();
            File destFile = new File(String.format("%s/%s", fileLocationOnDiskToDownloadTo, entry.getName()));
            if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
                throw new IOException("could not create the folders to unzip in");
            }
            if (!entry.isDirectory()) {
                try {
                    dest = new FileOutputStream(destFile);
                    inStream = zip.getInputStream(entry);
                    IOUtils.copyLarge((InputStream)inStream, (OutputStream)dest);
                    continue;
                }
                finally {
                    if (dest != null) {
                        dest.close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                    continue;
                }
            }
            if (destFile.exists() || destFile.mkdirs()) continue;
            throw new IOException("could not create folders to unzip file");
        }
        zip.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unGzipAndUntarFile(GZIPInputStream in, File fileLocationOnDiskToDownloadTo) throws IOException {
        InputStreamReader isr = new InputStreamReader(in);
        char[] data = new char[1024];
        BufferedWriter dest = null;
        try {
            int count;
            dest = new BufferedWriter(new FileWriter(fileLocationOnDiskToDownloadTo), 1024);
            while ((count = isr.read(data, 0, 1024)) != -1) {
                dest.write(data, 0, count);
            }
        }
        finally {
            if (dest != null) {
                dest.close();
            }
        }
        isr.close();
        this.untar(fileLocationOnDiskToDownloadTo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean untar(File fileToUntar) throws FileNotFoundException, IOException {
        boolean fileUntarred = false;
        String untarLocation = fileToUntar.getAbsolutePath();
        TarArchiveInputStream tarStream = null;
        try {
            tarStream = new TarArchiveInputStream((InputStream)new FileInputStream(fileToUntar));
            BufferedReader bufferedTarReader = null;
            try {
                ArchiveEntry entry;
                bufferedTarReader = new BufferedReader(new InputStreamReader((InputStream)tarStream));
                while ((entry = tarStream.getNextEntry()) != null) {
                    char[] cbuf = new char[1024];
                    OutputStreamWriter out = null;
                    try {
                        int count;
                        out = new FileWriter(new File(String.format("%s/%s", untarLocation, entry.getName())));
                        while ((count = bufferedTarReader.read(cbuf, 0, 1024)) != -1) {
                            out.write(cbuf, 0, count);
                        }
                        out.flush();
                    }
                    finally {
                        if (out == null) continue;
                        out.close();
                    }
                }
            }
            finally {
                if (bufferedTarReader != null) {
                    bufferedTarReader.close();
                }
            }
        }
        finally {
            if (tarStream != null) {
                tarStream.close();
            }
        }
        return fileUntarred;
    }

    public MavenJarFile getMavenJarFileFromFolderWithArtifactId(File folder, String artifactId) throws IOException {
        MavenJarFile mainJarFile = null;
        for (File aFile : folder.listFiles()) {
            if (aFile.isDirectory()) {
                mainJarFile = this.getMavenJarFileFromFolderWithArtifactId(aFile, artifactId);
                if (mainJarFile == null) continue;
                break;
            }
            if (!aFile.getName().contains(artifactId) || !aFile.getName().contains("jar")) continue;
            mainJarFile = new MavenJarFile(aFile);
            break;
        }
        return mainJarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeStreamToDisk(InputStream in, String name, File outputLocationFolder) throws FileNotFoundException, IOException {
        if (!outputLocationFolder.exists() && !outputLocationFolder.mkdirs()) {
            throw new IOException("could not create the folders to write stream to disk");
        }
        File outputFile = new File(outputLocationFolder, name);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        in.close();
        return outputFile;
    }
}

