/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.autoupdater;

import com.compomics.software.autoupdater.CompareVersionNumbers;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class MetaDataXMLParser {
    private String highestVersionNumber;
    private XMLEvent XMLEvent;

    public MetaDataXMLParser(XMLEventReader xmlReader) throws XMLStreamException {
        while (xmlReader.hasNext()) {
            this.XMLEvent = xmlReader.nextEvent();
            if (!this.XMLEvent.isStartElement() || !this.XMLEvent.asStartElement().getName().getLocalPart().equalsIgnoreCase("versions")) continue;
            this.parseVersionNumbers(xmlReader);
            break;
        }
    }

    public String getHighestVersionNumber() {
        return this.highestVersionNumber;
    }

    private void parseVersionNumbers(XMLEventReader xmlReader) throws XMLStreamException {
        CompareVersionNumbers versionNumberComparator = new CompareVersionNumbers();
        while (xmlReader.hasNext()) {
            this.XMLEvent = xmlReader.nextEvent();
            if (this.XMLEvent.isStartElement()) {
                if (!this.XMLEvent.asStartElement().getName().getLocalPart().equalsIgnoreCase("version")) continue;
                if (this.highestVersionNumber == null) {
                    this.highestVersionNumber = xmlReader.nextEvent().asCharacters().getData();
                    continue;
                }
                String versionNumberToCompareWith = xmlReader.nextEvent().asCharacters().getData();
                if (versionNumberComparator.compare(this.highestVersionNumber, versionNumberToCompareWith) != 1) continue;
                this.highestVersionNumber = versionNumberToCompareWith;
                continue;
            }
            if (!this.XMLEvent.isEndElement() || !this.XMLEvent.asEndElement().getName().getLocalPart().equalsIgnoreCase("versions")) continue;
            break;
        }
    }
}

