/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.Util;
import com.compomics.util.db.ObjectsCache;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.rowset.serial.SerialBlob;

public class ObjectsDB
implements Serializable {
    static final long serialVersionUID = -8595805180622832745L;
    private String dbName;
    private Connection dbConnection;
    private ArrayList<String> longKeys = new ArrayList();
    private ObjectsCache objectsCache;
    private BufferedWriter debugSpeedWriter;
    private BufferedWriter debugContentWriter;
    private File debugFolder;
    private boolean busy = false;
    private String tableQueueUpdating = "";
    private ArrayList<String> tableQueue = new ArrayList();
    private HashMap<String, ArrayList<String>> contentQueue = new HashMap();
    private ArrayList<String> contentTableQueue = new ArrayList();
    private boolean debugSpeed = false;
    private boolean debugContent = false;
    private boolean debugInteractions = false;
    private boolean useSQLite = false;

    public ObjectsDB(String folder, String dbName, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        this.dbName = dbName;
        objectsCache.addDb(this);
        this.establishConnection(folder, deleteOldDatabase, objectsCache);
    }

    public String getName() {
        if (this.dbName == null) {
            this.dbName = "old_idDB";
        }
        return this.dbName;
    }

    public ObjectsCache getObjectsCache() {
        return this.objectsCache;
    }

    public void setObjectCache(ObjectsCache objectCache) {
        this.objectsCache = objectCache;
        objectCache.addDb(this);
    }

    public void addTable(String tableName) throws SQLException {
        if (tableName.length() >= 128) {
            int index = this.longKeys.size();
            this.longKeys.add(tableName);
            tableName = index + "";
        }
        if (this.debugInteractions) {
            System.out.println("Inserting table, table:" + tableName);
        }
        Statement stmt = this.dbConnection.createStatement();
        stmt.execute("CREATE table " + tableName + " (" + "NAME VARCHAR(32672) PRIMARY KEY," + "MATCH_BLOB blob" + ")");
        stmt.close();
    }

    public void insertObject(String tableName, String objectKey, Object object, boolean inCache) throws SQLException, IOException {
        if (inCache) {
            this.objectsCache.addObject(this.dbName, tableName, objectKey, object, true);
        } else {
            if (this.debugInteractions) {
                System.out.println("Inserting single object, table:" + tableName + ", key: " + objectKey);
            }
            PreparedStatement ps = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
            ps.setString(1, objectKey);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.close();
            bos.close();
            ps.setBytes(2, bos.toByteArray());
            ps.executeUpdate();
        }
    }

    public void insertObjects(String tableName, HashMap<String, Object> objects, WaitingHandler waitingHandler) throws SQLException, IOException {
        this.insertObjects(tableName, objects, waitingHandler, false);
    }

    public void insertObjects(String tableName, HashMap<String, Object> objects, WaitingHandler waitingHandler, boolean allNewObjects) throws SQLException, IOException {
        if (this.debugInteractions) {
            System.out.println("Preparing table insertion:" + tableName);
        }
        PreparedStatement insertStatement = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
        PreparedStatement updateStatement = this.dbConnection.prepareStatement("UPDATE " + tableName + " SET MATCH_BLOB=? WHERE NAME=?");
        this.dbConnection.setAutoCommit(false);
        ArrayList<Object> tableContent = new ArrayList();
        if (!allNewObjects) {
            tableContent = this.tableContent(tableName);
        }
        int rowCounter = 0;
        for (String objectKey : objects.keySet()) {
            if (this.debugContent) {
                if (this.debugInteractions) {
                    System.out.println("Inserting batch of objects, table:" + tableName + ", key: " + objectKey);
                }
                File debugObjectFile = new File(this.debugFolder, "debugMatch");
                FileOutputStream fos = new FileOutputStream(debugObjectFile);
                BufferedOutputStream debugBos = new BufferedOutputStream(fos);
                ObjectOutputStream debugOos = new ObjectOutputStream(debugBos);
                debugOos.writeObject(objects.get(objectKey));
                debugOos.close();
                debugBos.close();
                fos.close();
                long size = debugObjectFile.length();
                this.debugContentWriter.write(tableName + "\t" + objectKey + "\t" + size + "\n");
                this.debugContentWriter.flush();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(objects.get(objectKey));
            if (!allNewObjects && tableContent.contains(objectKey)) {
                updateStatement.setString(2, objectKey);
                updateStatement.setBytes(1, bos.toByteArray());
                updateStatement.addBatch();
            } else {
                insertStatement.setString(1, objectKey);
                insertStatement.setBytes(2, bos.toByteArray());
                insertStatement.addBatch();
            }
            if (++rowCounter % this.objectsCache.getBatchSize() == 0) {
                updateStatement.executeBatch();
                insertStatement.executeBatch();
                updateStatement.clearParameters();
                insertStatement.clearParameters();
                this.dbConnection.commit();
                rowCounter = 0;
            }
            oos.close();
            bos.close();
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
            updateStatement.executeBatch();
            insertStatement.executeBatch();
            updateStatement.clearParameters();
            insertStatement.clearParameters();
            this.dbConnection.commit();
        }
        this.dbConnection.setAutoCommit(true);
        updateStatement.close();
        insertStatement.close();
    }

    public synchronized void loadObjects(String tableName, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (!this.busy && (this.tableQueue.isEmpty() || this.tableQueue.indexOf(tableName) == 0)) {
            ResultSet results;
            if (this.debugInteractions) {
                System.out.println("getting table objects, table:" + tableName);
            }
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                Statement rowCountStatement = this.dbConnection.createStatement();
                results = rowCountStatement.executeQuery("select count(*) from " + tableName);
                results.next();
                Integer numberOfRows = results.getInt(1);
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setSecondaryProgressCounter(0);
                waitingHandler.setMaxSecondaryProgressCounter(numberOfRows);
            }
            this.busy = true;
            Statement stmt = this.dbConnection.createStatement();
            results = stmt.executeQuery("select * from " + tableName);
            while (results.next()) {
                Blob tempBlob;
                String key;
                if (waitingHandler != null) {
                    waitingHandler.increaseSecondaryProgressCounter();
                    if (waitingHandler.isRunCanceled()) break;
                }
                if (this.objectsCache.inCache(this.dbName, tableName, key = results.getString(1))) continue;
                if (this.useSQLite) {
                    byte[] bytes = results.getBytes(2);
                    tempBlob = new SerialBlob(bytes);
                } else {
                    tempBlob = results.getBlob(2);
                }
                BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
                ObjectInputStream in = new ObjectInputStream(bis);
                Object object = in.readObject();
                in.close();
                this.objectsCache.addObject(this.dbName, tableName, key, object, false);
            }
            results.close();
            stmt.close();
            this.busy = false;
            this.tableQueue.remove(tableName);
        } else {
            if (!this.tableQueue.contains(tableName)) {
                this.tableQueue.add(tableName);
            }
            this.wait(11L);
            this.loadObjects(tableName, waitingHandler);
        }
    }

    public synchronized void loadObjects(String tableName, ArrayList<String> keys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (!this.busy && (this.contentTableQueue.isEmpty() || this.contentTableQueue.indexOf(tableName) == 0)) {
            if (this.debugInteractions) {
                System.out.println("getting " + keys.size() + " objects, table:" + tableName);
            }
            boolean concurrentAccess = this.tableQueueUpdating.equals(tableName);
            ArrayList<Object> queue = new ArrayList();
            if (!concurrentAccess && this.contentQueue.get(tableName) != null) {
                queue = this.contentQueue.get(tableName);
                this.contentTableQueue.remove(tableName);
                this.contentQueue.remove(tableName);
            }
            if (!keys.equals(queue)) {
                for (String key : keys) {
                    if (queue.contains(key)) continue;
                    queue.add(key);
                }
            }
            ArrayList<String> toLoad = new ArrayList<String>();
            for (String string : queue) {
                if (this.objectsCache == null || this.objectsCache.inCache(this.dbName, tableName, string)) continue;
                toLoad.add(string);
            }
            if (!toLoad.isEmpty()) {
                this.busy = true;
                Statement stmt = this.dbConnection.createStatement();
                ResultSet resultSet = stmt.executeQuery("select * from " + tableName);
                int found = 0;
                while (resultSet.next() && found < toLoad.size()) {
                    String key = resultSet.getString(1);
                    if (toLoad.contains(key)) {
                        Blob tempBlob;
                        ++found;
                        if (this.useSQLite) {
                            byte[] bytes = resultSet.getBytes(2);
                            tempBlob = new SerialBlob(bytes);
                        } else {
                            tempBlob = resultSet.getBlob(2);
                        }
                        BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
                        ObjectInputStream in = new ObjectInputStream(bis);
                        Object object = in.readObject();
                        in.close();
                        bis.close();
                        this.objectsCache.addObject(this.dbName, tableName, key, object, false);
                        if (waitingHandler != null) {
                            waitingHandler.increaseSecondaryProgressCounter();
                        }
                    }
                    if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                    break;
                }
                resultSet.close();
                stmt.close();
                this.busy = false;
            }
        } else {
            this.tableQueueUpdating = tableName;
            if (!this.contentTableQueue.contains(tableName)) {
                this.contentTableQueue.add(tableName);
                this.contentQueue.put(tableName, keys);
            } else if (keys.equals(this.contentQueue.get(tableName))) {
                this.wait(7L);
                this.loadObjects(tableName, keys, waitingHandler);
            } else {
                ArrayList<String> queue = this.contentQueue.get(tableName);
                for (String newItem : keys) {
                    if (queue.contains(newItem)) continue;
                    queue.add(newItem);
                }
            }
            this.tableQueueUpdating = "";
        }
    }

    public Object retrieveObject(String tableName, String objectKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException {
        return this.retrieveObject(tableName, objectKey, useDB, true);
    }

    public Object retrieveObject(String tableName, String objectKey, boolean useDB, boolean useCache) throws SQLException, IOException, ClassNotFoundException {
        Object object = null;
        if (this.objectsCache != null) {
            object = this.objectsCache.getObject(this.dbName, tableName, objectKey);
        }
        if (!useDB || object != null) {
            return object;
        }
        if (this.debugInteractions) {
            System.out.println("Retrieving object, table:" + tableName + ", key: " + objectKey);
        }
        if (this.dbConnection == null) {
            return object;
        }
        long start = System.currentTimeMillis();
        Statement stmt = this.dbConnection.createStatement();
        ResultSet results = stmt.executeQuery("select MATCH_BLOB from " + tableName + " where NAME='" + objectKey + "'");
        if (results.next()) {
            Blob tempBlob;
            if (this.useSQLite) {
                byte[] bytes = results.getBytes(1);
                tempBlob = new SerialBlob(bytes);
            } else {
                tempBlob = results.getBlob(1);
            }
            BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
            ObjectInputStream in = new ObjectInputStream(bis);
            object = in.readObject();
            in.close();
            results.close();
            stmt.close();
            if (useCache) {
                this.objectsCache.addObject(this.dbName, tableName, objectKey, object, false);
            }
            if (this.debugSpeed) {
                long loaded = System.currentTimeMillis();
                File debugObjectFile = new File(this.debugFolder, "debugMatch");
                FileOutputStream fos = new FileOutputStream(debugObjectFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(object);
                oos.close();
                bos.close();
                fos.close();
                long written = System.currentTimeMillis();
                FileInputStream fis = new FileInputStream(debugObjectFile);
                bis = new BufferedInputStream(fis);
                in = new ObjectInputStream(bis);
                Object match = in.readObject();
                fis.close();
                bis.close();
                in.close();
                long read = System.currentTimeMillis();
                long size = debugObjectFile.length();
                long queryTime = loaded - start;
                long serializationTime = written - loaded;
                long deserializationTime = read - written;
                this.debugSpeedWriter.write(tableName + "\t" + objectKey + "\t" + queryTime + "\t" + serializationTime + "\t" + deserializationTime + "\t" + size + "\n");
            }
            return object;
        }
        results.close();
        stmt.close();
        return null;
    }

    public boolean inDB(String tableName, String objectKey, boolean cache) throws SQLException {
        if (cache && this.objectsCache.inCache(this.dbName, tableName, objectKey)) {
            return true;
        }
        if (this.debugInteractions) {
            System.out.println("checking db content, table:" + tableName + ", key: " + objectKey);
        }
        Statement stmt = this.dbConnection.createStatement();
        ResultSet results = stmt.executeQuery("select * from " + tableName + " where NAME='" + objectKey + "'");
        boolean result = results.next();
        results.close();
        stmt.close();
        return result;
    }

    public ArrayList<String> tableContent(String tableName) throws SQLException {
        if (this.debugInteractions) {
            System.out.println("checking db content, table:" + tableName);
        }
        Statement stmt = this.dbConnection.createStatement();
        ResultSet results = stmt.executeQuery("select * from " + tableName);
        ArrayList<String> tableContent = new ArrayList<String>();
        while (results.next()) {
            tableContent.add(results.getString(1));
        }
        results.close();
        stmt.close();
        return tableContent;
    }

    public void deleteObject(String tableName, String objectKey) throws SQLException, IOException {
        this.objectsCache.removeObject(this.dbName, tableName, objectKey);
        if (this.debugInteractions) {
            System.out.println("Removing object, table:" + tableName + ", key: " + objectKey);
        }
        Statement stmt = this.dbConnection.createStatement();
        stmt.executeUpdate("delete from " + tableName + " where NAME='" + objectKey + "'");
        stmt.close();
    }

    public void updateObject(String tableName, String objectKey, Object object) throws SQLException, IOException {
        this.updateObject(tableName, objectKey, object, true);
    }

    public void updateObject(String tableName, String objectKey, Object object, boolean cache) throws SQLException, IOException {
        boolean cacheUpdated = false;
        if (cache) {
            cacheUpdated = this.objectsCache.updateObject(this.dbName, tableName, objectKey, object);
        }
        if (!cacheUpdated) {
            if (this.debugInteractions) {
                System.out.println("Updating object, table:" + tableName + ", key: " + objectKey);
            }
            PreparedStatement ps = this.dbConnection.prepareStatement("update " + tableName + " set MATCH_BLOB=? where NAME='" + objectKey + "'");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.close();
            bos.close();
            ps.setBytes(1, bos.toByteArray());
            ps.executeUpdate();
        }
    }

    public void close() throws SQLException {
        block10: {
            this.objectsCache = null;
            if (this.dbConnection != null) {
                this.dbConnection.close();
            }
            if (!this.useSQLite) {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true;deregister=false");
                }
                catch (SQLException e) {
                    if (e.getMessage().indexOf("Derby system shutdown") != -1) break block10;
                    e.printStackTrace();
                }
            }
        }
        if (this.debugSpeed && this.debugSpeedWriter != null) {
            try {
                this.debugSpeedWriter.close();
                this.debugSpeedWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugContent && this.debugContentWriter != null) {
            try {
                this.debugContentWriter.close();
                this.debugContentWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dbConnection = null;
    }

    public void establishConnection(String aDbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        File parentFolder = new File(aDbFolder);
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        File dbFolder = new File(aDbFolder, this.dbName);
        String path = dbFolder.getAbsolutePath();
        if (dbFolder.exists() && deleteOldDatabase) {
            this.close();
            boolean deleted = Util.deleteDir(dbFolder);
            if (!deleted) {
                System.out.println("Failed to delete db folder: " + dbFolder.getPath());
            }
        }
        if (this.useSQLite) {
            try {
                Class.forName("org.sqlite.JDBC");
                this.dbConnection = DriverManager.getConnection("jdbc:sqlite:" + path);
            }
            catch (SQLException e) {
                String url = "jdbc:derby:" + path + ";create=true";
                this.dbConnection = DriverManager.getConnection(url);
                this.useSQLite = false;
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        } else {
            String url = "jdbc:derby:" + path + ";create=true";
            this.dbConnection = DriverManager.getConnection(url);
        }
        this.objectsCache = objectsCache;
        if (this.debugSpeed) {
            try {
                this.debugFolder = new File(aDbFolder);
                this.debugSpeedWriter = new BufferedWriter(new FileWriter(new File(parentFolder, "dbSpeed.txt")));
                this.debugSpeedWriter.write("Table\tkey\tQuery time\tSerialization time\tDeserialization time\tsize\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugContent) {
            try {
                this.debugFolder = new File(aDbFolder);
                String tempFileName = "dbContent.txt";
                int counter = 1;
                while (new File(parentFolder, tempFileName).exists()) {
                    tempFileName = "dbContent" + counter++ + ".txt";
                }
                this.debugContentWriter = new BufferedWriter(new FileWriter(new File(parentFolder, tempFileName)));
                this.debugContentWriter.write("Table\tkey\tsize\n");
                this.debugContentWriter.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String correctTableName(String tableName) {
        tableName = "\"" + tableName + "\"";
        if (this.longKeys.contains(tableName)) {
            tableName = this.longKeys.indexOf(tableName) + "";
        }
        return tableName;
    }
}

