/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.examples;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;

public class HelpWindow
extends JFrame {
    private JButton closeJButton;
    private JScrollPane jScrollPane1;
    private JEditorPane textJEditorPane;

    public HelpWindow(JFrame parent, URL fileName) {
        this.initComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")));
        try {
            InputStream stream = fileName.openStream();
            InputStreamReader streamReader = new InputStreamReader(stream);
            BufferedReader b = new BufferedReader(streamReader);
            String s = b.readLine();
            String helpText = "";
            while (s != null) {
                helpText = helpText + s;
                s = b.readLine();
            }
            b.close();
            streamReader.close();
            stream.close();
            this.textJEditorPane.setText(helpText);
        }
        catch (Exception e) {
            this.textJEditorPane.setText("The selected help file is not yet available.");
        }
        this.textJEditorPane.setCaretPosition(0);
        this.setSize(450, 500);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public HelpWindow(JDialog parent, URL fileName) {
        this.initComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")));
        try {
            InputStream stream = fileName.openStream();
            InputStreamReader streamReader = new InputStreamReader(stream);
            BufferedReader b = new BufferedReader(streamReader);
            String s = b.readLine();
            String helpText = "";
            while (s != null) {
                helpText = helpText + s;
                s = b.readLine();
            }
            b.close();
            streamReader.close();
            stream.close();
            this.textJEditorPane.setText(helpText);
        }
        catch (Exception e) {
            this.textJEditorPane.setText("The selected help file is not yet available.");
        }
        this.textJEditorPane.setCaretPosition(0);
        this.setSize(450, 500);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.closeJButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textJEditorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Compomics-Utilites - Help");
        this.setAlwaysOnTop(true);
        this.closeJButton.setText("Close");
        this.closeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpWindow.this.closeJButtonActionPerformed(evt);
            }
        });
        this.textJEditorPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.textJEditorPane.setContentType("text/html");
        this.textJEditorPane.setEditable(false);
        this.textJEditorPane.setMinimumSize(new Dimension(10, 10));
        this.textJEditorPane.setPreferredSize(new Dimension(10, 10));
        this.textJEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                HelpWindow.this.textJEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.textJEditorPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jScrollPane1, -1, 235, Short.MAX_VALUE).add((Component)this.closeJButton)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 494, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.closeJButton).addContainerGap()));
        this.pack();
    }

    private void closeJButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void textJEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ENTERED.toString())) {
            this.setCursor(new Cursor(12));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.EXITED.toString())) {
            this.setCursor(new Cursor(0));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            if (evt.getDescription().startsWith("#")) {
                this.textJEditorPane.scrollToReference(evt.getDescription());
            } else {
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(evt.getDescription());
                this.setCursor(new Cursor(0));
            }
        }
    }
}

