/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.annotation.go;

import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class GOFactory {
    private static GOFactory instance = null;
    private BufferedRandomAccessFile bufferedRandomAccessFile = null;
    public static final String separator = "\t";
    private HashMap<String, ArrayList<Long>> proteinIndexes = new HashMap();
    private HashMap<String, ArrayList<Long>> termIndexes = new HashMap();
    private HashMap<String, ArrayList<Long>> termNameIndexes = new HashMap();
    private boolean mappingFileOpen = false;

    public static GOFactory getInstance() {
        if (instance == null) {
            instance = new GOFactory();
        }
        return instance;
    }

    private GOFactory() {
    }

    public void initialize(File file, WaitingHandler waitingHandler) throws IOException {
        String line;
        this.clearFactory();
        if (this.bufferedRandomAccessFile != null) {
            this.bufferedRandomAccessFile.close();
        }
        this.bufferedRandomAccessFile = new BufferedRandomAccessFile(file, "r", 102400);
        this.mappingFileOpen = true;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        long progressUnit = this.bufferedRandomAccessFile.length() / 100L;
        long index = this.bufferedRandomAccessFile.getFilePointer();
        while ((line = this.bufferedRandomAccessFile.readLine()) != null) {
            String[] splittedLine = line.split(separator);
            if (splittedLine.length == 3 && !splittedLine[0].equals("") && !splittedLine[1].equals("")) {
                String accession = splittedLine[0];
                ArrayList<Long> indexes = this.proteinIndexes.get(accession);
                if (indexes == null) {
                    indexes = new ArrayList();
                    this.proteinIndexes.put(accession, indexes);
                }
                indexes.add(index);
                String goTermId = splittedLine[1];
                indexes = this.termIndexes.get(goTermId);
                if (indexes == null) {
                    indexes = new ArrayList();
                    this.termIndexes.put(goTermId, indexes);
                }
                indexes.add(index);
                String goTerm = splittedLine[2].toLowerCase();
                indexes = this.termNameIndexes.get(goTerm);
                if (indexes == null) {
                    indexes = new ArrayList();
                    this.termNameIndexes.put(goTerm, indexes);
                }
                indexes.add(index);
            }
            index = this.bufferedRandomAccessFile.getFilePointer();
            if (waitingHandler == null) continue;
            waitingHandler.setSecondaryProgressCounter((int)(index / progressUnit));
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
    }

    public ArrayList<String> getGoAccessions(String proteinAccession) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Long> indexes = this.proteinIndexes.get(proteinAccession);
        if (indexes != null) {
            for (long index : indexes) {
                this.bufferedRandomAccessFile.seek(index);
                String line = this.bufferedRandomAccessFile.getNextLine();
                String[] splittedLine = line.split(separator);
                if (splittedLine.length != 3 || !splittedLine[0].equals(proteinAccession)) {
                    throw new IllegalArgumentException("Line \"" + line + "\" at index " + index + " does not correspond to accession " + proteinAccession + ".");
                }
                result.add(splittedLine[1]);
            }
        }
        return result;
    }

    public ArrayList<String> getProteinGoAccessions(String matchKey) throws IOException {
        String[] accessions = ProteinMatch.getAccessions(matchKey);
        ArrayList<String> goAccessions = new ArrayList<String>();
        for (String accession : accessions) {
            for (String goTerm : this.getGoAccessions(accession)) {
                if (goAccessions.contains(goTerm)) continue;
                goAccessions.add(goTerm);
            }
        }
        return goAccessions;
    }

    public ArrayList<String> getProteinGoDescriptions(String matchKey) throws IOException {
        String[] accessions = ProteinMatch.getAccessions(matchKey);
        ArrayList<String> goDescriptions = new ArrayList<String>();
        for (String accession : accessions) {
            for (String goAccession : this.getGoAccessions(accession)) {
                String goDescription = this.getTermDescription(goAccession).toLowerCase();
                if (goDescriptions.contains(goDescription)) continue;
                goDescriptions.add(goDescription);
            }
        }
        return goDescriptions;
    }

    public ArrayList<String> getAccessions(String goAccession) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Long> indexes = this.termIndexes.get(goAccession);
        if (indexes != null) {
            for (long index : indexes) {
                this.bufferedRandomAccessFile.seek(index);
                String line = this.bufferedRandomAccessFile.getNextLine();
                String[] splittedLine = line.split(separator);
                if (splittedLine.length != 3 || !splittedLine[1].equals(goAccession)) {
                    throw new IllegalArgumentException("Line \"" + line + "\" at index " + index + " does not correspond to GO accession " + goAccession + ".");
                }
                result.add(splittedLine[0]);
            }
        }
        return result;
    }

    public String getTermDescription(String goAccession) throws IOException {
        ArrayList<Long> indexes = this.termIndexes.get(goAccession);
        if (indexes != null && !indexes.isEmpty()) {
            long index = indexes.get(0);
            this.bufferedRandomAccessFile.seek(index);
            String line = this.bufferedRandomAccessFile.getNextLine();
            String[] splittedLine = line.split(separator);
            if (splittedLine.length != 3 || !splittedLine[1].equals(goAccession)) {
                throw new IllegalArgumentException("Line \"" + line + "\" at index " + index + " does not correspond to GO accession " + goAccession + ".");
            }
            return splittedLine[2];
        }
        return null;
    }

    public String getTermAccession(String goTerm) throws IOException {
        ArrayList<Long> indexes = this.termNameIndexes.get(goTerm = goTerm.toLowerCase());
        if (indexes != null && !indexes.isEmpty()) {
            long index = indexes.get(0);
            this.bufferedRandomAccessFile.seek(index);
            String line = this.bufferedRandomAccessFile.getNextLine();
            String[] splittedLine = line.split(separator);
            if (splittedLine.length != 3 || !splittedLine[2].equalsIgnoreCase(goTerm)) {
                throw new IllegalArgumentException("Line \"" + line + "\" at index " + index + " does not correspond to GO term " + goTerm + ".");
            }
            return splittedLine[1];
        }
        return null;
    }

    public int getNumberOfProteins() {
        return this.proteinIndexes.size();
    }

    public int getNumberOfTerms() {
        return this.termIndexes.size();
    }

    public int getNProteinsForTerm(String goAccession) {
        ArrayList<Long> indexes = this.termIndexes.get(goAccession);
        if (indexes == null) {
            return 0;
        }
        return indexes.size();
    }

    public int getNTermsForProtein(String accession) {
        ArrayList<Long> indexes = this.termIndexes.get(accession);
        if (indexes == null) {
            return 0;
        }
        return indexes.size();
    }

    public ArrayList<String> getProteinMapped() {
        return new ArrayList<String>(this.proteinIndexes.keySet());
    }

    public ArrayList<String> getTermsMapped() {
        return new ArrayList<String>(this.termIndexes.keySet());
    }

    public ArrayList<String> getTermNamesMapped() {
        return new ArrayList<String>(this.termNameIndexes.keySet());
    }

    public void closeFiles() throws IOException {
        if (this.bufferedRandomAccessFile != null) {
            this.bufferedRandomAccessFile.close();
            this.mappingFileOpen = false;
        }
    }

    public void clearFactory() {
        this.proteinIndexes.clear();
        this.termIndexes.clear();
        this.termNameIndexes.clear();
    }

    public boolean isMappingFileOpen() {
        return this.mappingFileOpen;
    }
}

