/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AminoAcidPattern
implements Serializable {
    static final long serialVersionUID = -2823716418631089876L;
    private Integer target;
    private HashMap<Integer, ArrayList<AminoAcid>> aaTargeted = new HashMap();
    private HashMap<Integer, ArrayList<AminoAcid>> aaExcluded = new HashMap();

    public AminoAcidPattern() {
        this.target = 0;
        this.aaTargeted.put(0, new ArrayList());
        this.aaExcluded.put(0, new ArrayList());
    }

    public AminoAcidPattern(String sequence) {
        this.target = 0;
        this.aaExcluded.put(0, new ArrayList());
        for (int i = 0; i < sequence.length(); ++i) {
            char letter = sequence.charAt(i);
            AminoAcid aa = AminoAcid.getAminoAcid(letter);
            ArrayList<AminoAcid> list = new ArrayList<AminoAcid>();
            list.add(aa);
            this.aaTargeted.put(i, list);
        }
    }

    public AminoAcidPattern(AminoAcidPattern aminoAcidPattern) {
        this.target = aminoAcidPattern.getTarget();
        for (int index = 0; index < aminoAcidPattern.length(); ++index) {
            this.aaTargeted.put(index, aminoAcidPattern.getTargetedAA(index));
            this.aaExcluded.put(index, aminoAcidPattern.getExcludedAA(index));
        }
    }

    public AminoAcidPattern(ArrayList<String> targetTesidues) throws IllegalArgumentException {
        this.target = 0;
        Collections.sort(targetTesidues);
        ArrayList<AminoAcid> aminoAcids = new ArrayList<AminoAcid>();
        for (String letter : targetTesidues) {
            AminoAcid aa = AminoAcid.getAminoAcid(letter);
            if (aa != null) {
                aminoAcids.add(aa);
                continue;
            }
            throw new IllegalArgumentException("Amino acid not recognized " + letter + ".");
        }
        this.aaTargeted.put(0, aminoAcids);
    }

    public void swapRows(int fromRow, int toRow) throws IllegalArgumentException {
        if (this.aaTargeted.size() < fromRow || this.aaExcluded.size() < fromRow || fromRow < 0 || toRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + fromRow);
        }
        if (this.aaTargeted.size() < toRow || this.aaExcluded.size() < fromRow || toRow < 0 || fromRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + toRow);
        }
        ArrayList<AminoAcid> toRowDataTarget = this.aaTargeted.get(toRow);
        ArrayList<AminoAcid> toRowDataExcluded = this.aaExcluded.get(toRow);
        this.aaTargeted.put(toRow, this.aaTargeted.get(fromRow));
        this.aaExcluded.put(toRow, this.aaExcluded.get(fromRow));
        this.aaTargeted.put(fromRow, toRowDataTarget);
        this.aaExcluded.put(fromRow, toRowDataExcluded);
        if (this.target == fromRow) {
            this.target = toRow;
        } else if (this.target == toRow) {
            this.target = fromRow;
        }
    }

    public Integer getTarget() {
        return this.target;
    }

    public void setTarget(Integer target) {
        this.target = target;
    }

    public ArrayList<AminoAcid> getAminoAcidsAtTarget() {
        if (this.aaTargeted.containsKey(this.target)) {
            return this.aaTargeted.get(this.target);
        }
        return new ArrayList<AminoAcid>();
    }

    public void setTargeted(int index, ArrayList<AminoAcid> targets) {
        this.aaTargeted.put(index, targets);
    }

    public ArrayList<AminoAcid> getTargetedAA(int index) {
        return this.aaTargeted.get(index);
    }

    public ArrayList<AminoAcid> getExcludedAA(int index) {
        return this.aaExcluded.get(index);
    }

    public void setExcluded(int index, ArrayList<AminoAcid> exclusions) {
        this.aaExcluded.put(index, exclusions);
    }

    public void removeAA(int index) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(this.aaTargeted.keySet());
        Collections.sort(indexes);
        for (int aa : indexes) {
            if (aa < index) continue;
            if (aa > index) {
                this.aaTargeted.put(aa - 1, this.aaTargeted.get(aa));
            }
            this.aaTargeted.remove(aa);
        }
        indexes = new ArrayList<Integer>(this.aaExcluded.keySet());
        Collections.sort(indexes);
        for (int aa : indexes) {
            if (aa < index) continue;
            if (aa > index) {
                this.aaExcluded.put(aa - 1, this.aaExcluded.get(aa));
            }
            this.aaExcluded.remove(aa);
        }
    }

    public Pattern getAsStringPattern() {
        String regex = "";
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            ArrayList<AminoAcid> tempTarget = this.aaTargeted.get(i);
            ArrayList<String> toAdd = new ArrayList<String>();
            if (tempTarget == null || tempTarget.isEmpty()) {
                toAdd.addAll(AminoAcid.getAminoAcids());
            } else {
                for (AminoAcid aa : tempTarget) {
                    if (toAdd.contains(aa.singleLetterCode)) continue;
                    toAdd.add(aa.singleLetterCode);
                }
            }
            Collections.sort(toAdd);
            ArrayList<String> restrictions = new ArrayList<String>();
            ArrayList<AminoAcid> exclude = this.aaExcluded.get(i);
            if (exclude != null) {
                for (AminoAcid aminoAcid : exclude) {
                    if (restrictions.contains(aminoAcid.singleLetterCode)) continue;
                    restrictions.add(aminoAcid.singleLetterCode);
                }
            }
            regex = regex + "[";
            for (String string : toAdd) {
                if (restrictions.contains(string)) continue;
                regex = regex + string;
            }
            regex = regex + "]";
        }
        return Pattern.compile(regex, 2);
    }

    public ArrayList<Integer> getIndexes(String input) {
        Pattern pattern = this.getAsStringPattern();
        ArrayList<Integer> result = new ArrayList<Integer>();
        Matcher matcher = pattern.matcher(input);
        matcher.matches();
        int index = 0;
        while (matcher.find(index)) {
            index = matcher.start();
            result.add(index + this.target + 1);
            ++index;
        }
        return result;
    }

    public boolean matches(String aminoAcidSequence) {
        Pattern pattern = this.getAsStringPattern();
        Matcher matcher = pattern.matcher(aminoAcidSequence);
        return matcher.find();
    }

    public boolean isStarting(String aminoAcidSequence) {
        return this.matches(aminoAcidSequence.substring(0, this.length()));
    }

    public boolean isEnding(String aminoAcidSequence) {
        return this.matches(aminoAcidSequence.substring(aminoAcidSequence.length() - this.length()));
    }

    public boolean isSameAs(AminoAcidPattern anotherPattern) {
        return anotherPattern.getAsStringPattern().pattern().equalsIgnoreCase(this.getAsStringPattern().pattern());
    }

    public int length() {
        if (this.aaTargeted.isEmpty() && this.aaExcluded.isEmpty()) {
            return 1;
        }
        if (this.aaTargeted.isEmpty()) {
            return Collections.max(this.aaExcluded.keySet()) + 1;
        }
        if (this.aaExcluded.isEmpty()) {
            return Collections.max(this.aaTargeted.keySet()) + 1;
        }
        return Math.max(Collections.max(this.aaTargeted.keySet()), Collections.max(this.aaExcluded.keySet())) + 1;
    }

    public AminoAcidPattern getStandardSearchPattern() {
        AminoAcidPattern result = new AminoAcidPattern();
        result.setTarget(this.target);
        result.setTargeted(this.target, this.getAminoAcidsAtTarget());
        return result;
    }

    public static AminoAcidPattern getTrypsinExample() {
        AminoAcidPattern example = new AminoAcidPattern();
        example.setTarget(0);
        ArrayList<AminoAcid> target = new ArrayList<AminoAcid>();
        target.add(AminoAcid.K);
        target.add(AminoAcid.R);
        example.setTargeted(0, target);
        ArrayList<AminoAcid> exclusion = new ArrayList<AminoAcid>();
        exclusion.add(AminoAcid.P);
        example.setExcluded(1, exclusion);
        return example;
    }

    public void merge(AminoAcidPattern otherPattern) {
        for (int i = 0; i < otherPattern.length(); ++i) {
            if (otherPattern.getExcludedAA(i) != null && !otherPattern.getExcludedAA(i).isEmpty()) {
                if (this.aaExcluded.get(i) == null) {
                    this.aaExcluded.put(i, new ArrayList());
                }
                for (AminoAcid aa : otherPattern.getExcludedAA(i)) {
                    if (this.aaExcluded.get(i).contains(aa)) continue;
                    this.aaExcluded.get(i).add(aa);
                }
            }
            if (otherPattern.getTargetedAA(i) == null || otherPattern.getTargetedAA(i).isEmpty()) continue;
            if (this.aaTargeted.get(i) == null) {
                this.aaTargeted.put(i, new ArrayList());
            }
            for (AminoAcid aa : otherPattern.getTargetedAA(i)) {
                if (this.aaTargeted.get(i).contains(aa)) continue;
                this.aaTargeted.get(i).add(aa);
            }
        }
    }

    public static AminoAcidPattern merge(AminoAcidPattern pattern1, AminoAcidPattern pattern2) {
        AminoAcidPattern result = new AminoAcidPattern(pattern1);
        result.merge(pattern2);
        return result;
    }

    public String toString() {
        return this.getAsStringPattern().pattern();
    }
}

