/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;

public class PTM
extends ExperimentObject {
    static final long serialVersionUID = -545472596243822505L;
    public static final int MODAA = 0;
    public static final int MODN = 1;
    public static final int MODNAA = 2;
    public static final int MODC = 3;
    public static final int MODCAA = 4;
    public static final int MODNP = 5;
    public static final int MODNPAA = 6;
    public static final int MODCP = 7;
    public static final int MODCPAA = 8;
    public static final int MODMAX = 9;
    private int type;
    private ArrayList<String> residuesArray = new ArrayList();
    private String name;
    private String shortName;
    private double mass;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList();
    private ArrayList<ReporterIon> reporterIons = new ArrayList();
    private AminoAcidPattern pattern = new AminoAcidPattern();

    public PTM() {
    }

    public PTM(int type, String name, double mass, ArrayList<String> residuesArray) {
        this.type = type;
        this.name = name;
        this.mass = mass;
        this.residuesArray.addAll(residuesArray);
        this.pattern = new AminoAcidPattern(residuesArray);
    }

    public PTM(int type, String name, String shortName, double mass, ArrayList<String> residuesArray) {
        this.type = type;
        this.name = name;
        this.shortName = shortName;
        this.mass = mass;
        this.residuesArray.addAll(residuesArray);
        this.pattern = new AminoAcidPattern(residuesArray);
    }

    public PTM(int type, String name, double mass, AminoAcidPattern aminoAcidPattern) {
        this.type = type;
        this.name = name;
        this.mass = mass;
        this.pattern = aminoAcidPattern;
    }

    public PTM(int type, String name, String shortName, double mass, AminoAcidPattern aminoAcidPattern) {
        this.type = type;
        this.name = name;
        this.shortName = shortName;
        this.mass = mass;
        this.pattern = aminoAcidPattern;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public double getMass() {
        return this.mass;
    }

    public ArrayList<String> getResidues() {
        return this.residuesArray;
    }

    public boolean isSameAs(PTM anotherPTM) {
        return this.type == anotherPTM.getType() && this.mass == anotherPTM.getMass() && anotherPTM.getPattern().isSameAs(this.pattern);
    }

    public ArrayList<NeutralLoss> getNeutralLosses() {
        return this.neutralLosses;
    }

    public void setNeutralLosses(ArrayList<NeutralLoss> neutralLosses) {
        this.neutralLosses = neutralLosses;
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        this.neutralLosses.add(neutralLoss);
    }

    public ArrayList<ReporterIon> getReporterIons() {
        return this.reporterIons;
    }

    public void setReporterIons(ArrayList<ReporterIon> reporterIons) {
        this.reporterIons = reporterIons;
    }

    public void addReporterIon(ReporterIon reporterIon) {
        this.reporterIons.add(reporterIon);
    }

    public AminoAcidPattern getPattern() {
        if (this.pattern == null) {
            this.pattern = new AminoAcidPattern(this.residuesArray);
        }
        return this.pattern;
    }

    public void setPattern(AminoAcidPattern pattern) {
        this.pattern = pattern;
    }

    public boolean isStandardSearch() {
        return this.pattern.length() == 1;
    }

    public boolean isNTerm() {
        return this.type == 1 || this.type == 2 || this.type == 5 || this.type == 6;
    }

    public boolean isCTerm() {
        return this.type == 3 || this.type == 4 || this.type == 7 || this.type == 8;
    }
}

