/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ReporterIon
extends Ion {
    static final long serialVersionUID = 1109011048958734120L;
    private static HashMap<Integer, String> reporterIonTypes = new HashMap();
    public static final ReporterIon iTRAQ113 = new ReporterIon("iTRAQ113", 113.1075 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon iTRAQ114 = new ReporterIon("iTRAQ114", 114.111 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon iTRAQ115 = new ReporterIon("iTRAQ115", 115.1079 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon iTRAQ116 = new ReporterIon("iTRAQ116", 116.1113 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon iTRAQ117 = new ReporterIon("iTRAQ117", 117.11465 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon iTRAQ118 = new ReporterIon("iTRAQ118", 118.1117 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon iTRAQ119 = new ReporterIon("iTRAQ119", 119.115 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon iTRAQ121 = new ReporterIon("iTRAQ121", 121.1217 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon TMT0 = new ReporterIon("TMT0", 126.127491 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon TMT1 = new ReporterIon("TMT1", 127.1308594 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon TMT2 = new ReporterIon("TMT2", 128.1341553 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon TMT3 = new ReporterIon("TMT3", 129.1375046 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon TMT4 = new ReporterIon("TMT4", 130.1408768 - ElementaryIon.proton.getTheoreticMass());
    public static final ReporterIon TMT5 = new ReporterIon("TMT5", 131.1444851 - ElementaryIon.proton.getTheoreticMass());
    private String name;
    private int subtype;

    public ReporterIon(String name, double mass) {
        this.type = Ion.IonType.REPORTER_ION;
        this.name = name;
        this.theoreticMass = mass;
        boolean found = false;
        for (int possibleType : reporterIonTypes.keySet()) {
            if (!reporterIonTypes.get(possibleType).equals(name)) continue;
            this.subtype = possibleType;
            found = true;
            break;
        }
        if (!found) {
            this.subtype = reporterIonTypes.size();
            reporterIonTypes.put(this.subtype, name);
        }
    }

    public ReporterIon(int subType) {
        this.type = Ion.IonType.REPORTER_ION;
        this.name = reporterIonTypes.get(subType);
        this.subtype = subType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMass(double referenceMass) {
        this.theoreticMass = referenceMass;
    }

    @Override
    public CvTerm getPrideCvTerm() {
        return null;
    }

    public boolean isSameAs(ReporterIon anotherReporterIon) {
        return this.theoreticMass == anotherReporterIon.getTheoreticMass();
    }

    public int getIndex() {
        return (int)this.getTheoreticMass();
    }

    @Override
    public int getSubType() {
        return this.subtype;
    }

    @Override
    public String getSubTypeAsString() {
        return reporterIonTypes.get(this.subtype);
    }

    public static ArrayList<Integer> getPossibleSubtypes() {
        ArrayList<Integer> possibleTypes = new ArrayList<Integer>(reporterIonTypes.keySet());
        Collections.sort(possibleTypes);
        return possibleTypes;
    }

    @Override
    public ArrayList<NeutralLoss> getNeutralLosses() {
        return new ArrayList<NeutralLoss>();
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        return anotherIon.getType() == Ion.IonType.REPORTER_ION && anotherIon.getSubType() == this.subtype;
    }
}

