/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.ModificationProfile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import no.uib.jsparklines.data.XYDataPoint;

public class SearchParameters
implements Serializable {
    static final long serialVersionUID = -2773993307168773763L;
    private PrecursorAccuracyType currentPrecursorAccuracyType = PrecursorAccuracyType.PPM;
    private Double precursorTolerance = 10.0;
    private Double fragmentIonMZTolerance = 0.5;
    private ModificationProfile utilitiesModificationProfile = new ModificationProfile();
    private Enzyme enzyme;
    private Integer nMissedCleavages = 2;
    private File fastaFile;
    private File parametersFile;
    private HashMap<String, Double> fractionMolecularWeights = new HashMap();
    private HashMap<String, XYDataPoint> fractionMolecularWeightRanges = new HashMap();
    private Integer forwardIon = 1;
    private Integer rewindIon = 4;
    private Charge minChargeSearched = new Charge(1, 2);
    private Charge maxChargeSearched = new Charge(1, 4);
    private static String[] forwardIons = new String[]{"a", "b", "c"};
    private static String[] rewindIons = new String[]{"x", "y", "z"};
    private Double maxEValue = 100.0;
    private Integer hitListLength = 25;
    private Integer hitListLengthDeNovo = 10;
    private Charge minimalChargeForMultipleChargedFragments = new Charge(1, 3);
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Boolean removePrecursor = false;
    private Boolean scalePrecursor = true;
    private Boolean estimateCharge = true;
    private Boolean correctPrecursorMass = true;
    private Boolean discardLowQualitySpectra = true;
    private String fragmentationModel = "CID_IT_TRYP";
    private Boolean generateQuery = false;

    public ModificationProfile getModificationProfile() {
        return this.utilitiesModificationProfile;
    }

    public void setModificationProfile(ModificationProfile modificationProfile) {
        this.utilitiesModificationProfile = modificationProfile;
    }

    public Double getFragmentIonAccuracy() {
        return this.fragmentIonMZTolerance;
    }

    public void setFragmentIonAccuracy(Double fragmentIonMZTolerance) {
        this.fragmentIonMZTolerance = fragmentIonMZTolerance;
    }

    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    public void setEnzyme(Enzyme enzyme) {
        this.enzyme = enzyme;
    }

    public File getParametersFile() {
        return this.parametersFile;
    }

    public void setParametersFile(File parametersFile) {
        this.parametersFile = parametersFile;
    }

    public File getFastaFile() {
        return this.fastaFile;
    }

    public void setFastaFile(File fastaFile) {
        this.fastaFile = fastaFile;
    }

    public Integer getnMissedCleavages() {
        return this.nMissedCleavages;
    }

    public void setnMissedCleavages(Integer nMissedCleavages) {
        this.nMissedCleavages = nMissedCleavages;
    }

    public Integer getIonSearched1() {
        return this.forwardIon;
    }

    public void setIonSearched1(String ionSearched1) {
        if (ionSearched1.equals("a")) {
            this.forwardIon = 0;
        } else if (ionSearched1.equals("b")) {
            this.forwardIon = 1;
        } else if (ionSearched1.equals("c")) {
            this.forwardIon = 2;
        } else if (ionSearched1.equals("x")) {
            this.forwardIon = 3;
        } else if (ionSearched1.equals("y")) {
            this.forwardIon = 4;
        } else if (ionSearched1.equals("z")) {
            this.forwardIon = 5;
        }
    }

    public Integer getIonSearched2() {
        return this.rewindIon;
    }

    public void setIonSearched2(String ionSearched2) {
        if (ionSearched2.equals("a")) {
            this.rewindIon = 0;
        } else if (ionSearched2.equals("b")) {
            this.rewindIon = 1;
        } else if (ionSearched2.equals("c")) {
            this.rewindIon = 2;
        } else if (ionSearched2.equals("x")) {
            this.rewindIon = 3;
        } else if (ionSearched2.equals("y")) {
            this.rewindIon = 4;
        } else if (ionSearched2.equals("z")) {
            this.rewindIon = 5;
        }
    }

    public static String[] getIons() {
        int i;
        String[] ions = new String[forwardIons.length + rewindIons.length];
        for (i = 0; i < forwardIons.length; ++i) {
            ions[ions.length] = forwardIons[i];
        }
        for (i = 0; i < rewindIons.length; ++i) {
            ions[ions.length] = rewindIons[i];
        }
        return ions;
    }

    public static String[] getForwardIons() {
        return forwardIons;
    }

    public static String[] getRewindIons() {
        return rewindIons;
    }

    public Double getPrecursorAccuracy() {
        return this.precursorTolerance;
    }

    public void setPrecursorAccuracy(Double precursorTolerance) {
        this.precursorTolerance = precursorTolerance;
    }

    public PrecursorAccuracyType getPrecursorAccuracyType() {
        return this.currentPrecursorAccuracyType;
    }

    public void setPrecursorAccuracyType(PrecursorAccuracyType currentPrecursorAccuracyType) {
        this.currentPrecursorAccuracyType = currentPrecursorAccuracyType;
    }

    public Boolean isPrecursorAccuracyTypePpm() {
        return this.currentPrecursorAccuracyType == PrecursorAccuracyType.PPM;
    }

    public HashMap<String, Double> getFractionMolecularWeights() {
        return this.fractionMolecularWeights;
    }

    public void setFractionMolecularWeights(HashMap<String, Double> fractionMolecularWeights) {
        this.fractionMolecularWeights = fractionMolecularWeights;
    }

    public HashMap<String, XYDataPoint> getFractionMolecularWeightRanges() {
        return this.fractionMolecularWeightRanges;
    }

    public void setFractionMolecularWeightRanges(HashMap<String, XYDataPoint> fractionMolecularWeightRanges) {
        this.fractionMolecularWeightRanges = fractionMolecularWeightRanges;
    }

    public Charge getMaxChargeSearched() {
        return this.maxChargeSearched;
    }

    public void setMaxChargeSearched(Charge maxChargeSearched) {
        this.maxChargeSearched = maxChargeSearched;
    }

    public Charge getMinChargeSearched() {
        return this.minChargeSearched;
    }

    public void setMinChargeSearched(Charge minChargeSearched) {
        this.minChargeSearched = minChargeSearched;
    }

    public Double getMaxEValue() {
        return this.maxEValue;
    }

    public void setMaxEValue(Double maxEValue) {
        this.maxEValue = maxEValue;
    }

    public Integer getHitListLength() {
        return this.hitListLength;
    }

    public void setHitListLength(Integer hitListLength) {
        this.hitListLength = hitListLength;
    }

    public Integer getHitListLengthDeNovo() {
        return this.hitListLengthDeNovo;
    }

    public void setHitListLengthDeNovo(Integer hitListLengthDeNovo) {
        this.hitListLengthDeNovo = hitListLengthDeNovo;
    }

    public Charge getMinimalChargeForMultipleChargedFragments() {
        return this.minimalChargeForMultipleChargedFragments;
    }

    public void setMinimalChargeForMultipleChargedFragments(Charge minimalChargeForMultipleChargedFragments) {
        this.minimalChargeForMultipleChargedFragments = minimalChargeForMultipleChargedFragments;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Boolean isEstimateCharge() {
        return this.estimateCharge;
    }

    public void setEstimateCharge(Boolean estimateCharge) {
        this.estimateCharge = estimateCharge;
    }

    public Boolean isRemovePrecursor() {
        return this.removePrecursor;
    }

    public void setRemovePrecursor(Boolean removePrecursor) {
        this.removePrecursor = removePrecursor;
    }

    public Boolean isScalePrecursor() {
        return this.scalePrecursor;
    }

    public void setScalePrecursor(Boolean scalePrecursor) {
        this.scalePrecursor = scalePrecursor;
    }

    public static SearchParameters getIdentificationParameters(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        SearchParameters result = (SearchParameters)SerializationUtils.readObject(file);
        ModificationProfile modificationProfile = result.getModificationProfile();
        if (!modificationProfile.hasOMSSAIndexes()) {
            PTMFactory.getInstance().setSearchedOMSSAIndexes(modificationProfile);
        }
        return result;
    }

    public static void saveIdentificationParameters(SearchParameters identificationParameters, File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        SerializationUtils.writeObject(identificationParameters, file);
    }

    public void saveIdentificationParametersAsTextFile(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileWriter fw = new FileWriter(file);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(this.toString());
        bw.close();
        fw.close();
    }

    public String toString() {
        boolean first;
        ArrayList<String> fixedPtms;
        StringBuilder output = new StringBuilder();
        output.append("# ------------------------------------------------------------------");
        output.append(System.getProperty("line.separator"));
        output.append("# Search Parameters");
        output.append(System.getProperty("line.separator"));
        output.append("# ------------------------------------------------------------------");
        output.append(System.getProperty("line.separator"));
        output.append(System.getProperty("line.separator"));
        output.append("DATABASE_FILE=");
        if (this.fastaFile != null) {
            output.append(this.fastaFile.getAbsolutePath());
        }
        output.append(System.getProperty("line.separator"));
        output.append("ENZYME=");
        if (this.enzyme != null) {
            output.append(this.enzyme.getName());
        }
        output.append(System.getProperty("line.separator"));
        output.append("FIXED_MODIFICATIONS=");
        if (this.utilitiesModificationProfile != null) {
            fixedPtms = this.utilitiesModificationProfile.getFixedModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//" + ptm);
            }
        }
        output.append(System.getProperty("line.separator"));
        output.append("VARIABLE_MODIFICATIONS=");
        if (this.utilitiesModificationProfile != null) {
            fixedPtms = this.utilitiesModificationProfile.getVariableModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//" + ptm);
            }
        }
        output.append(System.getProperty("line.separator"));
        output.append("MAX_MISSED_CLEAVAGES=");
        output.append(this.nMissedCleavages);
        output.append(System.getProperty("line.separator"));
        output.append("PRECURSOR_MASS_TOLERANCE=");
        output.append(this.precursorTolerance);
        output.append(System.getProperty("line.separator"));
        output.append("PRECURSOR_MASS_TOLERANCE_UNIT=");
        if (this.currentPrecursorAccuracyType == PrecursorAccuracyType.PPM) {
            output.append("ppm");
        } else {
            output.append("Da");
        }
        output.append(System.getProperty("line.separator"));
        output.append("FRAGMENT_MASS_TOLERANCE=");
        output.append(this.fragmentIonMZTolerance);
        output.append(System.getProperty("line.separator"));
        output.append("FRAGMENT_ION_TYPE_1=");
        if (this.forwardIon == 0) {
            output.append("a");
        } else if (this.forwardIon == 1) {
            output.append("b");
        } else if (this.forwardIon == 2) {
            output.append("c");
        } else if (this.forwardIon == 3) {
            output.append("x");
        } else if (this.forwardIon == 4) {
            output.append("y");
        } else if (this.forwardIon == 5) {
            output.append("z");
        }
        output.append(System.getProperty("line.separator"));
        output.append("FRAGMENT_ION_TYPE_2=");
        if (this.rewindIon == 0) {
            output.append("a");
        } else if (this.rewindIon == 1) {
            output.append("b");
        } else if (this.rewindIon == 2) {
            output.append("c");
        } else if (this.rewindIon == 3) {
            output.append("x");
        } else if (this.rewindIon == 4) {
            output.append("y");
        } else if (this.rewindIon == 5) {
            output.append("z");
        }
        output.append(System.getProperty("line.separator"));
        output.append("PRECURSOR_CHARGE_LOWER_BOUND=");
        output.append(this.minChargeSearched);
        output.append(System.getProperty("line.separator"));
        output.append("PRECURSOR_CHARGE_UPPER_BOUND=");
        output.append(this.maxChargeSearched);
        output.append(System.getProperty("line.separator"));
        output.append("EVALUE_CUTOFF=");
        output.append(this.maxEValue);
        output.append(System.getProperty("line.separator"));
        output.append("MAXIMUM_HITLIST_LENGTH=");
        output.append(this.hitListLength);
        output.append(System.getProperty("line.separator"));
        output.append("OMSSA_PRECURSOR_ELIMINATION=");
        output.append(this.removePrecursor);
        output.append(System.getProperty("line.separator"));
        output.append("OMSSA_PRECURSOR_SCALING=");
        output.append(this.scalePrecursor);
        output.append(System.getProperty("line.separator"));
        output.append("OMSSA_MINIMAL_PEPTIDE_SIZE=");
        output.append(this.minPeptideLength);
        output.append(System.getProperty("line.separator"));
        output.append("OMSSA_MAXIMAL_PEPTIDE_SIZE=");
        output.append(this.maxPeptideLength);
        output.append(System.getProperty("line.separator"));
        output.append("OMSSA_PRECURSOR_CHARGE_TO_CONSIDER_MULTIPLY_CHARGED_FRAGMENTS=");
        output.append(this.minimalChargeForMultipleChargedFragments);
        output.append(System.getProperty("line.separator"));
        output.append("OMSSA_CHARGE_ESTIMATION=");
        output.append(this.estimateCharge);
        output.append(System.getProperty("line.separator"));
        output.append(System.getProperty("line.separator"));
        output.append("DeNovo Options:");
        output.append(System.getProperty("line.separator"));
        output.append("CORRECT_PRECURSOR_MASS=");
        output.append(this.correctPrecursorMass);
        output.append(System.getProperty("line.separator"));
        output.append("DISCARD_LOW_QUALITY_SPECTRA=");
        output.append(this.discardLowQualitySpectra);
        output.append(System.getProperty("line.separator"));
        output.append("FRAGMENTATION_MODEL=");
        output.append(this.fragmentationModel);
        output.append(System.getProperty("line.separator"));
        output.append("GENERATE_QUERY=");
        output.append(this.generateQuery);
        output.append(System.getProperty("line.separator"));
        output.append("HIT_LIST_LENGTH=");
        output.append(this.hitListLengthDeNovo);
        output.append(System.getProperty("line.separator"));
        return output.toString();
    }

    public boolean equals(SearchParameters otherSearchParameters) {
        if (otherSearchParameters == null) {
            return false;
        }
        if (this.getPrecursorAccuracyType() != otherSearchParameters.getPrecursorAccuracyType()) {
            return false;
        }
        if (this.getPrecursorAccuracy().doubleValue() != otherSearchParameters.getPrecursorAccuracy().doubleValue()) {
            return false;
        }
        if (this.getFragmentIonAccuracy().doubleValue() != otherSearchParameters.getFragmentIonAccuracy().doubleValue()) {
            return false;
        }
        if (this.getnMissedCleavages().intValue() != otherSearchParameters.getnMissedCleavages().intValue()) {
            return false;
        }
        if (this.getFastaFile() == null && otherSearchParameters.getFastaFile() != null || this.getFastaFile() != null && otherSearchParameters.getFastaFile() == null) {
            return false;
        }
        if (this.getFastaFile() != null && otherSearchParameters.getFastaFile() != null && !this.getFastaFile().getAbsolutePath().equalsIgnoreCase(otherSearchParameters.getFastaFile().getAbsolutePath())) {
            return false;
        }
        if (this.getIonSearched1().intValue() != otherSearchParameters.getIonSearched1().intValue()) {
            return false;
        }
        if (this.getIonSearched2().intValue() != otherSearchParameters.getIonSearched2().intValue()) {
            return false;
        }
        if (!this.getMinChargeSearched().equals(otherSearchParameters.getMinChargeSearched())) {
            return false;
        }
        if (!this.getMaxChargeSearched().equals(otherSearchParameters.getMaxChargeSearched())) {
            return false;
        }
        if (this.getMinPeptideLength() != null && otherSearchParameters.getMinPeptideLength() != null && this.getMinPeptideLength().intValue() != otherSearchParameters.getMinPeptideLength().intValue()) {
            return false;
        }
        if (this.getMinPeptideLength() != null && otherSearchParameters.getMinPeptideLength() == null || this.getMinPeptideLength() == null && otherSearchParameters.getMinPeptideLength() != null) {
            return false;
        }
        if (this.getMaxPeptideLength() != null && otherSearchParameters.getMaxPeptideLength() != null && this.getMaxPeptideLength().intValue() != otherSearchParameters.getMaxPeptideLength().intValue()) {
            return false;
        }
        if (this.getMaxPeptideLength() != null && otherSearchParameters.getMaxPeptideLength() == null || this.getMaxPeptideLength() == null && otherSearchParameters.getMaxPeptideLength() != null) {
            return false;
        }
        if (this.getMaxEValue().doubleValue() != otherSearchParameters.getMaxEValue().doubleValue()) {
            return false;
        }
        if (this.getHitListLength().intValue() != otherSearchParameters.getHitListLength().intValue()) {
            return false;
        }
        if (!this.getMinimalChargeForMultipleChargedFragments().equals(otherSearchParameters.getMinimalChargeForMultipleChargedFragments())) {
            return false;
        }
        if (this.isRemovePrecursor().booleanValue() != otherSearchParameters.isRemovePrecursor().booleanValue()) {
            return false;
        }
        if (this.isScalePrecursor().booleanValue() != otherSearchParameters.isScalePrecursor().booleanValue()) {
            return false;
        }
        if (this.isEstimateCharge().booleanValue() != otherSearchParameters.isEstimateCharge().booleanValue()) {
            return false;
        }
        if (this.getEnzyme() != null && otherSearchParameters.getEnzyme() != null && !this.getEnzyme().equals(otherSearchParameters.getEnzyme())) {
            return false;
        }
        if (this.getEnzyme() != null && otherSearchParameters.getEnzyme() == null || this.getEnzyme() == null && otherSearchParameters.getEnzyme() != null) {
            return false;
        }
        if (this.getParametersFile() != null && otherSearchParameters.getParametersFile() != null && !this.getParametersFile().getAbsolutePath().equalsIgnoreCase(otherSearchParameters.getParametersFile().getAbsolutePath())) {
            return false;
        }
        if (this.getParametersFile() != null && otherSearchParameters.getParametersFile() == null || this.getParametersFile() == null && otherSearchParameters.getParametersFile() != null) {
            return false;
        }
        if (!this.getModificationProfile().equals(otherSearchParameters.getModificationProfile())) {
            return false;
        }
        if (this.getFractionMolecularWeightRanges() != null && otherSearchParameters.getFractionMolecularWeightRanges() != null && !this.getFractionMolecularWeightRanges().equals(otherSearchParameters.getFractionMolecularWeightRanges())) {
            return false;
        }
        if (this.getFractionMolecularWeightRanges() != null && otherSearchParameters.getFractionMolecularWeightRanges() == null || this.getFractionMolecularWeightRanges() == null && otherSearchParameters.getFractionMolecularWeightRanges() != null) {
            return false;
        }
        if (!this.getFragmentationModel().equalsIgnoreCase(otherSearchParameters.getFragmentationModel())) {
            return false;
        }
        if (this.isCorrectPrecursorMass().booleanValue() != otherSearchParameters.isCorrectPrecursorMass().booleanValue()) {
            return false;
        }
        return this.getDiscardLowQualitySpectra().booleanValue() == otherSearchParameters.getDiscardLowQualitySpectra().booleanValue();
    }

    public Boolean isCorrectPrecursorMass() {
        if (this.correctPrecursorMass != null) {
            return this.correctPrecursorMass;
        }
        return true;
    }

    public void correctPrecursorMass(Boolean correctPrecursorMass) {
        this.correctPrecursorMass = correctPrecursorMass;
    }

    public Boolean getDiscardLowQualitySpectra() {
        if (this.discardLowQualitySpectra != null) {
            return this.discardLowQualitySpectra;
        }
        return true;
    }

    public void setDiscardLowQualitySpectra(Boolean discardLowQualitySpectra) {
        this.discardLowQualitySpectra = discardLowQualitySpectra;
    }

    public String getFragmentationModel() {
        return this.fragmentationModel;
    }

    public void setFragmentationModel(String fragmentationModel) {
        this.fragmentationModel = fragmentationModel;
    }

    public Boolean generateQuery() {
        return this.generateQuery;
    }

    public void setGenerateQuery(Boolean generateQuery) {
        this.generateQuery = generateQuery;
    }

    public static enum PrecursorAccuracyType {
        PPM,
        DA;

    }
}

