/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.software.CommandLineUtils;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.SearchParametersCLIParams;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.preferences.ModificationProfile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public class SearchParametersInputBean {
    private ArrayList<File> spectrumFiles;
    private File outputFolder;
    private SearchParameters searchParameters;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
    private boolean omssaEnabled = true;
    private boolean xtandemEnabled = true;
    private boolean omssaOutputAsOmx = true;
    private File omssaLocation = null;
    private File xtandemLocation = null;
    private File pepNovoExecutable = null;
    private int mgfMaxSize = 1000;
    private int mgfNSpectra = 25000;
    private boolean fixDuplicateSpectrumTitles = false;
    private int nThreads = Runtime.getRuntime().availableProcessors();

    public SearchParametersInputBean(CommandLine aLine) throws FileNotFoundException, IOException, ClassNotFoundException {
        String omssaFormatOption;
        String omssaFolder;
        String xtandemOption;
        String omssaOption;
        Serializable option;
        String arg;
        Serializable option2;
        String arg2;
        if (aLine.hasOption(SearchParametersCLIParams.MGF_SPLITTING_LIMIT.id)) {
            arg2 = aLine.getOptionValue(SearchParametersCLIParams.MGF_SPLITTING_LIMIT.id);
            option2 = new Integer(arg2);
            this.mgfMaxSize = option2;
        }
        if (aLine.hasOption(SearchParametersCLIParams.MGF_MAX_SPECTRA.id)) {
            arg2 = aLine.getOptionValue(SearchParametersCLIParams.MGF_MAX_SPECTRA.id);
            option2 = new Integer(arg2);
            this.mgfNSpectra = option2;
        }
        String filesTxt = aLine.getOptionValue(SearchParametersCLIParams.SPECTRUM_FILES.id);
        this.spectrumFiles = SearchParametersInputBean.getSpectrumFiles(filesTxt);
        if (aLine.hasOption(SearchParametersCLIParams.OUTPUT_FOLDER.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.OUTPUT_FOLDER.id);
            this.outputFolder = new File(arg);
        }
        if (aLine.hasOption(SearchParametersCLIParams.SEARCH_PARAMETERS.id)) {
            String fileTxt = aLine.getOptionValue(SearchParametersCLIParams.SEARCH_PARAMETERS.id);
            this.searchParameters = SearchParameters.getIdentificationParameters(new File(fileTxt));
            this.ptmFactory.setSearchedOMSSAIndexes(this.searchParameters.getModificationProfile());
        } else {
            PTM modification;
            ArrayList<String> args;
            String arg3;
            this.searchParameters = new SearchParameters();
            if (aLine.hasOption(SearchParametersCLIParams.PPM.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.PPM.id);
                option = new Integer(arg);
                if ((Integer)option == 1) {
                    this.searchParameters.setPrecursorAccuracyType(SearchParameters.PrecursorAccuracyType.PPM);
                } else {
                    this.searchParameters.setPrecursorAccuracyType(SearchParameters.PrecursorAccuracyType.DA);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.PREC_TOL.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.PREC_TOL.id);
                option = new Double(arg);
                this.searchParameters.setPrecursorAccuracy((Double)option);
            }
            if (aLine.hasOption(SearchParametersCLIParams.FRAG_TOL.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.FRAG_TOL.id);
                option = new Double(arg);
                this.searchParameters.setFragmentIonAccuracy((Double)option);
            }
            if (aLine.hasOption(SearchParametersCLIParams.ENZYME.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.ENZYME.id);
                option = this.enzymeFactory.getEnzyme(arg);
                this.searchParameters.setEnzyme((Enzyme)option);
            } else {
                option2 = this.enzymeFactory.getEnzyme("Trypsin");
                this.searchParameters.setEnzyme((Enzyme)option2);
            }
            if (aLine.hasOption(SearchParametersCLIParams.DB.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.DB.id);
                File fastaFile = new File(arg);
                this.searchParameters.setFastaFile(fastaFile);
            }
            if (aLine.hasOption(SearchParametersCLIParams.MC.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.MC.id);
                option = new Integer(arg);
                this.searchParameters.setnMissedCleavages((Integer)option);
            }
            if (aLine.hasOption(SearchParametersCLIParams.FI.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.FI.id);
                this.searchParameters.setIonSearched1(arg);
            }
            if (aLine.hasOption(SearchParametersCLIParams.RI.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.RI.id);
                this.searchParameters.setIonSearched2(arg);
            }
            if (aLine.hasOption(SearchParametersCLIParams.MIN_CHARGE.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.MIN_CHARGE.id);
                option = new Integer(arg);
                this.searchParameters.setMinChargeSearched(new Charge(1, (Integer)option));
            }
            if (aLine.hasOption(SearchParametersCLIParams.MAX_CHARGE.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.MAX_CHARGE.id);
                option = new Integer(arg);
                this.searchParameters.setMinChargeSearched(new Charge(1, (Integer)option));
            }
            if (aLine.hasOption(SearchParametersCLIParams.MAX_EVALUE.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.MAX_EVALUE.id);
                option = new Double(arg);
                this.searchParameters.setMaxEValue((Double)option);
            }
            if (aLine.hasOption(SearchParametersCLIParams.HITLIST_LENGTH.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.HITLIST_LENGTH.id);
                option = new Integer(arg);
                this.searchParameters.setHitListLength((Integer)option);
            }
            if (aLine.hasOption(SearchParametersCLIParams.HITLIST_LENGTH_DE_NOVO.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.HITLIST_LENGTH_DE_NOVO.id);
                option = new Integer(arg);
                this.searchParameters.setHitListLengthDeNovo((Integer)option);
            }
            if (aLine.hasOption(SearchParametersCLIParams.MIN_PEP_LENGTH.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.MIN_PEP_LENGTH.id);
                option = new Integer(arg);
                this.searchParameters.setMinPeptideLength((Integer)option);
            }
            if (aLine.hasOption(SearchParametersCLIParams.MAX_PEP_LENGTH.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.MAX_PEP_LENGTH.id);
                option = new Integer(arg);
                this.searchParameters.setMaxPeptideLength((Integer)option);
            }
            if (aLine.hasOption(SearchParametersCLIParams.REMOVE_PREC.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.REMOVE_PREC.id);
                option = new Integer(arg);
                if ((Integer)option == 1) {
                    this.searchParameters.setRemovePrecursor(true);
                } else {
                    this.searchParameters.setRemovePrecursor(false);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.SCALE_PREC.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.SCALE_PREC.id);
                option = new Integer(arg);
                if ((Integer)option == 1) {
                    this.searchParameters.setScalePrecursor(true);
                } else {
                    this.searchParameters.setScalePrecursor(false);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.ESTIMATE_CHARGE.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.ESTIMATE_CHARGE.id);
                option = new Integer(arg);
                if ((Integer)option == 1) {
                    this.searchParameters.setEstimateCharge(true);
                } else {
                    this.searchParameters.setEstimateCharge(false);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.ESTIMATE_CHARGE_DE_NOVO.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.ESTIMATE_CHARGE_DE_NOVO.id);
                option = new Integer(arg);
                if ((Integer)option == 1) {
                    this.searchParameters.setEstimateCharge(true);
                } else {
                    this.searchParameters.setEstimateCharge(false);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.CORRECT_PRECURSOR_MASS.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.CORRECT_PRECURSOR_MASS.id);
                option = new Integer(arg);
                if ((Integer)option == 1) {
                    this.searchParameters.correctPrecursorMass(true);
                } else {
                    this.searchParameters.correctPrecursorMass(false);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.DISCARD_SPECTRA.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.DISCARD_SPECTRA.id);
                option = new Integer(arg);
                if ((Integer)option == 1) {
                    this.searchParameters.setDiscardLowQualitySpectra(true);
                } else {
                    this.searchParameters.setDiscardLowQualitySpectra(false);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.GENERATE_BLAST.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.GENERATE_BLAST.id);
                option = new Integer(arg);
                if ((Integer)option == 1) {
                    this.searchParameters.setGenerateQuery(true);
                } else {
                    this.searchParameters.setGenerateQuery(false);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.FRAGMENTATION_MODEL.id)) {
                arg = aLine.getOptionValue(SearchParametersCLIParams.FRAGMENTATION_MODEL.id);
                this.searchParameters.setFragmentationModel(arg);
            }
            ModificationProfile modificationProfile = new ModificationProfile();
            if (aLine.hasOption(SearchParametersCLIParams.FIXED_MODS.id)) {
                arg3 = aLine.getOptionValue(SearchParametersCLIParams.FIXED_MODS.id);
                args = CommandLineUtils.splitInput(arg3);
                for (String ptmName : args) {
                    modification = this.ptmFactory.getPTM(ptmName);
                    modificationProfile.addFixedModification(modification);
                }
            }
            if (aLine.hasOption(SearchParametersCLIParams.VARIABLE_MODS.id)) {
                arg3 = aLine.getOptionValue(SearchParametersCLIParams.VARIABLE_MODS.id);
                args = CommandLineUtils.splitInput(arg3);
                for (String ptmName : args) {
                    modification = this.ptmFactory.getPTM(ptmName);
                    modificationProfile.addVariableModification(modification);
                }
            }
            this.searchParameters.setModificationProfile(modificationProfile);
            this.ptmFactory.setSearchedOMSSAIndexes(this.searchParameters.getModificationProfile());
        }
        if (aLine.hasOption(SearchParametersCLIParams.OMSSA.id) && (omssaOption = aLine.getOptionValue(SearchParametersCLIParams.OMSSA.id)).trim().equals("0")) {
            this.omssaEnabled = false;
        }
        if (aLine.hasOption(SearchParametersCLIParams.XTANDEM.id) && (xtandemOption = aLine.getOptionValue(SearchParametersCLIParams.XTANDEM.id)).trim().equals("0")) {
            this.xtandemEnabled = false;
        }
        if (aLine.hasOption(SearchParametersCLIParams.OMSSA_LOCATION.id)) {
            omssaFolder = aLine.getOptionValue(SearchParametersCLIParams.OMSSA_LOCATION.id);
            this.omssaLocation = new File(omssaFolder);
        }
        if (aLine.hasOption(SearchParametersCLIParams.XTANDEM_LOCATION.id)) {
            omssaFolder = aLine.getOptionValue(SearchParametersCLIParams.XTANDEM_LOCATION.id);
            this.xtandemLocation = new File(omssaFolder);
        }
        if (aLine.hasOption(SearchParametersCLIParams.PEP_NOVO_LOCATION.id)) {
            String pepNovoExecutable = aLine.getOptionValue(SearchParametersCLIParams.PEP_NOVO_LOCATION.id);
            this.pepNovoExecutable = new File(pepNovoExecutable);
        }
        if (aLine.hasOption(SearchParametersCLIParams.OMSSA_FORMAT.id) && (omssaFormatOption = aLine.getOptionValue(SearchParametersCLIParams.OMSSA_FORMAT.id)).trim().equals("csv")) {
            this.omssaOutputAsOmx = false;
        }
        if (aLine.hasOption(SearchParametersCLIParams.FIX_DUPLICATE_TITLES.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.FIX_DUPLICATE_TITLES.id);
            option = new Integer(arg);
            this.fixDuplicateSpectrumTitles = (Integer)option == 1;
        }
        if (aLine.hasOption(SearchParametersCLIParams.THREADS.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.THREADS.id);
            this.nThreads = new Integer(arg);
        }
    }

    public ArrayList<File> getSpectrumFiles() {
        return this.spectrumFiles;
    }

    public File getOutputFile() {
        return this.outputFolder;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public static ArrayList<File> getSpectrumFiles(String optionInput) throws FileNotFoundException {
        ArrayList<String> extentions = new ArrayList<String>();
        extentions.add(".mgf");
        return CommandLineUtils.getFiles(optionInput, extentions);
    }

    public boolean isOmssaEnabled() {
        return this.omssaEnabled;
    }

    public boolean isXTandemEnabled() {
        return this.xtandemEnabled;
    }

    public boolean isOmssaOutputAsOmx() {
        return this.omssaOutputAsOmx;
    }

    public File getOmssaLocation() {
        return this.omssaLocation;
    }

    public void setOmssaLocation(File omssaLocation) {
        this.omssaLocation = omssaLocation;
    }

    public File getXtandemLocation() {
        return this.xtandemLocation;
    }

    public void setXtandemLocation(File xtandemLocation) {
        this.xtandemLocation = xtandemLocation;
    }

    public File getPepNovoExecutable() {
        return this.pepNovoExecutable;
    }

    public void setPepNovoExecutable(File pepNovoExecutable) {
        this.pepNovoExecutable = pepNovoExecutable;
    }

    public int getMgfMaxSize() {
        return this.mgfMaxSize;
    }

    public int getMgfNSpectra() {
        return this.mgfNSpectra;
    }

    public boolean fixDuplicateSpectrumTitles() {
        return this.fixDuplicateSpectrumTitles;
    }

    public void setFixDuplicateSpectrumTitles(boolean fixDuplicateSpectrumTitles) {
        this.fixDuplicateSpectrumTitles = fixDuplicateSpectrumTitles;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidStartup(CommandLine aLine, ToolType currentToolType) throws IOException {
        ArrayList<String> args;
        Number temp;
        String arg;
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (!aLine.hasOption(SearchParametersCLIParams.SPECTRUM_FILES.id) || aLine.getOptionValue(SearchParametersCLIParams.SPECTRUM_FILES.id).equals("")) {
            System.out.println(System.getProperty("line.separator") + "Spectrum files not specified." + System.getProperty("line.separator"));
            return false;
        }
        ArrayList<File> tempSpectrumFiles = SearchParametersInputBean.getSpectrumFiles(aLine.getOptionValue(SearchParametersCLIParams.SPECTRUM_FILES.id));
        for (File file : tempSpectrumFiles) {
            if (file.exists()) continue;
            System.out.println(System.getProperty("line.separator") + "File '" + file.getName() + "' not found." + System.getProperty("line.separator"));
            return false;
        }
        if (!aLine.hasOption(SearchParametersCLIParams.OUTPUT_FOLDER.id) || aLine.getOptionValue(SearchParametersCLIParams.OUTPUT_FOLDER.id).equals("")) {
            System.out.println(System.getProperty("line.separator") + "Output folder not specified." + System.getProperty("line.separator"));
            return false;
        }
        File file = new File(aLine.getOptionValue(SearchParametersCLIParams.OUTPUT_FOLDER.id));
        if (!file.exists()) {
            System.out.println(System.getProperty("line.separator") + "Output folder '" + file.getName() + "' not found." + System.getProperty("line.separator"));
            return false;
        }
        if (currentToolType == ToolType.SearchGUI && !aLine.hasOption(SearchParametersCLIParams.SEARCH_PARAMETERS.id)) {
            if (!aLine.hasOption(SearchParametersCLIParams.DB.id) || aLine.getOptionValue(SearchParametersCLIParams.DB.id).toString().equals("")) {
                System.out.println("\nFasta file not specified.\n");
                return false;
            }
            arg = aLine.getOptionValue(SearchParametersCLIParams.DB.id);
            try {
                File fastaFile = new File(arg);
                if (!fastaFile.exists()) {
                    System.out.println("\nFasta file not found.\n");
                    return false;
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while setting the database:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.SEARCH_PARAMETERS.id)) {
            try {
                String fileTxt = aLine.getOptionValue(SearchParametersCLIParams.SEARCH_PARAMETERS.id);
                SearchParameters tempSearchParameters = SearchParameters.getIdentificationParameters(new File(fileTxt));
                if (currentToolType != ToolType.DeNovoGUI) return true;
                if (tempSearchParameters.getPrecursorAccuracy() < 0.0 || tempSearchParameters.getPrecursorAccuracy() > 5.0) {
                    System.out.println(System.getProperty("line.separator") + "Precursor tolerance has to be between 0 and 5.0!" + System.getProperty("line.separator"));
                    return false;
                }
                if (tempSearchParameters.getHitListLengthDeNovo() <= 20) return true;
                System.out.println(System.getProperty("line.separator") + "Maximum the de novo solutions is 20!" + System.getProperty("line.separator"));
                return false;
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the search parameters:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.PPM.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.PPM.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the ppm/Da parameter:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.PREC_TOL.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.PREC_TOL.id);
            try {
                temp = new Double(arg);
                if (currentToolType == ToolType.DeNovoGUI && ((Double)temp < 0.0 || (Double)temp > 5.0)) {
                    System.out.println(System.getProperty("line.separator") + "Precursor tolerance has to be between 0 and 5.0!" + System.getProperty("line.separator"));
                    return false;
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the precursor m/z tolerance parameter:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.FRAG_TOL.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.FRAG_TOL.id);
            try {
                new Double(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the fragment ion m/z parameter:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.ENZYME.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.ENZYME.id);
            try {
                Enzyme selectedEnzyme = EnzymeFactory.getInstance().getEnzyme(arg);
                if (selectedEnzyme == null) {
                    System.out.println(System.getProperty("line.separator") + "Unknown enzyme: '" + arg + "'." + System.getProperty("line.separator") + "See SearchGUI for the list of supported enzymes. (Note that the names are case sensitive.)");
                    return false;
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the enzyme:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.MC.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.MC.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the number of missed cleavages:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.MIN_CHARGE.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.MIN_CHARGE.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the minimum charge:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.MAX_CHARGE.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.MAX_CHARGE.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the maximum charge:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.MAX_EVALUE.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.MAX_EVALUE.id);
            try {
                new Double(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the maximum e-value:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.HITLIST_LENGTH.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.HITLIST_LENGTH.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the OMSSA hit list length:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.HITLIST_LENGTH_DE_NOVO.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.HITLIST_LENGTH_DE_NOVO.id);
            try {
                temp = new Integer(arg);
                if ((Integer)temp > 20) {
                    System.out.println(System.getProperty("line.separator") + "Maximum hit list length is 20!" + System.getProperty("line.separator"));
                    return false;
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the hit list length:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.MIN_PEP_LENGTH.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.MIN_PEP_LENGTH.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the minimal peptide length:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.MAX_PEP_LENGTH.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.MAX_PEP_LENGTH.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the maximal peptide length:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.REMOVE_PREC.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.REMOVE_PREC.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the remove precursor option:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.SCALE_PREC.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.SCALE_PREC.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the scale precursor option:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.ESTIMATE_CHARGE.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.ESTIMATE_CHARGE.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the estimate charge option:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.ESTIMATE_CHARGE_DE_NOVO.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.ESTIMATE_CHARGE_DE_NOVO.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the estimate charge option:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.CORRECT_PRECURSOR_MASS.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.CORRECT_PRECURSOR_MASS.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the correct precursor mass option:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.DISCARD_SPECTRA.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.DISCARD_SPECTRA.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the discard precursor option:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.FRAGMENTATION_MODEL.id) && !(arg = aLine.getOptionValue(SearchParametersCLIParams.FRAGMENTATION_MODEL.id)).equalsIgnoreCase("CID_IT_TRYP")) {
            System.out.println(System.getProperty("line.separator") + "Fragmentation model not supported." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(SearchParametersCLIParams.GENERATE_BLAST.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.GENERATE_BLAST.id);
            try {
                new Integer(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the generate BLAST query option:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(SearchParametersCLIParams.FIXED_MODS.id)) {
            arg = aLine.getOptionValue(SearchParametersCLIParams.FIXED_MODS.id);
            try {
                args = CommandLineUtils.splitInput(arg);
                for (String ptmName : args) {
                    PTMFactory.getInstance().getPTM(ptmName);
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while reading the fixed modifications:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (!aLine.hasOption(SearchParametersCLIParams.VARIABLE_MODS.id)) return true;
        arg = aLine.getOptionValue(SearchParametersCLIParams.VARIABLE_MODS.id);
        try {
            args = CommandLineUtils.splitInput(arg);
            for (String ptmName : args) {
                PTMFactory.getInstance().getPTM(ptmName);
            }
            return true;
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "An error occurred while reading the variable modifications:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
            e.printStackTrace();
            return false;
        }
    }

    public static enum ToolType {
        SearchGUI,
        DeNovoGUI;

    }
}

