/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.FastaIndex;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.protein.Header;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JProgressBar;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class SequenceFactory {
    private static SequenceFactory instance = null;
    private HashMap<String, Header> currentHeaderMap = new HashMap();
    private HashMap<String, Protein> currentProteinMap = new HashMap();
    private FastaIndex fastaIndex = null;
    private BufferedRandomAccessFile currentRandomAccessFile = null;
    private File currentFastaFile = null;
    private int nCache = 1;
    private ArrayList<String> loadedProteins = new ArrayList();
    private static final String[] decoyFlags = new String[]{"REVERSED", "RND", "SHUFFLED"};
    private HashMap<String, Double> molecularWeights = new HashMap();
    private static String targetDecoyFileNameTag = "_concatenated_target_decoy.fasta";

    private SequenceFactory() {
    }

    public static SequenceFactory getInstance() {
        if (instance == null) {
            instance = new SequenceFactory();
        }
        return instance;
    }

    public static SequenceFactory getInstance(int nCache) {
        if (instance == null) {
            instance = new SequenceFactory();
        }
        instance.setnCache(nCache);
        return instance;
    }

    public void clearFactory() throws IOException {
        this.closeFile();
        this.currentHeaderMap.clear();
        this.currentProteinMap.clear();
        this.fastaIndex = null;
        this.currentRandomAccessFile = null;
        this.currentFastaFile = null;
        this.loadedProteins.clear();
        this.molecularWeights.clear();
    }

    public void emptyCache() {
        this.currentHeaderMap.clear();
        this.currentProteinMap.clear();
        this.loadedProteins.clear();
        this.molecularWeights.clear();
    }

    public Protein getProtein(String accession) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        return this.getProtein(accession, true);
    }

    private Protein getProtein(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        Protein currentProtein;
        if (this.isDefaultReversed() && this.isDecoyAccession(accession)) {
            String targetAccession = SequenceFactory.getDefaultTargetAccession(accession);
            try {
                Protein targetProtein = this.getProtein(targetAccession, reindex);
                return new Protein(accession, targetProtein.getDatabaseType(), SequenceFactory.reverseSequence(targetProtein.getSequence()), true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((currentProtein = this.currentProteinMap.get(accession)) == null) {
            Long index = this.fastaIndex.getIndex(accession);
            if (index == null) {
                if (reindex) {
                    this.fastaIndex = this.getFastaIndex(true, null);
                    return this.getProtein(accession, false);
                }
                throw new IllegalArgumentException("Protein not found: " + accession + ".");
            }
            currentProtein = this.getProtein(accession, index, 0);
            if (this.loadedProteins.size() == this.nCache) {
                this.currentProteinMap.remove(this.loadedProteins.get(0));
                this.currentHeaderMap.remove(this.loadedProteins.get(0));
                this.loadedProteins.remove(0);
            }
            this.loadedProteins.add(accession);
            this.currentProteinMap.put(accession, currentProtein);
        }
        if (currentProtein == null) {
            throw new IllegalArgumentException("Protein not found: " + accession + ".");
        }
        return currentProtein;
    }

    private synchronized Protein getProtein(String accession, long index, int nTries) throws InterruptedException, IOException, IllegalArgumentException {
        try {
            String line;
            this.currentRandomAccessFile.seek(index);
            String sequence = "";
            Header currentHeader = this.currentHeaderMap.get(accession);
            while ((line = this.currentRandomAccessFile.readLine()) != null) {
                if ((line = line.trim()).startsWith(">")) {
                    if (!sequence.equals("")) break;
                    if (currentHeader != null) continue;
                    currentHeader = Header.parseFromFASTA(line);
                    this.currentHeaderMap.put(accession, currentHeader);
                    continue;
                }
                sequence = sequence + line;
            }
            return new Protein(accession, currentHeader.getDatabaseType(), sequence, this.isDecoyAccession(accession));
        }
        catch (IOException e) {
            if (nTries <= 100) {
                this.wait(10L);
                return this.getProtein(accession, index, nTries + 1);
            }
            throw e;
        }
    }

    public Header getHeader(String accession) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        return this.getHeader(accession, true);
    }

    private Header getHeader(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        Header result = this.currentHeaderMap.get(accession);
        if (result == null) {
            Long index = this.fastaIndex.getIndex(accession);
            if (index == null) {
                if (reindex) {
                    this.fastaIndex = this.getFastaIndex(true, null);
                    return this.getHeader(accession, false);
                }
                throw new IllegalArgumentException("Protein not found: " + accession + ".");
            }
            return this.getHeader(index, 0);
        }
        return result;
    }

    private synchronized Header getHeader(long index, int nTries) throws InterruptedException, IOException {
        try {
            this.currentRandomAccessFile.seek(index);
            return Header.parseFromFASTA(this.currentRandomAccessFile.readLine());
        }
        catch (IOException e) {
            if (nTries <= 100) {
                this.wait(10L);
                return this.getHeader(index, nTries + 1);
            }
            throw e;
        }
    }

    public void loadFastaFile(File fastaFile) throws FileNotFoundException, IOException, ClassNotFoundException, StringIndexOutOfBoundsException, IllegalArgumentException {
        this.loadFastaFile(fastaFile, null);
    }

    public void loadFastaFile(File fastaFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException, StringIndexOutOfBoundsException, IllegalArgumentException {
        if (!fastaFile.exists()) {
            throw new FileNotFoundException("The FASTA file '" + fastaFile.getAbsolutePath() + "' could not be found!");
        }
        this.currentFastaFile = fastaFile;
        this.currentRandomAccessFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        this.fastaIndex = this.getFastaIndex(false, waitingHandler);
    }

    private FastaIndex getFastaIndex() throws FileNotFoundException, IOException, ClassNotFoundException, IllegalArgumentException {
        return this.getFastaIndex(false, null);
    }

    private FastaIndex getFastaIndex(boolean overwrite, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException, StringIndexOutOfBoundsException {
        FastaIndex tempFastaIndex;
        File indexFile;
        if (!overwrite && (indexFile = new File(this.currentFastaFile.getParent(), this.currentFastaFile.getName() + ".cui")).exists()) {
            try {
                tempFastaIndex = (FastaIndex)SerializationUtils.readObject(indexFile);
                Long indexLastModified = tempFastaIndex.getLastModified();
                if (indexLastModified != null) {
                    long fileLastModified = this.currentFastaFile.lastModified();
                    if (indexLastModified == fileLastModified) {
                        return tempFastaIndex;
                    }
                    System.err.println("Reindexing: " + this.currentFastaFile.getName() + ". (changes in the file detected)");
                }
            }
            catch (InvalidClassException e) {
                System.err.println("Reindexing: " + this.currentFastaFile.getName() + ". (Reason: " + e.getLocalizedMessage() + ")");
            }
            catch (Exception e) {
                System.err.println("Reindexing: " + this.currentFastaFile.getName() + ". (Reason: " + e.getLocalizedMessage() + ")");
            }
        }
        String decoyTag = null;
        String name = null;
        String version = null;
        Header.DatabaseType databaseType = null;
        File indexFile2 = new File(this.currentFastaFile.getParent(), this.currentFastaFile.getName() + ".cui");
        if (indexFile2.exists()) {
            try {
                tempFastaIndex = (FastaIndex)SerializationUtils.readObject(indexFile2);
                decoyTag = tempFastaIndex.getDecoyTag();
                version = tempFastaIndex.getVersion();
                databaseType = tempFastaIndex.getDatabaseType();
                name = tempFastaIndex.getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.out.println("Reindexing: " + this.currentFastaFile.getName() + ".");
        tempFastaIndex = SequenceFactory.createFastaIndex(this.currentFastaFile, name, decoyTag, databaseType, version, waitingHandler);
        if (waitingHandler == null || waitingHandler != null && !waitingHandler.isRunCanceled()) {
            try {
                this.writeIndex(tempFastaIndex, this.currentFastaFile.getParentFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tempFastaIndex;
    }

    private static FastaIndex createFastaIndex(File fastaFile, String name, String decoyTag, Header.DatabaseType databaseType, String version, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, StringIndexOutOfBoundsException, IllegalArgumentException {
        String line;
        HashMap<String, Long> indexes = new HashMap<String, Long>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        boolean decoy = false;
        boolean defaultReversed = false;
        boolean multipleType = false;
        int nTarget = 0;
        long index = bufferedRandomAccessFile.getFilePointer();
        if (databaseType == null) {
            databaseType = Header.DatabaseType.Unknown;
        }
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            if (line.startsWith(">")) {
                Header fastaHeader = Header.parseFromFASTA(line);
                String accession = fastaHeader.getAccession();
                if (accession == null) {
                    accession = fastaHeader.getRest();
                }
                if (indexes.containsKey(accession)) {
                    throw new IllegalArgumentException("Non unique accession number found '" + accession + "'!\nPlease check the FASTA file.");
                }
                indexes.put(accession, index);
                if (decoyTag == null) {
                    decoyTag = SequenceFactory.getDecoyFlag(accession);
                }
                if (decoyTag == null || !SequenceFactory.isDecoy(accession, decoyTag)) {
                    ++nTarget;
                    if (!multipleType) {
                        if (databaseType == Header.DatabaseType.Unknown) {
                            databaseType = fastaHeader.getDatabaseType();
                        } else if (fastaHeader.getDatabaseType() != databaseType && databaseType != Header.DatabaseType.Generic_Header) {
                            databaseType = Header.DatabaseType.Unknown;
                            multipleType = true;
                        }
                    }
                } else if (!decoy) {
                    decoy = true;
                    if (accession.endsWith(SequenceFactory.getDefaultDecoyAccessionSuffix())) {
                        defaultReversed = true;
                    }
                }
                if (waitingHandler == null) continue;
                waitingHandler.setSecondaryProgressCounter((int)(index / progressUnit));
                if (!waitingHandler.isRunCanceled()) continue;
                break;
            }
            index = bufferedRandomAccessFile.getFilePointer();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        bufferedRandomAccessFile.close();
        long lastModified = fastaFile.lastModified();
        if (version == null) {
            version = FastaIndex.getDefaultVersion(lastModified);
        }
        String fileName = fastaFile.getName();
        if (name == null) {
            name = fileName;
        }
        return new FastaIndex(indexes, fileName, name, decoy, defaultReversed, nTarget, lastModified, databaseType, decoyTag, version);
    }

    private void writeIndex(FastaIndex fastaIndex, File directory) throws IOException {
        File destinationFile = new File(directory, fastaIndex.getFileName() + ".cui");
        SerializationUtils.writeObject(fastaIndex, destinationFile);
    }

    public void saveIndex() throws IOException {
        this.writeIndex(this.fastaIndex, this.currentFastaFile.getParentFile());
    }

    public void closeFile() throws IOException {
        if (this.currentRandomAccessFile != null) {
            this.currentRandomAccessFile.close();
        }
    }

    public static boolean isDecoy(String proteinAccession, String decoyFlag) {
        if (decoyFlag == null || decoyFlag.isEmpty()) {
            return false;
        }
        String start = decoyFlag + ".*";
        String end = ".*" + decoyFlag;
        return proteinAccession.matches(start) || proteinAccession.matches(end);
    }

    public static String getDecoyFlag(String proteinAccession) {
        for (String flag : decoyFlags) {
            if (!SequenceFactory.isDecoy(proteinAccession, flag)) continue;
            return flag;
        }
        return null;
    }

    public boolean isDecoyAccession(String proteinAccession) {
        return SequenceFactory.isDecoy(proteinAccession, this.fastaIndex.getDecoyTag());
    }

    public static boolean isDecoy(String proteinAccession) {
        for (String flag : decoyFlags) {
            if (!SequenceFactory.isDecoy(proteinAccession, flag)) continue;
            return true;
        }
        return false;
    }

    public boolean concatenatedTargetDecoy() {
        return this.fastaIndex.isConcatenatedTargetDecoy();
    }

    public boolean isDefaultReversed() {
        return this.fastaIndex.isDefaultReversed();
    }

    public int getNTargetSequences() {
        return this.fastaIndex.getNTarget();
    }

    public void appendDecoySequences(File destinationFile) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        this.appendDecoySequences(destinationFile, null);
    }

    public void appendDecoySequences(File destinationFile, WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(this.fastaIndex.getNTarget());
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(destinationFile));
        for (String accession : this.fastaIndex.getIndexes().keySet()) {
            if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
            if (waitingHandler != null) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
            Protein currentProtein = this.getProtein(accession);
            Header currentHeader = this.getHeader(accession);
            String decoyAccession = SequenceFactory.getDefaultDecoyAccession(currentProtein.getAccession());
            Header decoyHeader = Header.parseFromFASTA(currentHeader.toString());
            decoyHeader.setAccession(decoyAccession);
            decoyHeader.setDescription(SequenceFactory.getDefaultDecoyDescription(decoyHeader.getDescription()));
            String decoySequence = SequenceFactory.reverseSequence(currentProtein.getSequence());
            bufferedWriter.write(currentHeader.toString() + System.getProperty("line.separator"));
            bufferedWriter.write(currentProtein.getSequence() + System.getProperty("line.separator"));
            if (decoyHeader.toString().equalsIgnoreCase(currentHeader.toString())) {
                decoyHeader.setRest(decoyAccession);
            }
            bufferedWriter.write(decoyHeader.toString() + System.getProperty("line.separator"));
            bufferedWriter.write(decoySequence + System.getProperty("line.separator"));
        }
        bufferedWriter.close();
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        boolean indexFile = true;
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            indexFile = false;
        }
        if (indexFile) {
            this.loadFastaFile(destinationFile, waitingHandler);
        } else {
            destinationFile.delete();
        }
    }

    public static String reverseSequence(String sequence) {
        return new StringBuilder(sequence).reverse().toString();
    }

    public ArrayList<String> getAccessions() {
        if (this.fastaIndex != null) {
            return new ArrayList<String>(this.fastaIndex.getIndexes().keySet());
        }
        return new ArrayList<String>();
    }

    public int getnCache() {
        return this.nCache;
    }

    public void setnCache(int nCache) {
        this.nCache = nCache;
    }

    public HashMap<String, Integer> getAAOccurrences(JProgressBar progressBar) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        HashMap<String, Integer> aaMap = new HashMap<String, Integer>();
        ArrayList<String> accessions = this.getAccessions();
        if (progressBar != null) {
            progressBar.setIndeterminate(false);
            progressBar.setMaximum(accessions.size());
            progressBar.setValue(0);
        }
        for (String accession : accessions) {
            if (!this.isDecoyAccession(accession)) {
                Protein protein = this.getProtein(accession);
                for (String aa : protein.getSequence().split("")) {
                    Integer n = aaMap.get(aa);
                    if (n == null) {
                        n = 0;
                    }
                    aaMap.put(aa, n + 1);
                }
            }
            if (progressBar == null) continue;
            progressBar.setValue(progressBar.getValue() + 1);
        }
        if (progressBar != null) {
            progressBar.setIndeterminate(true);
        }
        return aaMap;
    }

    public double computeMolecularWeight(String accession) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        if (this.isDefaultReversed() && this.isDecoyAccession(accession)) {
            try {
                return this.computeMolecularWeight(SequenceFactory.getDefaultTargetAccession(accession));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.molecularWeights.containsKey(accession)) {
            return this.molecularWeights.get(accession);
        }
        Protein protein = this.getProtein(accession);
        double weight = protein.computeMolecularWeight() / 1000.0;
        this.molecularWeights.put(accession, weight);
        return weight;
    }

    public static String getTargetDecoyFileNameTag() {
        return targetDecoyFileNameTag;
    }

    public static void setTargetDecoyFileNameTag(String targetDecoyFileNameTag) {
        SequenceFactory.targetDecoyFileNameTag = targetDecoyFileNameTag;
    }

    public String getFileName() {
        if (this.fastaIndex == null) {
            return null;
        }
        return this.fastaIndex.getFileName();
    }

    public File getCurrentFastaFile() {
        return this.currentFastaFile;
    }

    public static String getDefaultDecoyAccessionSuffix() {
        return "_" + decoyFlags[0];
    }

    public static String getDefaultDecoyAccession(String targetAccession) {
        return targetAccession + SequenceFactory.getDefaultDecoyAccessionSuffix();
    }

    public static String getDefaultDecoyDescription(String targetDescription) {
        return targetDescription + "-" + decoyFlags[0];
    }

    public static String getDefaultTargetAccession(String decoyAccession) {
        return decoyAccession.substring(0, decoyAccession.length() - SequenceFactory.getDefaultDecoyAccessionSuffix().length());
    }

    public FastaIndex getCurrentFastaIndex() {
        return this.fastaIndex;
    }
}

