/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.proteintree;

import com.compomics.util.experiment.identification.SequenceFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class Node
implements Serializable {
    static final long serialVersionUID = 8936868785405252371L;
    private int depth;
    private HashMap<String, ArrayList<Integer>> accessions = new HashMap();
    private HashMap<String, ArrayList<Integer>> termini = new HashMap();
    private HashMap<Character, Node> subtree = null;

    public Node(int depth) {
        this.depth = depth;
    }

    public Node(int depth, HashMap<String, ArrayList<Integer>> accessions) {
        this.depth = depth;
        this.accessions = accessions;
    }

    public HashMap<String, ArrayList<Integer>> getProteinMapping(String peptideSequence) throws IOException, InterruptedException, ClassNotFoundException {
        if (this.depth == peptideSequence.length()) {
            return this.getAllMappings();
        }
        if (this.accessions != null) {
            HashMap<String, ArrayList<Integer>> result = new HashMap<String, ArrayList<Integer>>(this.accessions.size());
            for (String accession : this.accessions.keySet()) {
                ArrayList<Integer> indexes = this.matchInProtein(accession, this.accessions.get(accession), peptideSequence);
                if (indexes.isEmpty()) continue;
                result.put(accession, indexes);
            }
            return result;
        }
        char aa = peptideSequence.charAt(this.depth);
        Node node = this.subtree.get(Character.valueOf(aa));
        if (node != null) {
            return node.getProteinMapping(peptideSequence);
        }
        return new HashMap<String, ArrayList<Integer>>();
    }

    public boolean splitNode(int maxNodeSize, int maxDepth) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        if (this.accessions.size() > maxNodeSize && this.depth <= maxDepth) {
            this.subtree = new HashMap();
            for (String accession : this.accessions.keySet()) {
                HashMap<Character, ArrayList<Integer>> indexes = this.getAA(accession, this.accessions.get(accession), this.depth);
                if (indexes.isEmpty()) {
                    indexes = this.getAA(accession, this.accessions.get(accession), this.depth);
                }
                for (char aa : indexes.keySet()) {
                    if (!this.subtree.containsKey(Character.valueOf(aa))) {
                        this.subtree.put(Character.valueOf(aa), new Node(this.depth + 1));
                    }
                    Node node = this.subtree.get(Character.valueOf(aa));
                    node.addAccession(accession, indexes.get(Character.valueOf(aa)));
                }
            }
            this.accessions = null;
            for (Node node : this.subtree.values()) {
                node.splitNode(maxNodeSize, maxDepth);
            }
            return true;
        }
        return false;
    }

    public void addAccession(String accession, ArrayList<Integer> indexes) {
        this.accessions.put(accession, indexes);
    }

    public long getSize() {
        if (this.accessions != null) {
            return this.accessions.size();
        }
        long result = 0L;
        for (Node node : this.subtree.values()) {
            result += node.getSize();
        }
        return result;
    }

    public HashMap<String, ArrayList<Integer>> getAccessions() {
        return this.accessions;
    }

    public HashMap<String, ArrayList<Integer>> getTermini() {
        return this.termini;
    }

    public HashMap<Character, Node> getSubtree() {
        return this.subtree;
    }

    public void clearAccessions() {
        this.accessions.clear();
    }

    public boolean isEmpty() {
        return this.subtree == null && this.accessions.isEmpty();
    }

    public int getDepth() {
        return this.depth;
    }

    public HashMap<String, ArrayList<Integer>> getAllMappings() throws IOException {
        if (this.accessions != null) {
            return this.accessions;
        }
        HashMap<String, ArrayList<Integer>> result = new HashMap<String, ArrayList<Integer>>();
        for (Node node : this.subtree.values()) {
            HashMap<String, ArrayList<Integer>> subResult = node.getAllMappings();
            for (String accession : subResult.keySet()) {
                ArrayList<Integer> indexes = result.get(accession);
                if (indexes == null) {
                    indexes = new ArrayList();
                    indexes.addAll((Collection<Integer>)subResult.get(accession));
                    result.put(accession, indexes);
                    continue;
                }
                indexes.addAll((Collection<Integer>)subResult.get(accession));
                Collections.sort(indexes);
                int previousIndex = -1;
                ArrayList<Integer> singleIndexes = new ArrayList<Integer>(indexes.size());
                for (int tempIndex : indexes) {
                    if (tempIndex == previousIndex) continue;
                    singleIndexes.add(tempIndex);
                    previousIndex = tempIndex;
                }
                result.put(accession, singleIndexes);
            }
        }
        for (String accession : this.termini.keySet()) {
            ArrayList<Integer> indexes = result.get(accession);
            if (indexes == null) {
                indexes = new ArrayList();
                result.put(accession, indexes);
            }
            for (Integer index : this.termini.get(accession)) {
                if (indexes.contains(index)) continue;
                indexes.add(index);
            }
        }
        return result;
    }

    private ArrayList<Integer> matchInProtein(String accession, ArrayList<Integer> seeds, String peptideSequence) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        String proteinSequence = SequenceFactory.getInstance().getProtein(accession).getSequence();
        ArrayList<Integer> results = new ArrayList<Integer>();
        int peptideLength = peptideSequence.length();
        for (int startIndex : seeds) {
            String subSequence;
            int endIndex = startIndex + peptideLength;
            if (endIndex > proteinSequence.length() || !(subSequence = proteinSequence.substring(startIndex, endIndex)).equals(peptideSequence)) continue;
            results.add(startIndex);
        }
        return results;
    }

    private HashMap<Character, ArrayList<Integer>> getAA(String accession, ArrayList<Integer> seeds, int offset) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        String proteinSequence = SequenceFactory.getInstance().getProtein(accession).getSequence();
        HashMap<Character, ArrayList<Integer>> result = new HashMap<Character, ArrayList<Integer>>();
        for (int startIndex : seeds) {
            int tempIndex = startIndex + offset;
            if (tempIndex < proteinSequence.length()) {
                char aa = proteinSequence.charAt(tempIndex);
                ArrayList<Integer> indexes = result.get(Character.valueOf(aa));
                if (indexes == null) {
                    indexes = new ArrayList();
                    result.put(Character.valueOf(aa), indexes);
                }
                if (indexes.contains(startIndex)) continue;
                indexes.add(startIndex);
                continue;
            }
            if (tempIndex == proteinSequence.length()) {
                ArrayList<Integer> indexes = this.termini.get(accession);
                if (indexes == null) {
                    indexes = new ArrayList();
                    this.termini.put(accession, indexes);
                }
                if (indexes.contains(startIndex)) continue;
                indexes.add(startIndex);
                continue;
            }
            throw new IllegalArgumentException("Attempting to index after the protein termini.");
        }
        return result;
    }

    private ArrayList<Integer> matchInProtein(String accession, ArrayList<Integer> seeds, int offset, char expectedChar) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException {
        String proteinSequence = SequenceFactory.getInstance().getProtein(accession).getSequence();
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (int startIndex : seeds) {
            int tempIndex = startIndex + offset;
            if (tempIndex >= proteinSequence.length() || proteinSequence.charAt(tempIndex) != expectedChar) continue;
            results.add(startIndex);
        }
        return results;
    }

    public Node getSubNode(String sequence) {
        if (sequence.length() <= this.depth) {
            throw new IllegalArgumentException(sequence + " is not subnode of the node (depth=" + this.depth + ").");
        }
        char aa = sequence.charAt(this.depth);
        if (this.depth < sequence.length() - 1) {
            return this.subtree.get(Character.valueOf(aa)).getSubNode(sequence);
        }
        if (this.depth == sequence.length() - 1) {
            return this.subtree.get(Character.valueOf(aa));
        }
        throw new IllegalArgumentException("depth " + this.depth + " longer than sequence " + sequence + ".");
    }
}

